/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web.httpserver;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class LazySessionInvalidationFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest wrappedRequest = RequestWrapper.wrap((HttpServletRequest)request);
        chain.doFilter((ServletRequest)wrappedRequest, response);
        RequestWrapper wrapper = (RequestWrapper)Proxy.getInvocationHandler(wrappedRequest);
        if (wrapper.isInvalidated()) {
            wrapper.invalidateSessionActually();
        }
    }

    public void destroy() {
    }

    private static class SessionWrapper
    implements InvocationHandler {
        private final HttpSession session;
        private final Runnable invalidationCallback;

        SessionWrapper(HttpSession session, Runnable invalidationCallback) {
            this.session = session;
            this.invalidationCallback = invalidationCallback;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.equals(HttpSession.class.getDeclaredMethod("invalidate", new Class[0]))) {
                this.invalidationCallback.run();
                Enumeration names = this.session.getAttributeNames();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    this.session.removeAttribute(name);
                }
                return null;
            }
            return method.invoke((Object)this.session, args);
        }

        static HttpSession wrap(HttpSession session, Runnable invalidationCallback) {
            ClassLoader loader = session.getClass().getClassLoader();
            Class[] interfaces = new Class[]{HttpSession.class};
            SessionWrapper h = new SessionWrapper(session, invalidationCallback);
            return (HttpSession)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)h);
        }
    }

    private static class RequestWrapper
    implements InvocationHandler,
    Runnable {
        private final HttpServletRequest request;
        private boolean invalidated;

        RequestWrapper(HttpServletRequest request) {
            this.request = request;
        }

        void invalidateSessionActually() {
            HttpSession session = this.request.getSession(false);
            if (session != null) {
                session.invalidate();
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.equals(HttpServletRequest.class.getDeclaredMethod("getSession", new Class[0])) || method.equals(HttpServletRequest.class.getDeclaredMethod("getSession", Boolean.TYPE))) {
                Object session = method.invoke((Object)this.request, args);
                if (session == null) {
                    return null;
                }
                return SessionWrapper.wrap((HttpSession)session, this);
            }
            return method.invoke((Object)this.request, args);
        }

        @Override
        public void run() {
            this.invalidated = true;
        }

        boolean isInvalidated() {
            return this.invalidated;
        }

        static HttpServletRequest wrap(HttpServletRequest request) {
            ClassLoader loader = request.getClass().getClassLoader();
            Class[] interfaces = new Class[]{HttpServletRequest.class};
            RequestWrapper h = new RequestWrapper(request);
            return (HttpServletRequest)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)h);
        }
    }
}

