/*
 * Decompiled with CFR 0.152.
 */
package nablarch.test.core.http.dump;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.RichTextString;

class RequestDumpAgent {
    RequestDumpAgent() {
    }

    void print(String uri, Map<String, String[]> params, OutputStream out) throws IOException {
        HSSFWorkbook book = this.createDumpedBook(uri, params);
        book.write(out);
    }

    HSSFWorkbook createDumpedBook(String uri, Map<String, String[]> params) throws IOException {
        HSSFWorkbook book = this.getTemplateBook("template.xls");
        HSSFSheet sheet = book.getSheet("Sheet1");
        HSSFCellStyle columnCellStyle = book.createCellStyle();
        this.drawRuledLine(columnCellStyle);
        columnCellStyle.setFillForegroundColor((short)42);
        columnCellStyle.setFillPattern((short)1);
        HSSFCellStyle valueCellStyle = book.createCellStyle();
        this.drawRuledLine(valueCellStyle);
        int rowIdx = 1;
        this.writeLine(sheet, rowIdx++, "// " + new Date());
        this.writeLine(sheet, rowIdx++, "// URI=[" + uri + "]");
        this.writeLine(sheet, rowIdx++, "LIST_MAP=");
        HSSFRow columnRow = sheet.createRow(rowIdx++);
        HSSFRow valueRow = sheet.createRow(rowIdx++);
        TreeMap<String, String[]> sortedParams = new TreeMap<String, String[]>(params);
        int columnIdx = 0;
        for (Map.Entry<String, String[]> e : sortedParams.entrySet()) {
            String key = e.getKey();
            HSSFCell columnCell = columnRow.createCell(columnIdx);
            this.setValue(columnCell, key);
            columnCell.setCellStyle(columnCellStyle);
            String value = this.escapeAndJoinWithComma(e.getValue());
            HSSFCell valueCell = valueRow.createCell(columnIdx);
            this.setValue(valueCell, value);
            valueCell.setCellStyle(valueCellStyle);
            ++columnIdx;
        }
        return book;
    }

    String escape(Object orig) {
        String s = String.valueOf(orig);
        StringBuilder result = new StringBuilder();
        block4: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    result.append("\\\\");
                    continue block4;
                }
                case ',': {
                    result.append("\\,");
                    continue block4;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HSSFWorkbook getTemplateBook(String resourcePath) throws IOException {
        InputStream in = RequestDumpAgent.class.getResourceAsStream(resourcePath);
        if (in == null) {
            throw new IllegalStateException("can't load template file in classpath. file=[" + resourcePath + "]");
        }
        try {
            POIFSFileSystem fs = new POIFSFileSystem(in);
            HSSFWorkbook hSSFWorkbook = new HSSFWorkbook(fs);
            return hSSFWorkbook;
        }
        finally {
            this.closeQuietly(in);
        }
    }

    private void writeLine(HSSFSheet sheet, int rowNum, String value) {
        HSSFRow row = sheet.createRow(rowNum);
        HSSFCell cell = row.createCell(0);
        this.setValue(cell, value);
    }

    private void setValue(HSSFCell target, String value) {
        target.setCellValue((RichTextString)new HSSFRichTextString(value));
    }

    private void drawRuledLine(HSSFCellStyle style) {
        style.setBorderBottom((short)1);
        style.setBorderLeft((short)1);
        style.setBorderRight((short)1);
        style.setBorderTop((short)1);
    }

    private String escapeAndJoinWithComma(Object[] array) {
        return this.escapeAndJoin(array, ",");
    }

    String escapeAndJoin(Object[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object e : array) {
            if (first) {
                first = false;
            } else {
                sb.append(delimiter);
            }
            String escaped = this.escape(e);
            sb.append(escaped);
        }
        return sb.toString();
    }

    void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

