/*
 * Decompiled with CFR 0.152.
 */
package nablarch.test.core.http.dump;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import nablarch.test.core.http.dump.RequestDumpServerShutdownFilter;
import nablarch.test.core.http.dump.RequestDumpServlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHandler;

public class RequestDumpServer {
    static final int PORT_NUM = 57777;
    private final int port;
    private Server jetty;

    public static void main(String[] args) throws Exception {
        new RequestDumpServer().start();
    }

    public RequestDumpServer() {
        this(57777);
    }

    public RequestDumpServer(int port) {
        this.port = port;
        this.jetty = this.createServer();
    }

    public void start() throws Exception {
        if (this.isAlreadyInUse()) {
            return;
        }
        this.jetty.start();
        this.jetty.join();
    }

    private Server createServer() {
        Server server = new Server(this.port);
        ServerConnector connector = new ServerConnector(server);
        server.addConnector((Connector)connector);
        ServletHandler handler = new ServletHandler();
        FilterHolder filterHolder = new FilterHolder((Filter)new RequestDumpServerShutdownFilter(this));
        handler.addFilterWithMapping(filterHolder, "/shutdown", EnumSet.allOf(DispatcherType.class));
        handler.addServletWithMapping(RequestDumpServlet.class, "/");
        server.setHandler((Handler)handler);
        return server;
    }

    void shutdownServer() {
        Thread t = new Thread(){

            @Override
            public void run() {
                RequestDumpServer.this.stopServer(RequestDumpServer.this.jetty);
            }
        };
        t.start();
    }

    void stopServer(Server server) {
        try {
            server.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAlreadyInUse() throws IOException {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(this.port);
            this.closeQuietly(serverSocket);
        }
        catch (BindException alreadyBounded) {
            try {
                System.err.println("port " + this.port + " is already used.");
                boolean bl = true;
                this.closeQuietly(serverSocket);
                return bl;
            }
            catch (Throwable throwable) {
                this.closeQuietly(serverSocket);
                throw throwable;
            }
        }
        return false;
    }

    void closeQuietly(ServerSocket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

