/*
 * Decompiled with CFR 0.152.
 */
package nablarch.test.core.http.dump;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.regex.Pattern;

public class SimpleReplacer {
    private final Pattern pattern;
    private final String replacement;
    private final Charset charset;
    private final String lineSeparator;

    public SimpleReplacer(Pattern pattern, String replacement, String charsetName) {
        this(pattern, replacement, charsetName, System.getProperty("line.separator"));
    }

    public SimpleReplacer(Pattern pattern, String replacement, String charsetName, String lineSeparator) {
        this(pattern, replacement, Charset.forName(charsetName), lineSeparator);
    }

    public SimpleReplacer(Pattern pattern, String replacement, Charset charset, String lineSeparator) {
        this.pattern = pattern;
        this.replacement = replacement;
        this.charset = charset;
        this.lineSeparator = lineSeparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(String inFilePath, String outFilePath) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(inFilePath);
            out = new FileOutputStream(outFilePath);
            this.replace(in, out);
            this.closeQuietly(in);
            this.closeQuietly(out);
        }
        catch (Throwable throwable) {
            this.closeQuietly(in);
            this.closeQuietly(out);
            throw throwable;
        }
    }

    public void replace(InputStream in, OutputStream out) throws IOException {
        InputStreamReader reader = new InputStreamReader(in, this.charset);
        OutputStreamWriter writer = new OutputStreamWriter(out, this.charset);
        this.replace(reader, writer);
    }

    public void replace(Reader reader, Writer writer) throws IOException {
        this.replace(new BufferedReader(reader), new BufferedWriter(writer));
    }

    protected void replace(BufferedReader reader, BufferedWriter writer) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            String replaced = this.replaceLine(line);
            writer.write(replaced);
            writer.write(this.lineSeparator);
        }
        writer.flush();
    }

    protected String replaceLine(String in) {
        return this.pattern.matcher(in).replaceAll(this.replacement);
    }

    void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

