/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import nablarch.fw.web.RestTestBodyConverter;

public class JacksonBodyConverter
implements RestTestBodyConverter {
    private static final RestTestBodyConverter.MediaType CONVERTIBLE_TYPE = new RestTestBodyConverter.MediaType("application/json");
    private final ObjectMapper objectMapper;

    public JacksonBodyConverter() {
        this(new DefaultObjectMapperFactory());
    }

    public JacksonBodyConverter(ObjectMapperFactory factory) {
        this.objectMapper = factory.create();
    }

    @Override
    public boolean isConvertible(Object body, RestTestBodyConverter.MediaType mediaType) {
        return CONVERTIBLE_TYPE.equals(mediaType);
    }

    @Override
    public String convert(Object body, RestTestBodyConverter.MediaType mediaType) {
        try {
            return this.objectMapper.writeValueAsString(body);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("body cannot convert to String. cause[" + e.getMessage() + "].", e);
        }
    }

    private static class DefaultObjectMapperFactory
    implements ObjectMapperFactory {
        private DefaultObjectMapperFactory() {
        }

        @Override
        public ObjectMapper create() {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.getFactory().configure(JsonWriteFeature.ESCAPE_NON_ASCII.mappedFeature(), true);
            return objectMapper;
        }
    }

    public static interface ObjectMapperFactory {
        public ObjectMapper create();
    }
}

