/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nablarch.core.util.StringUtil;
import nablarch.core.util.annotation.Published;
import nablarch.fw.web.HttpCookie;
import nablarch.fw.web.MockHttpRequest;
import nablarch.fw.web.RestTestBodyConverter;

@Published
public class RestMockHttpRequest
extends MockHttpRequest {
    private static final String LS = "\r\n";
    private final Collection<? extends RestTestBodyConverter> bodyConverters;
    private final String defaultContentType;
    private Object body;
    private static final String CONTENT_TYPE_KEY = "Content-Type";
    private static final String CONTENT_LENGTH_KEY = "Content-Length";

    public RestMockHttpRequest(Collection<? extends RestTestBodyConverter> bodyConverters, String defaultContentType) {
        this.bodyConverters = bodyConverters;
        this.defaultContentType = defaultContentType;
    }

    public Object getBody() {
        return this.body;
    }

    public RestMockHttpRequest setBody(Object body) {
        this.body = body;
        if (this.getMediaType() == null && this.defaultContentType != null) {
            this.setContentType(this.defaultContentType);
        }
        return this;
    }

    private RestTestBodyConverter.MediaType getMediaType() {
        String contentType = this.getHeader(CONTENT_TYPE_KEY);
        if (StringUtil.hasValue((String)contentType)) {
            return new RestTestBodyConverter.MediaType(contentType);
        }
        return null;
    }

    public RestMockHttpRequest setContentType(String contentType) {
        this.getHeaderMap().put(CONTENT_TYPE_KEY, contentType);
        return this;
    }

    public RestMockHttpRequest setMethod(String method) {
        return (RestMockHttpRequest)super.setMethod(method);
    }

    public RestMockHttpRequest setHeaderMap(Map<String, String> headers) {
        return (RestMockHttpRequest)super.setHeaderMap(headers);
    }

    public RestMockHttpRequest setHeader(String headerName, String value) {
        this.getHeaderMap().put(headerName, value);
        return this;
    }

    public RestMockHttpRequest setRequestUri(String requestPath) {
        return (RestMockHttpRequest)super.setRequestUri(requestPath);
    }

    public RestMockHttpRequest setParam(String name, String ... params) {
        return (RestMockHttpRequest)super.setParam(name, params);
    }

    public RestMockHttpRequest setParamMap(Map<String, String[]> params) {
        return (RestMockHttpRequest)super.setParamMap(params);
    }

    public RestMockHttpRequest setCookie(HttpCookie cookie) {
        return (RestMockHttpRequest)super.setCookie(cookie);
    }

    public RestMockHttpRequest setHttpVersion(String httpVersion) {
        return (RestMockHttpRequest)super.setHttpVersion(httpVersion);
    }

    public RestMockHttpRequest setHost(String host) {
        return (RestMockHttpRequest)super.setHost(host);
    }

    public RestMockHttpRequest setRequestPath(String requestPath) {
        return (RestMockHttpRequest)super.setRequestPath(requestPath);
    }

    public String toString() {
        Map paramMap = this.getParamMap();
        if (this.body != null && !paramMap.isEmpty()) {
            throw new IllegalStateException("set only one of paramMap or body.");
        }
        String uri = this.getRequestUri();
        String params = this.concatParams(paramMap);
        String bodyStr = this.convertBody();
        if (StringUtil.hasValue((String)params)) {
            if ("GET".equals(this.getMethod())) {
                uri = uri.contains("?") ? uri + "&" + params : uri + "?" + params;
            } else {
                bodyStr = this.urlEncode(params);
            }
        }
        HashMap<String, String> headers = new HashMap<String, String>(this.getHeaderMap());
        if (StringUtil.hasValue((String)bodyStr)) {
            this.setContentLength(headers, bodyStr);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getMethod()).append(' ').append(this.urlEncode(uri)).append(' ').append(this.getHttpVersion()).append(LS);
        for (Map.Entry entry : headers.entrySet()) {
            buffer.append((String)entry.getKey()).append(": ").append((String)entry.getValue());
            buffer.append(LS);
        }
        buffer.append(LS);
        if (StringUtil.hasValue((String)bodyStr)) {
            buffer.append(bodyStr);
        }
        return buffer.toString();
    }

    private void setContentLength(Map<String, String> headers, String bodyStr) {
        String contentLengthFromHeader;
        int contentLength = bodyStr.getBytes().length;
        if (headers.containsKey(CONTENT_LENGTH_KEY) && Integer.parseInt(contentLengthFromHeader = headers.get(CONTENT_LENGTH_KEY)) != contentLength) {
            throw new RuntimeException("wrong Content-Length[" + contentLengthFromHeader + "] was set.correct length is [" + contentLength + "].");
        }
        headers.put(CONTENT_LENGTH_KEY, String.valueOf(contentLength));
    }

    private String concatParams(Map<String, String[]> paramMap) {
        if (paramMap.isEmpty()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        Iterator<Map.Entry<String, String[]>> params = paramMap.entrySet().iterator();
        while (params.hasNext()) {
            Map.Entry<String, String[]> param = params.next();
            String name = param.getKey();
            Iterator<Object> values = Arrays.asList((Object[])param.getValue()).iterator();
            while (values.hasNext()) {
                buffer.append(name).append("=").append((String)values.next());
                if (!values.hasNext()) continue;
                buffer.append("&");
            }
            if (!params.hasNext()) continue;
            buffer.append("&");
        }
        return buffer.toString();
    }

    private String urlEncode(String uri) {
        try {
            return new URI(uri).toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("url encoding failed. cause[" + e.getMessage() + "]", e);
        }
    }

    private String convertBody() {
        if (this.body == null) {
            return null;
        }
        RestTestBodyConverter.MediaType mediaType = this.getMediaType();
        if (mediaType != null) {
            RestTestBodyConverter detectedBodyConverter = this.findBodyConverter(mediaType);
            return detectedBodyConverter.convert(this.body, mediaType);
        }
        throw new RuntimeException("there was no Content-Type header but body was not empty.");
    }

    private RestTestBodyConverter findBodyConverter(RestTestBodyConverter.MediaType mediaType) {
        for (RestTestBodyConverter restTestBodyConverter : this.bodyConverters) {
            if (!restTestBodyConverter.isConvertible(this.body, mediaType)) continue;
            return restTestBodyConverter;
        }
        throw new RuntimeException("unsupported media type requested. MIME type = [ " + mediaType + " ]");
    }
}

