/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.web;

import java.util.Arrays;
import java.util.Collection;
import nablarch.fw.web.JacksonBodyConverter;
import nablarch.fw.web.RestMockHttpRequest;
import nablarch.fw.web.RestTestBodyConverter;
import nablarch.fw.web.StringBodyConverter;

public class RestMockHttpRequestBuilder {
    private Collection<? extends RestTestBodyConverter> bodyConverters = Arrays.asList(new StringBodyConverter(), new JacksonBodyConverter());
    private String defaultContentType = "application/json";

    private RestMockHttpRequest newRequest(String httpMethod, String uri) {
        return new RestMockHttpRequest(this.bodyConverters, this.defaultContentType).setMethod(httpMethod).setRequestUri(uri);
    }

    public RestMockHttpRequest get(String uri) {
        return this.newRequest("GET", uri);
    }

    public RestMockHttpRequest post(String uri) {
        return this.newRequest("POST", uri);
    }

    public RestMockHttpRequest put(String uri) {
        return this.newRequest("PUT", uri);
    }

    public RestMockHttpRequest delete(String uri) {
        return this.newRequest("DELETE", uri);
    }

    public void setDefaultContentType(String defaultContentType) {
        this.defaultContentType = defaultContentType;
    }

    public void setBodyConverters(Collection<? extends RestTestBodyConverter> bodyConverters) {
        this.bodyConverters = bodyConverters;
    }
}

