/*
 * Decompiled with CFR 0.152.
 */
package nablarch.test.core.http;

import java.util.List;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpResponse;
import nablarch.test.core.http.RequestResponseProcessor;

public class ComplexRequestResponseProcessor
implements RequestResponseProcessor {
    private List<RequestResponseProcessor> processors;

    @Override
    public HttpRequest processRequest(HttpRequest request) {
        for (RequestResponseProcessor processor : this.processors) {
            request = processor.processRequest(request);
        }
        return request;
    }

    @Override
    public HttpResponse processResponse(HttpRequest request, HttpResponse response) {
        for (RequestResponseProcessor processor : this.processors) {
            response = processor.processResponse(request, response);
        }
        return response;
    }

    @Override
    public void reset() {
        for (RequestResponseProcessor processor : this.processors) {
            processor.reset();
        }
    }

    public void setProcessors(List<RequestResponseProcessor> processors) {
        this.processors = processors;
    }
}

