/*
 * Decompiled with CFR 0.152.
 */
package nablarch.test.core.http;

import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.RestMockHttpRequest;
import nablarch.test.core.http.RequestResponseProcessor;

public class NablarchSIDManager
implements RequestResponseProcessor {
    private static final Logger LOGGER = LoggerManager.get(NablarchSIDManager.class);
    private String nablarchSID;
    private String cookieName = "NABLARCH_SID";

    @Override
    public HttpRequest processRequest(HttpRequest request) {
        if (request instanceof RestMockHttpRequest) {
            RestMockHttpRequest restMockHttpRequest = (RestMockHttpRequest)request;
            if (this.nablarchSID != null) {
                this.logDebug("Set session ID: " + this.cookieName + " = " + this.nablarchSID);
                restMockHttpRequest.setHeader("Cookie", this.cookieName + "=" + this.nablarchSID);
            }
        }
        return request;
    }

    @Override
    public HttpResponse processResponse(HttpRequest request, HttpResponse response) {
        String header = response.getHeader("Set-Cookie");
        if (header != null && !header.isEmpty()) {
            String value = header.split(";")[0];
            if (value.startsWith(this.cookieName + "=")) {
                this.nablarchSID = value.substring((this.cookieName + "=").length());
                this.logDebug("Get session ID: " + this.cookieName + " = " + this.nablarchSID);
            } else {
                this.logDebug("Set-Cookie header value does not contain " + this.cookieName + ". header value = " + header);
            }
        }
        return response;
    }

    @Override
    public void reset() {
        this.nablarchSID = null;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    private void logDebug(String message) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(message, new Object[0]);
        }
    }
}

