/*
 * Decompiled with CFR 0.152.
 */
package nablarch.test.core.http;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nablarch.core.exception.IllegalConfigurationException;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.repository.SystemRepository;
import nablarch.core.util.FileUtil;
import nablarch.core.util.annotation.Published;
import nablarch.test.core.db.DbAccessTestSupport;
import nablarch.test.core.http.SimpleRestTestSupport;
import nablarch.test.core.reader.TestDataParser;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.junit.Before;

@Published
public class RestTestSupport
extends SimpleRestTestSupport {
    private static final Logger LOGGER = LoggerManager.get(RestTestSupport.class);
    public static final String TEST_DATA_PARSER_KEY = "testDataParser";
    private static final String RESOURCE_ROOT_KEY = "nablarch.test.resource-root";
    private static final String DEFAULT_RESOURCE_ROOT = "test/java/";
    private static final String PATH_SEPARATOR = ";";
    private static final String SETUP_TABLE_SHEET = "setUpDb";
    private final DbAccessTestSupport dbSupport = new DbAccessTestSupport(((Object)((Object)this)).getClass());
    private boolean testDataExists = true;

    @Before
    public void setUpDb() {
        this.setUpDbIfSheetExists(SETUP_TABLE_SHEET);
        this.setUpDbIfSheetExists(this.testDescription.getMethodName());
    }

    protected void setUpDbIfSheetExists(String sheetName) {
        if (this.isExisting(sheetName)) {
            this.setUpDb(sheetName);
        } else {
            LOGGER.logDebug("skipped setUpDb because test data [resource: " + this.getResourceName(sheetName) + "] was not found.", new Object[0]);
        }
    }

    public void setUpDb(String sheetName) {
        this.dbSupport.setUpDb(sheetName);
    }

    public void setUpDb(String sheetName, String groupId) {
        this.dbSupport.setUpDb(sheetName, groupId);
    }

    public List<Map<String, String>> getListMap(String sheetName, String id) {
        return this.dbSupport.getListMap(sheetName, id);
    }

    public List<Map<String, String[]>> getListParamMap(String sheetName, String id) {
        return this.dbSupport.getListParamMap(sheetName, id);
    }

    public Map<String, String[]> getParamMap(String sheetName, String id) {
        return this.dbSupport.getParamMap(sheetName, id);
    }

    public void assertTableEquals(String sheetName) {
        this.dbSupport.assertTableEquals(sheetName);
    }

    public void assertTableEquals(String sheetName, String groupId) {
        this.dbSupport.assertTableEquals(sheetName, groupId);
    }

    public void assertTableEquals(String message, String sheetName, String groupId) {
        this.dbSupport.assertTableEquals(message, sheetName, groupId);
    }

    public void assertTableEquals(String message, String sheetName, String groupId, boolean failIfNoDataFound) {
        this.dbSupport.assertTableEquals(message, sheetName, groupId, failIfNoDataFound);
    }

    private boolean isExisting(String sheetName) {
        if (!this.testDataExists) {
            return false;
        }
        String resourceName = this.getResourceName(sheetName);
        String path = this.getPathOf(resourceName);
        if (path == null) {
            this.testDataExists = false;
            return false;
        }
        return this.getSheet(path, sheetName) != null;
    }

    private String getPathOf(String resourceName) {
        List<String> baseDirs = this.getTestDataPaths();
        for (String basePath : baseDirs) {
            if (!this.getTestDataParser().isResourceExisting(basePath, resourceName)) continue;
            return basePath;
        }
        return null;
    }

    private Sheet getSheet(String basePath, String sheetName) {
        Workbook book;
        String filePath = basePath + '/' + this.testDescription.getTestClassSimpleName();
        File file = new File(filePath + ".xlsx");
        if (!file.exists()) {
            file = new File(filePath + ".xls");
        }
        String absoluteFilePath = file.getAbsolutePath();
        InputStream in = null;
        try {
            String uri = new File(absoluteFilePath).toURI().toString();
            in = FileUtil.getResource((String)uri);
            book = WorkbookFactory.create((InputStream)in);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("test data file open failed.", e);
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietly((Closeable[])new Closeable[]{in});
                throw throwable;
            }
        }
        FileUtil.closeQuietly((Closeable[])new Closeable[]{in});
        return book.getSheet(sheetName);
    }

    private String getResourceName(String sheetName) {
        return this.testDescription.getTestClassSimpleName() + "/" + sheetName;
    }

    private List<String> getTestDataPaths() {
        String[] baseDirs = this.getResourceRootSetting().split(PATH_SEPARATOR);
        String relativePath = this.packageToPath(this.testDescription.getTestClass());
        ArrayList<String> testDataPaths = new ArrayList<String>(baseDirs.length);
        for (String baseDir : baseDirs) {
            testDataPaths.add(baseDir + '/' + relativePath);
        }
        return testDataPaths;
    }

    private String getResourceRootSetting() {
        String resourceRootSetting = (String)SystemRepository.get((String)RESOURCE_ROOT_KEY);
        return resourceRootSetting == null ? DEFAULT_RESOURCE_ROOT : resourceRootSetting;
    }

    private String packageToPath(Class<?> clazz) {
        String pkg = clazz.getPackage().getName();
        return pkg.replace('.', '/');
    }

    public final TestDataParser getTestDataParser() {
        TestDataParser parser = (TestDataParser)SystemRepository.get((String)TEST_DATA_PARSER_KEY);
        if (parser == null) {
            throw new IllegalConfigurationException(RestTestSupport.createNoComponentMessage(TEST_DATA_PARSER_KEY));
        }
        return parser;
    }
}

