/*
 * Decompiled with CFR 0.152.
 */
package nablarch.test.core.http;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import nablarch.core.exception.IllegalConfigurationException;
import nablarch.core.repository.SystemRepository;
import nablarch.core.util.FileUtil;
import nablarch.core.util.annotation.Published;
import nablarch.fw.ExecutionContext;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.HttpServer;
import nablarch.fw.web.HttpServerFactory;
import nablarch.fw.web.ResourceLocator;
import nablarch.fw.web.RestMockHttpRequest;
import nablarch.fw.web.RestMockHttpRequestBuilder;
import nablarch.fw.web.servlet.WebFrontController;
import nablarch.test.NablarchTestUtils;
import nablarch.test.core.http.HttpRequestTestSupportHandler;
import nablarch.test.core.http.HttpTestConfiguration;
import nablarch.test.core.http.RequestResponseProcessor;
import nablarch.test.core.http.RestTestConfiguration;
import nablarch.test.core.rule.TestDescription;
import nablarch.test.event.TestEventDispatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;

@Published
public class SimpleRestTestSupport
extends TestEventDispatcher {
    private static final String REST_TEST_CONFIGURATION_KEY = "restTestConfiguration";
    private static final String HTTP_REQUEST_BUILDER_KEY = "restMockHttpRequestBuilder";
    private static final String HTTP_SERVER_FACTORY_KEY = "httpServerFactory";
    private static final String DEFAULT_PROCESSOR_KEY = "defaultProcessor";
    private static HttpServer server;
    private static HttpRequestTestSupportHandler handler;
    private static boolean initialized;
    private RequestResponseProcessor defaultProcessor;
    private static final RequestResponseProcessor NOP_PROCESSOR;
    @Rule
    public TestDescription testDescription = new TestDescription();

    @Before
    public void setUp() {
        this.setupDefaultProcessor();
        RestTestConfiguration config = (RestTestConfiguration)((Object)SystemRepository.get((String)REST_TEST_CONFIGURATION_KEY));
        SimpleRestTestSupport.initializeIfNotYet(config);
    }

    private void setupDefaultProcessor() {
        RequestResponseProcessor processor = (RequestResponseProcessor)SystemRepository.get((String)DEFAULT_PROCESSOR_KEY);
        this.defaultProcessor = processor != null ? processor : NOP_PROCESSOR;
        this.defaultProcessor.reset();
    }

    public RestMockHttpRequestBuilder getHttpRequestBuilder() {
        RestMockHttpRequestBuilder requestBuilder = (RestMockHttpRequestBuilder)SystemRepository.get((String)HTTP_REQUEST_BUILDER_KEY);
        if (requestBuilder == null) {
            throw new IllegalConfigurationException(SimpleRestTestSupport.createNoComponentMessage(HTTP_REQUEST_BUILDER_KEY));
        }
        return requestBuilder;
    }

    public RestMockHttpRequest get(String uri) {
        return this.getHttpRequestBuilder().get(uri);
    }

    public RestMockHttpRequest post(String uri) {
        return this.getHttpRequestBuilder().post(uri);
    }

    public RestMockHttpRequest put(String uri) {
        return this.getHttpRequestBuilder().put(uri);
    }

    public RestMockHttpRequest delete(String uri) {
        return this.getHttpRequestBuilder().delete(uri);
    }

    public HttpResponse sendRequest(HttpRequest request) {
        return this.sendRequest(request, this.defaultProcessor);
    }

    public HttpResponse sendRequest(HttpRequest request, RequestResponseProcessor processor) {
        return this.sendRequestWithContext(request, new ExecutionContext(), processor);
    }

    public HttpResponse sendRequestWithContext(HttpRequest request, ExecutionContext context) {
        return this.sendRequestWithContext(request, context, this.defaultProcessor);
    }

    public HttpResponse sendRequestWithContext(HttpRequest request, ExecutionContext context, RequestResponseProcessor processor) {
        request = processor.processRequest(request);
        handler.setContext(context);
        HttpResponse response = server.handle(request, context);
        return processor.processResponse(request, response);
    }

    private static void initializeIfNotYet(RestTestConfiguration config) {
        if (!initialized) {
            SimpleRestTestSupport.createHttpServer(config);
            initialized = true;
        }
    }

    public static void resetHttpServer() {
        if (initialized) {
            server = null;
            initialized = false;
        }
    }

    private static void createHttpServer(RestTestConfiguration config) {
        server = SimpleRestTestSupport.createHttpServer();
        server.setTempDirectory(config.getTempDirectory());
        server.setWarBasePaths(SimpleRestTestSupport.getWarBasePaths(config));
        server.startLocal();
        handler = new HttpRequestTestSupportHandler((HttpTestConfiguration)config);
        WebFrontController controller = (WebFrontController)SystemRepository.get((String)config.getWebFrontControllerKey());
        ArrayList handlerQueue = new ArrayList(controller.getHandlerQueue());
        handler.register(handlerQueue);
        server.setHandlerQueue(handlerQueue);
    }

    private static List<ResourceLocator> getWarBasePaths(RestTestConfiguration config) {
        String[] baseDirs = config.getWebBaseDir().split(",");
        ArrayList<ResourceLocator> basePaths = new ArrayList<ResourceLocator>(baseDirs.length);
        for (String dir : baseDirs) {
            basePaths.add(ResourceLocator.valueOf((String)("file://" + NablarchTestUtils.toCanonicalPath((String)dir))));
        }
        return basePaths;
    }

    private static HttpServer createHttpServer() {
        HttpServerFactory factory = (HttpServerFactory)SystemRepository.get((String)HTTP_SERVER_FACTORY_KEY);
        if (factory == null) {
            throw new IllegalConfigurationException(SimpleRestTestSupport.createNoComponentMessage(HTTP_SERVER_FACTORY_KEY));
        }
        return factory.create();
    }

    public void assertStatusCode(String message, HttpResponse.Status expected, HttpResponse response) {
        this.assertStatusCode(message, expected.getStatusCode(), response);
    }

    public void assertStatusCode(String message, int expected, HttpResponse response) {
        Assert.assertEquals((String)(message + " [HTTP STATUS]"), (long)expected, (long)response.getStatusCode());
    }

    protected String readTextResource(String fileName) {
        try {
            URL url = this.getUrl(this.testDescription.getTestClassSimpleName() + "/" + fileName);
            File file = new File(url.toURI());
            return this.read(file);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("couldn't read resource [" + fileName + "]. cause [" + e.getMessage() + "].", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("couldn't read resource [" + fileName + "]. cause [" + e.getMessage() + "].", e);
        }
    }

    private URL getUrl(String fileName) {
        URL url = this.testDescription.getTestClass().getResource(fileName);
        if (url == null) {
            throw new IllegalArgumentException("couldn't find resource [" + fileName + "].");
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String read(File file) throws IOException {
        String string;
        FileInputStream is = null;
        ByteArrayOutputStream out = null;
        try {
            int length;
            is = new FileInputStream(file);
            out = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((length = ((InputStream)is).read(buffer)) != -1) {
                out.write(buffer, 0, length);
            }
            string = out.toString("UTF-8");
        }
        catch (Throwable throwable) {
            FileUtil.closeQuietly((Closeable[])new Closeable[]{is, out});
            throw throwable;
        }
        FileUtil.closeQuietly((Closeable[])new Closeable[]{is, out});
        return string;
    }

    protected static String createNoComponentMessage(String componentKey) {
        return "could not find component. name=[" + componentKey + "].";
    }

    static {
        initialized = false;
        NOP_PROCESSOR = new RequestResponseProcessor(){

            @Override
            public HttpRequest processRequest(HttpRequest request) {
                return request;
            }

            @Override
            public HttpResponse processResponse(HttpRequest request, HttpResponse response) {
                return response;
            }

            @Override
            public void reset() {
            }
        };
    }
}

