/*
 * Decompiled with CFR 0.152.
 */
package nablarch.integration.jaxrs.jackson;

import java.io.IOException;
import java.io.Reader;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.fw.ExecutionContext;
import nablarch.fw.jaxrs.BodyConverterSupport;
import nablarch.fw.jaxrs.JaxRsContext;
import nablarch.fw.web.HttpErrorResponse;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.servlet.NablarchHttpServletRequestWrapper;
import nablarch.fw.web.servlet.ServletExecutionContext;

public abstract class JacksonBodyConverterSupport
extends BodyConverterSupport {
    private static final Logger LOGGER = LoggerManager.get(JacksonBodyConverterSupport.class);

    protected Object convertRequest(HttpRequest request, ExecutionContext context) {
        JaxRsContext jaxRsContext = JaxRsContext.get((ExecutionContext)context);
        Class beanClass = jaxRsContext.getRequestClass();
        NablarchHttpServletRequestWrapper servletRequest = ((ServletExecutionContext)context).getServletRequest();
        try {
            return this.readValue(servletRequest.getReader(), beanClass);
        }
        catch (IOException e) {
            LOGGER.logInfo("failed to read request. cause = [" + e.getMessage() + ']', new Object[0]);
            throw new HttpErrorResponse(HttpResponse.Status.BAD_REQUEST.getStatusCode(), (Throwable)e);
        }
    }

    protected abstract Object readValue(Reader var1, Class<?> var2) throws IOException;

    protected HttpResponse convertResponse(Object response, ExecutionContext context) {
        JaxRsContext jaxRsContext = JaxRsContext.get((ExecutionContext)context);
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.setContentType(this.getContentType(jaxRsContext.getProducesMediaType()).getValue());
        try {
            httpResponse.write((CharSequence)this.writeValueAsString(response));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("failed to write response.", e);
        }
        return httpResponse;
    }

    protected abstract String writeValueAsString(Object var1) throws IOException;

    public boolean isConvertible(String mediaType) {
        return mediaType.toLowerCase().startsWith("application/json");
    }
}

