/*
 * Decompiled with CFR 0.152.
 */
package nablarch.integration.router;

import java.util.ArrayList;
import java.util.List;
import nablarch.core.repository.SystemRepository;
import nablarch.core.util.ClassTraversal;
import nablarch.core.util.ResourcesUtil;
import nablarch.core.util.StringUtil;
import nablarch.integration.router.RoutesMapping;
import net.unit8.http.router.ARStringUtil;
import net.unit8.http.router.ControllerDetector;
import net.unit8.http.router.ControllerUtil;

public class NablarchControllerDetector
implements ControllerDetector {
    public List<String> detect() {
        final ArrayList<String> controllers = new ArrayList<String>();
        RoutesMapping mapping = (RoutesMapping)((Object)SystemRepository.getObject((String)"packageMapping"));
        final String actionBasePackage = mapping.getBasePackage();
        for (ResourcesUtil.Resources resources : ResourcesUtil.getResourcesTypes((String)actionBasePackage)) {
            resources.forEach(new ClassTraversal.ClassHandler(){

                public void process(String packageName, String shortClassName) {
                    String pkgPath = ARStringUtil.removeStart((String)packageName, (String)actionBasePackage);
                    String uncapitalizedShortClassName = ControllerUtil.fromClassNameToPath((String)shortClassName);
                    String actionPath = StringUtil.chomp((String)uncapitalizedShortClassName, (String)"Action");
                    StringBuilder sb = new StringBuilder(256);
                    if (StringUtil.hasValue((String)pkgPath)) {
                        sb.append(pkgPath.substring(1).replace('.', '/')).append('/');
                    }
                    sb.append(actionPath);
                    controllers.add(sb.toString());
                }
            });
        }
        return controllers;
    }
}

