/*
 * Decompiled with CFR 0.152.
 */
package nablarch.integration.router;

import java.util.List;
import java.util.Map;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.repository.initialization.Initializable;
import nablarch.fw.ExecutionContext;
import nablarch.fw.web.HttpErrorResponse;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.handler.RoutingHandlerSupport;
import nablarch.fw.web.servlet.ServletExecutionContext;
import nablarch.integration.router.PathOptions;
import nablarch.integration.router.PathOptionsFormatter;
import nablarch.integration.router.PathOptionsProvider;
import nablarch.integration.router.RoutesMethodBinderFactory;
import nablarch.integration.router.SimplePathOptionsFormatter;
import net.unit8.http.router.ARStringUtil;
import net.unit8.http.router.Options;
import net.unit8.http.router.RouteSet;
import net.unit8.http.router.RoutingException;

public class PathOptionsProviderRoutesMapping
extends RoutingHandlerSupport
implements Initializable {
    private static final Logger LOGGER = LoggerManager.get(PathOptionsProviderRoutesMapping.class);
    private final RouteSet routeSet = new RouteSet();
    private String baseUri = "";
    private PathOptionsProvider pathOptionsProvider;
    private PathOptionsFormatter pathOptionsFormatter = new SimplePathOptionsFormatter();

    protected Class<?> getHandlerClass(HttpRequest request, ExecutionContext executionContext) throws ClassNotFoundException {
        try {
            String path = this.getPath(request, executionContext);
            Options options = this.routeSet.recognizePath(path, request.getMethod());
            executionContext.setMethodBinder(this.methodBinderFactory.create((String)options.get((Object)"action")));
            Options params = options.except(new String[]{"controller", "action"});
            for (Map.Entry option : params.entrySet()) {
                if (option.getValue() == null) continue;
                request.setParam((String)option.getKey(), new String[]{option.getValue().toString()});
            }
            return Thread.currentThread().getContextClassLoader().loadClass((String)options.get((Object)"controller"));
        }
        catch (RoutingException e) {
            throw new HttpErrorResponse(HttpResponse.Status.NOT_FOUND.getStatusCode(), (Throwable)e);
        }
    }

    private String getPath(HttpRequest request, ExecutionContext executionContext) {
        String path = executionContext instanceof ServletExecutionContext ? ((ServletExecutionContext)executionContext).getHttpRequest().getRequestPath() : request.getRequestPath();
        String normalized = ARStringUtil.removeStart((String)path, (String)this.getBaseUri());
        return normalized.startsWith("/") ? normalized : "/" + normalized;
    }

    public void initialize() {
        if (this.pathOptionsProvider == null) {
            throw new IllegalStateException("pathOptionsProvider is not set.");
        }
        List<PathOptions> pathOptionsList = this.pathOptionsProvider.provide();
        for (PathOptions pathOptions : pathOptionsList) {
            this.routeSet.addRoute(pathOptions.getPath(), pathOptions.getOptions());
        }
        if (this.methodBinderFactory == null) {
            this.setMethodBinderFactory(new RoutesMethodBinderFactory());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this.pathOptionsFormatter.format(pathOptionsList), new Object[0]);
        }
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public void setPathOptionsProvider(PathOptionsProvider pathOptionsProvider) {
        this.pathOptionsProvider = pathOptionsProvider;
    }

    public void setPathOptionsFormatter(PathOptionsFormatter pathOptionsFormatter) {
        this.pathOptionsFormatter = pathOptionsFormatter;
    }
}

