/*
 * Decompiled with CFR 0.152.
 */
package nablarch.integration.router;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Map;
import nablarch.core.repository.initialization.Initializable;
import nablarch.core.util.FileUtil;
import nablarch.fw.ExecutionContext;
import nablarch.fw.web.HttpErrorResponse;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.handler.RoutingHandlerSupport;
import nablarch.fw.web.servlet.ServletExecutionContext;
import nablarch.integration.router.RoutesMethodBinderFactory;
import net.unit8.http.router.ARStringUtil;
import net.unit8.http.router.Options;
import net.unit8.http.router.Routes;
import net.unit8.http.router.RoutingException;

public class RoutesMapping
extends RoutingHandlerSupport
implements Initializable {
    private static volatile boolean loading = false;
    private static long lastLoaded = -1L;
    private String baseUri;
    private URL routesUrl;
    private long checkInterval;
    private String basePackage;

    public RoutesMapping() {
        this.setBaseUri("");
        this.setRoutes("routes.xml");
        this.setCheckInterval(0L);
    }

    protected Class<?> getHandlerClass(HttpRequest request, ExecutionContext executionContext) throws ClassNotFoundException {
        try {
            this.reloadRoutes();
            String path = executionContext instanceof ServletExecutionContext ? ((ServletExecutionContext)executionContext).getHttpRequest().getRequestPath() : request.getRequestPath();
            String normalizedPath = ARStringUtil.removeStart((String)path, (String)this.baseUri);
            if (!normalizedPath.startsWith("/")) {
                normalizedPath = "/" + normalizedPath;
            }
            Options options = Routes.recognizePath((String)normalizedPath, (String)request.getMethod());
            String controller = options.getString("controller");
            executionContext.setMethodBinder(this.methodBinderFactory.create(options.getString("action")));
            Options params = options.except(new String[]{"controller", "action"});
            for (Map.Entry paramPair : params.entrySet()) {
                if (paramPair.getValue() == null) continue;
                request.setParam((String)paramPair.getKey(), new String[]{paramPair.getValue().toString()});
            }
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return loader.loadClass(this.basePackage + "." + controller + "Action");
        }
        catch (RoutingException e) {
            throw new HttpErrorResponse(404, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadRoutes() {
        block11: {
            if (loading || this.routesIsNotFile()) {
                return;
            }
            try {
                File routesFile = new File(URLDecoder.decode(this.routesUrl.getPath(), "UTF-8"));
                int milli = 1000;
                if (lastLoaded >= 0L && (this.checkInterval < 0L || System.currentTimeMillis() <= lastLoaded + this.checkInterval * 1000L)) break block11;
                RoutesMapping routesMapping = this;
                synchronized (routesMapping) {
                    if (loading) {
                        return;
                    }
                    loading = true;
                }
                if (!loading) break block11;
                try {
                    long lastModified = routesFile.lastModified();
                    if (lastModified > lastLoaded) {
                        Routes.load((File)routesFile);
                        lastLoaded = System.currentTimeMillis();
                    }
                }
                finally {
                    loading = false;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean routesIsNotFile() {
        return !this.routesUrl.getProtocol().equals("file");
    }

    public void setRoutes(String routes) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        this.routesUrl = loader.getResource(routes);
        if (this.routesUrl == null) {
            throw new IllegalArgumentException("routes resource could not be found. routes = [" + routes + "]");
        }
    }

    public void setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public void initialize() {
        block5: {
            block4: {
                if (!this.routesIsNotFile()) break block4;
                InputStream in = null;
                try {
                    in = this.routesUrl.openStream();
                    Routes.load((InputStream)in);
                }
                catch (IOException iOException) {
                    FileUtil.closeQuietly((Closeable[])new Closeable[]{in});
                }
                catch (Throwable throwable) {
                    FileUtil.closeQuietly((Closeable[])new Closeable[]{in});
                    throw throwable;
                }
                FileUtil.closeQuietly((Closeable[])new Closeable[]{in});
                break block5;
            }
            this.reloadRoutes();
        }
        if (this.methodBinderFactory == null) {
            this.setMethodBinderFactory(new RoutesMethodBinderFactory());
        }
    }
}

