/*
 * Decompiled with CFR 0.152.
 */
package nablarch.integration.router;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import nablarch.core.util.StringUtil;
import nablarch.integration.router.PathOptions;
import nablarch.integration.router.PathOptionsFormatter;
import net.unit8.http.router.Options;

public class SimplePathOptionsFormatter
implements PathOptionsFormatter {
    @Override
    public String format(List<PathOptions> pathOptionsList) {
        TreeMap<String, PathOptions> sortedByPathAndHttpMethod = new TreeMap<String, PathOptions>();
        for (PathOptions pathOptions : pathOptionsList) {
            Options condition = (Options)pathOptions.getOptions().get((Object)"conditions");
            sortedByPathAndHttpMethod.put(pathOptions.getPath() + " " + condition.get((Object)"method"), pathOptions);
        }
        ArrayList<String> logStringList = new ArrayList<String>(pathOptionsList.size());
        for (PathOptions pathOptions : sortedByPathAndHttpMethod.values()) {
            logStringList.add(this.format(pathOptions));
        }
        return StringUtil.join((String)System.getProperty("line.separator"), logStringList);
    }

    private String format(PathOptions pathOptions) {
        Options options = pathOptions.getOptions();
        Options conditions = (Options)options.get((Object)"conditions");
        return String.format("%s %s => %s#%s", conditions.get((Object)"method"), pathOptions.getPath(), options.get((Object)"controller"), options.get((Object)"action"));
    }
}

