/*
 * Decompiled with CFR 0.152.
 */
package nablarch.integration.router.jaxrs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import nablarch.integration.router.PathOptions;
import nablarch.integration.router.PathOptionsProvider;
import nablarch.integration.router.jaxrs.JaxRsResource;
import nablarch.integration.router.jaxrs.JaxRsResourceFinder;
import nablarch.integration.router.jaxrs.JaxRsRouterConverter;

public class JaxRsPathOptionsProvider
implements PathOptionsProvider {
    private static final Comparator<PathOptions> ORDER_BY_PATH_ASC = new Comparator<PathOptions>(){

        @Override
        public int compare(PathOptions left, PathOptions right) {
            return left.getPath().compareTo(right.getPath());
        }
    };
    private String basePackage;
    private String applicationPath;

    @Override
    public List<PathOptions> provide() {
        if (this.applicationPath == null) {
            throw new IllegalStateException("applicationPath is not set.");
        }
        if (this.basePackage == null) {
            throw new IllegalStateException("basePackage is not set.");
        }
        JaxRsResourceFinder resourceFinder = new JaxRsResourceFinder();
        JaxRsRouterConverter pathStringParser = new JaxRsRouterConverter(this.applicationPath);
        ArrayList<PathOptions> pathOptionsList = new ArrayList<PathOptions>();
        for (JaxRsResource jaxRsResource : resourceFinder.find(this.basePackage)) {
            pathOptionsList.addAll(pathStringParser.parse(jaxRsResource));
        }
        Collections.sort(pathOptionsList, ORDER_BY_PATH_ASC);
        return pathOptionsList;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setApplicationPath(String applicationPath) {
        this.applicationPath = applicationPath;
    }
}

