/*
 * Decompiled with CFR 0.152.
 */
package nablarch.integration.router.jaxrs;

import java.util.regex.Pattern;
import nablarch.integration.router.jaxrs.PathRequirements;
import net.unit8.http.router.Options;

public class JaxRsPathParser {
    public PathRequirements parse(String jaxRsPath) {
        StringBuilder routerPath = new StringBuilder();
        Options requirements = Options.newInstance();
        CodePointIterator iterator = new CodePointIterator(jaxRsPath);
        while (iterator.hasNext()) {
            int codePoint = iterator.nextInt();
            if (codePoint == 123) {
                JaxRsPathParameter jaxRsPathParameter = this.parseJaxRsPathParameter(iterator);
                routerPath.append("(:").append(jaxRsPathParameter.name).append(')');
                if (!jaxRsPathParameter.hasRegex()) continue;
                requirements.put((Object)jaxRsPathParameter.name, (Object)Pattern.compile(jaxRsPathParameter.regex));
                continue;
            }
            routerPath.appendCodePoint(codePoint);
        }
        return new PathRequirements(routerPath.toString(), requirements);
    }

    private JaxRsPathParameter parseJaxRsPathParameter(CodePointIterator iterator) {
        StringBuilder parameterName = new StringBuilder();
        while (iterator.hasNext()) {
            int codePoint = iterator.nextInt();
            if (codePoint == 32) continue;
            if (codePoint == 125) {
                return new JaxRsPathParameter(parameterName.toString());
            }
            if (codePoint == 58) {
                String regex = this.parseJaxRsPathParameterRegex(iterator);
                return new JaxRsPathParameter(parameterName.toString(), regex);
            }
            parameterName.appendCodePoint(codePoint);
        }
        throw new IllegalStateException("Parameter segment has no end brackets. (parameterName='" + parameterName + "')");
    }

    private String parseJaxRsPathParameterRegex(CodePointIterator iterator) {
        StringBuilder regex = new StringBuilder();
        StringBuilder spaceBuf = new StringBuilder();
        int braceOpen = 0;
        boolean parameterSegmentClosed = false;
        boolean inRegexValue = false;
        while (iterator.hasNext()) {
            int codePoint = iterator.nextInt();
            if (codePoint == 32) {
                if (!inRegexValue) continue;
                spaceBuf.appendCodePoint(codePoint);
                continue;
            }
            inRegexValue = true;
            if (codePoint == 123) {
                ++braceOpen;
            } else if (codePoint == 125) {
                if (braceOpen == 0) {
                    parameterSegmentClosed = true;
                    break;
                }
                --braceOpen;
            }
            regex.append(spaceBuf.toString());
            regex.appendCodePoint(codePoint);
            spaceBuf.setLength(0);
        }
        if (!parameterSegmentClosed) {
            throw new IllegalStateException("Parameter segment has no end brackets. (regexp='" + regex + "')");
        }
        return regex.toString();
    }

    private static class JaxRsPathParameter {
        private final String name;
        private final String regex;

        private JaxRsPathParameter(String name) {
            this(name, (String)null);
        }

        private JaxRsPathParameter(String name, String regex) {
            this.name = name;
            this.regex = regex;
        }

        private boolean hasRegex() {
            return this.regex != null;
        }
    }

    private static class CodePointIterator {
        private final String text;
        private final int codePointCount;
        private int index;

        private CodePointIterator(String text) {
            this.text = text;
            this.codePointCount = text.codePointCount(0, text.length());
        }

        private boolean hasNext() {
            return this.index < this.codePointCount;
        }

        private int nextInt() {
            int codePoint = this.text.codePointAt(this.index);
            ++this.index;
            return codePoint;
        }
    }
}

