/*
 * Decompiled with CFR 0.152.
 */
package nablarch.integration.router.jaxrs;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import nablarch.core.util.ClassTraversal;
import nablarch.core.util.ResourcesUtil;
import nablarch.integration.router.jaxrs.JaxRsResource;

public class JaxRsResourceFinder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JaxRsResource> find(String basePackage) {
        ResourceClassHandler resourceClassHandler = new ResourceClassHandler();
        for (ResourcesUtil.Resources resourcesType : ResourcesUtil.getResourcesTypes((String)basePackage)) {
            try {
                resourcesType.forEach((ClassTraversal.ClassHandler)resourceClassHandler);
            }
            finally {
                resourcesType.close();
            }
        }
        return resourceClassHandler.getJaxRsResourceList();
    }

    private static class ResourceClassHandler
    implements ClassTraversal.ClassHandler {
        private final ClassLoader classLoader = this.getClass().getClassLoader();
        private final List<JaxRsResource> jaxRsResourceList = new ArrayList<JaxRsResource>();

        private ResourceClassHandler() {
        }

        public void process(String packageName, String className) {
            try {
                Class<?> clazz = this.classLoader.loadClass(packageName + "." + className);
                if (this.isJaxRsResource(clazz)) {
                    List<Method> resourceMethodList = this.findResourceMethods(clazz);
                    this.jaxRsResourceList.add(new JaxRsResource(clazz, resourceMethodList));
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        private boolean isJaxRsResource(Class<?> clazz) {
            return clazz.isAnnotationPresent(Path.class);
        }

        private List<Method> findResourceMethods(Class<?> clazz) {
            ArrayList<Method> methodList = new ArrayList<Method>();
            for (Method method : clazz.getDeclaredMethods()) {
                if (!this.isAnnotatedByHttpMethod(method)) continue;
                methodList.add(method);
            }
            return methodList;
        }

        private boolean isAnnotatedByHttpMethod(Method method) {
            int httpMethodAnnotationCount = 0;
            for (Annotation annotation : method.getDeclaredAnnotations()) {
                if (!annotation.annotationType().isAnnotationPresent(HttpMethod.class)) continue;
                ++httpMethodAnnotationCount;
            }
            if (2 <= httpMethodAnnotationCount) {
                throw new RuntimeException("'" + method.getName() + "' method has multiple HTTP method annotations.");
            }
            return httpMethodAnnotationCount == 1;
        }

        private List<JaxRsResource> getJaxRsResourceList() {
            return this.jaxRsResourceList;
        }
    }
}

