/*
 * Decompiled with CFR 0.152.
 */
package nablarch.integration.router.jaxrs;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import nablarch.integration.router.PathOptions;
import nablarch.integration.router.jaxrs.JaxRsPathParser;
import nablarch.integration.router.jaxrs.JaxRsResource;
import nablarch.integration.router.jaxrs.PathRequirements;
import net.unit8.http.router.Options;

public class JaxRsRouterConverter {
    private static final String PATH_SEPARATOR = "/";
    private final String applicationPath;
    private final JaxRsPathParser jaxRsPathParser;

    public JaxRsRouterConverter(String applicationPath) {
        this(applicationPath, new JaxRsPathParser());
    }

    public JaxRsRouterConverter(String applicationPath, JaxRsPathParser jaxRsPathParser) {
        this.applicationPath = applicationPath;
        this.jaxRsPathParser = jaxRsPathParser;
    }

    public List<PathOptions> parse(JaxRsResource jaxRsResource) {
        ArrayList<PathOptions> pathOptionsList = new ArrayList<PathOptions>();
        Class<?> resourceClass = jaxRsResource.getResourceClass();
        for (Method resourceMethod : jaxRsResource.getResourceMethodList()) {
            Options options = Options.newInstance();
            options.put((Object)"controller", (Object)resourceClass.getName());
            options.put((Object)"action", (Object)resourceMethod.getName());
            options.put((Object)"conditions", (Object)this.buildConditions(resourceMethod));
            PathRequirements pathRequirements = this.buildRouterRequirements(resourceClass, resourceMethod);
            options.put((Object)"requirements", (Object)pathRequirements.getRequirements());
            PathOptions pathOptions = new PathOptions(pathRequirements.getPath(), options);
            pathOptionsList.add(pathOptions);
        }
        return pathOptionsList;
    }

    private Options buildConditions(Method resourceMethod) {
        for (Annotation annotation : resourceMethod.getDeclaredAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!annotationType.isAnnotationPresent(HttpMethod.class)) continue;
            Options conditions = Options.newInstance();
            conditions.put((Object)"method", (Object)annotationType.getAnnotation(HttpMethod.class).value());
            return conditions;
        }
        throw new IllegalArgumentException("'" + resourceMethod.getName() + "' method has no HttpMethod annotation.");
    }

    private PathRequirements buildRouterRequirements(Class<?> resourceClass, Method resourceMethod) {
        String jaxRsPath = this.buildJaxRsPath(resourceClass, resourceMethod);
        return this.jaxRsPathParser.parse(jaxRsPath);
    }

    private String buildJaxRsPath(Class<?> clazz, Method method) {
        String classAppended = this.appendPath(this.applicationPath, clazz);
        return this.appendPath(classAppended, method);
    }

    private String appendPath(String basePath, AnnotatedElement target) {
        String pathValue;
        if (!target.isAnnotationPresent(Path.class)) {
            return basePath;
        }
        StringBuilder result = new StringBuilder(basePath);
        if (!basePath.endsWith(PATH_SEPARATOR)) {
            result.append(PATH_SEPARATOR);
        }
        if ((pathValue = target.getAnnotation(Path.class).value()).startsWith(PATH_SEPARATOR)) {
            result.append(pathValue.substring(1));
        } else {
            result.append(pathValue);
        }
        return result.toString();
    }
}

