/*
 * Decompiled with CFR 0.152.
 */
package spock.genesis.transform;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.spockframework.compiler.AstNodeCache;
import spock.genesis.generators.LimitedGenerator;
import spock.genesis.transform.Iterations;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class GenASTTransformation
implements ASTTransformation,
GroovyObject {
    private static final AstNodeCache NODE_CACHE;
    private static final ClassNode ITERATIONS_ANNOTATION;
    private static final ClassNode LIMITED_CLASS_GENERATOR;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public GenASTTransformation() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void visit(ASTNode[] nodes, SourceUnit sourceUnit) {
        ModuleNode module = (ModuleNode)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])nodes, (int)0), ModuleNode.class);
        List classes = module.getClasses();
        ClassNode clazz = null;
        Iterator iterator = classes.iterator();
        while (iterator.hasNext()) {
            clazz = (ClassNode)ScriptBytecodeAdapter.castToType(iterator.next(), ClassNode.class);
            if (!this.isSpec(clazz)) continue;
            AnnotationNode classIterationsAnnotation = this.findIterationsAnnotation((AnnotatedNode)clazz);
            Integer classIterations = null;
            if (DefaultTypeTransformation.booleanUnbox((Object)classIterationsAnnotation)) {
                Integer n;
                classIterations = n = this.getNumberOfIterations(classIterationsAnnotation);
            }
            Map<String, Integer> featureIterations = this.getFeatureIterations(clazz, classIterations);
            if (!DefaultTypeTransformation.booleanUnbox(featureIterations)) continue;
            this.modifyDataProviders(clazz, featureIterations);
        }
    }

    private Map<String, Integer> getFeatureIterations(ClassNode clazz, Integer classIterations) {
        LinkedHashMap featureIterations = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
        MethodNode method = null;
        Iterator iterator = clazz.getMethods().iterator();
        while (iterator.hasNext()) {
            method = (MethodNode)ScriptBytecodeAdapter.castToType(iterator.next(), MethodNode.class);
            if (!this.isFeature(method)) continue;
            Integer methodIterations = classIterations;
            AnnotationNode iterationsAnnotation = this.findIterationsAnnotation((AnnotatedNode)method);
            if (DefaultTypeTransformation.booleanUnbox((Object)iterationsAnnotation)) {
                Integer n;
                methodIterations = n = this.getNumberOfIterations(iterationsAnnotation);
            }
            if (!(methodIterations != null)) continue;
            featureIterations.put(method.getName(), methodIterations);
        }
        return featureIterations;
    }

    private void modifyDataProviders(ClassNode clazz, Map<String, Integer> featureIterations) {
        Set<String> modifyFeatureNames = featureIterations.keySet();
        MethodNode method = null;
        Iterator iterator = clazz.getMethods().iterator();
        while (iterator.hasNext()) {
            Expression expression;
            method = (MethodNode)ScriptBytecodeAdapter.castToType(iterator.next(), MethodNode.class);
            if (!this.isDataProvider(method)) continue;
            String featureName = this.getFeatureName(method.getName());
            if (!modifyFeatureNames.contains(featureName)) continue;
            int limit = DefaultTypeTransformation.intUnbox((Object)featureIterations.get(featureName));
            if (!(method.getCode() instanceof BlockStatement)) continue;
            BlockStatement code = (BlockStatement)ScriptBytecodeAdapter.castToType((Object)method.getCode(), BlockStatement.class);
            if (!(DefaultGroovyMethods.getAt((List)code.getStatements(), (int)0) instanceof ReturnStatement)) continue;
            ReturnStatement returnStatement = (ReturnStatement)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((List)code.getStatements(), (int)0), ReturnStatement.class);
            GenASTTransformation.wrapWithLimitedGenerator(returnStatement.getExpression(), limit);
            returnStatement.setExpression(expression);
        }
    }

    private String getFeatureName(String dataProviderName) {
        int featureEnd = dataProviderName.indexOf("prov");
        if (ScriptBytecodeAdapter.compareNotEqual((Object)featureEnd, (Object)-1)) {
            return dataProviderName.substring(0, featureEnd);
        }
        return ShortTypeHandling.castToString(null);
    }

    private AnnotationNode findAnnotation(ClassNode annotation, AnnotatedNode annotatedNode) {
        Reference annotation2 = new Reference((Object)annotation);
        public class _findAnnotation_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference annotation;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _findAnnotation_closure1(Object _outerInstance, Object _thisObject, Reference annotation) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.annotation = reference = annotation;
            }

            public Object doCall(Object it) {
                return ((AnnotationNode)it).getClassNode().isDerivedFrom((ClassNode)ScriptBytecodeAdapter.castToType((Object)this.annotation.get(), ClassNode.class));
            }

            public ClassNode getAnnotation() {
                return (ClassNode)ScriptBytecodeAdapter.castToType((Object)this.annotation.get(), ClassNode.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _findAnnotation_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (AnnotationNode)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.find((Collection)annotatedNode.getAnnotations(), (Closure)new _findAnnotation_closure1(this, this, annotation2)), AnnotationNode.class);
    }

    private boolean isDataProvider(MethodNode method) {
        return DefaultTypeTransformation.booleanUnbox((Object)this.findAnnotation(GenASTTransformation.NODE_CACHE.DataProviderMetadata, (AnnotatedNode)method));
    }

    private boolean isFeature(MethodNode method) {
        return DefaultTypeTransformation.booleanUnbox((Object)this.findAnnotation(GenASTTransformation.NODE_CACHE.FeatureMetadata, (AnnotatedNode)method));
    }

    private AnnotationNode findIterationsAnnotation(AnnotatedNode annotatedNode) {
        return this.findAnnotation(ITERATIONS_ANNOTATION, annotatedNode);
    }

    private boolean isSpec(ClassNode clazz) {
        return clazz.isDerivedFrom(GenASTTransformation.NODE_CACHE.Specification);
    }

    private Integer getNumberOfIterations(AnnotationNode iterationsAnnotation) {
        if (DefaultTypeTransformation.booleanUnbox((Object)iterationsAnnotation)) {
            Expression value = iterationsAnnotation.getMember("value");
            if (value instanceof ConstantExpression) {
                ConstantExpression valueExpression = (ConstantExpression)ScriptBytecodeAdapter.castToType((Object)value, ConstantExpression.class);
                return (Integer)ScriptBytecodeAdapter.castToType((Object)valueExpression.getValue(), Integer.class);
            }
            return 100;
        }
        return (Integer)ScriptBytecodeAdapter.castToType(null, Integer.class);
    }

    private static Expression wrapWithLimitedGenerator(Expression expression, int limit) {
        ArgumentListExpression args = new ArgumentListExpression(expression, (Expression)new ConstantExpression((Object)limit));
        return new ConstructorCallExpression(LIMITED_CLASS_GENERATOR, (Expression)args);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GenASTTransformation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        ClassNode classNode;
        ClassNode classNode2;
        AstNodeCache astNodeCache;
        NODE_CACHE = astNodeCache = new AstNodeCache();
        ITERATIONS_ANNOTATION = classNode2 = ClassHelper.makeWithoutCaching(Iterations.class);
        LIMITED_CLASS_GENERATOR = classNode = ClassHelper.makeWithoutCaching(LimitedGenerator.class);
    }

    public static final AstNodeCache getNODE_CACHE() {
        return NODE_CACHE;
    }

    public static final ClassNode getITERATIONS_ANNOTATION() {
        return ITERATIONS_ANNOTATION;
    }

    public static final ClassNode getLIMITED_CLASS_GENERATOR() {
        return LIMITED_CLASS_GENERATOR;
    }
}

