/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.ssl;

import java.io.IOException;
import java.net.Socket;
import javax.net.ssl.SSLServerSocket;
import org.apache.commons.ssl.JavaImpl;
import org.apache.commons.ssl.SSL;
import org.apache.commons.ssl.SSLServerSocketWrapper;
import org.apache.commons.ssl.SSLSocketWrapper;

public interface SSLWrapperFactory {
    public static final SSLWrapperFactory NO_WRAP = new SSLWrapperFactory(){

        @Override
        public Socket wrap(Socket s) {
            return s;
        }

        @Override
        public SSLServerSocket wrap(SSLServerSocket s, SSL ssl) throws IOException {
            boolean java13 = JavaImpl.isJava13();
            return java13 ? s : new SSLServerSocketWrapper(s, ssl, this);
        }
    };
    public static final SSLWrapperFactory DUMB_WRAP = new SSLWrapperFactory(){

        @Override
        public Socket wrap(Socket s) {
            return new SSLSocketWrapper(s);
        }

        @Override
        public SSLServerSocket wrap(SSLServerSocket s, SSL ssl) throws IOException {
            boolean java13 = JavaImpl.isJava13();
            return java13 ? s : new SSLServerSocketWrapper(s, ssl, this);
        }
    };

    public Socket wrap(Socket var1) throws IOException;

    public SSLServerSocket wrap(SSLServerSocket var1, SSL var2) throws IOException;
}

