/*
 * BridJ - Dynamic and blazing-fast native interop for Java.
 * http://bridj.googlecode.com/
 *
 * Copyright (c) 2010-2013, Olivier Chafik (http://ochafik.com/)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Olivier Chafik nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY OLIVIER CHAFIK AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.bridj.cpp.com;

import org.bridj.Pointer;
import org.bridj.ann.Library;
import org.bridj.ann.Runtime;
import org.bridj.ann.Virtual;

/**
 * <i>native declaration : line 176</i><br>
 * This file was autogenerated by <a
 * href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a
 * href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few
 * opensource projects.</a>.<br>
 * For help, please visit <a
 * href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a
 * href="http://bridj.googlecode.com/">BridJ</a> .
 */
@IID("0000002F-0000-0000-C000-000000000046")
public class IRecordInfo extends IUnknown {
//	public IRecordInfo() {
//		super();
//	}
//	public IRecordInfo(Pointer pointer) {
//		super(pointer);
//	}

    @Virtual(0)
    public native int RecordInit(Pointer<?> pvNew);

    @Virtual(1)
    public native int RecordClear(Pointer<?> pvExisting);

    @Virtual(2)
    public native int RecordCopy(Pointer<?> pvExisting, Pointer<?> pvNew);

    @Virtual(3)
    public native int GetGuid(Pointer<GUID> pguid);

    @Virtual(4)
    public native int GetName(Pointer<Pointer<Byte>> pbstrName);

    @Virtual(5)
    public native int GetSize(Pointer<Integer> pcbSize);

    @Virtual(6)
    public native int GetTypeInfo(Pointer<Pointer<ITypeInfo>> ppTypeInfo);

    @Virtual(7)
    public native int GetField(Pointer<?> pvData, Pointer<Byte> szFieldName, Pointer<VARIANT> pvarField);

    @Virtual(8)
    public native int GetFieldNoCopy(Pointer<?> pvData, Pointer<Byte> szFieldName, Pointer<VARIANT> pvarField, Pointer<Pointer<?>> ppvDataCArray);

    @Virtual(9)
    public native int PutField(int wFlags, Pointer<?> pvData, Pointer<Byte> szFieldName, Pointer<VARIANT> pvarField);

    @Virtual(10)
    public native int PutFieldNoCopy(int wFlags, Pointer<?> pvData, Pointer<Byte> szFieldName, Pointer<VARIANT> pvarField);

    @Virtual(11)
    public native int GetFieldNames(Pointer<Integer> pcNames, Pointer<Pointer<Byte>> rgBstrNames);

    @Virtual(12)
    public native boolean IsMatchingType(Pointer<IRecordInfo> pRecordInfo);

    @Virtual(13)
    public native Pointer<?> RecordCreate();

    @Virtual(14)
    public native int RecordCreateCopy(Pointer<?> pvSource, Pointer<Pointer<?>> ppvDest);

    @Virtual(15)
    public native int RecordDestroy(Pointer<?> pvRecord);
}
