/*
 * BridJ - Dynamic and blazing-fast native interop for Java.
 * http://bridj.googlecode.com/
 *
 * Copyright (c) 2010-2013, Olivier Chafik (http://ochafik.com/)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Olivier Chafik nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY OLIVIER CHAFIK AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.bridj.jawt;

import org.bridj.Callback;
import org.bridj.Pointer;
import org.bridj.StructObject;
import org.bridj.ann.Field;
import org.bridj.ann.Library;
import org.bridj.jawt.JawtLibrary.JNIEnv;
import org.bridj.ann.Convention;

/**
 * <i>native declaration : jawt.h</i><br>
 * This file was autogenerated by <a
 * href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a
 * href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few
 * opensource projects.</a>.<br>
 * For help, please visit <a
 * href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a
 * href="http://bridj.googlecode.com/">BridJ</a> .
 */
@Library("jawt")
@Convention(Convention.Style.StdCall)
public class JAWT extends StructObject {

    /**
     * Version of this structure. This must always be set before<br>
     * calling JAWT_GetAWT()
     */
    @Field(0)
    public int version() {
        return this.io.getIntField(this, 0);
    }

    /**
     * Version of this structure. This must always be set before<br>
     * calling JAWT_GetAWT()
     */
    @Field(0)
    public JAWT version(int version) {
        this.io.setIntField(this, 0, version);
        return this;
    }

    @Field(1)
    public Pointer<GetDrawingSurface_callback> GetDrawingSurface() {
        return this.io.getPointerField(this, 1);
    }

    @Field(2)
    public Pointer<FreeDrawingSurface_callback> FreeDrawingSurface() {
        return this.io.getPointerField(this, 2);
    }

    @Field(3)
    public Pointer<Lock_callback> Lock() {
        return this.io.getPointerField(this, 3);
    }

    @Field(4)
    public Pointer<Unlock_callback> Unlock() {
        return this.io.getPointerField(this, 4);
    }

    @Field(5)
    public Pointer<GetComponent_callback> GetComponent() {
        return this.io.getPointerField(this, 5);
    }

    public static abstract class GetDrawingSurface_callback extends Callback {

        public abstract Pointer<org.bridj.jawt.JAWT_DrawingSurface> invoke(Pointer<JNIEnv> env, Pointer<?> target);
    };
    /// <i>native declaration : jawt.h:236</i>

    public static abstract class FreeDrawingSurface_callback extends Callback {

        public abstract void invoke(Pointer<org.bridj.jawt.JAWT_DrawingSurface> ds);
    };
    /// <i>native declaration : jawt.h:242</i>

    public static abstract class Lock_callback extends Callback {

        public abstract void invoke(Pointer<JNIEnv> env);
    };
    /// <i>native declaration : jawt.h:247</i>

    public static abstract class Unlock_callback extends Callback {

        public abstract void invoke(Pointer<JNIEnv> env);
    };
    /// <i>native declaration : jawt.h:259</i>

    public static abstract class GetComponent_callback extends Callback {

        public abstract Pointer<?> invoke(Pointer<JNIEnv> env, Pointer<?> platformInfo);
    };
}
