/*
 * JavaCL - Java API and utilities for OpenCL
 * http://javacl.googlecode.com/
 *
 * Copyright (c) 2009-2013, Olivier Chafik (http://ochafik.com/)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Olivier Chafik nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY OLIVIER CHAFIK AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
	




	

	
	



	

	
	
	

	
package com.nativelibs4java.opencl;
import com.nativelibs4java.opencl.library.IOpenCLLibrary.cl_event;
import org.bridj.*;
import static org.bridj.Pointer.*;
/**
 *
 * @author ochafik
 */
final class ReusablePointers {
	public final int[] int1Array = new int[1];

    public final ReusablePointer
            sizeT3_1 = new ReusablePointer(3 * SizeT.SIZE),
            sizeT3_2 = new ReusablePointer(3 * SizeT.SIZE),
            sizeT3_3 = new ReusablePointer(3 * SizeT.SIZE);
    
    public final Pointer<Integer>
            int1 = allocateInt().withoutValidityInformation(),
            int2 = allocateInt().withoutValidityInformation();
    
    public final Pointer<SizeT>
            sizeT1 = allocateSizeT().withoutValidityInformation();
    
    public final Pointer<Long>
            long1 = allocateLong().withoutValidityInformation();
    
    public final Pointer<Pointer<?>>
            ptr1 = allocatePointer().withoutValidityInformation();
    
    public final ReusablePointer
            int3_1 = new ReusablePointer(4 * 3);
    
    public final ReusablePointer
            kernelArg = new ReusablePointer(8 * 16); // double16 arguments !
    
    public final Pointer<cl_event> event_out = allocateTypedPointer(cl_event.class).withoutValidityInformation();
    
    public final Pointer<Integer> pErr = allocateInt().withoutValidityInformation();
    
    public final int[] event_count = new int[1];
    public final ReusablePointer events_in = new ReusablePointer(Pointer.SIZE * 10);
    
    private ReusablePointers() {}
    
    public static ReusablePointers get() {
        return local.get();
    }
    private static final ThreadLocal<ReusablePointers> local = new ThreadLocal<ReusablePointers>() {

        @Override
        protected ReusablePointers initialValue() {
            return new ReusablePointers();
        }
        
    };
    
}
