/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.admin.visualstudio;

import com.ochafik.admin.visualstudio.Configuration;
import com.ochafik.admin.visualstudio.FileConfiguration;
import com.ochafik.admin.visualstudio.Solution;
import com.ochafik.admin.visualstudio.VisualStudioUtils;
import com.ochafik.xml.XMLUtils;
import com.ochafik.xml.XPathUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project
implements Comparable<Project> {
    public final Solution solution;
    public File projectFile;
    public String name;
    public String id;
    public List<String> depsIds = new ArrayList<String>();
    public Map<String, String> activeConfigurationNameBySolutionConfigurationName = new LinkedHashMap<String, String>();
    public Map<String, Configuration> configurations = new LinkedHashMap<String, Configuration>();
    public Map<File, FileConfiguration> fileConfigurations = new LinkedHashMap<File, FileConfiguration>();
    public List<File> files = new ArrayList<File>();

    public Project(Solution solution, File projectFile, String name, String id) {
        this.solution = solution;
        this.projectFile = projectFile;
        this.name = name;
        this.id = id;
    }

    @Override
    public int compareTo(Project o) {
        return this.name.compareTo(o.name);
    }

    String resolve(String s, Configuration configuration) {
        String res = VisualStudioUtils.resolveVariables(s, this.solution, this, configuration);
        return res == null || res.length() == 0 ? null : res;
    }

    public String resolveStringByXPath(String xPathString, Object source, Configuration configuration) throws XPathExpressionException {
        return this.resolve(XPathUtils.findStringByXPath((String)xPathString, (Object)source), configuration);
    }

    public List<String> resolveListByXPath(String xPathString, Object source, String separatorPattern, Configuration configuration) throws XPathExpressionException {
        String s = this.resolve(XPathUtils.findStringByXPath((String)xPathString, (Object)source), configuration);
        return s == null ? Collections.EMPTY_LIST : Arrays.asList(s.split(separatorPattern));
    }

    public TreeSet<String> resolveSetByXPath(String xPathString, Object source, String separatorPattern, Configuration configuration) throws XPathExpressionException {
        return new TreeSet<String>(this.resolveListByXPath(xPathString, source, separatorPattern, configuration));
    }

    Configuration parseConfiguration(Node configNode) throws XPathExpressionException {
        Configuration config = new Configuration();
        config.name = this.resolve(XPathUtils.findStringByXPath((String)"@Name", (Object)configNode), config);
        if (config.name == null) {
            return null;
        }
        config.outputDirectory = this.resolve(XPathUtils.findStringByXPath((String)"@OutputDirectory", (Object)configNode), config);
        Node compilerTool = XPathUtils.findNodeByXPath((String)"Tool[@Name='VCCLCompilerTool']", (Object)configNode);
        if (compilerTool != null) {
            config.includes = this.resolveListByXPath("@AdditionalIncludeDirectories", compilerTool, ";", config);
            config.preprocessorDefinitions = this.resolveSetByXPath("@PreprocessorDefinitions", compilerTool, ";", config);
        }
        config.outputFile = this.resolve(XPathUtils.findStringByXPath((String)"Tool[@Name='VCLinkerTool']/@OutputFile", (Object)configNode), config);
        return config;
    }

    public void parse(FileFilter fileFilter, boolean parseFileConfigurations, Solution solution) throws Exception {
        if (!this.projectFile.exists() || !this.projectFile.isFile()) {
            throw new IOException("Cannot find project file " + this.projectFile);
        }
        Document document = XMLUtils.readXML((File)this.projectFile);
        File projectPath = this.projectFile.getParentFile();
        for (Node configurationNode : XPathUtils.findNodesIterableByXPath((String)"VisualStudioProject/Configurations/Configuration", (Object)document)) {
            Configuration config = this.parseConfiguration(configurationNode);
            if (config == null) continue;
            this.configurations.put(config.name, config);
        }
        for (Node fileNode : XPathUtils.findNodesIterableByXPath((String)"//Files//File", (Object)document)) {
            String relativePath = this.resolveStringByXPath("@RelativePath", fileNode, null);
            if (relativePath == null) continue;
            File file = Project.relFile(projectPath, relativePath);
            if (fileFilter != null && !fileFilter.accept(file)) continue;
            this.files.add(file);
            if (!parseFileConfigurations) continue;
            FileConfiguration fileConfiguration = new FileConfiguration();
            fileConfiguration.file = file;
            this.fileConfigurations.put(file, fileConfiguration);
            for (Node fileConfigurationNode : XPathUtils.findNodesIterableByXPath((String)"FileConfiguration", (Object)fileNode)) {
                Configuration config = this.parseConfiguration(fileConfigurationNode);
                if (config == null) continue;
                fileConfiguration.configurations.put(config.name, config);
            }
        }
    }

    static File relFile(File base, String relPath) {
        relPath = relPath.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        return new File(base, relPath);
    }
}

