/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.admin.visualstudio;

import com.ochafik.admin.visualstudio.Configuration;
import com.ochafik.admin.visualstudio.Project;
import com.ochafik.admin.visualstudio.Solution;
import com.ochafik.util.listenable.Adapter;
import com.ochafik.util.string.RegexUtils;
import com.sun.jna.Platform;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualStudioUtils {
    private static Logger logger = Logger.getLogger(VisualStudioUtils.class.getName());
    static final Pattern variablePattern = Pattern.compile("$\\(([^)]+)\\)");

    public static List<String> getMicrosoftIncludes() {
        return Arrays.asList(VisualStudioUtils.getProp("VISUAL_STUDIO_INCLUDES", VisualStudioUtils.getMicrosoftVisualStudioHome() + "\\VC\\include" + ";" + VisualStudioUtils.getMicrosoftWindowsSDKHome() + "\\Include", true).split(";"));
    }

    public static File getMicrosoftWindowsProgramFilesDirectory() {
        String propName = Platform.is64Bit() ? "ProgramFiles(x86)" : "ProgramFiles";
        return new File(VisualStudioUtils.getProp(propName, "C:\\Program Files", true));
    }

    public static String getMicrosoftWindowsSDKHome() {
        return VisualStudioUtils.getProp("WINDOWS_SDK_HOME", new File(VisualStudioUtils.getMicrosoftWindowsProgramFilesDirectory(), "Microsoft SDKs\\Windows\\v6.0A").toString(), true);
    }

    private static String getMicrosoftVisualStudioHome() {
        return VisualStudioUtils.getProp("VISUAL_STUDIO_HOME", new File(VisualStudioUtils.getMicrosoftWindowsProgramFilesDirectory(), "Microsoft Visual Studio 9.0").toString(), true);
    }

    static String getProp(String name, String defVal) {
        return VisualStudioUtils.getProp(name, defVal, false);
    }

    static String getProp(String name, String defVal, boolean remember) {
        String v = System.getenv(name);
        v = v == null ? System.getProperty(name, defVal) : v;
        logger.log(Level.INFO, "[environment] " + name + "=" + v);
        return v;
    }

    public static String resolveVariables(String string, final Solution solution, final Project project, final Configuration configuration) {
        String res = RegexUtils.regexReplace((Pattern)variablePattern, (String)string, (Adapter)new Adapter<String[], String>(){

            public String adapt(String[] value) {
                String match = value[0];
                String variableName = value[1];
                VarType type = VarType.valueOf(variableName);
                if (type != null) {
                    switch (type) {
                        case ProjectName: {
                            return project.name == null ? match : project.name;
                        }
                        case TargetPath: {
                            return configuration.outputFile == null ? match : configuration.outputFile;
                        }
                        case SolutionName: {
                            String name = solution.getName();
                            return name == null ? match : name;
                        }
                        case SolutionDir: {
                            return solution.solutionFile == null ? match : solution.solutionFile.getParent();
                        }
                        case ConfigurationName: {
                            return configuration.name;
                        }
                        case TargetDir: {
                            if (configuration.outputFile == null) {
                                return match;
                            }
                            return new File(configuration.outputFile).getParent();
                        }
                    }
                    return match;
                }
                String v = System.getenv().get(variableName);
                return v == null ? match : v;
            }
        });
        return res;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum VarType {
        SolutionName,
        SolutionDir,
        ProjectName,
        ConfigurationName,
        TargetDir,
        TargetPath;

    }
}

