/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.compiler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import javax.tools.FileObject;

public class MemoryFileObject
implements FileObject {
    String path;
    byte[] content;

    public MemoryFileObject(String path, String content) {
        this.path = path;
        this.content = content == null ? null : content.getBytes();
    }

    public MemoryFileObject(String path, byte[] content) {
        this.path = path;
        this.content = content;
    }

    public String getPath() {
        return this.path;
    }

    public byte[] getContent() {
        return this.content;
    }

    public boolean delete() {
        this.content = null;
        return true;
    }

    public String getCharContent(boolean ignoreEncodingErrors) {
        return new String(this.content);
    }

    public long getLastModified() {
        return System.currentTimeMillis();
    }

    public String getName() {
        return this.getPath();
    }

    public InputStream openInputStream() {
        if (this.content == null) {
            return null;
        }
        return new ByteArrayInputStream(this.content);
    }

    public OutputStream openOutputStream() {
        return new ByteArrayOutputStream(){

            public void close() throws IOException {
                super.close();
                MemoryFileObject.this.content = this.toByteArray();
            }
        };
    }

    public Reader openReader(boolean ignoreEncodingErrors) {
        InputStream in = this.openInputStream();
        return in == null ? null : new InputStreamReader(in);
    }

    public Writer openWriter() {
        OutputStream out = this.openOutputStream();
        return out == null ? null : new OutputStreamWriter(out);
    }

    public URI toUri() {
        try {
            return new URI(this.getPath());
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return this.getPath() + ":\n" + this.getCharContent(true);
    }
}

