/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.lang.jnaerator.BridJTypeConversion;
import com.ochafik.lang.jnaerator.MatchingUtils;
import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.TypeConversion;
import com.ochafik.lang.jnaerator.UnsupportedConversionException;
import com.ochafik.lang.jnaerator.parser.Declaration;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.ModifierType;
import com.ochafik.lang.jnaerator.parser.Scanner;
import com.ochafik.lang.jnaerator.parser.Statement;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.VariablesDeclaration;
import com.ochafik.lang.jnaerator.parser.Visitor;
import com.ochafik.util.listenable.Pair;
import com.ochafik.util.string.StringUtils;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.bridj.BridJ;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridJer {
    Result result;
    int iFile = 0;

    public BridJer(Result result) {
        this.result = result;
    }

    String primName(TypeRef tr) {
        tr = tr.clone();
        tr.setModifiers(Collections.EMPTY_LIST);
        return tr.toString();
    }

    String primCapName(TypeRef tr) {
        return StringUtils.capitalize((String)this.primName(tr));
    }

    Expression staticPtrMethod(String name, Expression ... args) {
        return ElementsHelper.methodCall((Expression)ElementsHelper.expr((TypeRef)ElementsHelper.typeRef((Class)this.ptrClass())), (String)name, (Expression[])args);
    }

    public Pair<Element, List<Declaration>> convertToJava(Element element, final Identifier libraryClassName) {
        try {
            PrintStream out = new PrintStream("jnaerator-" + this.iFile++ + ".out");
            out.println(element);
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        final ArrayList extraDeclarationsOut = new ArrayList();
        final ReferencedElements ref = this.findReferencedElements(element);
        element.accept((Visitor)new Scanner(){
            int nConstants = 0;
            Set<Element> deleteStatements = new HashSet<Element>();

            public void visitVariableRef(Expression.VariableRef vr) {
                super.visitVariableRef(vr);
                String identStr = vr.getName() + "";
                if ("NULL".equals(identStr)) {
                    vr.replaceBy((Element)ElementsHelper.nullExpr());
                }
            }

            public void visitConstant(Expression.Constant c) {
                if (c.getValue() instanceof String) {
                    String ptrMethodName;
                    Class charClass;
                    if (c.getType() == Expression.Constant.Type.LongString) {
                        charClass = Short.class;
                        ptrMethodName = "pointerToWideCString";
                    } else {
                        charClass = Byte.class;
                        ptrMethodName = "pointerToCString";
                    }
                    String fieldName = "strConstant" + ++this.nConstants;
                    VariablesDeclaration staticConstField = new VariablesDeclaration((TypeRef)ElementsHelper.typeRef((Identifier)ElementsHelper.ident((Class)BridJer.this.ptrClass(), (Expression[])new Expression[]{ElementsHelper.expr((TypeRef)ElementsHelper.typeRef(charClass))})), new Declarator[]{new Declarator.DirectDeclarator(fieldName, BridJer.this.staticPtrMethod(ptrMethodName, c.clone()))});
                    staticConstField.addModifiers(new Modifier[]{ModifierType.Static, ModifierType.Private, ModifierType.Final});
                    extraDeclarationsOut.add(staticConstField);
                    c.replaceBy((Element)ElementsHelper.varRef((String)fieldName));
                    return;
                }
                super.visitConstant(c);
            }

            void replaceMalloc(TypeRef pointedType, Element toReplace, Expression sizeExpression) {
                Pair<TypeRef, Expression> typeAndSize = MatchingUtils.recognizeSizeOfMult(sizeExpression);
                if (typeAndSize != null && (pointedType == null || pointedType.equals(typeAndSize.getFirst()))) {
                    String tStr = String.valueOf(typeAndSize.getFirst());
                    try {
                        TypeConversion.JavaPrim prim = TypeConversion.JavaPrim.getJavaPrim(tStr);
                        if (prim != null && prim.isPrimitive) {
                            String cap = StringUtils.capitalize((String)tStr);
                            toReplace.replaceBy((Element)BridJer.this.staticPtrMethod("allocate" + cap + "s", (Expression)typeAndSize.getValue()));
                            return;
                        }
                    }
                    catch (Throwable th) {
                        // empty catch block
                    }
                }
                toReplace.replaceBy((Element)BridJer.this.staticPtrMethod("allocateBytes", sizeExpression));
            }

            <T extends Element> void visitAllButConstants(List<T> elements) {
                if (elements == null) {
                    return;
                }
                for (Element element : elements) {
                    if (element == null || element instanceof Expression.Constant) continue;
                    element.accept((Visitor)this);
                }
            }

            List<Expression> getArgs(List<Pair<String, Expression>> args) {
                if (args == null) {
                    return null;
                }
                ArrayList<Expression> ret = new ArrayList<Expression>(args.size());
                for (Pair<String, Expression> p : args) {
                    ret.add((Expression)p.getValue());
                }
                return ret;
            }

            public void visitDelete(Statement.Delete d) {
                d.replaceBy((Element)ElementsHelper.stat((Expression)ElementsHelper.methodCall((Expression)d.getValue(), (String)"release", (Expression[])new Expression[0])));
            }

            public void visitFunctionCall(Expression.FunctionCall fc) {
                Identifier ident;
                super.visit((Element)fc.getTarget());
                super.visit((Element)fc.getFunction());
                List<Expression> arguments = this.getArgs(fc.getArguments());
                if (fc.getTarget() == null && fc.getFunction() instanceof Expression.VariableRef && (ident = ((Expression.VariableRef)fc.getFunction()).getName()) instanceof Identifier.SimpleIdentifier && ((Identifier.SimpleIdentifier)ident).getTemplateArguments().isEmpty()) {
                    Expression arg3;
                    String name = ident.toString();
                    int nArgs = arguments == null ? 0 : arguments.size();
                    Expression arg1 = nArgs > 0 ? arguments.get(0) : null;
                    Expression arg2 = nArgs > 1 ? arguments.get(1) : null;
                    Expression expression = arg3 = nArgs > 2 ? arguments.get(2) : null;
                    if ("printf".equals(name)) {
                        this.visitAllButConstants(arguments);
                        fc.replaceBy((Element)ElementsHelper.methodCall((Expression)ElementsHelper.memberRef((Expression)ElementsHelper.expr((TypeRef)ElementsHelper.typeRef(System.class)), (String)"out"), (String)"println", (Expression[])new Expression[]{this.formatStr(arg1, arguments, 1)}));
                        return;
                    }
                    if ("sprintf".equals(name)) {
                        this.visitAllButConstants(arguments);
                        fc.replaceBy((Element)ElementsHelper.methodCall((Expression)arg1, (String)"setCString", (Expression[])new Expression[]{this.formatStr(arg2, arguments, 2)}));
                        return;
                    }
                    switch (nArgs) {
                        case 1: {
                            if ("malloc".equals(name)) {
                                this.visit(arguments);
                                this.replaceMalloc(null, (Element)fc, arg1);
                                return;
                            }
                            if (!"free".equals(name)) break;
                            this.visit(arguments);
                            fc.replaceBy((Element)ElementsHelper.methodCall((Expression)arg1, (String)"release", (Expression[])new Expression[0]));
                            return;
                        }
                        case 3: {
                            if ("memset".equals(name)) {
                                this.visit(arguments);
                                Expression value = arg2;
                                Expression num = arg3;
                                if ("0".equals(value + "")) {
                                    fc.replaceBy((Element)ElementsHelper.methodCall((Expression)arg1, (String)"clearBytes", (Expression[])new Expression[]{ElementsHelper.expr((int)0), num}));
                                } else {
                                    fc.replaceBy((Element)ElementsHelper.methodCall((Expression)arg1, (String)"clearBytes", (Expression[])new Expression[]{ElementsHelper.expr((int)0), num, value}));
                                }
                                return;
                            }
                            if ("memcpy".equals(name)) {
                                this.visit(arguments);
                                Expression dest = arg1;
                                Expression source = arg2;
                                Expression num = arg3;
                                fc.replaceBy((Element)ElementsHelper.methodCall((Expression)source, (String)"copyBytesAtOffsetTo", (Expression[])new Expression[]{ElementsHelper.expr((int)0), dest, ElementsHelper.expr((int)0), num}));
                                return;
                            }
                            if ("memmov".equals(name)) {
                                this.visit(arguments);
                                Expression dest = arg1;
                                Expression source = arg2;
                                Expression num = arg3;
                                fc.replaceBy((Element)ElementsHelper.methodCall((Expression)source, (String)"moveBytesAtOffsetTo", (Expression[])new Expression[]{ElementsHelper.expr((int)0), dest, ElementsHelper.expr((int)0), num}));
                                return;
                            }
                            if (!"memcmp".equals(name)) break;
                            this.visit(arguments);
                            Expression ptr1 = arg1;
                            Expression ptr2 = arg2;
                            Expression num = arg3;
                            fc.replaceBy((Element)ElementsHelper.methodCall((Expression)ptr1, (String)"compareBytes", (Expression[])new Expression[]{ptr2, num}));
                            return;
                        }
                    }
                }
                this.visit(arguments);
            }

            Expression formatStr(Expression str, List<Expression> arguments, int argsToSkip) {
                if (arguments.isEmpty()) {
                    return str;
                }
                ArrayList<Expression> fmtArgs = new ArrayList<Expression>();
                if (!(str instanceof Expression.Constant)) {
                    str = ElementsHelper.methodCall((Expression)str, (String)"getCString", (Expression[])new Expression[0]);
                }
                fmtArgs.add(str);
                int nArgs = arguments.size();
                for (int i = argsToSkip; i < nArgs; ++i) {
                    fmtArgs.add(arguments.get(i));
                }
                return ElementsHelper.methodCall((Expression)ElementsHelper.expr((TypeRef)ElementsHelper.typeRef(String.class)), (String)"format", (Expression[])fmtArgs.toArray(new Expression[fmtArgs.size()]));
            }

            public void visitIf(Statement.If ifStat) {
                super.visitIf(ifStat);
                Expression cond = ifStat.getCondition();
                if (!(cond instanceof Expression.BinaryOp)) {
                    cond.replaceBy((Element)ElementsHelper.expr((Expression)cond, (Expression.BinaryOperator)Expression.BinaryOperator.IsDifferent, (Expression)ElementsHelper.expr((int)0)));
                }
            }

            public void visitUnaryOp(Expression.UnaryOp unaryOp) {
                super.visitUnaryOp(unaryOp);
                switch (unaryOp.getOperator()) {
                    case Dereference: {
                        unaryOp.replaceBy((Element)ElementsHelper.methodCall((Expression)unaryOp.getOperand(), (String)"get", (Expression[])new Expression[0]));
                        break;
                    }
                    case Reference: {
                        unaryOp.replaceBy((Element)ElementsHelper.methodCall((Expression)unaryOp.getOperand(), (String)"getReference", (Expression[])new Expression[0]));
                    }
                }
            }

            public void visitCast(Expression.Cast cast) {
                super.visitCast(cast);
                if (cast.getType() instanceof TypeRef.TargettedTypeRef) {
                    cast.replaceBy((Element)ElementsHelper.methodCall((Expression)cast.getTarget(), (String)"as", (Expression[])new Expression[]{BridJer.this.result.typeConverter.typeLiteral(((TypeRef.TargettedTypeRef)cast.getType()).getTarget())}));
                }
            }

            public void visitArrayAccess(Expression.ArrayAccess arrayAccess) {
                super.visitArrayAccess(arrayAccess);
                arrayAccess.replaceBy((Element)ElementsHelper.methodCall((Expression)arrayAccess.getTarget(), (String)"get", (Expression[])new Expression[]{arrayAccess.getIndex()}));
            }

            public void visitMemberRef(Expression.MemberRef memberRef) {
                if (!(memberRef.getParentElement() instanceof Expression.FunctionCall) && memberRef.getName() != null) {
                    switch (memberRef.getMemberRefStyle()) {
                        case Colons: {
                            memberRef.setMemberRefStyle(Expression.MemberRefStyle.Dot);
                            break;
                        }
                        case Arrow: 
                        case Dot: {
                            Expression.FunctionCall rep = ElementsHelper.methodCall((Expression)memberRef.getTarget(), (String)memberRef.getName().toString(), (Expression[])new Expression[0]);
                            if (memberRef.getMemberRefStyle() == Expression.MemberRefStyle.Arrow) {
                                rep = ElementsHelper.methodCall((Expression)rep, (String)"get", (Expression[])new Expression[0]);
                            }
                            memberRef.replaceBy((Element)rep);
                            rep.accept((Visitor)this);
                            return;
                        }
                    }
                }
                super.visitMemberRef(memberRef);
            }

            public void visitVariablesDeclaration(VariablesDeclaration v) {
                super.visitVariablesDeclaration(v);
                if (v.getDeclarators().size() == 1) {
                    TypeRef mt;
                    Declarator decl = (Declarator)v.getDeclarators().get(0);
                    TypeRef vt = v.getValueType();
                    Object object = mt = decl instanceof Declarator.DirectDeclarator ? vt : decl.mutateTypeKeepingParent((Declarator.MutableByDeclarator)vt);
                    if (mt instanceof TypeRef) {
                        TypeRef mutatedType = mt;
                        if (decl.getDefaultValue() == null) {
                            boolean referenced;
                            TypeRef actualType = mutatedType;
                            boolean bl = referenced = ref.varDeclTypeRefsTransformedToPointers.contains(v) && mutatedType instanceof TypeRef.Pointer;
                            if (referenced) {
                                actualType = ((TypeRef.Pointer)mutatedType).getTarget();
                            }
                            if (BridJer.this.result.symbols.isClassType(actualType)) {
                                decl.setDefaultValue((Expression)(referenced ? BridJer.this.staticPtrMethod("allocate", BridJer.this.result.typeConverter.typeLiteral(actualType)) : new Expression.New(actualType.clone())));
                                Expression vr = ElementsHelper.varRef((Identifier.SimpleIdentifier)new Identifier.SimpleIdentifier(decl.resolveName(), new Expression[0]));
                                Statement deleteStat = ElementsHelper.stat((Expression)ElementsHelper.methodCall((Expression)ElementsHelper.expr((TypeRef)ElementsHelper.typeRef(BridJ.class)), (String)"delete", (Expression[])new Expression[]{referenced ? ElementsHelper.methodCall((Expression)vr, (String)"get", (Expression[])new Expression[0]) : vr}));
                                deleteStat.setCommentAfter("// object would end up being deleted by the GC later, but in C++ it would be deleted here.");
                                Statement.Block parentBlock = (Statement.Block)v.getParentElement();
                                ArrayList<Statement> stats = new ArrayList<Statement>(parentBlock.getStatements());
                                int i = stats.size();
                                while (i-- != 0) {
                                    Statement stat = (Statement)stats.get(i);
                                    if (stat instanceof Statement.Return || this.deleteStatements.contains(stat)) continue;
                                    stats.add(i + 1, deleteStat);
                                    this.deleteStatements.add((Element)deleteStat);
                                    break;
                                }
                                parentBlock.setStatements(stats);
                            }
                        }
                        BridJTypeConversion.NL4JConversion conv = ((BridJTypeConversion)BridJer.this.result.typeConverter).convertTypeToNL4J(mutatedType, libraryClassName, null, null, -1, -1);
                        v.setValueType(conv.getTypeRef(false));
                        if (conv.arrayLengths != null && mutatedType instanceof TypeRef.TargettedTypeRef && decl.getDefaultValue() == null) {
                            v.setDeclarators(Arrays.asList(new Declarator.DirectDeclarator(decl.resolveName(), this.newAllocateArray(((TypeRef.TargettedTypeRef)mutatedType).getTarget(), conv.arrayLengths))));
                        }
                    }
                }
            }

            public void visitAssignmentOp(Expression.AssignmentOp assignment) {
                Expression.UnaryOp uop;
                Expression.BinaryOperator binOp = assignment.getOperator().getCorrespondingBinaryOp();
                Expression value = assignment.getValue();
                value.setParenthesisIfNeeded();
                if (assignment.getTarget() instanceof Expression.UnaryOp && (uop = (Expression.UnaryOp)assignment.getTarget()).getOperator() == Expression.UnaryOperator.Dereference) {
                    this.visit((Element)uop.getOperand());
                    this.visit((Element)assignment.getValue());
                    Expression target = uop.getOperand();
                    if (binOp != null) {
                        value = ElementsHelper.expr((Expression)ElementsHelper.methodCall((Expression)target.clone(), (String)"get", (Expression[])new Expression[0]), (Expression.BinaryOperator)binOp, (Expression)value);
                    }
                    assignment.replaceBy((Element)ElementsHelper.methodCall((Expression)target, (String)"set", (Expression[])new Expression[]{value}));
                    return;
                }
                if (assignment.getTarget() instanceof Expression.ArrayAccess) {
                    Expression.ArrayAccess aa = (Expression.ArrayAccess)assignment.getTarget();
                    this.visit((Element)aa.getTarget());
                    this.visit((Element)aa.getIndex());
                    this.visit((Element)assignment.getValue());
                    Expression target = aa.getTarget();
                    Expression index = aa.getIndex();
                    if (binOp != null) {
                        value = ElementsHelper.expr((Expression)ElementsHelper.methodCall((Expression)target.clone(), (String)"get", (Expression[])new Expression[]{index.clone()}), (Expression.BinaryOperator)binOp, (Expression)value);
                    }
                    assignment.replaceBy((Element)ElementsHelper.methodCall((Expression)target, (String)"set", (Expression[])new Expression[]{index, value}));
                    return;
                }
                if (assignment.getTarget() instanceof Expression.MemberRef) {
                    boolean isArrow;
                    Expression.MemberRef mr = (Expression.MemberRef)assignment.getTarget();
                    boolean bl = isArrow = mr.getMemberRefStyle() == Expression.MemberRefStyle.Arrow;
                    if (isArrow || mr.getMemberRefStyle() == Expression.MemberRefStyle.Dot) {
                        Expression target = mr.getTarget();
                        String name = mr.getName().toString();
                        if (binOp != null) {
                            value = ElementsHelper.expr((Expression)ElementsHelper.methodCall((Expression)target.clone(), (String)name, (Expression[])new Expression[0]), (Expression.BinaryOperator)binOp, (Expression)value);
                        }
                        if (isArrow) {
                            target = ElementsHelper.methodCall((Expression)target, (String)"get", (Expression[])new Expression[0]);
                        }
                        assignment.replaceBy((Element)ElementsHelper.methodCall((Expression)target, (String)name, (Expression[])new Expression[]{value}));
                        return;
                    }
                }
                super.visitAssignmentOp(assignment);
            }

            public void visitNew(Expression.New new1) {
                super.visitNew(new1);
                if (new1.getConstruction() == null) {
                    new1.replaceBy((Element)BridJer.this.staticPtrMethod("allocate" + BridJer.this.primCapName(new1.getType()), new Expression[0]));
                }
            }

            public void notSup(Element x, String msg) throws UnsupportedConversionException {
                throw new UnsupportedConversionException(x, msg);
            }

            Expression newAllocateArray(TypeRef tr, Collection<Expression> sizes) {
                return BridJer.this.staticPtrMethod("allocate" + BridJer.this.primCapName(tr) + "s", sizes.toArray(new Expression[sizes.size()]));
            }

            public void visitNewArray(Expression.NewArray newArray) {
                super.visitNewArray(newArray);
                if (newArray.getType() instanceof TypeRef.Primitive) {
                    if (newArray.getDimensions().size() > 3) {
                        this.notSup((Element)newArray, "TODO only dimensions 1 to 3 are supported for primitive array creations !");
                    }
                    newArray.replaceBy((Element)this.newAllocateArray(newArray.getType(), newArray.getDimensions()));
                } else {
                    if (newArray.getDimensions().size() != 1) {
                        this.notSup((Element)newArray, "TODO only dimension 1 is supported for reference array creations !");
                    }
                    newArray.replaceBy((Element)BridJer.this.staticPtrMethod("allocateArray", BridJer.this.result.typeConverter.typeLiteral(newArray.getType()), (Expression)newArray.getDimensions().get(0)));
                }
            }

            public void visitPointer(TypeRef.Pointer pointer) {
                super.visitPointer(pointer);
            }
        });
        return new Pair((Object)element, extraDeclarationsOut);
    }

    TypeRef getWrapperType(TypeRef tr) {
        TypeConversion.JavaPrim prim = this.result.typeConverter.getPrimitive(tr);
        if (prim != null) {
            return ElementsHelper.typeRef(prim.wrapperType);
        }
        return tr;
    }

    TypeRef pointerToTypeRef(TypeRef targetType) {
        Identifier id = ElementsHelper.ident((Class)this.ptrClass(), (Expression[])new Expression[0]);
        id.resolveLastSimpleIdentifier().addTemplateArgument(ElementsHelper.expr((TypeRef)targetType));
        return ElementsHelper.typeRef((Identifier)id);
    }

    Class ptrClass() {
        return this.result.config.runtime.pointerClass;
    }

    private ReferencedElements findReferencedElements(Element element) {
        final ReferencedElements ret = new ReferencedElements();
        element.accept((Visitor)new Scanner(){

            public void visitUnaryOp(Expression.UnaryOp unaryOp) {
                Expression.VariableRef vr;
                Element e;
                super.visitUnaryOp(unaryOp);
                if (unaryOp.getOperator() == Expression.UnaryOperator.Reference && unaryOp.getOperand() instanceof Expression.VariableRef && (e = BridJer.this.result.symbols.getVariable((vr = (Expression.VariableRef)unaryOp.getOperand()).getName())) != null) {
                    ret.referencedElements.add((Pair<Element, Integer>)new Pair((Object)e, (Object)e.getId()));
                }
            }
        });
        final LinkedHashMap<Integer, String> referencedElementsChangedNames = new LinkedHashMap<Integer, String>();
        for (Pair<Element, Integer> kv : ret.referencedElements) {
            Element e = (Element)kv.getKey();
            if (!(e instanceof Declarator.DirectDeclarator)) continue;
            Declarator.DirectDeclarator decl = (Declarator.DirectDeclarator)e;
            String name = decl.getName();
            String changedName = "p" + StringUtils.capitalize((String)name);
            referencedElementsChangedNames.put(e.getId(), changedName);
            decl.setName(changedName);
            VariablesDeclaration vd = (VariablesDeclaration)decl.getParentElement();
            TypeRef tr = vd.getValueType();
            vd.setValueType((TypeRef)new TypeRef.Pointer(tr, Declarator.PointerStyle.Pointer));
            ret.varDeclTypeRefsTransformedToPointers.add((Element)vd);
            Expression defVal = decl.getDefaultValue();
            if (defVal != null) {
                decl.setDefaultValue(this.staticPtrMethod("pointerTo" + this.primCapName(tr), defVal));
                continue;
            }
            decl.setDefaultValue(this.staticPtrMethod("allocate" + this.primCapName(tr), new Expression[0]));
        }
        element.accept((Visitor)new Scanner(){

            public void visitIdentifier(Identifier identifier) {
                String changedName;
                super.visitIdentifier(identifier);
                Element e = BridJer.this.result.symbols.getVariable(identifier);
                if (e != null && this.isReferenced(e) && (changedName = (String)referencedElementsChangedNames.get(e.getId())) != null) {
                    Identifier replacedIdentifier = ElementsHelper.ident((String[])new String[]{changedName});
                    identifier.replaceBy((Element)replacedIdentifier);
                    ret.referencedElements.add((Pair<Element, Integer>)new Pair((Object)replacedIdentifier, (Object)replacedIdentifier.getId()));
                }
            }

            boolean isReferenced(Element e) {
                if (e == null) {
                    return false;
                }
                return ret.referencedElements.contains(new Pair((Object)e, (Object)e.getId()));
            }

            public void visitVariableRef(Expression.VariableRef vr) {
                super.visitVariableRef(vr);
                Identifier ident = vr.getName();
                if (this.isReferenced((Element)ident)) {
                    vr.replaceBy((Element)ElementsHelper.methodCall((Expression)ElementsHelper.varRef((Identifier)ident), (String)"get", (Expression[])new Expression[0]));
                }
            }

            public void visitUnaryOp(Expression.UnaryOp unaryOp) {
                String changedName;
                Expression.VariableRef vr;
                Identifier ident;
                Element e;
                if (unaryOp.getOperator() == Expression.UnaryOperator.Reference && unaryOp.getOperand() instanceof Expression.VariableRef && ((e = BridJer.this.result.symbols.getVariable(ident = (vr = (Expression.VariableRef)unaryOp.getOperand()).getName())) != null || this.isReferenced(e) || this.isReferenced((Element)ident)) && (changedName = (String)referencedElementsChangedNames.get(e.getId())) != null) {
                    Expression rep = ElementsHelper.varRef((String)changedName);
                    unaryOp.replaceBy((Element)rep);
                    this.visit((Element)rep);
                    return;
                }
                super.visitUnaryOp(unaryOp);
            }
        });
        return ret;
    }

    static class ReferencedElements {
        final Set<Pair<Element, Integer>> referencedElements = new HashSet<Pair<Element, Integer>>();
        final Set<Element> varDeclTypeRefsTransformedToPointers = new HashSet<Element>();

        ReferencedElements() {
        }
    }
}

