/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GYPUtils {
    public static Map<String, Object> map() {
        return new LinkedHashMap<String, Object>();
    }

    public static String toGYP(Object o) {
        StringBuilder out = new StringBuilder();
        GYPUtils.toGYP(o, out, "");
        return out.toString();
    }

    static void toGYP(Object o, StringBuilder out, String indent) {
        if (o instanceof Map) {
            GYPUtils.toGYP((Map)o, out, indent);
        } else if (o instanceof String) {
            out.append('\'').append(o).append('\'');
        } else if (o instanceof Number) {
            out.append(o);
        } else if (o instanceof List) {
            GYPUtils.toGYP((List)o, out, indent);
        } else {
            throw new RuntimeException("Type not supported: " + o.getClass().getName() + " (" + o + ")");
        }
    }

    private static void toGYP(Map<String, Object> map, StringBuilder out, String indent) {
        String indent2 = indent + "  ";
        out.append("{\n");
        Iterator<Map.Entry<String, Object>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> e = it.next();
            out.append(indent2).append('\'').append(e.getKey()).append("': ");
            GYPUtils.toGYP(e.getValue(), out, indent2);
            if (!it.hasNext()) continue;
            out.append(",\n");
        }
        out.append('\n').append(indent).append('}');
    }

    private static void toGYP(List<Object> list, StringBuilder out, String indent) {
        String indent2 = indent + "  ";
        out.append("[\n");
        Iterator<Object> it = list.iterator();
        while (it.hasNext()) {
            out.append(indent2);
            GYPUtils.toGYP(it.next(), out, indent2);
            if (!it.hasNext()) continue;
            out.append(",\n");
        }
        out.append('\n').append(indent).append(']');
    }
}

