/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.lang.jnaerator.DeclarationsConverter;
import com.ochafik.lang.jnaerator.JNATypeConversion;
import com.ochafik.lang.jnaerator.JNAeratorConfig;
import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.RococoaUtils;
import com.ochafik.lang.jnaerator.Signatures;
import com.ochafik.lang.jnaerator.SourceFiles;
import com.ochafik.lang.jnaerator.TypeConversion;
import com.ochafik.lang.jnaerator.UnsupportedConversionException;
import com.ochafik.lang.jnaerator.parser.Annotation;
import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.Declaration;
import com.ochafik.lang.jnaerator.parser.DeclarationsHolder;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.EmptyDeclaration;
import com.ochafik.lang.jnaerator.parser.Enum;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.ModifiableElement;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.ModifierType;
import com.ochafik.lang.jnaerator.parser.Printer;
import com.ochafik.lang.jnaerator.parser.Statement;
import com.ochafik.lang.jnaerator.parser.StoredDeclarations;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TaggedTypeRefDeclaration;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.VariablesDeclaration;
import com.ochafik.lang.jnaerator.runtime.LibraryExtractor;
import com.ochafik.lang.jnaerator.runtime.MangledFunctionMapper;
import com.ochafik.util.CompoundCollection;
import com.ochafik.util.listenable.Pair;
import com.ochafik.util.string.StringUtils;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.win32.StdCallLibrary;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.rococoa.AlreadyRetained;
import org.rococoa.cocoa.foundation.NSObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNADeclarationsConverter
extends DeclarationsConverter {
    private static final Pattern manglingCommentPattern = Pattern.compile("@mangling (.*)$", 8);
    static Map<Class<?>, Pair<List<Pair<Function, String>>, Set<String>>> cachedForcedMethodsAndTheirSignatures;
    Map<String, Pair<Function, List<Function>>> functionAlternativesByNativeSignature = new LinkedHashMap<String, Pair<Function, List<Function>>>();
    int nextAnonymousFieldId;

    public JNADeclarationsConverter(Result result) {
        super(result);
    }

    final JNATypeConversion typeConverter() {
        return (JNATypeConversion)this.result.typeConverter;
    }

    @Override
    public Struct convertCallback(TypeRef.FunctionSignature functionSignature, Signatures signatures, Identifier callerLibraryName) {
        Struct decl = super.convertCallback(functionSignature, signatures, callerLibraryName);
        if (decl != null) {
            List mods = functionSignature.getFunction().getModifiers();
            decl.setParents(Arrays.asList((TypeRef.SimpleTypeRef)ElementsHelper.typeRef(functionSignature.getFunction().hasModifier((Modifier)ModifierType.__stdcall) ? StdCallLibrary.StdCallCallback.class : this.result.config.runtime.callbackClass)));
        }
        return decl;
    }

    public static synchronized Pair<List<Pair<Function, String>>, Set<String>> getMethodsAndTheirSignatures(Class<?> originalLib) {
        Pair pair;
        if (cachedForcedMethodsAndTheirSignatures == null) {
            cachedForcedMethodsAndTheirSignatures = new LinkedHashMap();
        }
        if ((pair = cachedForcedMethodsAndTheirSignatures.get(originalLib)) == null) {
            pair = new Pair(new ArrayList(), new HashSet());
            for (Method m : originalLib.getDeclaredMethods()) {
                Function f = Function.fromMethod((Method)m);
                String sig = f.computeSignature(Function.SignatureType.JavaStyle);
                ((List)pair.getFirst()).add(new Pair((Object)f, (Object)sig));
                ((Set)pair.getSecond()).add(sig);
            }
        }
        return pair;
    }

    @Override
    public void addMissingMethods(Class<?> originalLib, Signatures existingSignatures, Struct outputLib) {
        for (Pair f : (List)JNADeclarationsConverter.getMethodsAndTheirSignatures(originalLib).getFirst()) {
            if (!existingSignatures.addMethod((String)f.getSecond())) continue;
            outputLib.addDeclaration((Declaration)((Function)f.getFirst()).clone());
        }
    }

    @Override
    public EmptyDeclaration skipDeclaration(Element e, String ... preMessages) {
        if (this.result.config.limitComments) {
            return null;
        }
        ArrayList<String> mess = new ArrayList<String>();
        if (preMessages != null) {
            mess.addAll(Arrays.asList(preMessages));
        }
        mess.addAll(Arrays.asList("SKIPPED:", new Printer(null).formatComments(e, true, true, false, new String[0]).toString(), this.getFileCommentContent(e), e.toString().replace("*/", "* /")));
        return new EmptyDeclaration(mess.toArray(new String[0]));
    }

    @Override
    public void convertEnum(Enum e, Signatures signatures, DeclarationsHolder out, Identifier libraryClassName) {
        if (e.isForwardDeclaration()) {
            return;
        }
        Identifier rawEnumName = this.getActualTaggedTypeName((TypeRef.TaggedTypeRef)e);
        Map<String, TypeConversion.EnumItemResult> results = this.result.typeConverter.getEnumValuesAndCommentsByName(e, libraryClassName);
        boolean hasEnumClass = false;
        if (rawEnumName != null && rawEnumName.resolveLastSimpleIdentifier().getName() != null) {
            Identifier enumName = this.result.typeConverter.getValidJavaIdentifier(rawEnumName);
            if (!signatures.addClass(enumName)) {
                return;
            }
            hasEnumClass = true;
            Struct struct = this.publicStaticClass(enumName, null, Struct.Type.JavaInterface, (Element)e, new Identifier[0]);
            out.addDeclaration((Declaration)new TaggedTypeRefDeclaration((TypeRef.TaggedTypeRef)struct));
            if (!this.result.config.noComments) {
                struct.addToCommentBefore(new String[]{"enum values"});
            }
            out = struct;
            signatures = new Signatures();
        }
        this.outputEnumItemsAsConstants(results, out, signatures, libraryClassName, hasEnumClass);
    }

    @Override
    protected void convertFunction(Function function, Signatures signatures, boolean isCallback, DeclarationsHolder declarations, DeclarationsHolder implementations, Identifier libraryClassName, String sig, Identifier functionName, String library, int iConstructor) {
        block38: {
            Boolean alreadyRetained;
            assert (implementations == declarations || declarations == null);
            Pair alternativesPair = this.functionAlternativesByNativeSignature.get(sig);
            if (alternativesPair != null) {
                if (this.result.config.choicesInputFile != null) {
                    for (Function alt : (List)alternativesPair.getValue()) {
                        implementations.addDeclaration((Declaration)alt.clone());
                    }
                    return;
                }
            } else {
                alternativesPair = new Pair((Object)JNADeclarationsConverter.cleanClone(function), new ArrayList());
                this.functionAlternativesByNativeSignature.put(sig, (Pair<Function, List<Function>>)alternativesPair);
            }
            List alternatives = (List)alternativesPair.getValue();
            Function natFunc = new Function();
            Element parent = function.getParentElement();
            boolean isMethod = parent instanceof Struct;
            if (isMethod) {
                switch (((Struct)parent).getType()) {
                    default: 
                }
            }
            if (!isMethod && library != null && (alreadyRetained = Result.getMap(this.result.retainedRetValFunctions, library).get(functionName.toString())) != null && alreadyRetained.booleanValue()) {
                natFunc.addAnnotation(new Annotation(ElementsHelper.typeRef(AlreadyRetained.class), ElementsHelper.expr((boolean)alreadyRetained)));
            }
            boolean isObjectiveC = function.getType() == Function.Type.ObjCMethod;
            natFunc.setType(Function.Type.JavaMethod);
            if (this.result.config.synchronizedMethods && !isCallback && this.result.config.useJNADirectCalls) {
                natFunc.addModifiers(new Modifier[]{ModifierType.Synchronized});
            }
            if (this.result.config.useJNADirectCalls && !isCallback && !isObjectiveC) {
                natFunc.addModifiers(new Modifier[]{ModifierType.Public, ModifierType.Static, ModifierType.Native});
            }
            try {
                String bufSign;
                TypeRef returnType = null;
                if (!isObjectiveC) {
                    returnType = function.getValueType();
                    if (returnType == null) {
                        returnType = new TypeRef.Primitive("int");
                    }
                    if (returnType != null) {
                        returnType.addModifiers(function.getModifiers());
                    }
                } else {
                    returnType = RococoaUtils.fixReturnType(function);
                    functionName = ElementsHelper.ident((String[])new String[]{RococoaUtils.getMethodName(function)});
                }
                Identifier modifiedMethodName = isCallback ? ElementsHelper.ident((String[])new String[]{this.result.config.callbackInvokeMethodName}) : this.result.typeConverter.getValidJavaMethodName(ElementsHelper.ident((Identifier)functionName, (Identifier[])new Identifier[0]));
                LinkedHashSet<String> names = new LinkedHashSet<String>();
                if (function.getName() != null && !modifiedMethodName.equals((Object)function.getName().toString())) {
                    names.add(function.getName().toString());
                }
                if (function.getAsmName() != null) {
                    names.add(function.getAsmName());
                }
                if (!isCallback && !modifiedMethodName.equals((Object)functionName)) {
                    this.annotateActualName((ModifiableElement)natFunc, functionName);
                }
                natFunc.setName(modifiedMethodName);
                natFunc.setValueType(this.typeConverter().convertTypeToJNA(returnType, TypeConversion.TypeConversionMode.ReturnType, libraryClassName));
                if (!this.result.config.noComments) {
                    natFunc.importComments((Element)function, new String[]{isCallback ? null : this.getFileCommentContent((Element)function)});
                }
                if (function.getName() != null) {
                    Object[] name = new Object[]{function.getName().toString()};
                    for (Pair<MessageFormat, MessageFormat> mf : this.result.config.onlineDocumentationURLFormats) {
                        try {
                            MessageFormat urlFormat = (MessageFormat)mf.getSecond();
                            URL url = new URL(urlFormat.format(name));
                            URLConnection con = url.openConnection();
                            con.getInputStream().close();
                            MessageFormat displayFormat = (MessageFormat)mf.getFirst();
                            natFunc.addToCommentBefore(new String[]{"@see <a href=\"" + url + "\">" + displayFormat.format(name) + "</a>"});
                            break;
                        }
                        catch (Exception ex) {
                        }
                    }
                }
                boolean alternativeOutputs = !isCallback;
                Function primOrBufFunc = alternativeOutputs ? natFunc.clone() : null;
                Function natStructFunc = alternativeOutputs ? natFunc.clone() : null;
                TreeSet<String> argNames = new TreeSet<String>();
                int nArgs = function.getArgs().size();
                for (int iArg = 0; iArg < nArgs; ++iArg) {
                    Arg arg = (Arg)function.getArgs().get(iArg);
                    boolean isVarArgs = JNADeclarationsConverter.isVarArgs(arg);
                    if (isVarArgs && iArg == nArgs - 1) {
                        Identifier vaType = ElementsHelper.ident(isObjectiveC ? NSObject.class : Object.class, (Expression[])new Expression[0]);
                        String argName = this.chooseJavaArgName(arg.getName() == null ? "varargs" : arg.getName(), iArg + 1, argNames);
                        natFunc.addArg(new Arg(argName, (TypeRef)ElementsHelper.typeRef((Identifier)vaType.clone()))).setVarArg(true);
                        if (!alternativeOutputs) continue;
                        primOrBufFunc.addArg(new Arg(argName, (TypeRef)ElementsHelper.typeRef((Identifier)vaType.clone()))).setVarArg(true);
                        natStructFunc.addArg(new Arg(argName, (TypeRef)ElementsHelper.typeRef((Identifier)vaType.clone()))).setVarArg(true);
                        continue;
                    }
                    String argName = this.chooseJavaArgName(arg.getName(), iArg + 1, argNames);
                    TypeRef mutType = arg.createMutatedType();
                    if (mutType == null) {
                        throw new UnsupportedConversionException((Element)function, "Argument " + arg.getName() + " cannot be converted");
                    }
                    if (isVarArgs) {
                        mutType = new TypeRef.Pointer(ElementsHelper.typeRef(Void.TYPE), Declarator.PointerStyle.Pointer);
                    }
                    natFunc.addArg(new Arg(argName, this.typeConverter().convertTypeToJNA(mutType, TypeConversion.TypeConversionMode.NativeParameter, libraryClassName)));
                    if (!alternativeOutputs) continue;
                    primOrBufFunc.addArg(new Arg(argName, this.typeConverter().convertTypeToJNA(mutType, TypeConversion.TypeConversionMode.PrimitiveOrBufferParameter, libraryClassName)));
                    natStructFunc.addArg(new Arg(argName, this.typeConverter().convertTypeToJNA(mutType, TypeConversion.TypeConversionMode.NativeParameterWithStructsPtrPtrs, libraryClassName)));
                }
                String natSign = natFunc.computeSignature(Function.SignatureType.JavaStyle);
                String primOrBufSign = alternativeOutputs ? primOrBufFunc.computeSignature(Function.SignatureType.JavaStyle) : null;
                String string = bufSign = alternativeOutputs ? natStructFunc.computeSignature(Function.SignatureType.JavaStyle) : null;
                if (signatures == null || signatures.addMethod(natSign)) {
                    boolean isDeprecated;
                    boolean bl = isDeprecated = alternativeOutputs && !primOrBufSign.equals(natSign);
                    if (!isDeprecated || !this.result.config.skipDeprecated) {
                        if (isDeprecated) {
                            if (!this.result.config.noComments) {
                                if (primOrBufSign.equals(bufSign)) {
                                    natFunc.addToCommentBefore(Arrays.asList("@deprecated use the safer method {@link #" + primOrBufSign + "} instead"));
                                } else {
                                    natFunc.addToCommentBefore(Arrays.asList("@deprecated use the safer methods {@link #" + primOrBufSign + "} and {@link #" + bufSign + "} instead"));
                                }
                            }
                            natFunc.addAnnotation(new Annotation(ElementsHelper.typeRef(Deprecated.class)));
                        }
                        this.collectParamComments(natFunc);
                        implementations.addDeclaration((Declaration)natFunc);
                        alternatives.add(JNADeclarationsConverter.cleanClone(natFunc));
                    }
                }
                if (alternativeOutputs) {
                    if (signatures == null || signatures.addMethod(primOrBufSign)) {
                        this.collectParamComments(primOrBufFunc);
                        implementations.addDeclaration((Declaration)primOrBufFunc);
                        alternatives.add(JNADeclarationsConverter.cleanClone(primOrBufFunc));
                    }
                    if (signatures == null || signatures.addMethod(bufSign)) {
                        this.collectParamComments(natStructFunc);
                        implementations.addDeclaration((Declaration)natStructFunc);
                        alternatives.add(JNADeclarationsConverter.cleanClone(natStructFunc));
                    }
                }
            }
            catch (UnsupportedConversionException ex) {
                if (this.result.config.limitComments) break block38;
                implementations.addDeclaration((Declaration)new EmptyDeclaration(new String[]{this.getFileCommentContent((Element)function), ex.toString()}));
            }
        }
    }

    @Override
    public Struct convertStruct(Struct struct, Signatures signatures, Identifier callerLibraryClass, String callerLibrary, boolean onlyFields) throws IOException {
        Identifier structName = this.getActualTaggedTypeName((TypeRef.TaggedTypeRef)struct);
        if (structName == null) {
            return null;
        }
        if (struct.isForwardDeclaration()) {
            return null;
        }
        if (!signatures.addClass(structName)) {
            return null;
        }
        boolean isUnion = struct.getType() == Struct.Type.CUnion;
        boolean inheritsFromStruct = false;
        Identifier baseClass = null;
        if (!onlyFields) {
            if (!struct.getParents().isEmpty()) {
                for (TypeRef.SimpleTypeRef parentName : struct.getParents()) {
                    Struct parent = this.result.structsByName.get(parentName.getName());
                    if (parent == null || (baseClass = this.result.typeConverter.getTaggedTypeIdentifierInJava((TypeRef.TaggedTypeRef)parent)) == null) continue;
                    inheritsFromStruct = true;
                    break;
                }
            }
            if (baseClass == null) {
                Class c = isUnion ? this.result.config.runtime.unionClass : this.result.config.runtime.structClass;
                baseClass = this.result.config.runtime != JNAeratorConfig.Runtime.JNA ? ElementsHelper.ident((Class)c, (Expression[])new Expression[]{ElementsHelper.expr((TypeRef)ElementsHelper.typeRef((Identifier)structName.clone())), ElementsHelper.expr((TypeRef)ElementsHelper.typeRef((Identifier)ElementsHelper.ident((Identifier)structName.clone(), (String)"ByValue"))), ElementsHelper.expr((TypeRef)ElementsHelper.typeRef((Identifier)ElementsHelper.ident((Identifier)structName.clone(), (String)"ByReference")))}) : ElementsHelper.ident((Class)c, (Expression[])new Expression[0]);
            }
        }
        Struct structJavaClass = this.publicStaticClass(structName, baseClass, Struct.Type.JavaClass, (Element)struct, new Identifier[0]);
        int[] iChild = new int[]{0};
        Signatures childSignatures = new Signatures();
        boolean succeeded = true;
        for (Declaration d : struct.getDeclarations()) {
            if (d instanceof VariablesDeclaration) {
                succeeded = this.convertVariablesDeclaration((VariablesDeclaration)d, childSignatures, (DeclarationsHolder)structJavaClass, iChild, false, structName, callerLibraryClass, callerLibrary) && succeeded;
                continue;
            }
            if (onlyFields) continue;
            if (d instanceof TaggedTypeRefDeclaration) {
                TypeRef.TaggedTypeRef tr = ((TaggedTypeRefDeclaration)d).getTaggedTypeRef();
                if (tr instanceof Struct) {
                    this.outputConvertedStruct((Struct)tr, childSignatures, (DeclarationsHolder)structJavaClass, callerLibrary, false);
                    continue;
                }
                if (!(tr instanceof Enum)) continue;
                this.convertEnum((Enum)tr, childSignatures, (DeclarationsHolder)structJavaClass, callerLibraryClass);
                continue;
            }
            if (d instanceof StoredDeclarations.TypeDef) {
                TypeRef target;
                StoredDeclarations.TypeDef td = (StoredDeclarations.TypeDef)d;
                TypeRef tr = td.getValueType();
                if (tr instanceof Struct) {
                    this.outputConvertedStruct((Struct)tr, childSignatures, (DeclarationsHolder)structJavaClass, callerLibrary, false);
                    continue;
                }
                TypeRef.FunctionSignature fs = null;
                if (tr instanceof TypeRef.FunctionSignature) {
                    fs = (TypeRef.FunctionSignature)tr;
                } else if (tr instanceof TypeRef.Pointer && (target = ((TypeRef.Pointer)tr).getTarget()) instanceof TypeRef.FunctionSignature) {
                    fs = (TypeRef.FunctionSignature)target;
                }
                if (fs == null) continue;
                this.convertCallback(fs, childSignatures, (DeclarationsHolder)structJavaClass, callerLibraryClass);
                continue;
            }
            if (!this.result.config.genCPlusPlus || !(d instanceof Function)) continue;
            Function f = (Function)d;
            String library = this.result.getLibrary((Element)struct);
            if (library == null) continue;
            ArrayList decls = new ArrayList();
            DeclarationsHolder.ListWrapper out = new DeclarationsHolder.ListWrapper(decls);
            this.convertFunction(f, childSignatures, false, (DeclarationsHolder)out, (DeclarationsHolder)out, callerLibraryClass, -1);
            for (Declaration md : decls) {
                if (!(md instanceof Function)) continue;
                Function method = (Function)md;
                Identifier methodImplName = method.getName().clone();
                Identifier methodName = this.result.typeConverter.getValidJavaMethodName(f.getName());
                method.setName(methodName);
                ArrayList<Expression> args = new ArrayList<Expression>();
                boolean isStatic = f.hasModifier((Modifier)ModifierType.Static);
                int iArg = 0;
                for (Arg arg : new ArrayList(method.getArgs())) {
                    if (iArg == 0 && !isStatic) {
                        arg.replaceBy(null);
                        args.add(ElementsHelper.thisRef());
                    } else {
                        args.add(ElementsHelper.varRef((String)arg.getName()));
                    }
                    ++iArg;
                }
                Expression.FunctionCall implCall = ElementsHelper.methodCall((Expression)this.result.getLibraryInstanceReferenceExpression(library), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)methodImplName.toString(), (Expression[])args.toArray(new Expression[args.size()]));
                method.setBody(ElementsHelper.block((Statement[])new Statement[]{"void".equals(String.valueOf(method.getValueType())) ? ElementsHelper.stat((Expression)implCall) : new Statement.Return((Expression)implCall)}));
                method.addModifiers(new Modifier[]{ModifierType.Public, isStatic ? ModifierType.Static : null});
                structJavaClass.addDeclaration((Declaration)method);
            }
        }
        if (!onlyFields) {
            if (this.result.config.features.contains((Object)JNAeratorConfig.GenFeatures.StructConstructors)) {
                this.addStructConstructors(structName, structJavaClass, struct);
            }
            Struct byRef = this.publicStaticClass(ElementsHelper.ident((String[])new String[]{"ByReference"}), structName, Struct.Type.JavaClass, null, ElementsHelper.ident((Identifier)ElementsHelper.ident((Class)this.result.config.runtime.structClass, (Expression[])new Expression[0]), (String)"ByReference"));
            Struct byVal = this.publicStaticClass(ElementsHelper.ident((String[])new String[]{"ByValue"}), structName, Struct.Type.JavaClass, null, ElementsHelper.ident((Identifier)ElementsHelper.ident((Class)this.result.config.runtime.structClass, (Expression[])new Expression[0]), (String)"ByValue"));
            if (!succeeded) {
                byRef.addModifiers(new Modifier[]{ModifierType.Abstract});
                byVal.addModifiers(new Modifier[]{ModifierType.Abstract});
            }
            if (succeeded && this.result.config.runtime != JNAeratorConfig.Runtime.JNA) {
                if (!inheritsFromStruct) {
                    structJavaClass.addDeclaration((Declaration)this.createNewStructMethod("newByReference", byRef));
                    structJavaClass.addDeclaration((Declaration)this.createNewStructMethod("newByValue", byVal));
                }
                structJavaClass.addDeclaration((Declaration)this.createNewStructMethod("newInstance", structJavaClass));
                structJavaClass.addDeclaration((Declaration)this.createNewStructArrayMethod(structJavaClass, isUnion));
            }
            structJavaClass.addDeclaration((Declaration)ElementsHelper.decl((TypeRef.TaggedTypeRef)byRef));
            structJavaClass.addDeclaration((Declaration)ElementsHelper.decl((TypeRef.TaggedTypeRef)byVal));
        }
        if (!succeeded) {
            structJavaClass.addModifiers(new Modifier[]{ModifierType.Abstract});
        }
        return structJavaClass;
    }

    protected Function createNewStructMethod(String name, Struct byRef) {
        TypeRef.SimpleTypeRef tr = ElementsHelper.typeRef((Identifier)byRef.getTag().clone());
        Function f = new Function(Function.Type.JavaMethod, ElementsHelper.ident((String[])new String[]{name}), (TypeRef)tr);
        String varName = "s";
        f.addModifiers(new Modifier[]{ModifierType.Protected});
        if (this.result.config.runtime != JNAeratorConfig.Runtime.JNA) {
            f.setBody(ElementsHelper.block((Statement[])new Statement[]{new Statement.Return((Expression)new Expression.New(tr.clone(), ElementsHelper.methodCall((String)null, (Expression[])new Expression[0])))}).setCompact(true));
        } else {
            f.setBody(ElementsHelper.block((Statement[])new Statement[]{ElementsHelper.stat((TypeRef)tr.clone(), (String)varName, (Expression)new Expression.New(tr.clone(), ElementsHelper.methodCall((String)null, (Expression[])new Expression[0]))), ElementsHelper.stat((Expression)ElementsHelper.methodCall((Expression)ElementsHelper.varRef((String)varName), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"useMemory", (Expression[])new Expression[]{ElementsHelper.methodCall((String)"getPointer", (Expression[])new Expression[0])})), ElementsHelper.stat((Expression)ElementsHelper.methodCall((String)"write", (Expression[])new Expression[0])), ElementsHelper.stat((Expression)ElementsHelper.methodCall((Expression)ElementsHelper.varRef((String)varName), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"read", (Expression[])new Expression[0])), new Statement.Return(ElementsHelper.varRef((String)varName))}));
        }
        return f;
    }

    protected Function createNewStructArrayMethod(Struct struct, boolean isUnion) {
        if (this.result.config.runtime == JNAeratorConfig.Runtime.JNA) {
            return null;
        }
        TypeRef.SimpleTypeRef tr = ElementsHelper.typeRef((Identifier)struct.getTag().clone());
        TypeRef.ArrayRef ar = new TypeRef.ArrayRef((TypeRef)tr, new Expression[0]);
        String varName = "arrayLength";
        Function f = new Function(Function.Type.JavaMethod, ElementsHelper.ident((String[])new String[]{"newArray"}), (TypeRef)ar, new Arg[]{new Arg(varName, ElementsHelper.typeRef(Integer.TYPE))});
        f.addModifiers(new Modifier[]{ModifierType.Public, ModifierType.Static});
        f.setBody(ElementsHelper.block((Statement[])new Statement[]{new Statement.Return((Expression)ElementsHelper.methodCall((Expression)ElementsHelper.expr((TypeRef)ElementsHelper.typeRef((Class)(isUnion ? this.result.config.runtime.unionClass : this.result.config.runtime.structClass))), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"newArray", (Expression[])new Expression[]{this.result.typeConverter.typeLiteral((TypeRef)tr), ElementsHelper.varRef((String)varName)}))}));
        return f;
    }

    @Override
    public int countFieldsInStruct(Struct s) throws UnsupportedConversionException {
        int count = 0;
        for (Declaration declaration : s.getDeclarations()) {
            if (!(declaration instanceof VariablesDeclaration)) continue;
            count += ((VariablesDeclaration)declaration).getDeclarators().size();
        }
        for (TypeRef.SimpleTypeRef parentName : s.getParents()) {
            Struct parent = this.result.structsByName.get(parentName.getName());
            if (parent == null) {
                throw new UnsupportedConversionException((Element)s, "Cannot find parent " + parentName + " of struct " + s);
            }
            count += this.countFieldsInStruct(parent);
        }
        return count;
    }

    public VariablesDeclaration convertVariablesDeclarationToJNA(String name, TypeRef mutatedType, int[] iChild, Identifier callerLibraryName, Element ... toImportDetailsFrom) throws UnsupportedConversionException {
        name = this.result.typeConverter.getValidJavaArgumentName(ElementsHelper.ident((String[])new String[]{name})).toString();
        Expression.NewArray initVal = null;
        TypeRef javaType = this.typeConverter().convertTypeToJNA(mutatedType, TypeConversion.TypeConversionMode.FieldType, callerLibraryName);
        mutatedType = ((JNATypeConversion)this.result.typeConverter).resolveTypeDef(mutatedType, callerLibraryName, true, false);
        VariablesDeclaration convDecl = new VariablesDeclaration();
        convDecl.addModifiers(new Modifier[]{ModifierType.Public});
        if (javaType instanceof TypeRef.ArrayRef && mutatedType instanceof TypeRef.ArrayRef) {
            TypeRef.ArrayRef mr = (TypeRef.ArrayRef)mutatedType;
            TypeRef.ArrayRef jr = (TypeRef.ArrayRef)javaType;
            Expression mul = null;
            List dims = mr.flattenDimensions();
            int i = dims.size();
            while (i-- != 0) {
                Expression x = (Expression)dims.get(i);
                if (x == null || x instanceof Expression.EmptyArraySize) {
                    jr = new TypeRef.ArrayRef(ElementsHelper.typeRef(Pointer.class), new Expression[0]);
                    javaType = jr;
                    break;
                }
                Pair<Expression, TypeRef> c = this.result.typeConverter.convertExpressionToJava(x, callerLibraryName, false, true, null);
                ((Expression)c.getFirst()).setParenthesis(dims.size() != 1);
                if (mul == null) {
                    mul = (Expression)c.getFirst();
                    continue;
                }
                mul = ElementsHelper.expr((Expression)((Expression)c.getFirst()), (Expression.BinaryOperator)Expression.BinaryOperator.Multiply, (Expression)mul);
            }
            initVal = new Expression.NewArray(jr.getTarget(), Arrays.asList(mul), Collections.EMPTY_LIST);
        }
        if (javaType == null) {
            throw new UnsupportedConversionException((Element)mutatedType, "failed to convert type to Java");
        }
        if (javaType.toString().equals("void")) {
            throw new UnsupportedConversionException((Element)mutatedType, "void type !");
        }
        for (Element e : toImportDetailsFrom) {
            convDecl.importDetails(e, false);
        }
        convDecl.importDetails((Element)mutatedType, true);
        convDecl.importDetails((Element)javaType, true);
        convDecl.moveAllCommentsBefore();
        convDecl.deDioxygenizeCommentBefore();
        convDecl.setValueType(javaType);
        convDecl.addDeclarator((Declarator)new Declarator.DirectDeclarator(name, (Expression)initVal));
        return convDecl;
    }

    @Override
    public boolean convertVariablesDeclaration(VariablesDeclaration v, Signatures signatures, DeclarationsHolder out, int[] iChild, boolean isGlobal, Identifier holderName, Identifier callerLibraryClass, String callerLibrary) {
        try {
            TypeRef valueType = v.getValueType();
            for (Declarator vs : v.getDeclarators()) {
                VariablesDeclaration vd;
                String name = vs.resolveName();
                if (name == null || name.length() == 0) {
                    name = "anonymous" + this.nextAnonymousFieldId++;
                }
                TypeRef mutatedType = valueType;
                if (!(vs instanceof Declarator.DirectDeclarator)) {
                    mutatedType = (TypeRef)vs.mutateTypeKeepingParent((Declarator.MutableByDeclarator)valueType);
                    vs = new Declarator.DirectDeclarator(vs.resolveName());
                }
                if ((vd = this.convertVariablesDeclarationToJNA(name, mutatedType, iChild, callerLibraryClass, new Element[]{v, vs})) != null) {
                    Declarator d = (Declarator)v.getDeclarators().get(0);
                    if (d.getBits() > 0) {
                        String st;
                        int bits = d.getBits();
                        if (!this.result.config.runtime.hasBitFields) {
                            throw new UnsupportedConversionException((Element)d, "This runtime does not support bit fields : " + (Object)((Object)this.result.config.runtime) + " (please use BridJ instead)");
                        }
                        vd.addAnnotation(new Annotation((TypeRef)this.result.config.runtime.typeRef(JNAeratorConfig.Runtime.Ann.Bits), ElementsHelper.expr((int)bits)));
                        String mst = st = vd.getValueType().toString();
                        if (st.equals("int") || st.equals("long") || st.equals("short") || st.equals("long")) {
                            mst = bits <= 8 ? "byte" : (bits <= 16 ? "short" : (bits <= 32 ? "int" : "long"));
                        }
                        if (!st.equals(mst)) {
                            vd.setValueType((TypeRef)new TypeRef.Primitive(mst));
                        }
                    }
                    if (!(mutatedType instanceof TypeRef.Primitive) && !this.result.config.noComments) {
                        vd.addToCommentBefore(new String[]{"C type : " + mutatedType});
                    }
                    out.addDeclaration((Declaration)vd);
                }
                if (this.result.config.beanStructs) {
                    Function setMethod;
                    Function getMethod = new Function(Function.Type.JavaMethod, ElementsHelper.ident((String[])new String[]{"get" + StringUtils.capitalize((String)name)}), vd.getValueType().clone()).setBody(ElementsHelper.block((Statement[])new Statement[]{new Statement.Return(ElementsHelper.varRef((String)name))})).addModifiers(new Modifier[]{ModifierType.Public});
                    if (signatures.addMethod(getMethod)) {
                        out.addDeclaration((Declaration)getMethod);
                    }
                    if (signatures.addMethod(setMethod = new Function(Function.Type.JavaMethod, ElementsHelper.ident((String[])new String[]{"set" + StringUtils.capitalize((String)name)}), ElementsHelper.typeRef(Void.TYPE), new Arg[]{new Arg(name, vd.getValueType().clone())}).setBody(ElementsHelper.block((Statement[])new Statement[]{ElementsHelper.stat((Expression)ElementsHelper.expr((Expression)ElementsHelper.memberRef((Expression)ElementsHelper.thisRef(), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (Identifier)ElementsHelper.ident((String[])new String[]{name})), (Expression.AssignmentOperator)Expression.AssignmentOperator.Equal, (Expression)ElementsHelper.varRef((String)name)))})).addModifiers(new Modifier[]{ModifierType.Public}))) {
                        out.addDeclaration((Declaration)setMethod);
                    }
                }
                iChild[0] = iChild[0] + 1;
            }
            return true;
        }
        catch (UnsupportedConversionException e) {
            out.addDeclaration((Declaration)new EmptyDeclaration(new String[]{e.toString()}));
            return false;
        }
    }

    @Override
    TaggedTypeRefDeclaration publicStaticClassDecl(Identifier name, Identifier parentName, Struct.Type type, Element toCloneCommentsFrom, Identifier ... interfaces) {
        return ElementsHelper.decl((TypeRef.TaggedTypeRef)this.publicStaticClass(name, parentName, type, toCloneCommentsFrom, interfaces));
    }

    @Override
    Struct publicStaticClass(Identifier name, Identifier parentName, Struct.Type type, Element toCloneCommentsFrom, Identifier ... interfaces) {
        Struct cl = new Struct();
        cl.setType(type);
        cl.setTag(name);
        if (parentName != null) {
            cl.setParents(new TypeRef.SimpleTypeRef[]{ElementsHelper.typeRef((Identifier)parentName)});
        }
        if (type == Struct.Type.JavaInterface) {
            for (Identifier inter : interfaces) {
                cl.addParent(ElementsHelper.typeRef((Identifier)inter));
            }
        } else {
            for (Identifier inter : interfaces) {
                cl.addProtocol(ElementsHelper.typeRef((Identifier)inter));
            }
        }
        if (!this.result.config.noComments) {
            cl.importComments(toCloneCommentsFrom, new String[]{this.getFileCommentContent(toCloneCommentsFrom)});
        }
        cl.addModifiers(new Modifier[]{ModifierType.Public, ModifierType.Static});
        return cl;
    }

    @Override
    public Pair<List<VariablesDeclaration>, List<VariablesDeclaration>> getParentAndOwnDeclarations(Struct structJavaClass, Struct nativeStruct) throws IOException {
        Pair ret = new Pair(new ArrayList(), new ArrayList());
        if (!nativeStruct.getParents().isEmpty()) {
            for (TypeRef.SimpleTypeRef parentName : nativeStruct.getParents()) {
                Struct parent = this.result.structsByName.get(parentName.getName());
                if (parent == null) continue;
                Struct parentJavaClass = this.convertStruct(parent, new Signatures(), null, null, true);
                Pair<List<VariablesDeclaration>, List<VariablesDeclaration>> parentDecls = this.getParentAndOwnDeclarations(parentJavaClass, parent);
                ((List)ret.getFirst()).addAll((Collection)parentDecls.getFirst());
                ((List)ret.getFirst()).addAll((Collection)parentDecls.getSecond());
            }
        }
        for (Declaration d : structJavaClass.getDeclarations()) {
            VariablesDeclaration vd;
            if (!(d instanceof VariablesDeclaration) || (vd = (VariablesDeclaration)d).getDeclarators().size() != 1 || !this.isField(vd)) continue;
            ((List)ret.getSecond()).add(vd);
        }
        return ret;
    }

    private boolean isJNAPointer(TypeRef tr) {
        if (!(tr instanceof TypeRef.SimpleTypeRef)) {
            return false;
        }
        TypeRef.SimpleTypeRef str = (TypeRef.SimpleTypeRef)tr;
        Identifier name = str.getName().eraseTemplateArguments();
        return name.toString().equals(Pointer.class.getName());
    }

    private void addStructConstructors(Identifier structName, Struct structJavaClass, Struct nativeStruct) throws IOException {
        ArrayList initialMembers = new ArrayList(structJavaClass.getDeclarations());
        TreeSet<String> signatures = new TreeSet<String>();
        Function emptyConstructor = new Function(Function.Type.JavaMethod, structName.clone(), null).addModifiers(new Modifier[]{ModifierType.Public});
        emptyConstructor.setBody(ElementsHelper.block((Statement[])new Statement[]{ElementsHelper.stat((Expression)ElementsHelper.methodCall((String)"super", (Expression[])new Expression[0]))}));
        this.addConstructor(structJavaClass, emptyConstructor);
        boolean isUnion = nativeStruct.getType() == Struct.Type.CUnion;
        boolean addPointerConstructor = true;
        if (isUnion) {
            LinkedHashMap<String, Pair> fieldsAndCommentsByTypeStr = new LinkedHashMap<String, Pair>();
            for (Declaration d : initialMembers) {
                String trStr;
                Pair pair;
                VariablesDeclaration vd;
                if (!(d instanceof VariablesDeclaration) || (vd = (VariablesDeclaration)d).getDeclarators().size() != 1) continue;
                String name = ((Declarator)vd.getDeclarators().get(0)).resolveName();
                TypeRef tr = vd.getValueType();
                if (!this.isField(vd)) continue;
                if (this.isJNAPointer(tr)) {
                    addPointerConstructor = false;
                }
                if ((pair = (Pair)fieldsAndCommentsByTypeStr.get(trStr = tr.toString())) == null) {
                    pair = new Pair((Object)tr, new ArrayList());
                    fieldsAndCommentsByTypeStr.put(trStr, pair);
                }
                ((List)pair.getSecond()).add(new Pair((Object)vd.getCommentBefore(), (Object)name));
            }
            for (Pair pair : fieldsAndCommentsByTypeStr.values()) {
                ArrayList<Object> commentBits = new ArrayList<Object>();
                ArrayList<Object> nameBits = new ArrayList<Object>();
                for (Pair p : (List)pair.getValue()) {
                    if (p.getFirst() != null) {
                        commentBits.add(p.getFirst());
                    }
                    nameBits.add(p.getValue());
                }
                String name = StringUtils.implode(nameBits, (Object)"_or_");
                TypeRef tr = (TypeRef)pair.getFirst();
                Function unionValConstr = new Function(Function.Type.JavaMethod, structName.clone(), null, new Arg[]{new Arg(name, tr.clone())});
                if (!this.result.config.noComments && !commentBits.isEmpty()) {
                    unionValConstr.addToCommentBefore(new String[]{"@param " + name + " " + StringUtils.implode(commentBits, (Object)", or ")});
                }
                unionValConstr.addModifiers(new Modifier[]{ModifierType.Public});
                Expression assignmentExpr = ElementsHelper.varRef((String)name);
                for (Pair p : (List)pair.getValue()) {
                    assignmentExpr = new Expression.AssignmentOp(ElementsHelper.memberRef((Expression)ElementsHelper.thisRef(), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (Identifier)ElementsHelper.ident((String[])new String[]{(String)p.getValue()})), Expression.AssignmentOperator.Equal, assignmentExpr);
                }
                unionValConstr.setBody(ElementsHelper.block((Statement[])new Statement[]{ElementsHelper.stat((Expression)ElementsHelper.methodCall((String)"super", (Expression[])new Expression[0])), tr instanceof TypeRef.ArrayRef ? this.throwIfArraySizeDifferent(name) : null, ElementsHelper.stat((Expression)assignmentExpr), ElementsHelper.stat((Expression)ElementsHelper.methodCall((String)"setType", (Expression[])new Expression[]{this.result.typeConverter.getJavaClassLitteralExpression(tr)}))}));
                if (!signatures.add(unionValConstr.computeSignature(Function.SignatureType.JavaStyle))) continue;
                structJavaClass.addDeclaration((Declaration)unionValConstr);
            }
        } else {
            int nArgs;
            Statement.Block getFieldOrderImpl;
            String uname;
            String name;
            Function fieldsConstr = new Function(Function.Type.JavaMethod, structName.clone(), null);
            fieldsConstr.setBody(new Statement.Block()).addModifiers(new Modifier[]{ModifierType.Public});
            Pair<List<VariablesDeclaration>, List<VariablesDeclaration>> decls = this.getParentAndOwnDeclarations(structJavaClass, nativeStruct);
            TreeMap<Integer, String> namesById = new TreeMap<Integer, String>();
            HashSet<String> names = new HashSet<String>();
            ArrayList<Expression> orderedFieldNames = new ArrayList<Expression>();
            int iArg = 0;
            for (Object vd : new CompoundCollection(new Collection[]{(Collection)decls.getFirst(), (Collection)decls.getSecond()})) {
                String name2 = this.chooseJavaArgName(((Declarator)vd.getDeclarators().get(0)).resolveName(), iArg, names);
                namesById.put(vd.getId(), name2);
                fieldsConstr.addArg(new Arg(name2, vd.getValueType().clone()));
                ++iArg;
            }
            if (iArg == 1 && this.isJNAPointer(((Arg)fieldsConstr.getArgs().get(0)).getValueType())) {
                addPointerConstructor = false;
            }
            Expression.FunctionCall superCall = ElementsHelper.methodCall((String)"super", (Expression[])new Expression[0]);
            for (VariablesDeclaration vd : (List)decls.getFirst()) {
                name = ((Declarator)vd.getDeclarators().get(0)).resolveName();
                uname = (String)namesById.get(vd.getId());
                Struct parent = (Struct)vd.getParentElement();
                Identifier parentTgName = this.typeConverter().getTaggedTypeIdentifierInJava((TypeRef.TaggedTypeRef)parent);
                if (!this.result.config.noComments) {
                    fieldsConstr.addToCommentBefore(new String[]{"@param " + name + " @see " + parentTgName + "#" + ((Declarator)vd.getDeclarators().get(0)).resolveName()});
                }
                superCall.addArgument(ElementsHelper.varRef((String)uname));
            }
            fieldsConstr.getBody().addStatement(ElementsHelper.stat((Expression)superCall));
            for (VariablesDeclaration vd : (List)decls.getSecond()) {
                name = ((Declarator)vd.getDeclarators().get(0)).resolveName();
                uname = (String)namesById.get(vd.getId());
                if (!this.result.config.noComments && vd.getCommentBefore() != null) {
                    fieldsConstr.addToCommentBefore(new String[]{"@param " + uname + " " + vd.getCommentBefore()});
                }
                if (vd.getValueType() instanceof TypeRef.ArrayRef) {
                    fieldsConstr.getBody().addStatement(this.throwIfArraySizeDifferent(uname));
                }
                fieldsConstr.getBody().addStatement(ElementsHelper.stat((Expression)new Expression.AssignmentOp(ElementsHelper.memberRef((Expression)ElementsHelper.thisRef(), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (Identifier)ElementsHelper.ident((String[])new String[]{name})), Expression.AssignmentOperator.Equal, ElementsHelper.varRef((String)uname))));
                orderedFieldNames.add(ElementsHelper.expr((String)name));
            }
            String getFieldOrderName = "getFieldOrder";
            Expression.FunctionCall selfList = ElementsHelper.methodCall((Expression)ElementsHelper.expr((TypeRef)ElementsHelper.typeRef(Arrays.class)), (String)"asList", (Expression[])orderedFieldNames.toArray(new Expression[orderedFieldNames.size()]));
            if (nativeStruct.getParents().isEmpty()) {
                getFieldOrderImpl = ElementsHelper.block((Statement[])new Statement[]{new Statement.Return((Expression)selfList)});
            } else {
                String fieldOrderName = "fieldOrder";
                VariablesDeclaration vd = new VariablesDeclaration(ElementsHelper.typeRef(List.class), new Declarator[]{new Declarator.DirectDeclarator(fieldOrderName, (Expression)new Expression.New(ElementsHelper.typeRef(ArrayList.class), new Expression[]{ElementsHelper.methodCall((Expression)ElementsHelper.varRef((String)"super"), (String)getFieldOrderName, (Expression[])new Expression[0])}))});
                getFieldOrderImpl = ElementsHelper.block((Statement[])new Statement[]{vd, ElementsHelper.stat((Expression)ElementsHelper.methodCall((Expression)ElementsHelper.varRef((String)fieldOrderName), (String)"addAll", (Expression[])new Expression[]{selfList})), new Statement.Return(ElementsHelper.varRef((String)fieldOrderName))});
            }
            TypeRef.SimpleTypeRef listRef = ElementsHelper.typeRef((Identifier)ElementsHelper.ident(List.class, (Expression[])new Expression[]{ElementsHelper.expr((TypeRef)ElementsHelper.typeRef((String)"?"))}));
            Function getFieldOrder = new Function(Function.Type.JavaMethod, ElementsHelper.ident((String[])new String[]{getFieldOrderName}), (TypeRef)listRef).setBody(getFieldOrderImpl).addModifiers(new Modifier[]{ModifierType.Protected});
            if (signatures.add(getFieldOrder.computeSignature(Function.SignatureType.JavaStyle))) {
                structJavaClass.addDeclaration((Declaration)getFieldOrder);
            }
            if ((nArgs = fieldsConstr.getArgs().size()) == 0) {
                System.err.println("Struct with no field : " + structName);
            }
            if (nArgs > 0 && nArgs < this.result.config.maxConstructedFields && signatures.add(fieldsConstr.computeSignature(Function.SignatureType.JavaStyle))) {
                structJavaClass.addDeclaration((Declaration)fieldsConstr);
            }
        }
        if (addPointerConstructor) {
            Function addressConstructor = new Function(Function.Type.JavaMethod, structName.clone(), null).addModifiers(new Modifier[]{ModifierType.Public});
            String pointerVarName = "peer";
            addressConstructor.addArg(new Arg(pointerVarName, ElementsHelper.typeRef(Pointer.class)));
            Expression.FunctionCall superPointerCall = ElementsHelper.methodCall((String)"super", (Expression[])new Expression[0]);
            superPointerCall.addArgument(ElementsHelper.varRef((String)pointerVarName));
            addressConstructor.setBody(ElementsHelper.block((Statement[])new Statement[]{ElementsHelper.stat((Expression)superPointerCall)}));
            this.addConstructor(structJavaClass, addressConstructor);
        }
    }

    @Override
    protected void configureCallbackStruct(Struct callbackStruct) {
        callbackStruct.setType(Struct.Type.JavaInterface);
        callbackStruct.addModifiers(new Modifier[]{ModifierType.Public});
    }

    @Override
    protected Struct createFakePointerClass(Identifier fakePointer) {
        Struct ptClass = this.result.declarationsConverter.publicStaticClass(fakePointer, ElementsHelper.ident(PointerType.class, (Expression[])new Expression[0]), Struct.Type.JavaClass, null, new Identifier[0]);
        String pointerVarName = "address";
        ptClass.addDeclaration((Declaration)new Function(Function.Type.JavaMethod, fakePointer, null, new Arg[]{new Arg(pointerVarName, ElementsHelper.typeRef(Pointer.class))}).addModifiers(new Modifier[]{ModifierType.Public}).setBody(ElementsHelper.block((Statement[])new Statement[]{ElementsHelper.stat((Expression)ElementsHelper.methodCall((String)"super", (Expression[])new Expression[]{ElementsHelper.varRef((String)pointerVarName)}))})));
        ptClass.addDeclaration((Declaration)new Function(Function.Type.JavaMethod, fakePointer, null).addModifiers(new Modifier[]{ModifierType.Public}).setBody(ElementsHelper.block((Statement[])new Statement[]{ElementsHelper.stat((Expression)ElementsHelper.methodCall((String)"super", (Expression[])new Expression[0]))})));
        return ptClass;
    }

    private void annotateActualName(ModifiableElement e, Identifier name) {
        e.addAnnotation(new Annotation((TypeRef)this.result.config.runtime.typeRef(JNAeratorConfig.Runtime.Ann.Name), ElementsHelper.expr((String)name.toString())));
    }

    @Override
    public void generateLibraryFiles(SourceFiles sourceFiles, Result result, JNAeratorConfig config) throws IOException {
        Struct librariesHub = null;
        PrintWriter hubOut = null;
        if (result.config.entryName != null) {
            librariesHub = new Struct();
            librariesHub.addToCommentBefore(new String[]{"JNA Wrappers instances"});
            librariesHub.setType(Struct.Type.JavaClass);
            librariesHub.addModifiers(new Modifier[]{ModifierType.Public, ModifierType.Abstract});
            Identifier hubName = result.getHubFullClassName();
            librariesHub.setTag((Identifier)hubName.resolveLastSimpleIdentifier());
            hubOut = result.classOutputter.getClassSourceWriter(hubName.toString());
            hubOut.println("package " + hubName.resolveAllButLastIdentifier() + ";");
            for (Identifier pn : result.javaPackages) {
                if (pn.equals((Object)"")) continue;
                hubOut.println("import " + pn + ".*;");
            }
        }
        for (String library : result.libraries) {
            if (library == null) continue;
            Identifier javaPackage = result.javaPackageByLibrary.get(library);
            Identifier simpleLibraryClassName = result.getLibraryClassSimpleName(library);
            Identifier fullLibraryClassName = result.getLibraryClassFullName(library);
            Struct interf = new Struct();
            interf.setResolvedJavaIdentifier(fullLibraryClassName);
            interf.addToCommentBefore(new String[]{"JNA Wrapper for library <b>" + library + "</b>", result.declarationsConverter.getFileCommentContent(result.config.libraryProjectSources.get(library), null)});
            if (hubOut != null) {
                interf.addToCommentBefore(new String[]{"@see " + result.config.entryName + "." + library});
            }
            interf.addModifiers(new Modifier[]{ModifierType.Public});
            interf.setTag(simpleLibraryClassName);
            Expression nativeLibFieldExpr = null;
            if (!result.config.skipLibraryInstanceDeclarations) {
                Expression[] expressionArray;
                Expression libNameExpr = ElementsHelper.opaqueExpr((String)result.getLibraryFileExpression(library));
                TypeRef.SimpleTypeRef libTypeRef = ElementsHelper.typeRef((Identifier)fullLibraryClassName);
                Expression libClassLiteral = result.typeConverter.typeLiteral((TypeRef)libTypeRef);
                boolean isJNAerator = result.config.runtime == JNAeratorConfig.Runtime.JNAerator;
                Object libraryPathGetterExpr = isJNAerator ? ElementsHelper.methodCall((Expression)ElementsHelper.expr((TypeRef)ElementsHelper.typeRef(LibraryExtractor.class)), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"getLibraryPath", (Expression[])new Expression[]{libNameExpr, ElementsHelper.expr((boolean)true), libClassLiteral}) : libNameExpr;
                String libNameStringFieldName = "JNA_LIBRARY_NAME";
                String nativeLibFieldName = "JNA_NATIVE_LIB";
                interf.addDeclaration((Declaration)new VariablesDeclaration(ElementsHelper.typeRef(String.class), new Declarator[]{new Declarator.DirectDeclarator(libNameStringFieldName, libraryPathGetterExpr)}).addModifiers(new Modifier[]{ModifierType.Public, ModifierType.Static, ModifierType.Final}));
                Expression libraryNameFieldExpr = ElementsHelper.memberRef((Expression)ElementsHelper.expr((TypeRef)libTypeRef.clone()), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (Identifier)ElementsHelper.ident((String[])new String[]{libNameStringFieldName}));
                Expression optionsMapExpr = ElementsHelper.memberRef((Expression)ElementsHelper.expr((TypeRef)ElementsHelper.typeRef(MangledFunctionMapper.class)), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"DEFAULT_OPTIONS");
                if (isJNAerator) {
                    Expression[] expressionArray2 = new Expression[2];
                    expressionArray2[0] = libraryNameFieldExpr.clone();
                    expressionArray = expressionArray2;
                    expressionArray2[1] = optionsMapExpr.clone();
                } else {
                    Expression[] expressionArray3 = new Expression[1];
                    expressionArray = expressionArray3;
                    expressionArray3[0] = libraryNameFieldExpr.clone();
                }
                Expression[] getInstArgs = expressionArray;
                interf.addDeclaration((Declaration)new VariablesDeclaration(ElementsHelper.typeRef(NativeLibrary.class), new Declarator[]{new Declarator.DirectDeclarator(nativeLibFieldName, (Expression)ElementsHelper.methodCall((Expression)ElementsHelper.expr((TypeRef)ElementsHelper.typeRef(NativeLibrary.class)), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"getInstance", (Expression[])getInstArgs))}).addModifiers(new Modifier[]{ModifierType.Public, ModifierType.Static, ModifierType.Final}));
                nativeLibFieldExpr = ElementsHelper.memberRef((Expression)ElementsHelper.expr((TypeRef)libTypeRef.clone()), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (Identifier)ElementsHelper.ident((String[])new String[]{nativeLibFieldName}));
                if (result.config.useJNADirectCalls) {
                    interf.addDeclaration((Declaration)new Function(Function.Type.StaticInit, null, null).setBody(ElementsHelper.block((Statement[])new Statement[]{ElementsHelper.stat((Expression)ElementsHelper.methodCall((Expression)ElementsHelper.expr((TypeRef)ElementsHelper.typeRef(Native.class)), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"register", (Expression[])new Expression[]{ElementsHelper.memberRef((Expression)ElementsHelper.expr((TypeRef)libTypeRef.clone()), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (Identifier)ElementsHelper.ident((String[])new String[]{"class"})), nativeLibFieldExpr.clone()}))})).addModifiers(new Modifier[]{ModifierType.Static}));
                } else {
                    Expression[] expressionArray4;
                    if (isJNAerator) {
                        Expression[] expressionArray5 = new Expression[3];
                        expressionArray5[0] = libraryNameFieldExpr.clone();
                        expressionArray5[1] = libClassLiteral;
                        expressionArray4 = expressionArray5;
                        expressionArray5[2] = optionsMapExpr.clone();
                    } else {
                        Expression[] expressionArray6 = new Expression[2];
                        expressionArray6[0] = libraryNameFieldExpr.clone();
                        expressionArray4 = expressionArray6;
                        expressionArray6[1] = libClassLiteral;
                    }
                    Expression[] loadLibArgs = expressionArray4;
                    VariablesDeclaration instanceDecl = new VariablesDeclaration((TypeRef)libTypeRef, new Declarator[]{new Declarator.DirectDeclarator(librariesHub == null ? "INSTANCE" : library, ElementsHelper.cast((TypeRef)libTypeRef, (Expression)ElementsHelper.methodCall((Expression)ElementsHelper.expr((TypeRef)ElementsHelper.typeRef(Native.class)), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"loadLibrary", (Expression[])loadLibArgs)))}).addModifiers(new Modifier[]{ModifierType.Public, ModifierType.Static, ModifierType.Final});
                    if (librariesHub != null) {
                        librariesHub.addDeclaration((Declaration)instanceDecl);
                        librariesHub.addProtocol(fullLibraryClassName.clone());
                    } else {
                        interf.addDeclaration((Declaration)instanceDecl);
                    }
                }
            }
            boolean stdcall = false;
            List<Function> functions = result.functionsByLibrary.get(library);
            if (functions != null) {
                for (Function function : functions) {
                    if (!function.hasModifier((Modifier)ModifierType.__stdcall)) continue;
                    stdcall = true;
                    break;
                }
            }
            Identifier libSuperInter = ElementsHelper.ident((Class)(stdcall ? StdCallLibrary.class : config.runtime.libraryClass), (Expression[])new Expression[0]);
            if (result.config.useJNADirectCalls) {
                interf.addProtocol(libSuperInter);
                interf.setType(Struct.Type.JavaClass);
            } else {
                interf.addParent(libSuperInter);
                interf.setType(Struct.Type.JavaInterface);
            }
            this.fillLibraryMapping(result, sourceFiles, (DeclarationsHolder)interf, (DeclarationsHolder)interf, library, javaPackage, nativeLibFieldExpr);
            this.writeLibraryInterface(result, sourceFiles, (DeclarationsHolder)interf, library, javaPackage);
        }
        if (hubOut != null) {
            hubOut.println(librariesHub.toString());
            hubOut.close();
        }
    }
}

