/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.lang.jnaerator.GlobalsGenerator;
import com.ochafik.lang.jnaerator.JNADeclarationsConverter;
import com.ochafik.lang.jnaerator.JNATypeConversion;
import com.ochafik.lang.jnaerator.JNAeratorConfig;
import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.Signatures;
import com.ochafik.lang.jnaerator.TypeConversion;
import com.ochafik.lang.jnaerator.UnsupportedConversionException;
import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.Declaration;
import com.ochafik.lang.jnaerator.parser.DeclarationsHolder;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.ModifierType;
import com.ochafik.lang.jnaerator.parser.Statement;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.VariablesDeclaration;
import com.ochafik.lang.jnaerator.runtime.globals.Global;
import com.ochafik.lang.jnaerator.runtime.globals.GlobalCallback;
import com.ochafik.lang.jnaerator.runtime.globals.GlobalPointer;
import com.ochafik.lang.jnaerator.runtime.globals.GlobalPointerType;
import com.ochafik.lang.jnaerator.runtime.globals.GlobalStruct;
import com.ochafik.lang.jnaerator.runtime.globals.GlobalUnion;
import com.sun.jna.ptr.ByReference;
import java.util.ArrayList;

public class JNAGlobalsGenerator
extends GlobalsGenerator {
    public JNAGlobalsGenerator(Result result) {
        super(result);
    }

    final JNATypeConversion typeConverter() {
        return (JNATypeConversion)this.result.typeConverter;
    }

    public void convertGlobals(VariablesDeclaration globals, Signatures signatures, DeclarationsHolder out, Expression nativeLibFieldExpr, Identifier callerLibraryName, String callerLibrary) throws UnsupportedConversionException {
        if (this.result.config.runtime == JNAeratorConfig.Runtime.JNA) {
            return;
        }
        for (Declarator d : globals.getDeclarators()) {
            try {
                boolean hasOffset;
                TypeRef instType;
                Identifier name = this.result.typeConverter.getValidJavaArgumentName(ElementsHelper.ident((String[])new String[]{d.resolveName()}));
                TypeRef type = (TypeRef)d.mutateTypeKeepingParent((Declarator.MutableByDeclarator)globals.getValueType());
                if (type == null) continue;
                TypeRef targetType = type instanceof TypeRef.Pointer ? ((TypeRef.Pointer)type).getTarget() : null;
                boolean isCallback = targetType != null && this.result.callbacksByName.containsKey(ElementsHelper.ident((String[])new String[]{targetType.toString()}));
                ArrayList modifiers = new ArrayList(type.getModifiers());
                modifiers.addAll(globals.getModifiers());
                if (!isCallback && !ModifierType.Extern.isContainedBy(modifiers) && !ModifierType.Dllexport.isContainedBy(modifiers) && !ModifierType.Dllimport.isContainedBy(modifiers) || !signatures.addVariable(name.toString())) continue;
                boolean isPointer = type instanceof TypeRef.Pointer;
                TypeConversion.JavaPrim prim = this.result.typeConverter.getPrimitive(isPointer ? ((TypeRef.Pointer)type).getTarget() : type);
                type.setMarkedAsResolved(false);
                TypeRef convertedType = this.typeConverter().convertTypeToJNA(type, TypeConversion.TypeConversionMode.NativeParameter, callerLibraryName);
                String convTypStr = convertedType.toString();
                if (convTypStr.endsWith(".ByValue")) {
                    convTypStr = convTypStr.substring(0, convTypStr.length() - ".ByValue".length());
                }
                boolean isStruct = this.result.structsFullNames.contains(ElementsHelper.ident((String[])new String[]{convTypStr}));
                boolean isUnion = this.result.unionsFullNames.contains(ElementsHelper.ident((String[])new String[]{convTypStr}));
                if (prim != null || isCallback || isStruct || isUnion) {
                    TypeRef.SimpleTypeRef globalType = null;
                    Expression extraArg = null;
                    if (isUnion) {
                        globalType = ElementsHelper.typeRef((Identifier)ElementsHelper.ident(GlobalUnion.class, (Expression[])new Expression[]{ElementsHelper.expr((TypeRef)convertedType.clone())}));
                        extraArg = ElementsHelper.memberRef((Expression)ElementsHelper.expr((TypeRef)convertedType.clone()), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"class");
                    } else if (isStruct) {
                        globalType = ElementsHelper.typeRef((Identifier)ElementsHelper.ident(GlobalStruct.class, (Expression[])new Expression[]{ElementsHelper.expr((TypeRef)convertedType.clone())}));
                        extraArg = ElementsHelper.memberRef((Expression)ElementsHelper.expr((TypeRef)convertedType.clone()), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"class");
                    } else if (isCallback) {
                        globalType = ElementsHelper.typeRef((Identifier)ElementsHelper.ident(GlobalCallback.class, (Expression[])new Expression[]{ElementsHelper.expr((TypeRef)targetType.clone())}));
                        extraArg = ElementsHelper.memberRef((Expression)ElementsHelper.expr((TypeRef)targetType.clone()), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"class");
                    } else if (isPointer) {
                        Class<? extends ByReference> brt = this.result.typeConverter.primToByReference.get((Object)prim);
                        if (brt != null) {
                            globalType = ElementsHelper.typeRef((Identifier)ElementsHelper.ident(GlobalPointerType.class, (Expression[])new Expression[]{ElementsHelper.expr((TypeRef)ElementsHelper.typeRef((Identifier)ElementsHelper.ident(brt, (Expression[])new Expression[0])))}));
                            extraArg = ElementsHelper.classLiteral(brt);
                        } else if (prim == TypeConversion.JavaPrim.Void) {
                            globalType = ElementsHelper.typeRef(GlobalPointer.class);
                        }
                    } else {
                        Class<? extends Global> globalClass = this.result.typeConverter.primToGlobal.get((Object)prim);
                        if (globalClass != null) {
                            globalType = ElementsHelper.typeRef(globalClass);
                        }
                    }
                    if (globalType != null) {
                        ArrayList<Expression> constructorArgs = new ArrayList<Expression>();
                        constructorArgs.add(nativeLibFieldExpr.clone());
                        if (extraArg != null) {
                            constructorArgs.add(extraArg);
                        }
                        constructorArgs.add(ElementsHelper.expr((String)name.toString()));
                        VariablesDeclaration vd = new VariablesDeclaration((TypeRef)globalType, new Declarator[]{new Declarator.DirectDeclarator(name.toString(), (Expression)new Expression.New(globalType.clone(), constructorArgs.toArray(new Expression[constructorArgs.size()])))});
                        vd.addModifiers(new Modifier[]{ModifierType.Public, ModifierType.Static, ModifierType.Final});
                        vd.importComments((Element)globals, new String[0]);
                        out.addDeclaration((Declaration)vd);
                        continue;
                    }
                    out.addDeclaration((Declaration)this.result.declarationsConverter.skipDeclaration((Element)d, "Unsupported global value type: " + convTypStr));
                }
                if (!signatures.addClass(name)) continue;
                Struct struct = this.result.declarationsConverter.publicStaticClass(name, null, Struct.Type.JavaClass, null, new Identifier[0]);
                struct.addModifiers(new Modifier[]{ModifierType.Final});
                struct.importDetails((Element)globals, false);
                struct.moveAllCommentsBefore();
                TypeRef.Pointer pointerType = new TypeRef.Pointer(type, Declarator.PointerStyle.Pointer);
                TypeRef convPointerType = this.typeConverter().convertTypeToJNA((TypeRef)pointerType, TypeConversion.TypeConversionMode.FieldType, callerLibraryName);
                boolean isPtr = false;
                boolean isByRef = false;
                String convPointerTypeStr = convPointerType.toString();
                if (convPointerTypeStr.equals(this.result.config.runtime.pointerClass.getName())) {
                    isPtr = true;
                    instType = convPointerType;
                    hasOffset = false;
                } else if (this.result.typeConverter.byReferenceClassesNames.contains(convPointerTypeStr)) {
                    isByRef = true;
                    instType = convPointerType;
                    hasOffset = false;
                } else if (convPointerTypeStr.endsWith(".ByReference") && this.result.structsByName.get(convPointerTypeStr.substring(0, convPointerTypeStr.length() - ".ByReference".length())) != null) {
                    instType = this.typeConverter().convertTypeToJNA(type, TypeConversion.TypeConversionMode.PointedValue, callerLibraryName);
                    hasOffset = true;
                } else {
                    Identifier instTypeName = ElementsHelper.ident((String[])new String[]{name + "_holder"});
                    Struct holderStruct = this.result.declarationsConverter.publicStaticClass(instTypeName, ElementsHelper.ident((Class)this.result.config.runtime.structClass, (Expression[])new Expression[0]), Struct.Type.JavaClass, null, new Identifier[0]);
                    holderStruct.addModifiers(new Modifier[]{ModifierType.Final});
                    VariablesDeclaration vd = ((JNADeclarationsConverter)this.result.declarationsConverter).convertVariablesDeclarationToJNA("value", type, new int[1], callerLibraryName, new Element[0]);
                    if (vd.getValueType().toString().equals(this.result.config.runtime.pointerClass.getName())) {
                        isByRef = true;
                        instType = convPointerType;
                        hasOffset = false;
                    } else {
                        holderStruct.addDeclaration((Declaration)vd);
                        Function pointerConstructor = new Function(Function.Type.JavaMethod, instTypeName, null, new Arg[]{new Arg("pointer", (TypeRef)new TypeRef.SimpleTypeRef(this.result.config.runtime.pointerClass.getName()))});
                        hasOffset = false;
                        pointerConstructor.setBody(new Statement.Block(new Statement[]{new Statement.ExpressionStatement((Expression)ElementsHelper.methodCall((String)"super", (Expression[])new Expression[0])), new Statement.ExpressionStatement((Expression)ElementsHelper.methodCall((String)"useMemory", (Expression[])new Expression[]{ElementsHelper.varRef((String)"pointer"), ElementsHelper.expr((int)0)})), new Statement.ExpressionStatement((Expression)ElementsHelper.methodCall((String)"read", (Expression[])new Expression[0]))}));
                        holderStruct.addDeclaration((Declaration)pointerConstructor);
                        instType = new TypeRef.SimpleTypeRef(instTypeName);
                        struct.addDeclaration((Declaration)ElementsHelper.decl((TypeRef.TaggedTypeRef)holderStruct));
                    }
                }
                Identifier instName = name;
                struct.addDeclaration((Declaration)new VariablesDeclaration(instType, new Declarator[]{new Declarator.DirectDeclarator(instName.toString())}).addModifiers(new Modifier[]{ModifierType.Private, ModifierType.Static}));
                Expression.VariableRef instRef = new Expression.VariableRef(instName);
                Expression.FunctionCall ptrExpr = ElementsHelper.methodCall((Expression)nativeLibFieldExpr.clone(), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"getGlobalVariableAddress", (Expression[])new Expression[]{ElementsHelper.expr((String)name.toString())});
                ArrayList<Statement.ExpressionStatement> initStats = new ArrayList<Statement.ExpressionStatement>();
                initStats.add(new Statement.ExpressionStatement(ElementsHelper.expr((Expression)instRef.clone(), (Expression.AssignmentOperator)Expression.AssignmentOperator.Equal, (Expression)(isPtr ? ptrExpr : (isByRef ? new Expression.New(instType) : new Expression.New(instType, new Expression.FunctionCall(null, new Expression[]{ptrExpr, hasOffset ? ElementsHelper.expr((int)0) : null})))))));
                if (isByRef) {
                    initStats.add(new Statement.ExpressionStatement((Expression)ElementsHelper.methodCall((Expression)instRef, (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"setPointer", (Expression[])new Expression[]{ptrExpr})));
                }
                struct.addDeclaration((Declaration)new Function(Function.Type.JavaMethod, ElementsHelper.ident((String[])new String[]{"get"}), instType).setBody(new Statement.Block(new Statement[]{new Statement.If(ElementsHelper.expr((Expression)instRef, (Expression.BinaryOperator)Expression.BinaryOperator.IsEqual, (Expression)ElementsHelper.nullExpr()), (Statement)(initStats.size() == 1 ? (Statement)initStats.get(0) : new Statement.Block(initStats)), null), new Statement.Return(instRef.clone())})).addModifiers(new Modifier[]{ModifierType.Public, ModifierType.Static, ModifierType.Synchronized}));
                out.addDeclaration((Declaration)ElementsHelper.decl((TypeRef.TaggedTypeRef)struct));
            }
            catch (Throwable t) {
                out.addDeclaration((Declaration)this.result.declarationsConverter.skipDeclaration((Element)d, t.toString()));
            }
        }
    }
}

