/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.google.common.base.Preconditions;
import com.ochafik.io.FileListUtils;
import com.ochafik.io.IOUtils;
import com.ochafik.io.ReadText;
import com.ochafik.io.WriteText;
import com.ochafik.lang.compiler.CompilerUtils;
import com.ochafik.lang.compiler.MemoryFileManager;
import com.ochafik.lang.compiler.MemoryFileObject;
import com.ochafik.lang.compiler.MemoryJavaFile;
import com.ochafik.lang.compiler.URLFileObject;
import com.ochafik.lang.jnaerator.BridgeSupportParser;
import com.ochafik.lang.jnaerator.CToJavaPreScanner;
import com.ochafik.lang.jnaerator.ClassOutputter;
import com.ochafik.lang.jnaerator.JNAeratorCommandLineArgs;
import com.ochafik.lang.jnaerator.JNAeratorConfig;
import com.ochafik.lang.jnaerator.JNAeratorConfigUtils;
import com.ochafik.lang.jnaerator.JNAeratorParser;
import com.ochafik.lang.jnaerator.JavaDocCreator;
import com.ochafik.lang.jnaerator.MissingNamesChooser;
import com.ochafik.lang.jnaerator.NativePlatform;
import com.ochafik.lang.jnaerator.ObjectiveCToJavaPreScanner;
import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.ScalaGenerator;
import com.ochafik.lang.jnaerator.SimpleGUI;
import com.ochafik.lang.jnaerator.SourceFiles;
import com.ochafik.lang.jnaerator.Symbols;
import com.ochafik.lang.jnaerator.TypeConversion;
import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.ModifiableElement;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.ModifierKind;
import com.ochafik.lang.jnaerator.parser.ObjCppLexer;
import com.ochafik.lang.jnaerator.parser.ObjCppParser;
import com.ochafik.lang.jnaerator.parser.Scanner;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.Visitor;
import com.ochafik.lang.jnaerator.runtime.Mangling;
import com.ochafik.lang.jnaerator.studio.JNAeratorStudio;
import com.ochafik.util.listenable.Adapter;
import com.ochafik.util.listenable.Pair;
import com.ochafik.util.string.RegexUtils;
import com.ochafik.util.string.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import org.anarres.cpp.LexerException;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.bridj.BridJ;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNAerator {
    public static final String JNAERATOR_URL = "http://code.google.com/p/jnaerator/";
    public static String DONATE_URL = "http://sourceforge.net/donate/index.php?group_id=266856";
    public static String ABOUT_JNAERATOR_URL = "http://code.google.com/p/jnaerator/wiki/AboutJNAerator";
    public static String ABOUT_ROCOCOA_URL = "http://code.google.com/p/rococoa";
    public static String ABOUT_BRIDJ_URL = "http://code.google.com/p/bridj/wiki";
    public static String ABOUT_JNA_URL = "https://github.com/twall/jna";
    private static Pattern argTokenPattern = Pattern.compile("(?m)\"[^\"]*\"|[^\\s]+");
    private static Pattern argVariablePattern = Pattern.compile("\\$\\(([^)]+)\\)");
    protected final JNAeratorConfig config;
    static final Pattern definePattern = Pattern.compile("#\\s*define\\s+(\\w+)\\s+(.*)");
    static final boolean fullFilePathInComments = true;
    private static final String DEFAULT_CONFIG_FILE = "config.jnaerator";
    private static final String POM_FILENAME = "pom.xml";
    protected static final Pattern fileRadixPattern = Pattern.compile("(?:[/\\\\]|^)(.*?)(?:Full\\.bridgesupport|\\.[^.]+)$");
    private static final Pattern classAndMethodNamePattern = Pattern.compile("(.+?)::([^:]+)");
    static Logger logger = Logger.getLogger(JNAerator.class.getName());

    public JNAerator(JNAeratorConfig config) {
        this.config = config;
    }

    protected static void fixConfig(JNAeratorConfig config) {
        String entry;
        Collection<File> inputFiles;
        if (config.sourceFiles.isEmpty() && config.bridgeSupportFiles.isEmpty() && !config.libraryFiles.isEmpty()) {
            config.extractLibSymbols = true;
        }
        File firstFile = (inputFiles = config.getInputFiles()).isEmpty() ? null : inputFiles.iterator().next().getAbsoluteFile();
        String firstFileName = firstFile == null ? null : firstFile.getName();
        Set<String> libraries = config.getLibraries();
        String string = config.entryName != null ? config.entryName : (entry = libraries.size() == 1 ? libraries.iterator().next() : null);
        if (config.outputDir == null) {
            config.outputDir = new File(".");
        }
        if (config.sourcesOutputDir == null) {
            config.sourcesOutputDir = config.outputMode == JNAeratorConfig.OutputMode.Maven ? new File(config.outputDir, "src/main/java") : config.outputDir;
        }
        if (config.resourcesOutputDir == null && config.outputMode != null) {
            config.resourcesOutputDir = config.outputMode.isMaven() ? new File(config.outputDir, "src/main/resources") : config.outputDir;
        }
        if (config.outputJar == null && config.outputMode != null && config.outputMode.isJar()) {
            config.outputJar = new File(config.outputDir, (entry == null ? "out" : entry) + ".jar");
        }
        if (config.mavenArtifactId == null && entry != null) {
            config.mavenArtifactId = entry;
        }
        if (config.mavenGroupId == null && config.rootPackageName != null) {
            config.mavenGroupId = config.rootPackageName;
        }
        config.cacheDir = JNAerator.getDir("cache");
    }

    public static String[] getJNAeratorArgsFromPref() {
        String argsPref = System.getProperty("jnaerator.args");
        if (argsPref == null) {
            return null;
        }
        return argsPref.split(",");
    }

    public static void main(String[] argsArray) {
        JNAerator.main(new JNAerator(new JNAeratorConfig()), argsArray);
    }

    public static void main(final JNAerator jnaerator, String[] argsArray) {
        final Feedback[] feedback = new Feedback[1];
        try {
            String[] jnAeratorArgsFromPref = JNAerator.getJNAeratorArgsFromPref();
            if (jnAeratorArgsFromPref != null) {
                ArrayList<String> list = new ArrayList<String>();
                list.addAll(Arrays.asList(jnAeratorArgsFromPref));
                list.addAll(Arrays.asList(argsArray));
                argsArray = list.toArray(new String[list.size()]);
            }
            if (argsArray.length == 0) {
                argsArray = new File(DEFAULT_CONFIG_FILE).exists() ? new String[]{"@", DEFAULT_CONFIG_FILE} : new String[]{"-studio"};
            }
            ArrayList<String> args = new ArrayList<String>(Arrays.asList(argsArray));
            final JNAeratorConfig config = jnaerator.config;
            config.preprocessorConfig.frameworksPath.addAll(JNAeratorConfigUtils.DEFAULT_FRAMEWORKS_PATH);
            new JNAeratorCommandLineArgs.ArgsParser(){
                boolean simpleGUI = false;
                NativePlatform arch = NativePlatform.getCurrentPlatform();
                File libraryFileForCurrentArch = null;
                String currentLibrary = null;
                String currentExtractedInterface = null;

                @Override
                List<String> parsed(JNAeratorCommandLineArgs.ArgsParser.ParsedArg a) throws Exception {
                    switch (a.def) {
                        case AddIncludePath: {
                            File includedFile = a.getFileParam(0);
                            if (includedFile.isFile()) {
                                this.parsedActualFile(includedFile, false);
                            } else {
                                config.preprocessorConfig.explicitIncludes.add(includedFile.toString());
                            }
                            this.getPath(JNAeratorCommandLineArgs.PathType.SourcePath).add(includedFile);
                            break;
                        }
                        case DontCastConstants: {
                            config.castConstants = false;
                            break;
                        }
                        case CallbackInvokeName: {
                            config.callbackInvokeMethodName = a.getStringParam(0);
                            break;
                        }
                        case AddFrameworksPath: {
                            config.preprocessorConfig.frameworksPath.add(a.getFileParam(0).toString());
                            break;
                        }
                        case NoPreprocessing: {
                            config.preprocessorConfig.preprocess = false;
                            break;
                        }
                        case MaxConstructedFields: {
                            config.maxConstructedFields = a.getIntParam(0);
                            break;
                        }
                        case BeanStructs: {
                            config.beanStructs = true;
                            break;
                        }
                        case NoPrimitiveArrays: {
                            config.noPrimitiveArrays = true;
                            break;
                        }
                        case IfRegexMatch: {
                            String javaProperty = a.getStringParam(0);
                            String regex = a.getStringParam(1);
                            String thenCmd = a.getStringParam(2);
                            String elseCmd = a.getStringParam(3);
                            String propValue = System.getProperty(javaProperty);
                            if (propValue == null) {
                                propValue = "";
                            }
                            return Arrays.asList(propValue.matches(regex) ? thenCmd : elseCmd);
                        }
                        case AddRootDir: {
                            config.addRootDir(a.getFileParam("dir"));
                            break;
                        }
                        case SkipDeprecated: {
                            config.skipDeprecated = true;
                            break;
                        }
                        case ConvertBodies: {
                            config.convertBodies = true;
                            break;
                        }
                        case NoAutoImports: {
                            config.noAutoImports = true;
                            break;
                        }
                        case ForceOverwrite: {
                            config.forceOverwrite = true;
                            break;
                        }
                        case MavenGroupId: {
                            config.mavenGroupId = a.getStringParam(0);
                            break;
                        }
                        case MavenArtifactId: {
                            config.mavenArtifactId = a.getStringParam(0);
                            break;
                        }
                        case MavenVersion: {
                            config.mavenVersion = a.getStringParam(0);
                            break;
                        }
                        case OutputMode: {
                            config.outputMode = a.getEnumParam(0, JNAeratorConfig.OutputMode.class);
                            break;
                        }
                        case NoJAR: {
                            config.legacyNoJar = true;
                            break;
                        }
                        case NoCompile: {
                            config.legacyNoCompile = true;
                            break;
                        }
                        case SkipLibInstance: {
                            config.skipLibraryInstanceDeclarations = true;
                            break;
                        }
                        case COM: {
                            config.microsoftCOM = true;
                            break;
                        }
                        case ForceStringSignatures: {
                            config.charPtrAsString = true;
                            break;
                        }
                        case NoStringReturns: {
                            config.stringifyConstCStringReturnValues = false;
                            break;
                        }
                        case SkipIncludedFrameworks: {
                            config.skipIncludedFrameworks = true;
                            break;
                        }
                        case LibraryOverrides: {
                            config.libraryOverrides.putAll(a.getMapParam(0));
                            break;
                        }
                        case GenPrivateMembers: {
                            config.skipPrivateMembers = false;
                            break;
                        }
                        case CPlusPlusGen: {
                            config.genCPlusPlus = true;
                            break;
                        }
                        case NoStaticInit: {
                            config.noStaticInit = true;
                            break;
                        }
                        case CurrentLibrary: {
                            this.currentLibrary = a.getStringParam(0);
                            if (this.currentExtractedInterface == null) break;
                            config.extractedLibraries.put(this.currentLibrary, this.currentExtractedInterface);
                            break;
                        }
                        case ExtractDeclarations: {
                            this.currentExtractedInterface = a.getStringParam(0);
                            if (this.currentLibrary == null) break;
                            config.extractedLibraries.put(this.currentLibrary, this.currentExtractedInterface);
                            break;
                        }
                        case Dependencies: {
                            Preconditions.checkState((this.currentLibrary != null ? 1 : 0) != 0, (Object)"Please define -library before -dependencies.");
                            config.dependencies.put(this.currentLibrary, a.getList(0));
                            break;
                        }
                        case CurrentPackage: {
                            config.packageName = a.getStringParam(0);
                            break;
                        }
                        case OnlineDocURLFormat: {
                            config.onlineDocumentationURLFormats.add((Pair<MessageFormat, MessageFormat>)new Pair((Object)a.getMessageFormatParam(0), (Object)a.getMessageFormatParam(1)));
                            break;
                        }
                        case BeautifyNames: {
                            config.beautifyNames = true;
                            break;
                        }
                        case NoLibBundle: {
                            config.bundleLibraries = false;
                            break;
                        }
                        case DefaultLibrary: {
                            config.defaultLibrary = a.getStringParam(0);
                            break;
                        }
                        case RecursedExtensions: {
                            config.fileFilter = "*".equals(a.getStringParam(0)) ? null : new JNAeratorConfigUtils.FileExtensionFilter(a.getStringParam(0).split("[:;"));
                            break;
                        }
                        case DefineMacro: {
                            config.preprocessorConfig.explicitMacros.put(a.getStringParam(0), a.getStringParam(1));
                            break;
                        }
                        case DefineImplicitMacro: {
                            config.preprocessorConfig.implicitMacros.put(a.getStringParam(0), a.getStringParam(1));
                            break;
                        }
                        case DefineType: {
                            config.preprocessorConfig.forcedTypeDefs.put(a.getStringParam(0), a.getStringParam(1));
                            break;
                        }
                        case Direct: {
                            config.useJNADirectCalls = true;
                            break;
                        }
                        case OptionalFunctions: {
                            config.optionalFunctions.add(Pattern.compile(a.getStringParam(0)));
                            break;
                        }
                        case SkipEnums: {
                            config.skippedEnumNames.add(Pattern.compile(a.getStringParam(0)));
                            break;
                        }
                        case SkipStructs: {
                            config.skippedStructNames.add(Pattern.compile(a.getStringParam(0)));
                            break;
                        }
                        case SkipFunctions: {
                            config.skippedFunctionNames.add(Pattern.compile(a.getStringParam(0)));
                            break;
                        }
                        case EntryName: {
                            config.entryName = a.getStringParam(0);
                            break;
                        }
                        case ExtractSymbols: {
                            config.extractLibSymbols = true;
                            break;
                        }
                        case Runtime: {
                            config.runtime = a.getEnumParam(0, JNAeratorConfig.Runtime.class);
                            break;
                        }
                        case LibFile: {
                            config.addLibraryFile(a.getFileParam(0), this.arch);
                            break;
                        }
                        case File: {
                            return this.parsedFile(a);
                        }
                        case FrameworksPath: {
                            config.preprocessorConfig.frameworksPath.clear();
                            config.preprocessorConfig.frameworksPath.addAll(Arrays.asList(a.getStringParam(0).split(":")));
                            break;
                        }
                        case GUI: {
                            this.simpleGUI = true;
                            break;
                        }
                        case Help: 
                        case WikiDoc: {
                            JNAeratorCommandLineArgs.displayHelp(a.def == JNAeratorCommandLineArgs.OptionDef.WikiDoc);
                            throw new ExitException(0);
                        }
                        case WCharAsShort: {
                            config.wcharAsShort = true;
                            break;
                        }
                        case Synchronized: {
                            config.synchronizedMethods = true;
                            break;
                        }
                        case JarOut: {
                            config.outputJar = a.getFileParam(0);
                            break;
                        }
                        case ScalaStructSetters: {
                            config.scalaStructSetters = true;
                            break;
                        }
                        case NoComments: {
                            config.noComments = true;
                            break;
                        }
                        case LimitComments: {
                            config.limitComments = true;
                            break;
                        }
                        case MacrosOut: {
                            config.macrosOutFile = a.getFileParam(0);
                            break;
                        }
                        case GCCLong: {
                            config.gccLong = true;
                            break;
                        }
                        case SizeAsLong: {
                            config.sizeAsLong = true;
                            break;
                        }
                        case ForceNames: {
                            config.forceNames = true;
                            break;
                        }
                        case NoRawBindings: {
                            config.genRawBindings = false;
                            break;
                        }
                        case PublicRawBindings: {
                            config.publicRawBindings = true;
                            break;
                        }
                        case Undefine: {
                            config.undefines.add(a.getStringParam(0));
                            break;
                        }
                        case NoAuto: {
                            config.autoConf = false;
                            break;
                        }
                        case Reification: {
                            config.reification = true;
                            break;
                        }
                        case NoCPP: {
                            config.noCPlusPlus = true;
                            break;
                        }
                        case ScalaOut: {
                            config.scalaOut = a.getFileParam(0);
                            break;
                        }
                        case OutputDir: {
                            config.outputDir = a.getFileParam(0);
                            break;
                        }
                        case LibraryNamingPrefixes: {
                            config.libraryNamingPrefixes = a.getStringParam(0).split(",");
                            break;
                        }
                        case PreferJavac: {
                            config.preferJavac = true;
                            break;
                        }
                        case BridgeSupportOutFile: {
                            config.bridgesupportOutFile = a.getFileParam(0);
                            break;
                        }
                        case ChoicesOut: {
                            config.choicesOutFile = a.getFileParam(0);
                            break;
                        }
                        case ChoicesIn: {
                            config.choicesInputFile = a.getFileParam(0);
                            break;
                        }
                        case PreprocessingOut: {
                            config.preprocessingOutFile = a.getFileParam(0);
                            break;
                        }
                        case ExtractionOut: {
                            config.extractedSymbolsOut = a.getFileParam(0);
                            break;
                        }
                        case Project: {
                            JNAeratorConfigUtils.readProjectConfig(a.getFileParam(0), a.getStringParam(1), config);
                            break;
                        }
                        case RootPackage: {
                            config.rootPackageName = a.getStringParam(0);
                            break;
                        }
                        case RemoveInlineAsm: {
                            config.removeInlineAsm = true;
                            break;
                        }
                        case StructsInLibrary: {
                            config.putTopStructsInSeparateFiles = false;
                            break;
                        }
                        case EmptyStructsAsForwardDecls: {
                            config.treatEmptyStructsAsForwardDecls = true;
                            break;
                        }
                        case ParseInOnePiece: {
                            config.parseInChunks = false;
                            break;
                        }
                        case Studio: {
                            try {
                                JNAeratorStudio.main(new String[0]);
                                return null;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                throw new ExitException(1);
                            }
                        }
                        case Verbose: {
                            config.verbose = true;
                            break;
                        }
                        case Framework: {
                            config.addFramework(a.getStringParam(0));
                            break;
                        }
                        case IncludeArgs: {
                            return this.parsedArgsInclude(a);
                        }
                        case Arch: {
                            this.arch = a.getEnumParam(0, NativePlatform.class);
                            this.libraryFileForCurrentArch = null;
                        }
                    }
                    return Collections.emptyList();
                }

                private void parsedActualFile(File file, boolean retainAsTarget) throws Exception {
                    String lib = this.currentLibrary;
                    String fn = file.getName();
                    String lfn = fn.toLowerCase();
                    if (!lfn.matches(".*?\\.(c|cpp|h|hpp|hxx|m)")) {
                        throw new CommandLineException("File '" + file + "' does not seem to be a C, C++ or Objective-C source file, nor a dynamic library, nor a *.jnaerator file.");
                    }
                    if (lib == null) {
                        String name = fn;
                        int i = name.indexOf(46);
                        if (i >= 0) {
                            name = name.substring(0, i).trim();
                        }
                        if (name.length() > 0) {
                            lib = name;
                        }
                        System.out.println("Warning: no -library option for file '" + fn + "', using \"" + lib + "\".");
                    }
                    config.addSourceFile(file, lib, !file.isFile(), retainAsTarget, true);
                }

                private List<String> parsedFile(JNAeratorCommandLineArgs.ArgsParser.ParsedArg a) throws Exception {
                    File file = a.getFileParam(0);
                    if (file != null) {
                        String fn = file.getName();
                        if (fn.startsWith("-") && !file.exists()) {
                            JNAeratorCommandLineArgs.displayHelp(false);
                            throw new CommandLineException("Invalid switch : " + file);
                        }
                        if (file.isFile() && fn.matches(".*\\.jnaerator")) {
                            return this.parsedArgsInclude(a);
                        }
                        this.parsedArgs.add(Pair.create((Object)((Object)JNAeratorCommandLineArgs.OptionDef.File), Arrays.asList(a.getFileParam(0).toString())));
                        if (file.isDirectory() && fn.matches(".*\\.framework")) {
                            config.addFramework(file.toString());
                        } else if (fn.matches(".*\\.bridgesupport")) {
                            config.bridgeSupportFiles.add(file);
                        } else if (file.isFile() && JNAerator.isLibraryFile(file)) {
                            if (this.arch == null) {
                                throw new CommandLineException("No arch defined for file " + file + " !\n" + "Please use the option " + JNAeratorCommandLineArgs.OptionDef.Arch.clSwitch + " *on each binary file* with one of " + StringUtils.implode(NativePlatform.getPossiblePlatformsOfLibraryFile(file.toString()), (Object)", "));
                            }
                            if (!this.arch.pattern.matcher(file.toString()).matches()) {
                                throw new CommandLineException("File file " + file + " doesn't look like a native library for arch " + (Object)((Object)this.arch) + " (expected file extension = '" + this.arch.extension + "') !");
                            }
                            if (config.verbose) {
                                System.out.println("Adding file '" + file + "' for arch '" + (Object)((Object)this.arch) + "'.");
                            }
                            config.addLibraryFile(file, this.arch);
                        } else {
                            String lib = this.currentLibrary;
                            if (file.isDirectory() && fn.endsWith(".xcode") || file.isFile() && fn.toLowerCase().endsWith(".sln")) {
                                JNAeratorConfigUtils.readProjectConfig(file, null, config);
                            } else {
                                this.parsedActualFile(file, true);
                            }
                        }
                    }
                    return Collections.emptyList();
                }

                private List<String> parsedArgsInclude(JNAeratorCommandLineArgs.ArgsParser.ParsedArg a) throws IOException {
                    final File argsFile = a.getFileParam(0);
                    String argsFileContent = ReadText.readText((File)argsFile);
                    Adapter<String[], String> argVariableReplacer = new Adapter<String[], String>(){

                        public String adapt(String[] value) {
                            String n = value[1];
                            String v = System.getProperty(n);
                            if (v == null) {
                                v = System.getenv(n);
                            }
                            if (v == null && n.equals("DIR")) {
                                v = argsFile.getAbsoluteFile().getParent();
                            }
                            return v;
                        }
                    };
                    argsFileContent = argsFileContent.replaceAll("http://", "http:\\\\");
                    argsFileContent = argsFileContent.replaceAll("(?m)//[^\n]*(\n|$)", "\n");
                    argsFileContent = argsFileContent.replaceAll("http:\\\\", "http://");
                    argsFileContent = argsFileContent.replaceAll("(?m)/\\*([^*]|\\*[^/])*\\*/", "");
                    argsFileContent = RegexUtils.regexReplace((Pattern)argVariablePattern, (String)argsFileContent, (Adapter)argVariableReplacer);
                    ArrayList<String> ret = new ArrayList<String>();
                    List tokens = RegexUtils.find((String)argsFileContent, (Pattern)argTokenPattern);
                    for (String[] tokenMatch : tokens) {
                        String token = tokenMatch[0];
                        if ((token = token.trim()).startsWith("\"") && token.endsWith("\"")) {
                            token = token.substring(1, token.length() - 1);
                        }
                        if (token.length() == 0 || token.matches("^(//|#).*")) continue;
                        boolean allowMissing = token.endsWith("?");
                        if (token.contains("*")) {
                            Collection rs = FileListUtils.resolveShellLikeFileList((String)(allowMissing ? token.substring(0, token.length() - 1) : token));
                            for (String r : rs) {
                                ret.add(allowMissing ? r + "?" : r);
                            }
                            if (!rs.isEmpty()) continue;
                        }
                        ret.add(token);
                    }
                    return ret;
                }

                @Override
                void finished() throws IOException {
                    if (config.outputMode == null) {
                        if (config.legacyNoCompile && config.legacyNoJar) {
                            config.outputMode = JNAeratorConfig.OutputMode.Directory;
                            System.err.println("WARNING: legacy options " + JNAeratorCommandLineArgs.OptionDef.NoJAR.clSwitch + " and " + JNAeratorCommandLineArgs.OptionDef.NoCompile.clSwitch + " used, defaulting " + JNAeratorCommandLineArgs.OptionDef.OutputMode.clSwitch + " to " + config.outputMode.name());
                        }
                        if (config.outputMode == null) {
                            throw new CommandLineException("Missing output mode parameter " + JNAeratorCommandLineArgs.OptionDef.OutputMode.clSwitch + " !");
                        }
                    }
                    config.parsedArgs = this.parsedArgs;
                    for (String framework : config.frameworks) {
                    }
                    config.addRootDir(new File("."));
                    for (String i : config.preprocessorConfig.explicitIncludes) {
                        try {
                            config.addRootDir(new File(i));
                        }
                        catch (Exception exception) {}
                    }
                    JNAerator.fixConfig(config);
                    if (config.verbose) {
                        if (config.rawParsedSourcesOutFile == null) {
                            config.rawParsedSourcesOutFile = new File("_jnaerator.rawParsed.cpp");
                        }
                        if (config.normalizedParsedSourcesOutFile == null) {
                            config.normalizedParsedSourcesOutFile = new File("_jnaerator.normalizedParsed.cpp");
                        }
                        if (config.macrosOutFile == null) {
                            config.macrosOutFile = new File("_jnaerator.macros.cpp");
                        }
                        if (config.choicesOutFile == null) {
                            config.choicesOutFile = new File("_jnaerator.choices");
                        }
                        if (config.preprocessingOutFile == null) {
                            config.preprocessingOutFile = new File("_jnaerator.preprocessed.c");
                        }
                        if (config.extractedSymbolsOut == null) {
                            config.extractedSymbolsOut = new File("_jnaerator.extractedSymbols.h");
                        }
                        if (config.bridgesupportOutFile == null) {
                            config.bridgesupportOutFile = new File("_jnaerator.bridgesupport.h");
                        }
                    }
                    if (this.simpleGUI) {
                        SimpleGUI gui = new SimpleGUI(config);
                        feedback[0] = gui;
                        gui.show();
                    } else {
                        feedback[0] = new Feedback(){

                            public void setStatus(String string) {
                                System.out.println(string);
                            }

                            public void setFinished(Throwable e) {
                                e.printStackTrace();
                                e.fillInStackTrace();
                                throw new ExitException(1, e);
                            }

                            public void setFinished(File toOpen) {
                                System.out.println("#");
                                System.out.println("# SUCCESS: JNAeration completed !");
                                System.out.println("# Output mode is '" + config.outputMode.name() + "(" + config.outputMode.getDescription() + ")");
                                System.out.println("#");
                                if (config.outputMode.isMaven()) {
                                    System.out.println("# To build the resulting Maven project, use commands like :");
                                    System.out.println("#\tcd " + toOpen.getAbsolutePath());
                                    System.out.println("#\tmvn install");
                                } else {
                                    System.out.println("# => '" + toOpen.getAbsolutePath() + "'");
                                }
                                System.out.println("#");
                                throw new ExitException(0);
                            }

                            public void sourcesParsed(SourceFiles sourceFiles) {
                            }

                            public void wrappersGenerated(Result result) {
                            }
                        };
                    }
                    jnaerator.jnaerate(feedback[0]);
                    if (!this.simpleGUI) {
                        throw new ExitException(0);
                    }
                }
            }.parse(args);
        }
        catch (ExitException e) {
            if (e.errorCode != 0) {
                JNAerator.finalError(e.getCause());
            }
        }
        catch (Exception e) {
            JNAerator.finalError(e);
        }
    }

    private static void finalError(Throwable e) {
        if (e != null) {
            e.printStackTrace();
        }
        System.err.println("#");
        System.err.println("# ERROR: JNAeration failed !");
        System.err.println("#");
        if (e != null) {
            if (e instanceof CommandLineException) {
                System.err.println("#\t" + e.getMessage().replaceAll("\n", "\n#\t"));
                System.err.println("#\tPlease use -h for help on the command-line options available.");
            } else {
                System.err.println("#\t" + e.toString().replaceAll("\n", "\n#\t"));
            }
            System.err.println("#");
        }
    }

    public PrintWriter getSourceWriter(ClassOutputter outputter, String path) throws IOException {
        if (outputter == null) {
            return this.newFileWriter(new File(this.config.sourcesOutputDir, path));
        }
        return outputter.getSourceWriter(path);
    }

    private static boolean isLibraryFile(File file) {
        String arg = file.getName().toLowerCase();
        return arg.endsWith(".dll") || arg.endsWith(".pdb") || arg.endsWith(".dylib") || arg.endsWith(".so") || arg.endsWith(".jnilib");
    }

    protected void autoConfigure() {
        JNAeratorConfigUtils.autoConfigure(this.config);
    }

    PrintWriter newFileWriter(File file) throws IOException {
        return this.newFileWriter(file, false);
    }

    PrintWriter newFileOverwriter(File file) throws IOException {
        return this.newFileWriter(file, true);
    }

    PrintWriter newFileWriter(File file, boolean overwrite) throws IOException {
        if (file.exists()) {
            if (this.config.forceOverwrite || overwrite) {
                System.out.println("Overwriting file '" + file + "'");
            } else {
                throw new IOException("File '" + file + "' already exists (use " + JNAeratorCommandLineArgs.OptionDef.ForceOverwrite.clSwitch + " to force overwrite).");
            }
        }
        file.getAbsoluteFile().getParentFile().mkdirs();
        return new PrintWriter(file){

            public void print(String s) {
                super.print(s.replace("\r", "").replace("\n", StringUtils.LINE_SEPARATOR));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void jnaerate(final Feedback feedback) {
        try {
            MemoryFileManager javaCompilerMemoryFileManager;
            if (this.config.autoConf) {
                feedback.setStatus("Auto-configuring parser...");
                this.autoConfigure();
            }
            JNAerator.fixConfig(this.config);
            this.config.preprocessorConfig.implicitMacros.keySet().removeAll(this.config.undefines);
            this.config.preprocessorConfig.explicitMacros.keySet().removeAll(this.config.undefines);
            if (this.config.verbose) {
                JNAeratorConfigUtils.logger.log(Level.INFO, "Include path : \n\t" + StringUtils.implode(this.config.preprocessorConfig.getAllIncludes(), (Object)"\n\t"));
            }
            DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector<JavaFileObject>();
            JavaCompiler javaCompiler = null;
            final ClassOutputter[] classOutputter = new ClassOutputter[1];
            if (this.config.outputMode == null) {
                javaCompilerMemoryFileManager = null;
                classOutputter[0] = new ClassOutputter(){

                    public PrintWriter getSourceWriter(String path) throws IOException {
                        return new PrintWriter(new StringWriter());
                    }
                };
            } else if (this.config.outputMode.isJar()) {
                javaCompiler = CompilerUtils.getJavaCompiler(this.config.preferJavac);
                javaCompilerMemoryFileManager = new MemoryFileManager(javaCompiler.getStandardFileManager(diagnostics, null, null));
                classOutputter[0] = new ClassOutputter(){

                    public PrintWriter getSourceWriter(String path) throws IOException {
                        if (!path.startsWith("file:")) {
                            path = "file:///" + path;
                        }
                        if (path.endsWith(".java")) {
                            MemoryJavaFile c = new MemoryJavaFile(path, null, JavaFileObject.Kind.SOURCE);
                            javaCompilerMemoryFileManager.inputs.put(c.getPath().toString(), c);
                            return new PrintWriter(c.openWriter());
                        }
                        MemoryFileObject c = new MemoryFileObject(path, (String)null);
                        javaCompilerMemoryFileManager.outputs.put(c.getPath().toString(), c);
                        return new PrintWriter(c.openWriter());
                    }
                };
            } else {
                javaCompilerMemoryFileManager = null;
                if (this.config.outputMode.isDirectory()) {
                    if (this.config.outputMode.isMaven()) {
                        String pom = this.config.runtime.generateMavenProjectModel(this.config.mavenGroupId, this.config.mavenArtifactId, this.config.mavenVersion);
                        PrintWriter pomOut = this.newFileWriter(new File(this.config.outputDir, POM_FILENAME));
                        pomOut.println(pom);
                        pomOut.close();
                    }
                    classOutputter[0] = new ClassOutputter(){

                        public PrintWriter getSourceWriter(String path) throws IOException {
                            File file = new File(JNAerator.this.config.sourcesOutputDir, path);
                            File parent = file.getParentFile();
                            if (!parent.exists()) {
                                parent.mkdirs();
                            }
                            feedback.setStatus("Generating " + file.getName());
                            return JNAerator.this.newFileWriter(file);
                        }
                    };
                }
            }
            Result result = this.createResult(new ClassOutputter(){

                public PrintWriter getSourceWriter(String path) throws IOException {
                    PrintWriter out = JNAerator.this.getSourceWriter(classOutputter[0], path);
                    if (path.endsWith(".java")) {
                        return JNAerator.createUnicodeEscapeWriter(out);
                    }
                    return out;
                }
            }, feedback);
            if (this.config.outputMode != null) {
                if (this.config.outputMode == JNAeratorConfig.OutputMode.AutoGeneratedMaven) {
                    void var10_16;
                    String[] paths;
                    String[] stringArray = paths = new String[]{"src/main/java", "src/main/resources", "src/test/java", "src/test/resources"};
                    int n = stringArray.length;
                    boolean bl = false;
                    while (var10_16 < n) {
                        String path = stringArray[var10_16];
                        new File(this.config.outputDir, path).mkdirs();
                        ++var10_16;
                    }
                    if (this.config.parsedArgs != null) {
                        ArrayList<String> lines = new ArrayList<String>();
                        lines.add("// Generated by JNAerator (http://code.google.com/p/jnaerator/)");
                        block10: for (Pair<JNAeratorCommandLineArgs.OptionDef, List<String>> pair : this.config.parsedArgs) {
                            JNAeratorCommandLineArgs.OptionDef opt = (JNAeratorCommandLineArgs.OptionDef)((Object)pair.getKey());
                            List switches = (List)pair.getValue();
                            switch (opt) {
                                case ForceOverwrite: 
                                case OutputMode: 
                                case OutputDir: {
                                    continue block10;
                                }
                            }
                            lines.add(StringUtils.implode((Iterable)switches, (Object)" "));
                        }
                        PrintWriter out = this.newFileWriter(new File(this.config.outputDir, "src/main/jnaerator/config.jnaerator"));
                        out.println(StringUtils.implode(lines, (Object)"\n"));
                        out.close();
                    }
                } else if (this.config.outputMode.generatesSources()) {
                    SourceFiles sourceFiles = this.parseSources(feedback, result.typeConverter);
                    if (this.config.extractLibSymbols) {
                        this.parseLibSymbols(sourceFiles, result);
                    }
                    feedback.sourcesParsed(sourceFiles);
                    ScalaGenerator sgen = null;
                    if (this.config.scalaOut != null) {
                        sgen = new ScalaGenerator(result);
                    }
                    this.jnaerationCore(sourceFiles, result);
                    if (sgen != null) {
                        sgen.jnaerationCompleted();
                    }
                    feedback.wrappersGenerated(result);
                    if (javaCompiler != null) {
                        for (Map.Entry<String, String> entry : this.config.extraJavaSourceFilesContents.entrySet()) {
                            javaCompilerMemoryFileManager.addSourceInput(entry.getKey(), entry.getValue());
                        }
                        feedback.setStatus("Compiling JNAerated files...");
                        CompilerUtils.compile(javaCompiler, javaCompilerMemoryFileManager, diagnostics, "1.5", this.config.cacheDir, this.config.runtime.libraryClass, JNAerator.class, NSClass.class, Rococoa.class, Mangling.class, BridJ.class);
                        CompilerUtils.CompilationError.throwErrors(diagnostics.getDiagnostics(), javaCompilerMemoryFileManager.inputs, javaCompiler.getClass().getName());
                        if (this.config.outputMode == JNAeratorConfig.OutputMode.StandaloneJar) {
                            feedback.setStatus("Copying runtime classes...");
                            this.addRuntimeClasses(result, javaCompilerMemoryFileManager);
                        }
                    }
                    if (this.config.outputMode.isJar()) {
                        feedback.setStatus("Generating " + this.config.outputJar.getName());
                        javaCompilerMemoryFileManager.writeJar(this.config.outputJar, this.config.bundleSources, this.getResourceFiles());
                    } else if (this.config.outputMode.isDirectory()) {
                        for (Map.Entry<String, Object> entry : this.getResourceFiles().entrySet()) {
                            File inFile = (File)entry.getValue();
                            File outFile = new File(this.config.resourcesOutputDir, entry.getKey());
                            outFile.getAbsoluteFile().getParentFile().mkdirs();
                            FileInputStream in = new FileInputStream(inFile);
                            FileOutputStream out = new FileOutputStream(outFile);
                            try {
                                IOUtils.readWrite((InputStream)in, (OutputStream)out);
                            }
                            finally {
                                in.close();
                                out.close();
                            }
                        }
                    }
                }
            }
            feedback.setFinished(this.config.outputJar != null ? this.config.outputJar : this.config.outputDir);
        }
        catch (ExitException ex) {
            throw ex;
        }
        catch (Throwable th) {
            feedback.setFinished(th);
        }
    }

    static PrintWriter createUnicodeEscapeWriter(PrintWriter out) {
        return new PrintWriter(out){
            StringBuilder bout = new StringBuilder();

            public void print(String s) {
                JNAerator.escapeUnicode(s, this.bout);
                super.print(this.bout.toString());
            }
        };
    }

    public void parseLibSymbols(SourceFiles sourceFiles, Result result) throws FileNotFoundException, IOException {
        PrintWriter fileOut = null;
        if (this.config.extractedSymbolsOut != null) {
            if (this.config.verbose) {
                System.out.println("Writing symbols extracted from libraries to '" + this.config.extractedSymbolsOut + "'");
            }
            fileOut = this.newFileOverwriter(this.config.extractedSymbolsOut);
        }
        if (fileOut != null) {
            fileOut.close();
        }
    }

    private Map<String, File> getResourceFiles() {
        LinkedHashMap<String, File> additionalFiles = new LinkedHashMap<String, File>();
        if (this.config.bundleLibraries) {
            for (Map.Entry<NativePlatform, List<File>> e : this.config.libraryFilesByArch.entrySet()) {
                NativePlatform arch = e.getKey();
                for (File libraryFile : e.getValue()) {
                    additionalFiles.put("lib/" + arch.name() + "/" + libraryFile.getName(), libraryFile);
                }
            }
        }
        return additionalFiles;
    }

    protected static Map<String, URL> getRuntimeFiles(JNAeratorConfig.Runtime runtime, boolean needsObjCRuntime) throws IOException {
        ClassLoader classLoader = JNAerator.class.getClassLoader();
        LinkedHashMap<String, URL> ret = new LinkedHashMap<String, URL>();
        String listingFile = runtime.runtimeFilesListFileName;
        if (listingFile == null) {
            return ret;
        }
        ArrayList files = new ArrayList();
        for (String s : listingFile.split(",")) {
            files.addAll(ReadText.readLines((InputStream)classLoader.getResourceAsStream(s.trim())));
        }
        if (files == null) {
            throw new FileNotFoundException("Warning: Could not find JNAerator listing file '" + listingFile + "' : JNAerated files will need JNAerator in the path to execute.");
        }
        for (String file : files) {
            if (file.startsWith("Archive: ") || file.startsWith("META-INF/") || !needsObjCRuntime && file.contains("rococoa")) continue;
            URL url = classLoader.getResource(file);
            if (url == null) {
                if (file.matches("com/sun/jna/[^/]+/(lib\\w+\\.(jnilib|so)|\\w+\\.dll)")) {
                    System.out.println("JNA library missing : " + file);
                    continue;
                }
                if (file.matches("com/ochafik/lang/jnaerator/runtime/scala/.*\\.part")) {
                    System.out.println("Scala code missing : " + file);
                    continue;
                }
                if (file.toLowerCase().contains("android")) continue;
                throw new FileNotFoundException(file);
            }
            ret.put(file, url);
        }
        return ret;
    }

    protected void addRuntimeClasses(Result result, MemoryFileManager mfm) throws IOException {
        Map<String, URL> files = JNAerator.getRuntimeFiles(result.config.runtime, result.hasObjectiveC());
        boolean needsObjCRuntime = result.hasObjectiveC();
        for (Map.Entry<String, URL> e : files.entrySet()) {
            String file = e.getKey();
            URL url = e.getValue();
            file = "file:///" + file;
            if (mfm.outputs.containsKey(file)) continue;
            mfm.outputs.put(file, new URLFileObject(url));
        }
    }

    public static File getDir(String name) {
        File dir = new File(JNAerator.getDir(), name);
        dir.mkdirs();
        return dir;
    }

    public static File getDir() {
        File dir = new File(System.getProperty("user.home"));
        dir = new File(dir, ".jnaerator");
        dir = new File(dir, "temp");
        dir.mkdirs();
        return dir;
    }

    static boolean isHexDigit(char c) {
        return c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f' || Character.isDigit(c);
    }

    static void escapeUnicode(String s, StringBuilder bout) {
        if (s == null) {
            return;
        }
        bout.setLength(0);
        for (char c : s.toCharArray()) {
            char v = c;
            if (v > '\u007f') {
                bout.append("\\u");
                String h = Integer.toHexString(v);
                int i = 4 - h.length();
                while (i-- != 0) {
                    bout.append('0');
                }
                bout.append(h);
                continue;
            }
            bout.append(c);
        }
    }

    public SourceFiles parseSources(Feedback feedback, TypeConversion typeConverter) throws IOException, LexerException {
        feedback.setStatus("Parsing native headers...");
        return this.createJNAeratorParser().parse(this.config, typeConverter, null);
    }

    protected JNAeratorParser createJNAeratorParser() {
        return new JNAeratorParser();
    }

    public void addFile(File file, List<File> out) throws IOException {
        if (file.isFile()) {
            out.add(file);
        } else {
            File[] fs = file.listFiles();
            if (fs != null) {
                for (File f : fs) {
                    this.addFile(f, out);
                }
            }
        }
    }

    public Result createResult(ClassOutputter outputter, Feedback feedback) {
        return new Result(this.config, outputter, feedback);
    }

    public static ObjCppParser newParser(String s) throws IOException {
        Result result = new Result(new JNAeratorConfig(), null, null);
        ObjCppParser parser = new ObjCppParser((TokenStream)new CommonTokenStream((TokenSource)new ObjCppLexer((CharStream)new ANTLRReaderStream((Reader)new StringReader(s)))));
        parser.objCParserHelper = result.typeConverter;
        return parser;
    }

    protected void readChoices(Result result) throws IOException, RecognitionException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(result.config.choicesInputFile));
        ArrayList<Function> functions = null;
        int iLine = 0;
        while ((line = in.readLine()) != null) {
            ++iLine;
            if ((line = line.trim()).startsWith("//")) continue;
            if (line.length() == 0) {
                functions = null;
            }
            Function function = null;
            function = functions == null ? JNAerator.newParser(line).javaMethodDeclaration() : JNAerator.newParser((String)line).functionDeclaration().function;
            if (function == null) {
                System.err.println("Error: failed to parse function at line " + iLine + ": '" + line + "'");
                continue;
            }
            if (functions == null) {
                functions = new ArrayList<Function>();
                result.declarationsConverter.functionAlternativesByNativeSignature.put(function.computeSignature(Function.SignatureType.JavaStyle), (Pair<Function, List<Function>>)new Pair((Object)function, functions));
                continue;
            }
            functions.add(function);
        }
        System.err.println("Read " + result.declarationsConverter.functionAlternativesByNativeSignature.size() + " custom declarations from " + result.config.choicesInputFile);
    }

    public void jnaerationCore(SourceFiles sourceFiles, Result result) throws IOException, LexerException, RecognitionException {
        Object list;
        result.feedback.setStatus("Normalizing parsed code...");
        if (result.config.choicesInputFile != null) {
            this.readChoices(result);
        }
        if (this.config.rawParsedSourcesOutFile != null) {
            if (this.config.verbose) {
                System.out.println("Writing raw parsed sources to '" + this.config.rawParsedSourcesOutFile + "'");
            }
            WriteText.writeText((String)sourceFiles.toString(), (File)this.config.rawParsedSourcesOutFile);
        }
        sourceFiles.accept((Visitor)new ObjectiveCToJavaPreScanner(result));
        sourceFiles.accept((Visitor)new CToJavaPreScanner());
        sourceFiles.accept((Visitor)new MissingNamesChooser(result, this.config.runtime.renameFunctionSignatures()));
        sourceFiles.accept((Visitor)new Scanner(){

            protected void visitTypeRef(TypeRef tr) {
                List<Modifier> stoMods;
                super.visitTypeRef(tr);
                Element parent = tr.getParentElement();
                if (parent instanceof TypeRef && (stoMods = this.getStoMods(tr.getModifiers())) != null) {
                    ArrayList newMods = new ArrayList(tr.getModifiers());
                    newMods.removeAll(stoMods);
                    tr.setModifiers(newMods);
                    ((ModifiableElement)parent).addModifiers(stoMods);
                }
            }

            public List<Modifier> getStoMods(List<Modifier> mods) {
                ArrayList<Modifier> ret = null;
                for (Modifier mod : mods) {
                    if (!mod.isA(ModifierKind.StorageClassSpecifier)) continue;
                    if (ret == null) {
                        ret = new ArrayList<Modifier>();
                    }
                    ret.add(mod);
                }
                return ret;
            }
        });
        sourceFiles.accept((Visitor)new JavaDocCreator(result));
        if (this.config.normalizedParsedSourcesOutFile != null) {
            if (this.config.verbose) {
                System.out.println("Writing normalized parsed sources to '" + this.config.normalizedParsedSourcesOutFile + "'");
            }
            WriteText.writeText((String)sourceFiles.toString(), (File)this.config.normalizedParsedSourcesOutFile);
        }
        if (!result.config.bridgeSupportFiles.isEmpty()) {
            if (result.feedback != null) {
                result.feedback.setStatus("Parsing BridgeSupport files...");
            }
            new BridgeSupportParser(result, sourceFiles).parseBridgeSupportFiles();
        }
        sourceFiles.accept((Visitor)result);
        result.rehabilitateWeakTypeDefs();
        result.chooseLibraryClasses(this.config.packageName, this.config.rootPackageName);
        if (!result.classes.isEmpty() && result.objectiveCGenerator != null) {
            result.feedback.setStatus("Generating Objective-C classes...");
            result.objectiveCGenerator.generateObjectiveCClasses();
        }
        result.feedback.setStatus("Generating libraries...");
        if (result.libraries.size() == 1 && (list = result.definesByLibrary.get(null)) != null) {
            String lib = result.libraries.iterator().next();
            Result.getList(result.definesByLibrary, lib).addAll(list);
        }
        result.symbols = Symbols.resolveSymbols(sourceFiles);
        this.generateLibraryFiles(sourceFiles, result);
        if (this.config.verbose) {
            for (String unknownType : result.typeConverter.unknownTypes) {
                System.out.println("Unknown Type: " + unknownType);
            }
        }
        if (result.config.choicesOutFile != null) {
            PrintWriter out = this.newFileOverwriter(result.config.choicesOutFile);
            for (Map.Entry<String, Pair<Function, List<Function>>> e : result.declarationsConverter.functionAlternativesByNativeSignature.entrySet()) {
                Function f = (Function)e.getValue().getKey();
                String ff = f.getElementFile();
                if (ff != null) {
                    out.println("// " + ff + (f.getElementLine() > 0 ? ":" + f.getElementLine() : ""));
                }
                out.println(f);
                for (Function alt : (List)e.getValue().getValue()) {
                    out.println(alt);
                }
                out.println();
            }
            out.close();
        }
    }

    protected void generateLibraryFiles(SourceFiles sourceFiles, Result result) throws IOException {
        result.declarationsConverter.generateLibraryFiles(sourceFiles, result, this.config);
    }

    private boolean checkNoCycles(SourceFiles sourceFiles) {
        final LinkedHashMap ids = new LinkedHashMap(new Arg().getId());
        sourceFiles.accept((Visitor)new Scanner(){

            protected void visitElement(Element d) {
                if (d != null && ids.put(d.getId(), new RuntimeException().fillInStackTrace()) != null) {
                    Throwable previous = (Throwable)ids.get(d.getId());
                    throw new RuntimeException("Cycle : " + d, previous);
                }
                super.visitElement(d);
            }
        });
        return true;
    }

    class JNALibraryMapping
    extends LibraryMapping {
        JNALibraryMapping() {
        }
    }

    class LibraryMapping {
        public Struct interf;

        LibraryMapping() {
        }
    }

    static class ExitException
    extends RuntimeException {
        int errorCode;

        public ExitException(int errorCode) {
            this(errorCode, null);
        }

        public ExitException(int errorCode, Throwable cause) {
            super(cause);
            this.errorCode = errorCode;
        }
    }

    static class CommandLineException
    extends RuntimeException {
        public CommandLineException(String msg) {
            this(msg, null);
        }

        public CommandLineException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    public static interface Feedback {
        public void setStatus(String var1);

        public void setFinished(File var1);

        public void setFinished(Throwable var1);

        public void sourcesParsed(SourceFiles var1);

        public void wrappersGenerated(Result var1);
    }
}

