/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.ochafik.lang.jnaerator.JNAerator;
import com.ochafik.lang.jnaerator.JNAeratorConfig;
import com.ochafik.lang.jnaerator.NativePlatform;
import com.ochafik.util.listenable.Pair;
import com.ochafik.util.string.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JNAeratorCommandLineArgs {
    static void displayHelp(boolean wikiFormat) {
        ArrayList<OptionDef> opts = new ArrayList<OptionDef>(Arrays.asList(OptionDef.values()));
        Collections.sort(opts, new Comparator<OptionDef>(){

            @Override
            public int compare(OptionDef o1, OptionDef o2) {
                if (o1.clSwitch == null) {
                    return o2.clSwitch == null ? 0 : -1;
                }
                if (o2.clSwitch == null) {
                    return 1;
                }
                return o1.clSwitch.compareTo(o2.clSwitch);
            }
        });
        if (wikiFormat) {
            for (OptionDef opt : opts) {
                if (opt.examples.length > 0) {
                    for (String string : opt.examples) {
                        System.out.println(" * *" + string + "*");
                    }
                } else {
                    System.out.print(" * *" + opt.switchName() + "*");
                    for (OptionDef.ArgDef argDef : opt.args) {
                        System.out.print(" ");
                        System.out.print(argDef.name);
                    }
                    System.out.println();
                }
                System.out.println("  " + opt.description().replaceAll("\\*", "`*`").replaceAll("\n", "\n  "));
                for (OptionDef.ArgDef argDef : opt.args) {
                    String desc = argDef.type == OptionDef.Type.Enum ? StringUtils.implode((Object[])argDef.additionalClass.getEnumConstants(), (Object)" | ") : argDef.type.toString();
                    System.out.println("  _" + argDef.name + "_: " + desc);
                }
            }
        } else {
            System.out.println("Credits:   JNAerator is Copyright (c) 2008-2009 Olivier Chafik");
            System.out.println("           Includes Anarres JCPP (Apache 2.0 license), Copyright (c) 2007-2008, Shevek");
            System.out.println("           Includes Java Native Access (JNA) (LGPL license), Copyright (c) 2006-2009 Todd Fast, Timothy Wall, Wayne Meissner and others");
            System.out.println("           Includes Rococoa (LGPL license), Copyright (c) Copyright Duncan McGregor and others");
            System.out.println("           Includes ANTLR's runtime (BSD license), Copyright (c) 2003-2008, Terence Parr");
            System.out.println("           Licensing & Copyright details : http://code.google.com/p/jnaerator/wiki/CreditsAndLicense");
            for (OptionDef opt : opts) {
                if (opt.examples.length > 0) {
                    for (String string : opt.examples) {
                        System.out.println("\t" + string);
                    }
                } else {
                    System.out.print("\t" + opt.switchName());
                    for (OptionDef.ArgDef argDef : opt.args) {
                        System.out.print(" ");
                        System.out.print(argDef.name);
                    }
                    System.out.println();
                }
                System.out.println("\t\t" + opt.description());
                for (OptionDef.ArgDef argDef : opt.args) {
                    String desc = argDef.type == OptionDef.Type.Enum ? StringUtils.implode((Object[])argDef.additionalClass.getEnumConstants(), (Object)" | ") : argDef.type.toString();
                    System.out.println("\t\t" + argDef.name + ": " + desc);
                }
                System.out.println();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OptionDef {
        OutputMode("-mode", "Choose the output mode of JNAerator", new ArgDef(Type.Enum, "mode", JNAeratorConfig.OutputMode.class)),
        IncludeArgs("@(.+)?", OptionDef.strs("@path", "@ path"), "Read command-line arguments from a file. File may contain multiple lines (those beginning with \"//\" will be skipped), file wildcards will be resolved within the file content, as well as variables substitutions : $(someEnvOrJavaVarName), with $(DIR) being the parent directory of the current arguments file.", new ArgDef(Type.ExistingFile, "argumentsFile.jnaerator")),
        OutputDir("-o", "Output directory for all artifacts", new ArgDef(Type.OutputDir, "outDir")),
        ExtractSymbols("-scanSymbols", "Extract, unmangle and parse the symbols all listed shared libraries", new ArgDef[0]),
        AddIncludePath("-I(.+)?", OptionDef.strs("-Ipath", "-I path"), "Add a directory to the include path or include a file. See doc of JNAERATOR_INCLUDE_PATH", new ArgDef(Type.File, "path")),
        AddFrameworksPath("-F(.+)?", OptionDef.strs("-Fpath", "-F path"), "Add a directory to the frameworks path. See doc of JNAERATOR_FRAMEWORKS_PATH", new ArgDef(Type.File, "path")),
        FrameworksPath("-frameworksPath", "See doc of JNAERATOR_FRAMEWORKS_PATH", new ArgDef(Type.String, "path1:path2...")),
        Framework("-framework", "JNAerate a framework using its headers and its *.bridgesupport files if available", new ArgDef(Type.String, "frameworkName")),
        LimitComments("-limitComments", "Avoid useless comments (source file + line, skipped items...)", new ArgDef[0]),
        NoComments("-noComments", "Don't output any member comment.", new ArgDef[0]),
        NoMangling("-noMangling", "Don't output any C++ name mangling information (may cause C++-decorated symbols not to be found at execution time).", new ArgDef[0]),
        AddRootDir("-addRootDir", "Remove this directory from the path of descendant source files in the generated documentation.", new ArgDef(Type.ExistingDir, "path")),
        NoCPP("-nocpp", "Do not define the __cplusplus symbol", new ArgDef[0]),
        Reification("-reification", "Automatically create OO shortcuts for functions that look like methods (typedPtr.someFunc() for someFunc(typedPtr))", new ArgDef[0]),
        Undefine("-U(.+)", OptionDef.strs("-Uname", "-U name"), "Undefine a preprocessor symbol after the autoconfiguration phase.", new ArgDef(Type.String, "name")),
        GUI("-gui", "Show minimalist progression GUI", new ArgDef[0]),
        Synchronized("-synchronized", "Generate synchronized native methods", new ArgDef[0]),
        NoRawBindings("-noRawBindings", "Don't generate raw bindings amenable for assembler optimizations.", new ArgDef[0]),
        Dependencies("-dependencies", "Comma-separated list of dependencies for the current library (BridJ only).", new ArgDef(Type.CommaList, "methodName")),
        PublicRawBindings("-publicRawBindings", "Make raw bindings public.", new ArgDef[0]),
        BeanStructs("-beanStructs", "Generate getters and setters for struct fields (JNA & JNAerator runtimes only)", new ArgDef[0]),
        BeautifyNames("-beautifyNames", "Transform C names to Java-looking names : some_func() => someFunc()", new ArgDef[0]),
        ConvertBodies("-convertBodies", "Experimental conversion of function bodies to equivalent Java code (BridJ only).", new ArgDef[0]),
        JarOut("-jar", "Jar file where all generated sources and the compiled classes go", new ArgDef(Type.OutputFile, "outFile")),
        LibraryOverrides("-libraryOverrides", "Comma-separated list of `symbol=library` library overrides (when isolated functions are located in a different library than their surrounding code).", new ArgDef(Type.Map, "list")),
        ScalaStructSetters("-scalaStructSetters", "Generate Scala-style setters for BridJ structs (with a name like fieldName_$eq)", new ArgDef[0]),
        WCharAsShort("-wcharAsShort", "Force treatment of wchar_t as short (char by default)", new ArgDef[0]),
        CallbackInvokeName("-callbacksInvokeMethodName", "Name of the invocation method of callbacks ('apply' by default)", new ArgDef(Type.String, "methodName")),
        LibraryNamingPrefixes("-libraryNamingPrefixes", "Define prefixes commonly used in the library so that reification of functions is optimal (See -reification)", new ArgDef(Type.String, "commaSeparatedPrefixes")),
        Studio("-studio", "Launch JNAeratorStudio", new ArgDef[0]),
        ForceNames("-forceNames", "Force @Name annotations on all supported entities (structs, classes, enums, methods) to allow refactoring of resulting sources (BridJ-only).", new ArgDef[0]),
        NoStaticInit("-noStaticInit", "Don't generate static init block with BridJ.register() call (BridJ-specific)", new ArgDef[0]),
        ExtractDeclarations("-extractDeclarations", "Extract current library's declarations to an interface with the provided simple name (will be in same package as library implementation class); BridJ-specific", new ArgDef(Type.String, "interfaceSimpleClassName")),
        ScalaOut("-scalaOut", "[Experimental] Output Scala wrappers (callbacks implicits...)", new ArgDef(Type.OutputDir, "outDir")),
        NoStringReturns("-noStringReturns", "Prevent const char* and const wchar_t* return types from being converted to String and WString.", new ArgDef[0]),
        ForceStringSignatures("-forceStringSignatures", "Force String and String[] signatures for char* and char** params (JNA runtime only).", new ArgDef[0]),
        Project("-project", "Read Visual Studio 2008 project or solution file and use the configuration specified (e.g. \"Release|Win32\").", new ArgDef(Type.ExistingFile, "solutionFile"), new ArgDef(Type.String, "\"Config|Platform\"")),
        NoAuto("-noAuto", "No auto-configuration of preprocessor symbols and paths", new ArgDef[0]),
        COM("-com", "Generate Microsoft COM (C++) bindings.", new ArgDef[0]),
        GCCLong("-gccLong", "Use GCC convention for size of 'long' (4 bytes on 32 bits platforms, 8 bytes on 64 bits platforms).", new ArgDef[0]),
        SizeAsLong("-sizeAsLong", "Treat size_t and ptrdiff_t values as 'long' values. ONLY HERE FOR COMPATIBILITY WITH PREVIOUS VERSIONS, WILL EVENTUALLY BE REMOVED.", new ArgDef[0]),
        Direct("-direct", "JNAerate libraries that use JNA's faster direct call convention", new ArgDef[0]),
        PreferJavac("-preferJavac", "Use Sun's Javac compiler instead of Eclipse's ecj, if possible", new ArgDef[0]),
        StructsInLibrary("-structsInLibrary", "Force structs to be JNAerated as inner classes of their declaring libraries (otherwise, each top-level structure is defined as a top-level class in its library's package)", new ArgDef[0]),
        ParseInOnePiece("-parseInOnePiece", "Doesn't split the pre-processor output into multiple smaller parts and parse everything as it should (in theory everything should be parsed in one chunk, but in practice this means errors are not isolated from the rest of the parsing)", new ArgDef[0]),
        OnlineDocURLFormat("-onlineDoc", "Define a format for online documentation URLs (uses MessageFormat syntax, with arg 0 being the name of the function / structure).", new ArgDef(Type.MessageFormat, "linkDisplayFormat"), new ArgDef(Type.MessageFormat, "urlMessageFormat")),
        CurrentPackage("-package", "Set the Java package in which all the output will reside (by default, set to the library name).", new ArgDef(Type.String, "forcedPackageName")),
        RecursedExtensions("-allowedFileExts", "Colon-separated list of file extensions used to restrict files used when recursing on directories, or \"*\" to parse all files (by default = h:hpp:hxx)", new ArgDef(Type.String, "extensions")),
        SkipIncludedFrameworks("-skipIncludedFrameworks", "Skip Included Frameworks", new ArgDef[0]),
        SkipLibInstance("-skipLibraryInstance", "Skip library instance declarations", new ArgDef[0]),
        DontCastConstants("-dontCastConstants", "Don't cast generated constants", new ArgDef[0]),
        Runtime("-runtime", "Choose target runtime library between " + StringUtils.implode((Object[])JNAeratorConfig.Runtime.values(), (Object)", ") + " (default: " + (Object)((Object)JNAeratorConfig.Runtime.DEFAULT) + ").", new ArgDef(Type.Enum, "enum", JNAeratorConfig.Runtime.class)),
        IfRegexMatch("-ifRegexMatch", "Conditional evaluation of an argument if a java system property matches a regular expression", new ArgDef(Type.String, "javaProperty"), new ArgDef(Type.String, "regex"), new ArgDef(Type.String, "thenArg"), new ArgDef(Type.String, "elseArg")),
        DefineMacro("-D([^=]*)(?:=(.*))?", OptionDef.strs("-Dname=value", "-D name value", "-Dname=", "-DmacroName(x, y, z)=macroBody"), "Define a macro symbol", new ArgDef(Type.String, "name"), new ArgDef(Type.String, "value")),
        DefineImplicitMacro("-M([^=]*)(?:=(.*))?", OptionDef.strs("-Mname=value", "-M name value", "-Mname="), "Define an implicit macro symbol, as if it were added by the system (won't count as an explicit macro when generating GYP files and other build artifacts)", new ArgDef(Type.String, "name"), new ArgDef(Type.String, "value")),
        DefineType("-T([^=]*)(?:=(.*))?", OptionDef.strs("-Tname=value", "-T name value", "-Tname="), "Define a type symbol", new ArgDef(Type.String, "name"), new ArgDef(Type.String, "value")),
        NoAutoImports("-noAutoImport", "Don't add import statements automatically to output java source files", new ArgDef[0]),
        RootPackage("-root(?:Package)?", OptionDef.strs("-root", "-rootPackage"), "Define the root package for all output classes", new ArgDef(Type.String, "package")),
        CurrentLibrary("-library", "Define the name of the output library. This is a state parameter, it will affect all files listed after it, until another -library switch is provided. It does not affect sources included from a project file (Visual Studio...).\nC functions exported in library \"test\" will end up in class \"TestLibrary\", for instance. \nThe name of the library is the one fed to JNA to find the shared library, so library \"test\" must be in \"test.dll\" on Windows, \"libtest.dylib\" on Mac OS X and  \"libtest.so\" on other Unices.\nNote that a special hack is done for library \"c\" on Windows systems : the output name is set to \"msvcrt\" instead of \"c\".\n", new ArgDef(Type.String, "libName")),
        DefaultLibrary("-defaultLibrary", "Name of output library for elements declared in files not covered by a ${CurrentLibrary} switch", new ArgDef(Type.String, "libName")),
        SkipDeprecated("-skipDeprecated", "Don't generate members that would be tagged as @Deprecated", new ArgDef[0]),
        Help("-?-h(?:elp)?", OptionDef.strs("-h", "-help"), "Show command line arguments help", new ArgDef[0]),
        EntryName("-entryClass", "Generate a class _entryclassName.EntryClassName_ that will contain all of the jnaerated libraries instances. User code will just need to static import or derive from this class to access to the instances (has no effect for BridJ runtime).", new ArgDef(Type.String, "entryClassName")),
        Verbose("-v(?:erbose)?", OptionDef.strs("-v", "-verbose"), "Verbose output (both console and files)", new ArgDef[0]),
        ChoicesOut("-choicesOut", "Write the function alternative choices made (automatically set when ${Verbose} is used).", new ArgDef(Type.OutputFile, "outFile")),
        ChoicesIn("-choices", "Read the function alternative choices from a file in the format used by -choicesOut.", new ArgDef(Type.ExistingFile, "choicesFile")),
        PreprocessingOut("-preprocessingOut", "Write the preprocessor output in a file (automatically set when ${Verbose} is used).", new ArgDef(Type.OutputFile, "outFile")),
        EmptyStructsAsForwardDecls("-emptyStructsAsForwardDecls", "Treat empty structs as forward declarations", new ArgDef[0]),
        OptionalFunctions("-optionalFunctions", "Mark functions which name matches the provided regular expression pattern with the @Optional annotation (BridJ-only)", new ArgDef(Type.String, "namePattern")),
        SkipEnums("-skipEnums", "Skip enumerations which name matches the provided regular expression pattern", new ArgDef(Type.String, "namePattern")),
        SkipStructs("-skipStructs", "Skip structs and classes which name matches the provided regular expression pattern", new ArgDef(Type.String, "namePattern")),
        SkipFunctions("-skipFunctions", "Skip functions which name matches the provided regular expression pattern", new ArgDef(Type.String, "namePattern")),
        ExtractionOut("-extractionOut", "Write the symbols extracted from libraries in a file (automatically set when ${Verbose} is used).", new ArgDef(Type.OutputFile, "outFile")),
        BridgeSupportOutFile("-bridgeSupportOut", "Write the definitions extracted from bridgesupport files in a file (automatically set when ${Verbose} is used).", new ArgDef(Type.OutputFile, "outFile")),
        WikiDoc("-wikiHelp", "Output a wiki-friendly help", new ArgDef[0]),
        Arch("-arch", "Define the current architecture for libraries (state variable)", new ArgDef(Type.Enum, "archName", NativePlatform.class)),
        MacrosOut("-macrosOut", "Write the preprocessor macros in a file (automatically set when ${Verbose} is used).", new ArgDef(Type.OutputFile, "outFile")),
        NoPrimitiveArrays("-noPrimitiveArrays", "Never output primitive arrays for function arguments (use NIO buffers instead)", new ArgDef[0]),
        File(null, "Any header (or directory containing headers at any level of hierarchy), shared library, *.bridgesupport file or *.jnaerator file", new ArgDef(Type.OptionalFile, "file", PathType.SourcePath)),
        NoPreprocessing("-fpreprocessed", "Consider source files as being already preprocessed (preprocessor won't be run)", new ArgDef[0]),
        NoCompile("(?i)-noComp", "Do not compile JNAerated headers", new ArgDef[0]),
        NoJAR("(?i)-noJar", "Do not create an output JAR", new ArgDef[0]),
        NoLibBundle("(?i)-noLibBundle", "Do not bundle libraries in output JAR", new ArgDef[0]),
        LibFile("-libFile", "Bundle the provided file with the JNAerated JAR so that it is extracted with the library when it is first used.", new ArgDef(Type.ExistingFile, "resourceFile")),
        RemoveInlineAsm("-removeInlineAsm", "Remove inline asm from preprocessed source, useful when its unsupported syntax makes parsing to fail.", new ArgDef[0]),
        ForceOverwrite("-f", "Force the overwrite of existing files", new ArgDef[0]),
        MavenVersion("-mavenVersion", "Set version of the generated Maven project", new ArgDef(Type.String, "version")),
        MavenArtifactId("-mavenArtifactId", "Set artifact id of the generated Maven project", new ArgDef(Type.String, "artifactId")),
        MavenGroupId("-mavenGroupId", "Set group id of the generated Maven project", new ArgDef(Type.String, "groupId")),
        MaxConstructedFields("-maxConstrFields", "Maximum number of fields allowed for structure fields constructors. If a struct has more fields, it will only get a default constructor.", new ArgDef(Type.Int, "fieldCount")),
        GenPrivateMembers("-genPrivateMembers", "Generate wrappers for private fields and methods (will be protected and deprecated).", new ArgDef[0]),
        CPlusPlusGen("-genCPlusPlus", "[Experimental, Not working at all] Generate C++ classes.", new ArgDef[0]);

        public final ArgDef[] args;
        public final Pattern switchPattern;
        public final String clSwitch;
        private final String description;
        public final String[] examples;

        static String[] strs(String ... strs) {
            return strs;
        }

        private OptionDef(String clSwitch, String description, ArgDef ... args) {
            this(clSwitch, OptionDef.strs(new String[0]), description, args);
        }

        private OptionDef(String clSwitch, String[] examples, String description, ArgDef ... args) {
            this.clSwitch = clSwitch;
            this.description = description;
            this.args = args;
            this.examples = examples;
            this.switchPattern = clSwitch == null ? null : Pattern.compile(clSwitch);
            for (int i = 0; i < args.length; ++i) {
                args[i].position = i;
            }
        }

        String switchName() {
            return this.clSwitch == null ? "" : this.clSwitch.replace("(?i)", "");
        }

        public String toString() {
            return super.toString() + ": " + this.description();
        }

        public String format(Object ... fargs) {
            if (fargs.length != this.args.length) {
                throw new JNAerator.CommandLineException("Expected " + this.args.length + " args to format " + this.name() + ", got " + fargs.length);
            }
            StringBuilder b = new StringBuilder();
            b.append(this.clSwitch);
            int n = fargs.length;
            for (int i = 0; i < n; ++i) {
                ArgDef arg = this.args[i];
                Object farg = fargs[i];
                String f = arg.format(farg);
                if (f == null) continue;
                b.append(' ');
                b.append(arg.format(farg));
            }
            return b.toString();
        }

        public String description() {
            return this.isDeprecated() ? "(deprecated) " + this.description : this.description;
        }

        private boolean isDeprecated() {
            try {
                return OptionDef.class.getField(this.name()).isAnnotationPresent(Deprecated.class);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        public ArgDef getParam(String name) {
            for (ArgDef ad : this.args) {
                if (!ad.name.equals(name)) continue;
                return ad;
            }
            throw new NoSuchElementException("Argument parameter '" + name + "' in option " + (Object)((Object)this));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ArgDef {
            public final Type type;
            public final String name;
            public int position;
            public final Class<?> additionalClass;
            public final PathType pathType;

            public ArgDef(Type type, String name, Class<?> additionalClass, PathType pathType) {
                this.type = type;
                this.name = name;
                this.additionalClass = additionalClass;
                this.pathType = pathType;
            }

            public ArgDef(Type type, String name) {
                this(type, name, null, null);
            }

            public ArgDef(Type type, String name, Class<?> additionalClass) {
                this(type, name, additionalClass, null);
            }

            public ArgDef(Type type, String name, PathType pathType) {
                this(type, name, null, pathType);
            }

            public String normalize(String arg) {
                switch (this.type) {
                    case ExistingDir: 
                    case ExistingFile: 
                    case ExistingFileOrDir: 
                    case File: 
                    case OutputDir: 
                    case OutputFile: 
                    case OptionalFile: {
                        if (arg == null) break;
                        return new File(arg).getAbsolutePath();
                    }
                }
                return arg;
            }

            public String format(Object arg) {
                switch (this.type) {
                    case Enum: {
                        return ((Enum)this.additionalClass.cast(arg)).name();
                    }
                    case ExistingDir: 
                    case ExistingFile: 
                    case ExistingFileOrDir: 
                    case File: 
                    case OutputDir: 
                    case OutputFile: {
                        return ((File)arg).toString();
                    }
                    case OptionalFile: {
                        return arg == null ? null : ((File)arg).toString();
                    }
                    case String: {
                        return (String)arg;
                    }
                    case CommaList: {
                        return Joiner.on((String)",").join((Iterable)((List)arg));
                    }
                    case Map: {
                        return ((Map)arg).toString();
                    }
                    case Int: {
                        return ((Integer)arg).toString();
                    }
                }
                throw new UnsupportedOperationException("unknown type " + (Object)((Object)this.type));
            }

            File findFile(String arg, ArgsParser parser) {
                List<File> path;
                File f = new File(arg);
                if (!f.exists() && (path = parser.getPath(this.pathType)) != null) {
                    for (File dir : path) {
                        File ff = new File(dir, arg);
                        if (!ff.exists()) continue;
                        return ff;
                    }
                }
                return f;
            }

            Object convertArg(String arg, ArgsParser parser) throws FileNotFoundException {
                switch (this.type) {
                    case OptionalFile: {
                        boolean opt = arg.endsWith("?");
                        String fileName = opt ? arg.substring(0, arg.length() - 1) : arg;
                        File f = this.findFile(fileName, parser);
                        if (!f.exists()) {
                            if (opt) {
                                return null;
                            }
                            throw new FileNotFoundException(f.toString());
                        }
                        return f;
                    }
                    case CommaList: {
                        return Splitter.on((String)",").splitToList((CharSequence)arg);
                    }
                    case Map: {
                        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                        for (String pair : arg.split(",")) {
                            int i = pair.indexOf("=");
                            map.put(pair.substring(0, i), pair.substring(i + 1));
                        }
                        return map;
                    }
                    case File: {
                        return this.findFile(arg, parser);
                    }
                    case Int: {
                        return Integer.parseInt(arg);
                    }
                    case MessageFormat: {
                        return new MessageFormat(arg);
                    }
                    case String: {
                        return arg;
                    }
                    case ExistingDir: {
                        File f = this.findFile(arg, parser);
                        if (!f.isDirectory()) {
                            throw new FileNotFoundException(f.toString());
                        }
                        return f;
                    }
                    case ExistingFile: {
                        File f = this.findFile(arg, parser);
                        if (!f.isFile()) {
                            throw new FileNotFoundException(f.toString());
                        }
                        return f;
                    }
                    case ExistingFileOrDir: {
                        File f = this.findFile(arg, parser);
                        if (!f.exists()) {
                            throw new FileNotFoundException(f.toString());
                        }
                        return f;
                    }
                    case Enum: {
                        try {
                            return Enum.valueOf(this.additionalClass, arg);
                        }
                        catch (Throwable th) {
                            throw new JNAerator.CommandLineException("Argument '" + arg + "' is not one of the expected values :\n\t" + StringUtils.implode((Object[])this.additionalClass.getEnumConstants(), (Object)",\n\t"));
                        }
                    }
                    case OutputDir: {
                        File f = this.findFile(arg, parser);
                        if (f.isFile()) {
                            throw new FileNotFoundException("Expected directory, found file : " + f.toString());
                        }
                        f.getAbsoluteFile().getParentFile().mkdirs();
                        return f;
                    }
                    case OutputFile: {
                        File f = this.findFile(arg, parser);
                        if (f.isDirectory()) {
                            throw new FileNotFoundException("Expected file, found directory : " + f.toString());
                        }
                        f.getAbsoluteFile().getParentFile().mkdirs();
                        return f;
                    }
                }
                throw new UnsupportedOperationException();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            ExistingFile,
            ExistingDir,
            File,
            MessageFormat,
            String,
            Int,
            ExistingFileOrDir,
            OutputDir,
            OutputFile,
            OptionalFile,
            CommaList,
            Map,
            Enum;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PathType {
        SourcePath,
        LibraryPath;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ArgsParser {
        Map<PathType, List<File>> paths = new LinkedHashMap<PathType, List<File>>();
        List<Pair<OptionDef, List<String>>> parsedArgs = new ArrayList<Pair<OptionDef, List<String>>>();

        public List<File> getPath(PathType type) {
            if (type == null) {
                return null;
            }
            List<File> path = this.paths.get((Object)type);
            if (path == null) {
                path = new ArrayList<File>();
                this.paths.put(type, path);
            }
            return path;
        }

        public void parse(List<String> args) throws Exception {
            try {
                for (int i = 0; i < args.size(); ++i) {
                    String arg = args.get(i);
                    OptionDef defaultOpt = null;
                    for (OptionDef opt : OptionDef.values()) {
                        boolean matches;
                        Matcher m;
                        if (opt.switchPattern == null) {
                            defaultOpt = opt;
                            continue;
                        }
                        try {
                            m = opt.switchPattern.matcher(arg);
                            matches = m.matches();
                        }
                        catch (Throwable ex) {
                            throw new JNAerator.CommandLineException("Error while matching arg " + arg + " with option " + (Object)((Object)opt) + " (pattern = " + opt.switchPattern + ") : " + ex, ex);
                        }
                        if (!matches) continue;
                        if (opt.isDeprecated()) {
                            System.err.println("WARNING: option " + opt.clSwitch + " is deprecated and might be removed in future versions.");
                        }
                        ParsedArg pa = new ParsedArg();
                        pa.def = opt;
                        pa.params = new Object[opt.args.length];
                        int iArg = 0;
                        for (int iGroup = 0; iGroup < m.groupCount(); ++iGroup) {
                            String gp = m.group(iGroup + 1);
                            if (gp == null) continue;
                            pa.params[iArg] = opt.args[iArg].convertArg(gp, this);
                            ++iArg;
                        }
                        ArrayList<String> parsedArg = new ArrayList<String>();
                        parsedArg.add(arg);
                        while (iArg < opt.args.length) {
                            String param = null;
                            if (i < args.size() - 1) {
                                param = args.get(++i);
                            }
                            OptionDef.ArgDef argDef = opt.args[iArg];
                            pa.params[iArg] = argDef.convertArg(param, this);
                            parsedArg.add(argDef.normalize(param));
                            ++iArg;
                        }
                        this.parsedArgs.add((Pair<OptionDef, List<String>>)Pair.create((Object)((Object)opt), parsedArg));
                        List<String> parsed = this.parsed(pa);
                        if (parsed == null) {
                            return;
                        }
                        args.addAll(i + 1, parsed);
                        defaultOpt = null;
                        break;
                    }
                    if (defaultOpt == null) continue;
                    ParsedArg pa = new ParsedArg();
                    pa.def = defaultOpt;
                    OptionDef.ArgDef argDef = defaultOpt.args[0];
                    arg = argDef.normalize(arg);
                    pa.params = new Object[]{argDef.convertArg(arg, this)};
                    args.addAll(i + 1, this.parsed(pa));
                }
            }
            catch (JNAerator.ExitException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                JNAeratorCommandLineArgs.displayHelp(false);
                throw new JNAerator.CommandLineException("Error parsing arguments :\n" + StringUtils.implode(args, (Object)" ") + " : " + ex, ex);
            }
            this.finished();
        }

        abstract List<String> parsed(ParsedArg var1) throws Exception;

        abstract void finished() throws IOException;

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ParsedArg {
            public OptionDef def;
            public Object[] params;

            public File getFileParam(String name) {
                return (File)this.params[this.def.getParam((String)name).position];
            }

            public String getStringParam(String name) {
                return (String)this.params[this.def.getParam((String)name).position];
            }

            public int getIntParam(String name) {
                return (Integer)this.params[this.def.getParam((String)name).position];
            }

            public File getFileParam(int pos) {
                return (File)this.params[pos];
            }

            public String getStringParam(int pos) {
                return (String)this.params[pos];
            }

            public Map<String, String> getMapParam(int pos) {
                return (Map)this.params[pos];
            }

            public MessageFormat getMessageFormatParam(int pos) {
                return (MessageFormat)this.params[pos];
            }

            public int getIntParam(int pos) {
                return (Integer)this.params[pos];
            }

            public <E extends Enum<E>> E getEnumParam(int pos, Class<E> ec) {
                return (E)((Enum)ec.cast(this.params[pos]));
            }

            List<String> getList(int pos) {
                return (List)this.params[pos];
            }
        }
    }
}

