/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.io.ReadText;
import com.ochafik.lang.jnaerator.BridJDeclarationsConverter;
import com.ochafik.lang.jnaerator.BridJGlobalsGenerator;
import com.ochafik.lang.jnaerator.BridJTypeConversion;
import com.ochafik.lang.jnaerator.DeclarationsConverter;
import com.ochafik.lang.jnaerator.GlobalsGenerator;
import com.ochafik.lang.jnaerator.JNADeclarationsConverter;
import com.ochafik.lang.jnaerator.JNAGlobalsGenerator;
import com.ochafik.lang.jnaerator.JNATypeConversion;
import com.ochafik.lang.jnaerator.JNAerator;
import com.ochafik.lang.jnaerator.JNAeratorCommandLineArgs;
import com.ochafik.lang.jnaerator.JNAeratorConfigUtils;
import com.ochafik.lang.jnaerator.NativePlatform;
import com.ochafik.lang.jnaerator.NodeJSDeclarationsConverter;
import com.ochafik.lang.jnaerator.NodeJSGlobalsGenerator;
import com.ochafik.lang.jnaerator.NodeJSTypeConversion;
import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.TypeConversion;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.runtime.Structure;
import com.ochafik.lang.jnaerator.runtime.Union;
import com.ochafik.util.CompoundCollection;
import com.ochafik.util.listenable.Adapter;
import com.ochafik.util.listenable.Filter;
import com.ochafik.util.listenable.Pair;
import com.sun.jna.Callback;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.bridj.Pointer;
import org.bridj.ann.Array;
import org.bridj.ann.Bits;
import org.bridj.cpp.com.IID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNAeratorConfig {
    public static final String DEFAULT_HEADER_EXTENSIONS = "h:hpp:hxx";
    public static final String DEFAULT_IMPLEMS_EXTENSIONS = "cpp:c:cxx:m:mm";
    public final EnumSet<GenFeatures> features = EnumSet.allOf(GenFeatures.class);
    public Runtime runtime = Runtime.DEFAULT;
    public long fullParsingTimeout = 5000L;
    public long sliceParsingTimeout = 1000L;
    public final PreprocessorConfig preprocessorConfig = new PreprocessorConfig();
    public boolean followIncludes;
    boolean microsoftCOM;
    public File preprocessingOutFile;
    public File macrosOutFile;
    public File choicesOutFile;
    public File choicesInputFile;
    public boolean useJNADirectCalls;
    public boolean limitComments;
    public boolean noComments;
    public boolean putTopStructsInSeparateFiles = true;
    public boolean skipDeprecated;
    public boolean genRawBindings = true;
    public boolean publicRawBindings;
    public boolean beautifyNames;
    public boolean forceNames;
    public boolean treatEmptyStructsAsForwardDecls;
    public String[] libraryNamingPrefixes;
    public boolean extractLibSymbols;
    public final List<Pattern> optionalFunctions = new ArrayList<Pattern>();
    public final List<Pattern> skippedStructNames = new ArrayList<Pattern>();
    public final List<Pattern> skippedFunctionNames = new ArrayList<Pattern>();
    public final List<Pattern> skippedEnumNames = new ArrayList<Pattern>();
    public List<Pair<MessageFormat, MessageFormat>> onlineDocumentationURLFormats = new ArrayList<Pair<MessageFormat, MessageFormat>>();
    public String entryName;
    public boolean noStaticInit;
    public int maxConstructedFields = 10;
    public boolean beanStructs;
    public boolean reification;
    public boolean convertBodies;
    public boolean removeInlineAsm;
    public Map<String, List<String>> dependencies = new LinkedHashMap<String, List<String>>();
    public Map<String, String> libraryOverrides = new LinkedHashMap<String, String>();
    public Map<String, String> extraJavaSourceFilesContents = new LinkedHashMap<String, String>();
    public Set<String> frameworks = new LinkedHashSet<String>();
    boolean skipIncludedFrameworks;
    public FileFilter fileFilter = new JNAeratorConfigUtils.FileExtensionFilter("h:hpp:hxx".split("[:;]"));
    public Map<NativePlatform, List<File>> libraryFilesByArch = new LinkedHashMap<NativePlatform, List<File>>();
    public List<File> libraryFiles = new ArrayList<File>();
    public Map<String, List<File>> sourceFilesByLibrary = new LinkedHashMap<String, List<File>>();
    public final Map<File, String> libraryByDirectory = new LinkedHashMap<File, String>();
    public Map<File, String> libraryByFile = new LinkedHashMap<File, String>();
    public boolean verbose;
    boolean parseInChunks = true;
    public File outputDir;
    public File sourcesOutputDir;
    public File resourcesOutputDir;
    public List<String> rootDirectoriesPrefixesForSourceComments = new ArrayList<String>();
    public Adapter<Function, Boolean> functionsAccepter;
    public String packageName = null;
    public String rootPackageName = null;
    public String defaultLibrary;
    public Map<String, File> libraryProjectSources = new LinkedHashMap<String, File>();
    public Map<String, String> extractedLibraries = new LinkedHashMap<String, String>();
    public Adapter<File, String> fileToLibrary = new Adapter<File, String>(){

        public String adapt(File file) {
            String libraryName = null;
            try {
                file = file.getCanonicalFile();
                libraryName = JNAeratorConfig.this.libraryByFile.get(file);
                if (libraryName == null) {
                    libraryName = JNAeratorConfig.this.libraryByDirectory.get(file.getParentFile());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return libraryName == null ? JNAeratorConfig.this.defaultLibrary : libraryName;
        }
    };
    public Filter<Element> symbolsAccepter = new Filter<Element>(){

        public boolean accept(Element value) {
            String s = Element.getFileOfAscendency((Element)value);
            if (s == null) {
                return false;
            }
            File f = new File(s);
            try {
                f = f.getCanonicalFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return JNAeratorConfig.this.libraryByFile.containsKey(f);
        }
    };
    public String libraryForElementsInNullFile;
    public String cPlusPlusNameSpaceSeparator = "_";
    public boolean preferJavac;
    public Set<File> bridgeSupportFiles = new LinkedHashSet<File>();
    public File outputJar;
    public File cacheDir;
    public boolean autoConf = true;
    public boolean forceOverwrite;
    public Set<String> undefines = new HashSet<String>();
    public boolean gccLong;
    public boolean sizeAsLong;
    public OutputMode outputMode;
    @Deprecated
    public boolean legacyNoJar;
    @Deprecated
    public boolean legacyNoCompile;
    public boolean noAutoImports;
    public boolean bundleSources = true;
    public boolean noCPlusPlus;
    public String mavenGroupId = "com.mycompany";
    public String mavenArtifactId = "my-native-bindings";
    public String mavenVersion = "1.0-SNAPSHOT";
    Set<File> sourceFiles = new LinkedHashSet<File>();
    public boolean bundleLibraries = true;
    public boolean wcharAsShort;
    public boolean charPtrAsString;
    public boolean genCPlusPlus;
    public File extractedSymbolsOut;
    public boolean stringifyConstCStringReturnValues = true;
    public File bridgesupportOutFile;
    public boolean scalaStructSetters;
    public boolean noPrimitiveArrays;
    public boolean synchronizedMethods;
    public File scalaOut;
    public boolean skipPrivateMembers = true;
    public boolean castConstants = true;
    public File rawParsedSourcesOutFile;
    public File normalizedParsedSourcesOutFile;
    public List<Pair<JNAeratorCommandLineArgs.OptionDef, List<String>>> parsedArgs;
    public boolean skipLibraryInstanceDeclarations;
    public String callbackInvokeMethodName = "apply";

    public void addFramework(String framework) throws IOException {
        File file = JNAeratorConfigUtils.getFrameworkDirectory(framework, this.preprocessorConfig.frameworksPath);
        this.frameworks.add(framework);
        File headers = new File(file, "Headers");
        if (headers.exists()) {
            this.preprocessorConfig.implicitIncludes.add(headers.getAbsolutePath());
            File mainHeader = new File(headers, framework + ".h");
            if (mainHeader.exists()) {
                this.addSourceFile(mainHeader, framework, true, true, false);
            } else {
                this.addSourceFile(headers, framework, true, true, false);
            }
        } else {
            new IOException("No Headers subdirectory in framework '" + framework + "' found here : " + file).printStackTrace();
        }
        File naturalDir = new File(file, "Resources/BridgeSupport");
        File f = new File(naturalDir, framework + ".bridgesupport");
        if (!f.exists()) {
            f = new File(naturalDir, framework + "Full.bridgesupport");
        }
        if (f.exists()) {
            this.bridgeSupportFiles.add(f);
        }
    }

    public void addLibraryFile(File file, NativePlatform arch) {
        String fn;
        int i;
        List<File> others = this.libraryFilesByArch.get((Object)arch);
        if (others == null) {
            others = new ArrayList<File>();
            this.libraryFilesByArch.put(arch, others);
        }
        if ((i = (fn = file.getName()).lastIndexOf(46)) > 0) {
            fn = fn.substring(0, i);
        }
        others.add(file);
        this.libraryByFile.put(file, fn);
        this.libraryFiles.add(file);
    }

    public void addSourceFile(File file, String library, boolean applyFilters, boolean retainAsTarget, boolean indexSourceFilesByLibrary) throws IOException {
        block7: {
            block6: {
                if (!file.isFile()) break block6;
                if (this.fileFilter != null && applyFilters && !this.fileFilter.accept(file)) break block7;
                file = file.getCanonicalFile();
                if (library == null && this.fileToLibrary != null) {
                    library = (String)this.fileToLibrary.adapt((Object)file);
                }
                this.sourceFiles.add(file);
                if (retainAsTarget) {
                    this.libraryByFile.put(file, library);
                    File directory = file.getParentFile().getAbsoluteFile();
                    String oldLib = this.libraryByDirectory.put(directory, library);
                    if (oldLib != null && !oldLib.equals(library)) {
                        JNAerator.logger.log(Level.WARNING, "Directory " + directory + " contains files from different libraries, so there won't be any default library for its files (symbols defined in files from that library that were included but not explicitly listed will not be JNAerated).");
                        this.libraryByDirectory.put(directory, "");
                    }
                }
                if (library == null || !indexSourceFilesByLibrary) break block7;
                List<File> files = this.sourceFilesByLibrary.get(library);
                if (files == null) {
                    files = new ArrayList<File>();
                    this.sourceFilesByLibrary.put(library, files);
                }
                files.add(file);
                break block7;
            }
            File[] fs = file.listFiles();
            if (fs != null) {
                for (File f : fs) {
                    this.addSourceFile(f, library, true, retainAsTarget, indexSourceFilesByLibrary);
                }
            }
        }
    }

    public void addRootDir(File dir) throws IOException {
        if (!dir.exists()) {
            return;
        }
        String str = dir.getCanonicalPath();
        if (!str.endsWith(File.separator)) {
            str = str + File.separator;
        }
        if (!this.rootDirectoriesPrefixesForSourceComments.contains(str)) {
            this.rootDirectoriesPrefixesForSourceComments.add(str);
        }
    }

    public Set<String> getLibraries() {
        HashSet<String> ret = new HashSet<String>();
        for (Map.Entry<File, String> e : this.libraryByFile.entrySet()) {
            if (e.getValue() == null) continue;
            ret.add(e.getValue());
        }
        return ret;
    }

    public String getLibrary(String elementFile, Identifier elementName) {
        String libraryOverride;
        if (elementName != null && (libraryOverride = this.libraryOverrides.get(elementName.toString())) != null) {
            return libraryOverride;
        }
        if (elementFile == null) {
            return this.libraryForElementsInNullFile;
        }
        return this.fileToLibrary == null ? this.defaultLibrary : (String)this.fileToLibrary.adapt((Object)new File(elementFile));
    }

    public Collection<File> getFiles() {
        return this.sourceFiles;
    }

    public String relativizeFileForSourceComments(String path) {
        if (path == null) {
            return null;
        }
        for (String pref : this.rootDirectoriesPrefixesForSourceComments) {
            if (!path.startsWith(pref)) continue;
            path = path.substring(pref.length());
            break;
        }
        return path;
    }

    public Collection<File> getInputFiles() {
        return new CompoundCollection(new Collection[]{this.sourceFiles, this.bridgeSupportFiles, this.libraryFiles});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PreprocessorConfig {
        public boolean WORKAROUND_PP_BUGS = true;
        public final List<String> explicitIncludes = new ArrayList<String>();
        public final List<String> implicitIncludes = new ArrayList<String>();
        public final Map<String, String> implicitMacros = new LinkedHashMap<String, String>();
        public final Map<String, String> explicitMacros = new LinkedHashMap<String, String>();
        public final Map<String, String> forcedTypeDefs = new LinkedHashMap<String, String>();
        public final List<String> frameworksPath = new ArrayList<String>();
        public List<String> includeStrings = new ArrayList<String>();
        public boolean preprocess = true;

        public List<String> getAllIncludes() {
            ArrayList<String> list = new ArrayList<String>(this.explicitIncludes);
            list.addAll(this.implicitIncludes);
            return Collections.unmodifiableList(list);
        }

        public Map<String, String> getAllMacros() {
            LinkedHashMap<String, String> macros = new LinkedHashMap<String, String>();
            macros.putAll(this.implicitMacros);
            macros.putAll(this.explicitMacros);
            return macros;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OutputMode {
        Jar("JAR with bindings only"),
        StandaloneJar("JAR with bindings and runtime dependencies"),
        Directory("Bindings sources in simple file hierarchy"),
        Maven("Bindings sources in Maven project ready to build"),
        AutoGeneratedMaven("Maven project that automatically regenerates its bindings");

        private final String desc;

        private OutputMode(String desc) {
            this.desc = desc;
        }

        public String getDescription() {
            return this.desc;
        }

        public String toString() {
            return "'" + this.name() + "' : " + this.desc;
        }

        boolean isJar() {
            return this == Jar || this == StandaloneJar;
        }

        boolean isDirectory() {
            return this == Directory || this.isMaven();
        }

        boolean isMaven() {
            return this == Maven || this == AutoGeneratedMaven;
        }

        boolean generatesSources() {
            return this != AutoGeneratedMaven;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GenFeatures {
        Compile,
        FileComments,
        UsageComments,
        EnumTypeLocationComments,
        LibrariesAutoExtraction,
        CPlusPlusMangling,
        StructConstructors,
        TypedPointersForForwardDeclarations,
        OriginalFunctionSignatures,
        FunctionArgsJavaDoc;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Runtime {
        JNA(false, true, false, (Class)Callback.class, (Class)com.sun.jna.Pointer.class, (Class)Memory.class, (Class)com.sun.jna.Structure.class, (Class)com.sun.jna.Union.class, null, null, (Class)Library.class, null, "jna-runtime.jar.files"){

            public DeclarationsConverter createDeclarationsConverter(Result result) {
                return new JNADeclarationsConverter(result);
            }

            public GlobalsGenerator createGlobalsGenerator(Result result) {
                return new JNAGlobalsGenerator(result);
            }

            public TypeConversion createTypeConversion(Result result) {
                return new JNATypeConversion(result);
            }
        }
        ,
        JNAerator(false, true, false, (Class)Callback.class, (Class)com.sun.jna.Pointer.class, (Class)Memory.class, (Class)Structure.class, (Class)Union.class, null, null, (Class)Library.class, null, "jnaerator-runtime.jar.files"){

            public DeclarationsConverter createDeclarationsConverter(Result result) {
                return new JNADeclarationsConverter(result);
            }

            public GlobalsGenerator createGlobalsGenerator(Result result) {
                return new JNAGlobalsGenerator(result);
            }

            public TypeConversion createTypeConversion(Result result) {
                return new JNATypeConversion(result);
            }

            public String toString() {
                return "JNAerator (based on JNA)";
            }
        }
        ,
        BridJ(true, false, true, (Class)org.bridj.Callback.class, (Class)Pointer.class, null, null, null, null, (Class)Pointer.class, null, Bits.class, "bridj.jar.files"){

            public DeclarationsConverter createDeclarationsConverter(Result result) {
                return new BridJDeclarationsConverter(result);
            }

            public GlobalsGenerator createGlobalsGenerator(Result result) {
                return new BridJGlobalsGenerator(result);
            }

            public TypeConversion createTypeConversion(Result result) {
                return new BridJTypeConversion(result);
            }

            public String toString() {
                return "BridJ (faster runtime that supports C++)";
            }
        }
        ,
        NodeJS(false, true, false, null, null, null, null, null, null, null, null, null, null){

            public DeclarationsConverter createDeclarationsConverter(Result result) {
                return new NodeJSDeclarationsConverter(result);
            }

            public GlobalsGenerator createGlobalsGenerator(Result result) {
                return new NodeJSGlobalsGenerator(result);
            }

            public TypeConversion createTypeConversion(Result result) {
                return new NodeJSTypeConversion(result);
            }

            public String toString() {
                return "NodeJS (experimental native library bindings for node.js)";
            }

            public String generateMavenProjectModel(String groupId, String artifactId, String version) throws IOException {
                return "TODO";
            }

            public boolean renameFunctionSignatures() {
                return false;
            }
        };

        public static final Runtime DEFAULT;
        public final String runtimeFilesListFileName;
        private String annotationPackage;
        public final Class callbackClass;
        public final Class pointerClass;
        public final Class memoryClass;
        public final Class structClass;
        public final Class unionClass;
        public final Class structIOClass;
        public final Class arrayClass;
        public final Class libraryClass;
        public final boolean hasFastStructs;
        public final boolean hasJNA;
        public final boolean hasBitFields;

        public boolean renameFunctionSignatures() {
            return true;
        }

        private Runtime(boolean hasFastStructs, boolean hasJNA, boolean hasBitFields, Class<?> callbackClass, Class<?> pointerClass, Class<?> memoryClass, Class<?> structClass, Class<?> unionClass, Class<?> structIOClass, Class<?> arrayClass, Class<?> libraryClass, Class<? extends Annotation> someAnnotationClass, String runtimeFilesListFileName) {
            this.hasFastStructs = hasFastStructs;
            this.hasBitFields = hasBitFields;
            this.hasJNA = hasJNA;
            this.callbackClass = callbackClass;
            this.pointerClass = pointerClass;
            this.memoryClass = memoryClass;
            this.structClass = structClass;
            this.libraryClass = libraryClass;
            this.unionClass = unionClass;
            this.structIOClass = structIOClass;
            this.arrayClass = arrayClass;
            this.runtimeFilesListFileName = runtimeFilesListFileName;
            this.annotationPackage = someAnnotationClass == null ? null : someAnnotationClass.getPackage().getName();
        }

        public abstract DeclarationsConverter createDeclarationsConverter(Result var1);

        public abstract GlobalsGenerator createGlobalsGenerator(Result var1);

        public abstract TypeConversion createTypeConversion(Result var1);

        public TypeRef.SimpleTypeRef typeRef(Ann ann) {
            if (this.annotationPackage == null) {
                return null;
            }
            String n = ann.toString();
            if (this == BridJ) {
                if (ann == Ann.Length) {
                    n = Array.class.getSimpleName();
                } else if (ann == Ann.IID) {
                    return ElementsHelper.typeRef((Identifier)ElementsHelper.ident(IID.class, (Expression[])new Expression[0]));
                }
            }
            ArrayList<String> elts = new ArrayList<String>();
            elts.addAll(Arrays.asList(this.annotationPackage.split("\\.")));
            elts.add(n);
            return this.annotationPackage == null ? null : ElementsHelper.typeRef((Identifier)ElementsHelper.ident((String[])elts.toArray(new String[elts.size()])));
        }

        public String generateMavenProjectModel(String groupId, String artifactId, String version) throws IOException {
            String res = "com/ochafik/lang/jnaerator/" + this.name() + "-pom.xml";
            String pom = ReadText.readText((URL)((Object)((Object)this)).getClass().getClassLoader().getResource(res));
            if (pom == null) {
                throw new FileNotFoundException(res);
            }
            pom = pom.replaceAll("%groupId%", groupId).replaceAll("%artifactId%", artifactId).replaceAll("%version%", version);
            return pom;
        }

        static {
            DEFAULT = BridJ;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Ann {
            Bits,
            FastCall,
            StdCall,
            ObjCBlock,
            This,
            ThisCall,
            Length,
            ByValue,
            Field,
            Symbol,
            Name,
            Union,
            Virtual,
            Constructor,
            IID;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Platform {
        Windows,
        Linux,
        MacOSX;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Architecture {
        x86_64,
        i386,
        PowerPC;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Compiler {
        GCC4,
        MSVC9;

    }
}

