/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.io.WriteText;
import com.ochafik.lang.jnaerator.JNAeratorConfig;
import com.ochafik.lang.jnaerator.PreprocessorUtils;
import com.ochafik.lang.jnaerator.SourceFiles;
import com.ochafik.lang.jnaerator.TypeConversion;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.ObjCppLexer;
import com.ochafik.lang.jnaerator.parser.ObjCppParser;
import com.ochafik.lang.jnaerator.parser.Scanner;
import com.ochafik.lang.jnaerator.parser.SourceFile;
import com.ochafik.lang.jnaerator.parser.StoredDeclarations;
import com.ochafik.lang.jnaerator.parser.Visitor;
import com.ochafik.util.string.RegexUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.anarres.cpp.LexerException;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNAeratorParser {
    private static final boolean EASILY_DEBUGGABLE_BUT_FRAGILE_PARSING_MODE = false;
    static final Pattern asmPattern = Pattern.compile("(?s)__asm\\s*\\{.*?\\}");

    protected List<Slice> cutSourceContentInSlices(String sourceContent, PrintStream originalOut) {
        StringBuffer currentEmptyLines = new StringBuffer();
        StringBuffer currentBuffer = new StringBuffer();
        boolean sliceGotContent = false;
        String[] lines = sourceContent.split("\n");
        int iLine = 0;
        int nLines = lines.length;
        int lastStart = 0;
        String lastFile = null;
        Pattern fileInLinePattern = Pattern.compile("\"([^\"]+)\"");
        ArrayList<Slice> slices = new ArrayList<Slice>(nLines / 10);
        for (String line : lines) {
            if (line.startsWith("#line")) {
                lastStart = iLine;
                lastFile = RegexUtils.findFirst((String)line, (Pattern)fileInLinePattern, (int)1);
                if (sliceGotContent) {
                    String content = currentBuffer.toString();
                    slices.add(new Slice(lastFile, lastStart, content));
                }
                currentBuffer.setLength(0);
                sliceGotContent = false;
            }
            if (!sliceGotContent) {
                sliceGotContent = line.trim().length() > 0;
            }
            currentBuffer.append(line);
            currentBuffer.append('\n');
            currentEmptyLines.append('\n');
            ++iLine;
        }
        if (sliceGotContent) {
            String content = currentBuffer.toString();
            slices.add(new Slice(lastFile, lastStart, content));
        }
        return slices;
    }

    protected Callable<SourceFile> createParsingCallable(final JNAeratorConfig config, final TypeConversion typeConverter, final String source, final Set<String> topLevelTypeDefs, boolean isFull) {
        return new Callable<SourceFile>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SourceFile call() throws Exception {
                PrintStream originalOut = System.out;
                PrintStream originalErr = System.err;
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                PrintStream pout = new PrintStream(bout);
                System.setOut(pout);
                System.setErr(pout);
                RuntimeException error = null;
                try {
                    SourceFile sourceFile;
                    ObjCppParser parser = JNAeratorParser.this.newObjCppParser(typeConverter, source, config.verbose, pout);
                    if (topLevelTypeDefs != null) {
                        parser.topLevelTypeIdentifiers = topLevelTypeDefs;
                    }
                    if ((sourceFile = parser.sourceFile()) == null) {
                        throw new RuntimeException("parser.sourceFile() returned null");
                    }
                    SourceFile sourceFile2 = sourceFile;
                    return sourceFile2;
                }
                catch (RuntimeException ex) {
                    if (ex.getCause() instanceof InterruptedException) {
                        throw (InterruptedException)ex.getCause();
                    }
                    error = ex;
                }
                finally {
                    System.setOut(originalOut);
                    System.setErr(originalErr);
                }
                pout.flush();
                String errorOut = new String(bout.toByteArray()).trim();
                if (errorOut.length() > 0 && config.verbose) {
                    WriteText.writeText((String)errorOut, (File)new File("fullParsing.errors.txt"));
                }
                throw new ParseError(source, errorOut, error);
            }
        };
    }

    protected String removeInlineAsm(String source) {
        String replaced = RegexUtils.regexReplace((Pattern)asmPattern, (String)source, (RegexUtils.Replacer)new RegexUtils.Replacer(){

            public String replace(String[] groups) {
                int i = -1;
                StringBuilder b = new StringBuilder();
                for (char c : groups[0].toCharArray()) {
                    if (c != '\n') continue;
                    b.append(c);
                }
                return b.toString();
            }
        });
        return replaced;
    }

    private SourceFiles removeTypeDefsConflictingWithForcedTypeDefs(SourceFiles sourceFiles, final Set<String> forcedTypeDefs) {
        sourceFiles.accept((Visitor)new Scanner(){
            Set<String> seenOnce = new HashSet<String>();

            public void visitTypeDef(StoredDeclarations.TypeDef typeDef) {
                super.visitTypeDef(typeDef);
                ArrayList<Declarator> declaratorsToRemove = null;
                for (Declarator d : typeDef.getDeclarators()) {
                    String n = d.resolveName();
                    if (!forcedTypeDefs.contains(n) || this.seenOnce.add(n)) continue;
                    if (declaratorsToRemove == null) {
                        declaratorsToRemove = new ArrayList<Declarator>();
                    }
                    declaratorsToRemove.add(d);
                }
                if (declaratorsToRemove != null) {
                    for (Declarator d : declaratorsToRemove) {
                        d.replaceBy(null);
                    }
                }
            }
        });
        return sourceFiles;
    }

    /*
     * Exception decompiling
     */
    public SourceFiles parse(JNAeratorConfig config, TypeConversion typeConverter, PreprocessorUtils.MacroUseCallback macrosDependenciesOut) throws IOException, LexerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected ObjCppParser newObjCppParser(TypeConversion typeConverter, String s, final boolean verbose, final PrintStream errorOut) throws IOException {
        ObjCppParser parser = new ObjCppParser((TokenStream)new CommonTokenStream((TokenSource)new ObjCppLexer((CharStream)new ANTLRReaderStream((Reader)new StringReader(s))))){

            public void emitErrorMessage(String msg) {
                if (errorOut != null) {
                    errorOut.println(msg);
                }
            }

            public void reportError(RecognitionException arg0) {
                if (verbose) {
                    super.reportError(arg0);
                }
            }
        };
        parser.setupScopes();
        parser.objCParserHelper = typeConverter;
        return parser;
    }

    public static class ParseError
    extends RuntimeException {
        private final String source;
        private final String errors;

        public ParseError(String source, String errors, Throwable cause) {
            super("Failed to parse because of " + cause, cause);
            this.source = source;
            this.errors = errors;
        }

        public String getErrors() {
            return this.errors;
        }

        public String getSource() {
            return this.source;
        }
    }

    static class Slice {
        public String file;
        public int line;
        public String text;

        public Slice(String file, int line, String text) {
            this.file = file;
            this.line = line;
            this.text = text;
        }
    }
}

