/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.lang.jnaerator.JNAeratorConfig;
import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Scanner;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.util.string.StringUtils;

public class JavaDocCreator
extends Scanner {
    Result result;

    public JavaDocCreator(Result result) {
        this.result = result;
    }

    public void visitFunction(Function function) {
        if (!this.result.config.noComments && !(function.getParentElement() instanceof TypeRef.FunctionSignature) && this.result.config.features.contains((Object)JNAeratorConfig.GenFeatures.OriginalFunctionSignatures)) {
            function.moveAllCommentsBefore();
            function.addToCommentBefore(new String[]{"Original signature : <code>" + function.computeSignature(Function.SignatureType.Full) + "</code>"});
        }
        super.visitFunction(function);
    }

    String cleanCom(String com) {
        if (com == null) {
            return null;
        }
        if ((com = Element.cleanComment((String)com).trim().replaceAll("\n", "<br>")).trim().length() == 0) {
            return null;
        }
        return com;
    }

    public void visitArg(Arg arg) {
        super.visitArg(arg);
        if (arg.getName() == null) {
            return;
        }
        if (!this.result.config.features.contains((Object)JNAeratorConfig.GenFeatures.FunctionArgsJavaDoc)) {
            return;
        }
        String ca = arg.getCommentAfter();
        String cb = arg.getCommentBefore();
        if (ca == null && cb == null) {
            return;
        }
        Function f = (Function)arg.findParentOfType(Function.class);
        if (f == null) {
            return;
        }
        ca = this.cleanCom(ca);
        cb = this.cleanCom(cb);
        if (!this.result.config.noComments) {
            f.addToCommentBefore(new String[]{"@param " + arg.getName() + " " + StringUtils.implode((Object[])new String[]{ca, cb}, (Object)"<br>")});
        }
        arg.setCommentAfter(null);
        arg.setCommentBefore(null);
    }
}

