/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.io.ReadText;
import com.ochafik.lang.jnaerator.DeclarationsConverter;
import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.Signatures;
import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.Declaration;
import com.ochafik.lang.jnaerator.parser.DeclarationsHolder;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.Enum;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.ModifierType;
import com.ochafik.lang.jnaerator.parser.Statement;
import com.ochafik.lang.jnaerator.parser.StoredDeclarations;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TaggedTypeRefDeclaration;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.VariablesDeclaration;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.rococoa.ObjCClass;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSClass;
import org.rococoa.cocoa.foundation.NSObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectiveCGenerator {
    String classClassName = "_class_";
    String classInterfaceNameInCategoriesAndProtocols = "_static_";
    String classInstanceName = "_NSCLASS_";
    String classInstanceGetterName = "getNSClass";
    boolean AUTO_RELEASE_IN_FACTORIES = false;
    static Map<String, Set<String>> protocolsForcedInheritance;
    static Map<String, Set<String>> methodsExcludedFromStaticForwarding;
    final Result result;
    static Identifier NSObjectIdent;
    static Identifier ObjCObjectIdent;
    static Identifier ObjCClassIdent;

    public static Set<String> getForcedProtocolParents(String protocolName) {
        Set<String> ret;
        if (protocolsForcedInheritance == null) {
            protocolsForcedInheritance = new LinkedHashMap<String, Set<String>>();
            try {
                InputStream in = ObjectiveCGenerator.class.getClassLoader().getResourceAsStream("com/ochafik/lang/jnaerator/ObjectiveCProtocolsForcedInheritanceList.data");
                List lines = ReadText.readLines((InputStream)in);
                for (String line : lines) {
                    if ((line = line.trim()).startsWith("//") || line.startsWith("#") || line.length() == 0) continue;
                    String[] tks = line.split(":");
                    protocolsForcedInheritance.put(tks[0], new TreeSet<String>(Arrays.asList(tks[1].split(","))));
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return (ret = protocolsForcedInheritance.get(protocolName)) == null ? Collections.EMPTY_SET : ret;
    }

    public static boolean isMethodExcludedFromStaticForwarding(Function m) {
        if (methodsExcludedFromStaticForwarding == null) {
            methodsExcludedFromStaticForwarding = new LinkedHashMap<String, Set<String>>();
            try {
                InputStream in = ObjectiveCGenerator.class.getClassLoader().getResourceAsStream("com/ochafik/lang/jnaerator/ObjectiveCStaticForwardsExcludeList.data");
                List lines = ReadText.readLines((InputStream)in);
                for (String line : lines) {
                    if ((line = line.trim()).startsWith("//") || line.startsWith("#") || line.length() == 0) continue;
                    String[] tks = line.split("\\|");
                    String className = tks[0].trim();
                    String methodSignature = tks[1].trim();
                    Set<String> set = methodsExcludedFromStaticForwarding.get(className);
                    if (set == null) {
                        set = new HashSet<String>();
                        methodsExcludedFromStaticForwarding.put(className, set);
                    }
                    set.add(methodSignature);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (!(m.getParentElement() instanceof Struct)) {
            return false;
        }
        Struct s = (Struct)m.getParentElement();
        Identifier n = s.getTag();
        if (n != null && n.equals((Object)"NSObject")) {
            return true;
        }
        String sig = m.computeSignature(Function.SignatureType.JavaStyle);
        if (((Set)DeclarationsConverter.getMethodsAndTheirSignatures(NSObject.class).getSecond()).contains(sig)) {
            return true;
        }
        String cn = s.getTag() == null ? "" : s.getTag().toString();
        Set<String> set = methodsExcludedFromStaticForwarding.get(cn);
        if (set != null && set.contains(sig)) {
            return true;
        }
        set = methodsExcludedFromStaticForwarding.get("");
        return set != null && set.contains(sig);
    }

    public ObjectiveCGenerator(Result result) {
        this.result = result;
    }

    public Struct getStruct(Identifier className, Struct.Type type) {
        return Result.getMap(this.result.classes, type).get(className);
    }

    public Identifier getPackageName(Struct struct) {
        if (struct == null) {
            return null;
        }
        String library = this.result.getLibrary((Element)struct);
        Identifier javaPackage = this.result.getLibraryPackage(library);
        if (struct.getType() == Struct.Type.ObjCProtocol) {
            javaPackage = ElementsHelper.ident((Identifier)javaPackage, (String)"protocols");
        } else if (struct.getCategoryName() != null) {
            javaPackage = ElementsHelper.ident((Identifier)javaPackage, (String)"categories");
        }
        return javaPackage;
    }

    public Identifier getFullClassName(Struct struct) {
        if (struct == null) {
            return null;
        }
        Identifier javaPackage = this.getPackageName(struct);
        Identifier tag = struct.getTag();
        String categ = struct.getCategoryName();
        Identifier fullName = ElementsHelper.ident((Identifier)javaPackage, (Identifier[])new Identifier[]{categ == null ? tag.clone() : ElementsHelper.ident((String[])new String[]{categ})});
        return fullName;
    }

    public void generateObjectiveCClasses() throws IOException {
        for (Struct in : Result.getMap(this.result.classes, Struct.Type.ObjCClass).values()) {
            this.outputObjectiveCClass(in);
        }
        for (Struct protocol : Result.getMap(this.result.classes, Struct.Type.ObjCProtocol).values()) {
            for (String parent : ObjectiveCGenerator.getForcedProtocolParents(String.valueOf(protocol.getTag()))) {
                protocol.addParent(ElementsHelper.ident((String[])new String[]{parent}));
            }
            this.outputObjectiveCClass(protocol);
        }
    }

    public void outputObjectiveCClass(Struct in) throws IOException {
        Identifier fullClassName = this.getFullClassName(in);
        Signatures signatures = new Signatures();
        Struct s = this.generateObjectiveCClass(in, signatures);
        this.result.notifyBeforeWritingClass(fullClassName, s, signatures, this.result.getLibrary((Element)in));
        PrintWriter out = this.result.classOutputter.getClassSourceWriter(fullClassName.toString());
        this.result.printJavaClass(this.getPackageName(in), s, out);
        out.close();
    }

    public Struct generateObjectiveCClass(Struct in, Signatures signatures) throws IOException {
        Struct structThatReceivesStaticMethods;
        Function classGetter;
        boolean isInterface;
        boolean isProtocol = in.getType() == Struct.Type.ObjCProtocol;
        boolean isCategory = in.getCategoryName() != null;
        Struct instanceStruct = new Struct().addModifiers(new Modifier[]{ModifierType.Public});
        instanceStruct.setCommentBefore(in.getCommentBefore());
        instanceStruct.addToCommentBefore(new String[]{in.getCommentAfter()});
        instanceStruct.setTag(isCategory ? ElementsHelper.ident((String[])new String[]{in.getCategoryName()}) : in.getTag().clone());
        if (isProtocol || isCategory) {
            instanceStruct.setType(Struct.Type.JavaInterface);
        } else {
            instanceStruct.addModifiers(new Modifier[]{ModifierType.Abstract}).setType(Struct.Type.JavaClass);
        }
        Struct classStruct = new Struct();
        classStruct.setTag(ElementsHelper.ident((String[])new String[]{this.classClassName}));
        classStruct.setType(Struct.Type.JavaClass);
        classStruct.addModifiers(new Modifier[]{ModifierType.Public, ModifierType.Static, ModifierType.Abstract});
        ArrayList<TypeRef.SimpleTypeRef> interfacesForInstance = new ArrayList<TypeRef.SimpleTypeRef>();
        ArrayList parentsForInstance = new ArrayList(in.getParents());
        boolean isNSObject = in.getTag().equals((Object)NSObject.class.getSimpleName());
        if (!isCategory && !isProtocol) {
            for (Struct catIn : Result.getMap(this.result.objCCategoriesByTargetType, in.getTag()).values()) {
                Identifier catId = this.getFullClassName(catIn);
                Identifier.SimpleIdentifier sim = catId.resolveLastSimpleIdentifier();
                String categName = catIn.getTag() + "_" + sim;
                if (this.add(instanceStruct, (Declaration)this.createCastMethod(ElementsHelper.ident((String[])new String[]{categName}), catId, false), signatures, new Set[0])) {
                    classStruct.addDeclaration((Declaration)this.createCastMethod(ElementsHelper.ident((String[])new String[]{categName}), ElementsHelper.ident((Identifier)catId, (String)this.classInterfaceNameInCategoriesAndProtocols), true));
                }
                this.outputObjectiveCClass(catIn);
            }
        }
        for (Object sp : parentsForInstance) {
            Identifier id;
            Identifier p = sp.getName();
            String ps = p.toString();
            boolean basic = ps.toString().equals(ObjCObject.class.getName()) || ps.equals(NSObject.class.getName());
            Identifier identifier = id = basic ? p : this.result.typeConverter.findObjCClassIdent(p);
            if (id == null && (p.isPlain() || (id = p) == null)) continue;
            if (ps.toString().equals("NSObject")) {
                instanceStruct.addProtocol(ElementsHelper.ident(ObjCObject.class, (Expression[])new Expression[0]));
            } else {
                instanceStruct.addParent(id.clone());
            }
            if (basic) continue;
            classStruct.addParent(ElementsHelper.ident((Identifier)id, (String)this.classClassName));
        }
        boolean bl = isInterface = isProtocol || isCategory;
        if (instanceStruct.getParents().isEmpty()) {
            if (isInterface) {
                instanceStruct.addParent(ElementsHelper.ident(ObjCObject.class, (Expression[])new Expression[0]));
            } else if (isNSObject) {
                instanceStruct.addProtocol(ElementsHelper.ident(ObjCObject.class, (Expression[])new Expression[0]));
            } else {
                instanceStruct.addParent(ElementsHelper.ident(NSObject.class, (Expression[])new Expression[0]));
            }
        }
        if (classStruct.getParents().isEmpty()) {
            if (isNSObject) {
                classStruct.addParent(ElementsHelper.ident(NSClass.class, (Expression[])new Expression[0]));
            } else {
                classStruct.addParent(ElementsHelper.ident((Identifier)ElementsHelper.ident(NSObject.class, (Expression[])new Expression[0]), (String)this.classClassName));
            }
        }
        for (Identifier p : in.getProtocols()) {
            Identifier id = this.getFullClassName(this.getStruct(p.getName(), Struct.Type.ObjCProtocol));
            if (id == null) continue;
            interfacesForInstance.add(ElementsHelper.typeRef((Identifier)id));
        }
        for (TypeRef.SimpleTypeRef id : interfacesForInstance) {
            if (isProtocol || isCategory) {
                instanceStruct.addParent(id);
                continue;
            }
            instanceStruct.addProtocol(id);
        }
        VariablesDeclaration classHolder = new VariablesDeclaration();
        if (!isProtocol && !isCategory) {
            classHolder.addModifiers(new Modifier[]{ModifierType.Private, ModifierType.Static});
        }
        classHolder.setValueType((TypeRef)ElementsHelper.typeRef((String)this.classClassName));
        Expression.FunctionCall call = ElementsHelper.methodCall((Expression)ElementsHelper.expr((TypeRef)ElementsHelper.typeRef(Rococoa.class)), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"createClass", (Expression[])new Expression[0]);
        call.addArgument(ElementsHelper.expr((String)in.getTag().toString()));
        call.addArgument(ElementsHelper.memberRef((Expression)ElementsHelper.expr((TypeRef)ElementsHelper.typeRef((String)this.classClassName)), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"class"));
        if (isProtocol || isCategory) {
            classGetter = null;
            classHolder.addDeclarator((Declarator)new Declarator.DirectDeclarator(this.classInstanceName, (Expression)call));
        } else {
            classHolder.addDeclarator((Declarator)new Declarator.DirectDeclarator(this.classInstanceName));
            classGetter = new Function(Function.Type.JavaMethod, ElementsHelper.ident((String[])new String[]{this.classInstanceGetterName}), (TypeRef)ElementsHelper.typeRef((String)this.classClassName));
            classGetter.addModifiers(new Modifier[]{ModifierType.Public, ModifierType.Static});
            classGetter.setBody(new Statement.Block(new Statement[]{new Statement.If(ElementsHelper.expr((Expression)ElementsHelper.varRef((String)this.classInstanceName), (Expression.BinaryOperator)Expression.BinaryOperator.IsEqual, (Expression)Expression.Constant.newNull()), (Statement)new Statement.ExpressionStatement((Expression)new Expression.AssignmentOp(ElementsHelper.varRef((String)this.classInstanceName), Expression.AssignmentOperator.Equal, (Expression)call)), null), new Statement.Return(ElementsHelper.varRef((String)this.classInstanceName))}));
        }
        Struct classInterfaceStruct = null;
        if (isProtocol || isCategory) {
            structThatReceivesStaticMethods = classInterfaceStruct = new Struct();
            classInterfaceStruct.setType(Struct.Type.JavaInterface);
            classInterfaceStruct.setTag(ElementsHelper.ident((String[])new String[]{this.classInterfaceNameInCategoriesAndProtocols}));
            classInterfaceStruct.addParent(ElementsHelper.ident(ObjCClass.class, (Expression[])new Expression[0]));
            classStruct.addProtocol(ElementsHelper.ident((String[])new String[]{this.classInterfaceNameInCategoriesAndProtocols}));
        } else {
            structThatReceivesStaticMethods = classStruct;
        }
        if (!isProtocol && !isCategory) {
            this.addAllocIfMissing(in, "alloc");
            this.addAllocIfMissing(in, "new_");
        }
        Identifier fullClassName = this.getFullClassName(in);
        this.outputMembers(signatures, in, instanceStruct, structThatReceivesStaticMethods, in.getDeclarations(), isProtocol || isCategory);
        instanceStruct.addDeclaration((Declaration)ElementsHelper.decl((TypeRef.TaggedTypeRef)classInterfaceStruct));
        if (!isCategory) {
            instanceStruct.addDeclaration((Declaration)new TaggedTypeRefDeclaration((TypeRef.TaggedTypeRef)classStruct));
            instanceStruct.addDeclaration((Declaration)classGetter);
            instanceStruct.addDeclaration((Declaration)classHolder);
        }
        return instanceStruct;
    }

    Function createCastMethod(Identifier name, Identifier classId, boolean isStatic) {
        Function m = new Function();
        m.setType(Function.Type.JavaMethod);
        m.addModifiers(new Modifier[]{ModifierType.Public});
        m.setName(ElementsHelper.ident((String[])new String[]{"as" + (isStatic ? "Static_" : "_") + name}));
        m.setValueType((TypeRef)ElementsHelper.typeRef((Identifier)classId.clone()));
        m.setBody(ElementsHelper.block((Statement[])new Statement[]{new Statement.Return((Expression)ElementsHelper.methodCall((Expression)ElementsHelper.expr((TypeRef)ElementsHelper.typeRef(Rococoa.class)), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"cast", (Expression[])new Expression[]{ElementsHelper.varRef((String)"this"), this.result.typeConverter.typeLiteral((TypeRef)ElementsHelper.typeRef((Identifier)classId.clone()))}))}));
        return m;
    }

    private void addAllocIfMissing(Struct in, String allocName) {
        Identifier n = in.getTag();
        if (n.equals((Object)"NSObject") || n.equals((Object)"NSClass")) {
            return;
        }
        boolean hasAlloc = false;
        for (Declaration d : in.getDeclarations()) {
            Function f;
            if (!(d instanceof Function) || !(f = (Function)d).getArgs().isEmpty() || !allocName.equals(f.getName())) continue;
            hasAlloc = true;
            break;
        }
        if (!hasAlloc) {
            in.addDeclaration((Declaration)new Function(Function.Type.ObjCMethod, ElementsHelper.ident((String[])new String[]{allocName}), (TypeRef)ElementsHelper.typeRef((Identifier)in.getTag())).addModifiers(new Modifier[]{ModifierType.Static}));
        }
    }

    private void outputMembers(Signatures signatures, Struct in, Struct instanceStruct, Struct classStruct, List<Declaration> declarations, boolean isProtocol) throws IOException {
        Identifier fullClassName = this.getFullClassName(in);
        instanceStruct.setResolvedJavaIdentifier(fullClassName);
        Set objSigs = (Set)DeclarationsConverter.getMethodsAndTheirSignatures(NSObject.class).getSecond();
        HashSet clasSigs = new HashSet();
        int[] iChild = new int[1];
        for (Declaration d : declarations) {
            if (d instanceof Function) {
                Function f = (Function)d;
                ArrayList decls = new ArrayList();
                DeclarationsHolder.ListWrapper out = new DeclarationsHolder.ListWrapper(decls);
                this.result.declarationsConverter.convertFunction(f, null, false, (DeclarationsHolder)out, (DeclarationsHolder)out, fullClassName, -1);
                if (f.hasModifier((Modifier)ModifierType.Static)) {
                    for (Declaration decl : decls) {
                        if (!this.add(classStruct, decl, signatures, objSigs, clasSigs)) continue;
                        if (!isProtocol && decl instanceof Function) {
                            instanceStruct.addDeclaration((Declaration)this.createProxyCopy(f, (Function)decl));
                            signatures.addMethod((Function)decl);
                        }
                        if (classStruct.getType() != Struct.Type.JavaClass) continue;
                        decl.addModifiers(new Modifier[]{ModifierType.Public, ModifierType.Abstract});
                        decl.reorganizeModifiers();
                    }
                } else {
                    for (Declaration decl : decls) {
                        if (!this.add(instanceStruct, decl, signatures, objSigs) || isProtocol || !(decl instanceof Function)) continue;
                        Function addedF = this.createCreateCopyFromInit((Function)decl, (TypeRef.TaggedTypeRef)instanceStruct);
                        signatures.addMethod((Function)decl);
                        instanceStruct.addDeclaration((Declaration)addedF);
                        if (instanceStruct.getType() != Struct.Type.JavaClass) continue;
                        decl.addModifiers(new Modifier[]{ModifierType.Public, ModifierType.Abstract});
                        decl.reorganizeModifiers();
                    }
                }
            } else if (d instanceof TaggedTypeRefDeclaration) {
                TypeRef.TaggedTypeRef tr = ((TaggedTypeRefDeclaration)d).getTaggedTypeRef();
                if (tr instanceof Struct) {
                    this.result.declarationsConverter.outputConvertedStruct((Struct)tr, signatures, (DeclarationsHolder)instanceStruct, null, false);
                } else if (tr instanceof Enum) {
                    this.result.declarationsConverter.convertEnum((Enum)tr, signatures, (DeclarationsHolder)instanceStruct, fullClassName);
                }
            } else if (d instanceof StoredDeclarations.TypeDef) {
                StoredDeclarations.TypeDef td = (StoredDeclarations.TypeDef)d;
                TypeRef tr = td.getValueType();
                if (tr instanceof Struct) {
                    this.result.declarationsConverter.outputConvertedStruct((Struct)tr, signatures, (DeclarationsHolder)instanceStruct, null, false);
                } else if (tr instanceof TypeRef.FunctionSignature) {
                    this.result.declarationsConverter.convertCallback((TypeRef.FunctionSignature)tr, signatures, (DeclarationsHolder)instanceStruct, fullClassName);
                }
            }
            iChild[0] = iChild[0] + 1;
        }
    }

    private boolean add(Struct classStruct, Declaration decl, Signatures signatures, Set<?> ... additionalMethodSignatures) {
        if (decl instanceof Function) {
            String sig = ((Function)decl).computeSignature(Function.SignatureType.JavaStyle);
            for (Set<?> sigs : additionalMethodSignatures) {
                if (!sigs.contains(sig)) continue;
                return false;
            }
            if (signatures.addMethod(sig)) {
                classStruct.addDeclaration(decl);
                return true;
            }
            return false;
        }
        classStruct.addDeclaration(decl);
        return true;
    }

    private Function createCreateCopyFromInit(Function meth, TypeRef.TaggedTypeRef instanceStruct) {
        String name = meth.getName().toString();
        if (!name.matches("^init([A-Z].*|)$")) {
            return null;
        }
        Function createCopy = meth.clone();
        createCopy.setCommentBefore("Factory method");
        createCopy.addToCommentBefore(new String[]{"@see #" + meth.computeSignature(Function.SignatureType.JavaStyle)});
        createCopy.setName(ElementsHelper.ident((String[])new String[]{"create" + name.substring("init".length())}));
        createCopy.addModifiers(new Modifier[]{ModifierType.Public, ModifierType.Static});
        createCopy.reorganizeModifiers();
        Expression[] args = new Expression[meth.getArgs().size()];
        int i = 0;
        for (Arg arg : meth.getArgs()) {
            args[i++] = ElementsHelper.varRef((String)arg.getName());
        }
        Expression.FunctionCall val = ElementsHelper.methodCall((Expression)ElementsHelper.methodCall((Expression)ElementsHelper.methodCall(null, null, (String)this.classInstanceGetterName, (Expression[])new Expression[0]), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"alloc", (Expression[])new Expression[0]), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)meth.getName().toString(), (Expression[])args);
        if (this.AUTO_RELEASE_IN_FACTORIES) {
            val = ElementsHelper.methodCall((Expression)val, (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"autorelease", (Expression[])new Expression[0]);
            val = ElementsHelper.methodCall((Expression)ElementsHelper.expr((TypeRef)ElementsHelper.typeRef(Rococoa.class)), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"cast", (Expression[])new Expression[]{val, ElementsHelper.memberRef((Expression)ElementsHelper.expr((TypeRef)ElementsHelper.typeRef((Identifier)instanceStruct.getTag())), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"class")});
        }
        createCopy.setBody(new Statement.Block(new Statement[]{new Statement.Return((Expression)val)}));
        return createCopy;
    }

    private Function createProxyCopy(Function originalMethod, Function meth) {
        if (ObjectiveCGenerator.isMethodExcludedFromStaticForwarding(originalMethod)) {
            return null;
        }
        Function proxyCopy = meth.clone();
        proxyCopy.addModifiers(new Modifier[]{ModifierType.Public, ModifierType.Static});
        proxyCopy.reorganizeModifiers();
        Expression[] args = new Expression[meth.getArgs().size()];
        int i = 0;
        for (Arg arg : meth.getArgs()) {
            args[i++] = ElementsHelper.varRef((String)arg.getName());
        }
        Expression.FunctionCall val = ElementsHelper.methodCall((Expression)ElementsHelper.methodCall(null, null, (String)this.classInstanceGetterName, (Expression[])new Expression[0]), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)meth.getName().toString(), (Expression[])args);
        proxyCopy.setBody(new Statement.Block(new Statement[]{meth.getValueType() == null || "void".equals(meth.getValueType().toString()) ? ElementsHelper.stat((Expression)val) : new Statement.Return((Expression)val)}));
        return proxyCopy;
    }

    static {
        NSObjectIdent = ElementsHelper.ident(NSObject.class, (Expression[])new Expression[0]);
        ObjCObjectIdent = ElementsHelper.ident(ObjCObject.class, (Expression[])new Expression[0]);
        ObjCClassIdent = ElementsHelper.ident(ObjCClass.class, (Expression[])new Expression[0]);
    }
}

