/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import java.util.HashSet;
import java.util.Set;

public class Signatures {
    private final Set<Identifier> classSignatures = new HashSet<Identifier>();
    private final Set<String> variablesSignatures = new HashSet<String>();
    private final Set<String> methodsSignatures = new HashSet<String>();

    public boolean addClass(Identifier sig) {
        return this.classSignatures.add(sig);
    }

    public boolean addMethod(Function fun) {
        return this.addMethod(fun.computeSignature(Function.SignatureType.JavaStyle));
    }

    public boolean addMethod(String sig) {
        return this.methodsSignatures.add(sig);
    }

    public boolean addVariable(String sig) {
        return this.variablesSignatures.add(sig);
    }

    public Identifier findNextMethodName(String originalSignature, Identifier originalName) {
        String signature = originalSignature;
        Identifier name = originalName;
        int n = 1;
        while (!this.methodsSignatures.add(signature)) {
            String suffix = "$" + ++n;
            name = ElementsHelper.ident((String[])new String[]{originalName + suffix});
            int i = originalSignature.indexOf("(");
            signature = originalSignature.substring(0, i) + suffix + originalSignature.substring(i);
        }
        return name;
    }
}

