/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.Declaration;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.Enum;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.Namespace;
import com.ochafik.lang.jnaerator.parser.Scanner;
import com.ochafik.lang.jnaerator.parser.Statement;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.Visitor;
import java.util.LinkedHashMap;
import java.util.Map;

public class Symbols {
    public final Map<Integer, Element> resolvedVariables = new LinkedHashMap<Integer, Element>();
    public final Map<Integer, Element> resolvedTypes = new LinkedHashMap<Integer, Element>();
    public final Map<Element, SymbolTable> elementTables = new LinkedHashMap<Element, SymbolTable>();

    public Element getType(Identifier ident) {
        return this.resolvedTypes.get(ident.getId());
    }

    public Element getVariable(Identifier ident) {
        return this.resolvedVariables.get(ident.getId());
    }

    public SymbolTable getEnclosingSymbolTable(Element element) {
        while (element != null) {
            SymbolTable st = this.elementTables.get(element);
            if (st != null) {
                return st;
            }
            element = element.getParentElement();
        }
        return null;
    }

    public boolean isClassType(TypeRef tr) {
        if (tr instanceof TypeRef.SimpleTypeRef) {
            return this.getType(((TypeRef.SimpleTypeRef)tr).getName()) instanceof Struct;
        }
        return false;
    }

    public boolean isEnumType(TypeRef tr) {
        if (tr instanceof TypeRef.SimpleTypeRef) {
            return this.getType(((TypeRef.SimpleTypeRef)tr).getName()) instanceof Enum;
        }
        return false;
    }

    public boolean isEnumItem(Identifier ident) {
        Element v = this.getVariable(ident);
        if (v instanceof Declarator) {
            v = ((Declarator)v).getParentElement();
        }
        if (v instanceof Declaration) {
            v = ((Declaration)v).getValueType();
        }
        if (v instanceof TypeRef.SimpleTypeRef) {
            return this.getType(((TypeRef.SimpleTypeRef)v).getName()) instanceof Enum;
        }
        return false;
    }

    static Symbols resolveSymbols(Element root) {
        Symbols symbols = new Symbols();
        final SymbolTable rootTable = new SymbolTable(symbols);
        root.accept((Visitor)new Scanner(){
            SymbolTable currentTable;
            {
                this.currentTable = rootTable;
            }

            public void visitSimpleTypeRef(TypeRef.SimpleTypeRef element) {
                super.visitSimpleTypeRef(element);
                this.currentTable.resolveType(element.getName());
            }

            public void visitVariableRef(Expression.VariableRef element) {
                super.visitVariableRef(element);
                this.currentTable.resolveVariable(element.getName());
            }

            public void visitArg(Arg element) {
                super.visitArg(element);
                this.currentTable.defineVariable(element.getName(), (Element)element);
            }

            public void visitDirectDeclarator(Declarator.DirectDeclarator element) {
                super.visitDirectDeclarator(element);
                this.currentTable.defineVariable(element.getName(), (Element)element);
            }

            public void visitBlock(Statement.Block element) {
                this.currentTable = new SymbolTable(this.currentTable, null, (Element)element);
                try {
                    super.visitBlock(element);
                }
                finally {
                    this.currentTable = this.currentTable.parent;
                }
            }

            public void visitFunction(Function element) {
                this.currentTable.defineVariable(element.getName(), (Element)element);
                this.currentTable = new SymbolTable(this.currentTable, null, (Element)element);
                try {
                    super.visitFunction(element);
                }
                finally {
                    this.currentTable = this.currentTable.parent;
                }
            }

            public void visitStruct(Struct element) {
                this.currentTable.defineType(element.getTag(), (Element)element);
                this.currentTable = new SymbolTable(this.currentTable, element.getTag(), (Element)element);
                try {
                    super.visitStruct(element);
                }
                finally {
                    this.currentTable = this.currentTable.parent;
                }
            }

            public void visitNamespace(Namespace element) {
                this.currentTable = new SymbolTable(this.currentTable, element.getName(), (Element)element);
                try {
                    super.visitNamespace(element);
                }
                finally {
                    this.currentTable = this.currentTable.parent;
                }
            }

            public void visitFor(Statement.For element) {
                this.currentTable = new SymbolTable(this.currentTable, null, (Element)element);
                try {
                    super.visitFor(element);
                }
                finally {
                    this.currentTable = this.currentTable.parent;
                }
            }

            public void visitIf(Statement.If element) {
                this.currentTable = new SymbolTable(this.currentTable, null, (Element)element);
                try {
                    super.visitIf(element);
                }
                finally {
                    this.currentTable = this.currentTable.parent;
                }
            }

            public void visitTry(Statement.Try element) {
                this.currentTable = new SymbolTable(this.currentTable, null, (Element)element);
                try {
                    super.visitTry(element);
                }
                finally {
                    this.currentTable = this.currentTable.parent;
                }
            }

            public void visitCatch(Statement.Catch element) {
                this.currentTable = new SymbolTable(this.currentTable, null, (Element)element);
                try {
                    super.visitCatch(element);
                }
                finally {
                    this.currentTable = this.currentTable.parent;
                }
            }

            public void visitWhile(Statement.While element) {
                this.currentTable = new SymbolTable(this.currentTable, null, (Element)element);
                try {
                    super.visitWhile(element);
                }
                finally {
                    this.currentTable = this.currentTable.parent;
                }
            }

            public void visitDoWhile(Statement.DoWhile element) {
                this.currentTable = new SymbolTable(this.currentTable, null, (Element)element);
                try {
                    super.visitDoWhile(element);
                }
                finally {
                    this.currentTable = this.currentTable.parent;
                }
            }
        });
        return symbols;
    }

    public static class SymbolTable {
        public final SymbolTable parent;
        public final Symbols symbols;
        public final Map<Identifier, Element> variableDefinitions = new LinkedHashMap<Identifier, Element>();
        public final Map<Identifier, Element> typeDefinitions = new LinkedHashMap<Identifier, Element>();
        public final Identifier subNamespace;
        public final Element owner;

        public SymbolTable(Symbols symbols) {
            this.parent = null;
            this.symbols = symbols;
            this.owner = null;
            this.subNamespace = null;
        }

        public SymbolTable(SymbolTable parent, Identifier subNamespace, Element owner) {
            this.parent = parent;
            this.symbols = parent.symbols;
            this.subNamespace = subNamespace;
            this.owner = owner;
            if (owner != null) {
                this.symbols.elementTables.put(owner, this);
            }
        }

        public void defineVariable(String name, Element element) {
            this.defineVariable(ElementsHelper.ident((String[])new String[]{name}), element);
        }

        public void defineVariable(Identifier name, Element element) {
            this.variableDefinitions.put(name, element);
        }

        public void defineType(Identifier name, Element element) {
            this.typeDefinitions.put(name, element);
        }

        public Element resolveVariable(Identifier ident) {
            return this.resolve(ident, true);
        }

        public Element resolveType(Identifier ident) {
            return this.resolve(ident, false);
        }

        private Element resolve(Identifier ident, boolean varOrType) {
            Identifier.SimpleIdentifier lastIdent;
            if (ident == null) {
                return null;
            }
            Element resolved = (varOrType ? this.variableDefinitions : this.typeDefinitions).get(lastIdent = ident.resolveLastSimpleIdentifier());
            if (resolved == null) {
                if (this.parent != null) {
                    return this.parent.resolve(ident, varOrType);
                }
                return null;
            }
            (varOrType ? this.symbols.resolvedVariables : this.symbols.resolvedTypes).put(ident.getId(), resolved);
            return resolved;
        }
    }
}

