/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator;

import com.ochafik.lang.SyntaxUtils;
import com.ochafik.lang.jnaerator.JNAeratorConfig;
import com.ochafik.lang.jnaerator.Result;
import com.ochafik.lang.jnaerator.UnsupportedConversionException;
import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.Declaration;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Define;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.Enum;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.ModifierType;
import com.ochafik.lang.jnaerator.parser.ObjCppParser;
import com.ochafik.lang.jnaerator.parser.StoredDeclarations;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.VariablesDeclaration;
import com.ochafik.lang.jnaerator.runtime.CGFloatByReference;
import com.ochafik.lang.jnaerator.runtime.CharByReference;
import com.ochafik.lang.jnaerator.runtime.NativeSize;
import com.ochafik.lang.jnaerator.runtime.NativeSizeByReference;
import com.ochafik.lang.jnaerator.runtime.globals.Global;
import com.ochafik.lang.jnaerator.runtime.globals.GlobalByte;
import com.ochafik.lang.jnaerator.runtime.globals.GlobalCGFloat;
import com.ochafik.lang.jnaerator.runtime.globals.GlobalChar;
import com.ochafik.lang.jnaerator.runtime.globals.GlobalDouble;
import com.ochafik.lang.jnaerator.runtime.globals.GlobalFloat;
import com.ochafik.lang.jnaerator.runtime.globals.GlobalInt;
import com.ochafik.lang.jnaerator.runtime.globals.GlobalLong;
import com.ochafik.lang.jnaerator.runtime.globals.GlobalNativeLong;
import com.ochafik.lang.jnaerator.runtime.globals.GlobalNativeSize;
import com.ochafik.lang.jnaerator.runtime.globals.GlobalShort;
import com.ochafik.util.listenable.Pair;
import com.ochafik.util.string.StringUtils;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByReference;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.DoubleByReference;
import com.sun.jna.ptr.FloatByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.NativeLongByReference;
import com.sun.jna.ptr.ShortByReference;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.bridj.cpp.com.GUID;
import org.bridj.cpp.com.IUnknown;
import org.bridj.cpp.com.RECT;
import org.rococoa.ObjCClass;
import org.rococoa.ObjCObject;
import org.rococoa.Selector;
import org.rococoa.cocoa.CGFloat;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSObject;
import org.rococoa.cocoa.foundation.NSUInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeConversion
implements ObjCppParser.ObjCParserHelper {
    Result result;
    public boolean allowUnknownPointers = true;
    public boolean allowFakePointers = false;
    public Map<JavaPrim, Class<? extends ByReference>> primToByReference = new LinkedHashMap<JavaPrim, Class<? extends ByReference>>();
    public Map<JavaPrim, Class<? extends Global>> primToGlobal = new LinkedHashMap<JavaPrim, Class<? extends Global>>();
    public Map<JavaPrim, Class<? extends Buffer>> primToBuffer = new LinkedHashMap<JavaPrim, Class<? extends Buffer>>();
    public final Set<String> byReferenceClassesNames = new HashSet<String>();
    static Map<String, Pair<Integer, Class<?>>> buffersAndArityByType = new LinkedHashMap();
    static Map<String, Pair<Integer, Class<?>>> arraysAndArityByType = new LinkedHashMap();
    static Set<String> objectMethodNames = new HashSet<String>();
    Pattern wstringPat = Pattern.compile("((__)?const ){1,2}wchar_t\\*");
    Pattern stringPat = Pattern.compile("((__)?const ){1,2}char\\*");
    Pattern wstringPtrPtrPat = Pattern.compile("((__)?const ){1,2}wchar_t\\*\\*");
    Pattern stringPtrPtrPat = Pattern.compile("((__)?const ){1,2}char\\*\\*");
    static Map<String, Class<?>> predefObjCClasses;
    Set<String> unknownTypes = new HashSet<String>();
    public static Set<String> JAVA_OBJECT_METHODS;
    public static Set<String> JAVA_KEYWORDS;

    public TypeConversion(Result result) {
        this.result = result;
        this.initTypes();
    }

    public boolean isObjCppPrimitive(String s) {
        return this.result.isObjCppPrimitive(s);
    }

    protected TypeRef functionPointerTypeRef(TypeRef.FunctionSignature fs) {
        return fs;
    }

    protected TypeRef pointerTypeRef(TypeRef targetTypeRef) {
        return ElementsHelper.typeRef((Class)this.result.config.runtime.pointerClass);
    }

    public Expression typeLiteral(TypeRef c) {
        if (c == null) {
            return null;
        }
        if (c.toString().equals("?")) {
            return new Expression.Cast(ElementsHelper.typeRef(Type.class), (Expression)Expression.Constant.newNull());
        }
        return ElementsHelper.memberRef((Expression)ElementsHelper.expr((TypeRef)c), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (String)"class");
    }

    protected abstract JavaPrim getCppBoolMappingType();

    public void initTypes() {
        this.result.prim("void", JavaPrim.Void);
        this.result.prim("VOID", JavaPrim.Void);
        this.result.prim("UTF32Char", JavaPrim.Int);
        this.result.prim("unichar", JavaPrim.Char);
        this.result.prim("int64_t", JavaPrim.Long);
        this.result.prim("uint64_t", JavaPrim.Long);
        this.result.prim("u_int64_t", JavaPrim.Long);
        this.result.prim("long long", JavaPrim.Long);
        this.result.prim("long long int", JavaPrim.Long);
        this.result.prim("long int", JavaPrim.Int);
        this.result.prim("LONGLONG", JavaPrim.Long);
        this.result.prim("ULONGLONG", JavaPrim.Long);
        this.result.prim("INT", JavaPrim.Int);
        this.result.prim("UINT", JavaPrim.Int);
        this.result.prim("SHORT", JavaPrim.Short);
        this.result.prim("USHORT", JavaPrim.Short);
        this.result.prim("CHAR", JavaPrim.Byte);
        this.result.prim("byte", JavaPrim.Byte);
        this.result.prim("BYTE", JavaPrim.Byte);
        this.result.prim("UBYTE", JavaPrim.Byte);
        this.result.prim("DOUBLE", JavaPrim.Double);
        this.result.prim("FLOAT", JavaPrim.Float);
        this.result.prim("WORD", JavaPrim.Short);
        this.result.prim("DWORD", JavaPrim.Int);
        this.result.prim("DWORD64", JavaPrim.Long);
        this.result.prim("LONG64", JavaPrim.Long);
        this.result.prim("UInt64", JavaPrim.Long);
        this.result.prim("SInt64", JavaPrim.Long);
        this.result.prim("__int64", JavaPrim.Long);
        this.result.prim("__int64_t", JavaPrim.Long);
        this.result.prim("int32_t", JavaPrim.Int);
        this.result.prim("uint32_t", JavaPrim.Int);
        this.result.prim("__int32_t", JavaPrim.Int);
        this.result.prim("__uint32_t", JavaPrim.Int);
        this.result.prim("u_int32_t", JavaPrim.Int);
        this.result.prim("uint32", JavaPrim.Int);
        this.result.prim("int32", JavaPrim.Int);
        this.result.prim("int", JavaPrim.Int);
        this.result.prim("SInt32", JavaPrim.Int);
        this.result.prim("UInt32", JavaPrim.Int);
        this.result.prim("GLint", JavaPrim.Int);
        this.result.prim("GLuint", JavaPrim.Int);
        this.result.prim("GLenum", JavaPrim.Int);
        this.result.prim("GLsizei", JavaPrim.Int);
        this.result.prim("__int32", JavaPrim.Int);
        this.result.prim("NSInteger", JavaPrim.NSInteger);
        this.result.prim("NSUInteger", JavaPrim.NSUInteger);
        this.result.prim("CGFloat", JavaPrim.CGFloat);
        JavaPrim longPrim = this.result.config.gccLong ? JavaPrim.NativeSize : JavaPrim.NativeLong;
        this.result.prim("long", longPrim);
        this.result.prim("LONG", longPrim);
        this.result.prim("ULONG", longPrim);
        this.result.prim("time_t", JavaPrim.NativeTime);
        JavaPrim sizePrim = this.result.config.sizeAsLong ? longPrim : JavaPrim.NativeSize;
        this.result.prim("size_t", sizePrim);
        this.result.prim("ptrdiff_t", sizePrim);
        this.result.prim("__darwin_size_t", JavaPrim.NativeSize);
        this.result.prim("complex double", JavaPrim.ComplexDouble);
        this.result.prim("int16_t", JavaPrim.Short);
        this.result.prim("uint16_t", JavaPrim.Short);
        this.result.prim("__int16_t", JavaPrim.Short);
        this.result.prim("__uint16_t", JavaPrim.Short);
        this.result.prim("u_int16_t", JavaPrim.Short);
        this.result.prim("uint16", JavaPrim.Short);
        this.result.prim("int16", JavaPrim.Short);
        this.result.prim("SInt16", JavaPrim.Short);
        this.result.prim("UInt16", JavaPrim.Short);
        this.result.prim("short", JavaPrim.Short);
        this.result.prim("WCHAR", JavaPrim.Short);
        this.result.prim("wchar_t", this.result.config.wcharAsShort ? JavaPrim.Short : JavaPrim.Char);
        this.result.prim("__int16", JavaPrim.Short);
        this.result.prim("int8_t", JavaPrim.Byte);
        this.result.prim("uint8_t", JavaPrim.Byte);
        this.result.prim("u_int8_t", JavaPrim.Byte);
        this.result.prim("__uint8_t", JavaPrim.Byte);
        this.result.prim("__int8_t", JavaPrim.Byte);
        this.result.prim("SInt8", JavaPrim.Byte);
        this.result.prim("UInt8", JavaPrim.Byte);
        this.result.prim("char", JavaPrim.Byte);
        this.result.prim("unsigned char", JavaPrim.Byte);
        this.result.prim("__unsigned char", JavaPrim.Byte);
        this.result.prim("signed char", JavaPrim.Byte);
        this.result.prim("__signed char", JavaPrim.Byte);
        this.result.prim("SignedByte", JavaPrim.Byte);
        this.result.prim("__int8", JavaPrim.Byte);
        this.result.prim("float", JavaPrim.Float);
        this.result.prim("NSFloat", JavaPrim.Float);
        this.result.prim("CGFloat", JavaPrim.Float);
        this.result.prim("double_t", JavaPrim.Double);
        this.result.prim("double", JavaPrim.Double);
        this.result.prim("NSDouble", JavaPrim.Double);
        this.result.prim("CGDouble", JavaPrim.Double);
        JavaPrim cppBoolType = this.getCppBoolMappingType();
        this.result.prim("bool", cppBoolType);
        this.result.prim("Boolean", cppBoolType);
        this.result.prim("boolean_t", cppBoolType);
        this.primToByReference.put(JavaPrim.Int, IntByReference.class);
        this.primToByReference.put(JavaPrim.Char, CharByReference.class);
        this.primToByReference.put(JavaPrim.Short, ShortByReference.class);
        this.primToByReference.put(JavaPrim.Byte, ByteByReference.class);
        this.primToByReference.put(JavaPrim.Long, LongByReference.class);
        this.primToByReference.put(JavaPrim.Float, FloatByReference.class);
        this.primToByReference.put(JavaPrim.Double, DoubleByReference.class);
        this.primToByReference.put(JavaPrim.NativeLong, NativeLongByReference.class);
        this.primToByReference.put(JavaPrim.NativeSize, NativeSizeByReference.class);
        this.primToByReference.put(JavaPrim.NSInteger, NativeSizeByReference.class);
        this.primToByReference.put(JavaPrim.NSUInteger, NativeSizeByReference.class);
        this.primToByReference.put(JavaPrim.CGFloat, CGFloatByReference.class);
        for (Class<? extends ByReference> c : this.primToByReference.values()) {
            this.byReferenceClassesNames.add(c.getName());
        }
        this.primToGlobal.put(JavaPrim.Int, GlobalInt.class);
        this.primToGlobal.put(JavaPrim.Char, GlobalChar.class);
        this.primToGlobal.put(JavaPrim.Short, GlobalShort.class);
        this.primToGlobal.put(JavaPrim.Byte, GlobalByte.class);
        this.primToGlobal.put(JavaPrim.Long, GlobalLong.class);
        this.primToGlobal.put(JavaPrim.Float, GlobalFloat.class);
        this.primToGlobal.put(JavaPrim.Double, GlobalDouble.class);
        this.primToGlobal.put(JavaPrim.NativeLong, GlobalNativeLong.class);
        this.primToGlobal.put(JavaPrim.NativeSize, GlobalNativeSize.class);
        this.primToGlobal.put(JavaPrim.NSInteger, GlobalNativeSize.class);
        this.primToGlobal.put(JavaPrim.NSUInteger, GlobalNativeSize.class);
        this.primToGlobal.put(JavaPrim.CGFloat, GlobalCGFloat.class);
        this.primToBuffer.put(JavaPrim.Int, IntBuffer.class);
        this.primToBuffer.put(JavaPrim.Char, CharBuffer.class);
        this.primToBuffer.put(JavaPrim.Short, ShortBuffer.class);
        this.primToBuffer.put(JavaPrim.Byte, ByteBuffer.class);
        this.primToBuffer.put(JavaPrim.Long, LongBuffer.class);
        this.primToBuffer.put(JavaPrim.Float, FloatBuffer.class);
        this.primToBuffer.put(JavaPrim.Double, DoubleBuffer.class);
        TypeRef.Pointer pInt = new TypeRef.Pointer((TypeRef)new TypeRef.Primitive("int"), Declarator.PointerStyle.Pointer);
        this.result.addManualTypeDef("intptr_t", (TypeRef)pInt);
        this.result.addManualTypeDef("uintptr_t", (TypeRef)pInt);
    }

    protected TypeRef findTypeRef(Identifier name, Identifier libraryClassName) {
        TypeRef.SimpleTypeRef tr = this.findStructRef(name, libraryClassName);
        if (tr != null) {
            return tr;
        }
        tr = this.findEnum(name, libraryClassName);
        if (tr != null) {
            return tr;
        }
        tr = this.findCallbackRef(name, libraryClassName);
        if (tr != null) {
            return tr;
        }
        tr = this.findObjCClass(name);
        if (tr != null) {
            return tr;
        }
        tr = this.result.manualTypeDefs.get(name);
        if (tr != null) {
            return tr;
        }
        return null;
    }

    public TypeRef normalizeTypeRef(TypeRef tr) {
        return this.normalizeTypeRef(tr, new HashSet<Identifier>());
    }

    public TypeRef normalizeTypeRef(TypeRef tr, HashSet<Identifier> resolvedNames) {
        TypeRef.TargettedTypeRef ttr;
        if (tr instanceof TypeRef.SimpleTypeRef) {
            TypeRef td;
            Identifier name = ((TypeRef.SimpleTypeRef)tr).getName();
            TypeRef typeRef = td = resolvedNames.add(name) ? this.result.getTypeDef(name) : null;
            if (td != null) {
                return this.normalizeTypeRef(td, resolvedNames);
            }
            Struct s = this.result.resolveStruct(name);
            if (s != null) {
                return s;
            }
            Enum e = this.result.resolveEnum(name);
            if (e != null) {
                return e;
            }
            TypeRef.FunctionSignature c = this.result.resolveCallback(name);
            if (c != null) {
                return this.functionPointerTypeRef(c);
            }
        }
        if (tr instanceof TypeRef.TargettedTypeRef) {
            ttr = (TypeRef.TargettedTypeRef)tr;
            TypeRef target = ttr.getTarget();
            TypeRef ntarget = this.normalizeTypeRef(target, resolvedNames);
            if (ntarget != target) {
                ttr = (TypeRef.TargettedTypeRef)ttr.clone();
                ttr.setTarget(target);
            }
            return ttr;
        }
        if (tr instanceof TypeRef.TaggedTypeRef && (ttr = (TypeRef.TaggedTypeRef)tr).isForwardDeclaration()) {
            Identifier name = ttr.getTag();
            if (ttr instanceof Struct) {
                ttr = this.result.resolveStruct(name);
            } else if (ttr instanceof Enum) {
                ttr = this.result.resolveEnum(name);
            }
            if (ttr != null) {
                return ttr;
            }
        }
        return tr;
    }

    public JavaPrim getPrimitive(TypeRef valueType) {
        if (!(valueType instanceof TypeRef.Primitive) && !(valueType instanceof JavaPrimitive)) {
            valueType = this.normalizeTypeRef(valueType);
        }
        if (valueType == null) {
            return null;
        }
        Identifier name = null;
        List mods = valueType.getModifiers();
        int longCount = ModifierType.Long.countIn((Collection)mods);
        if (valueType instanceof JavaPrimitive) {
            return ((JavaPrimitive)valueType).getJavaPrim();
        }
        if (valueType instanceof TypeRef.Primitive) {
            name = ((TypeRef.Primitive)valueType).getName();
            if (name == null) {
                name = longCount == 1 ? ElementsHelper.ident((String[])new String[]{"long"}) : (longCount > 1 ? ElementsHelper.ident((String[])new String[]{"long long"}) : (valueType.hasModifier((Modifier)ModifierType.Short) ? ElementsHelper.ident((String[])new String[]{"short"}) : ElementsHelper.ident((String[])new String[]{"int"})));
            }
        } else if (valueType instanceof TypeRef.SimpleTypeRef) {
            name = ((TypeRef.SimpleTypeRef)valueType).getName();
        }
        if (name == null) {
            return null;
        }
        JavaPrim p = JavaPrim.getJavaPrim(name.toString());
        if (p != null && !p.isPrimitive) {
            return p;
        }
        boolean isLong = false;
        String str = name.toString();
        JavaPrim type = this.result.resolvePrimitive(str);
        if ((type == JavaPrim.Int || type == JavaPrim.NativeLong) && longCount >= 1) {
            return JavaPrim.Long;
        }
        if (type == JavaPrim.Double && valueType.hasModifier((Modifier)ModifierType._Complex)) {
            return JavaPrim.ComplexDouble;
        }
        return type;
    }

    public TypeRef.SimpleTypeRef findStructRef(Identifier name, Identifier libraryClassName) {
        return this.findStructRef(this.result.resolveStruct(name), libraryClassName);
    }

    public TypeRef.SimpleTypeRef findStructRef(Struct s, Identifier name, Identifier libraryClassName) {
        if (s == null || s.isForwardDeclaration()) {
            TypeRef td = this.result.getTypeDef(name);
            if (!(td instanceof Struct)) {
                return null;
            }
            s = (Struct)td;
        }
        if (s == null && this.result.config.runtime == JNAeratorConfig.Runtime.BridJ) {
            String ns = name.toString();
            Class<IUnknown> cl = null;
            if (ns.equals("IUnknown")) {
                cl = IUnknown.class;
            } else if (ns.equals("GUID")) {
                cl = GUID.class;
            } else if (ns.equals("RECT")) {
                cl = RECT.class;
            }
            if (cl != null) {
                return ElementsHelper.typeRef((Identifier)ElementsHelper.ident(cl, (Expression[])new Expression[0]));
            }
        }
        return ElementsHelper.typeRef((Identifier)this.getTaggedTypeIdentifierInJava((TypeRef.TaggedTypeRef)s));
    }

    public TypeRef.SimpleTypeRef findStructRef(Struct s, Identifier libraryClassName) {
        if (s == null) {
            return null;
        }
        switch (s.getType()) {
            case ObjCClass: 
            case ObjCProtocol: {
                return ElementsHelper.typeRef((Identifier)this.result.objectiveCGenerator.getFullClassName(s));
            }
        }
        return this.findStructRef(s, this.result.declarationsConverter.getActualTaggedTypeName((TypeRef.TaggedTypeRef)s), libraryClassName);
    }

    protected Identifier packageMember(Identifier libraryPackage, Identifier name) {
        return ElementsHelper.ident((Identifier)libraryPackage, (Identifier[])new Identifier[]{name});
    }

    protected Identifier libMember(Identifier libClass, Identifier libraryClassName, Identifier member) {
        return ElementsHelper.ident((Identifier)libClass, (Identifier[])new Identifier[]{member});
    }

    public Identifier findRef(Identifier name, Element e, Identifier libraryClassName, boolean inLibClass) {
        Struct parentStruct;
        if (e == null || !name.isPlain()) {
            return null;
        }
        String library = this.result.getLibrary(e);
        if (library == null) {
            return null;
        }
        Struct struct = parentStruct = e instanceof Struct ? (Struct)e : (Struct)e.findParentOfType(Struct.class);
        if (!inLibClass && parentStruct != null) {
            if (parentStruct == e) {
                return ElementsHelper.ident((Identifier)this.result.getLibraryPackage(library), (Identifier[])new Identifier[]{name});
            }
            return ElementsHelper.ident((Identifier)this.getTaggedTypeIdentifierInJava((TypeRef.TaggedTypeRef)parentStruct), (Identifier[])new Identifier[]{name});
        }
        return this.libMember(this.result.getLibraryClassFullName(library), libraryClassName, name);
    }

    public TypeRef.SimpleTypeRef findEnum(Identifier name, Identifier libraryClassName) {
        return this.findEnum(this.result.resolveEnum(name), libraryClassName);
    }

    public TypeRef.SimpleTypeRef findEnum(Enum s, Identifier libraryClassName) {
        if (s == null) {
            return null;
        }
        if (this.result.config.runtime == JNAeratorConfig.Runtime.BridJ) {
            return ElementsHelper.typeRef((Identifier)this.getTaggedTypeIdentifierInJava((TypeRef.TaggedTypeRef)s));
        }
        Identifier name = this.result.declarationsConverter.getActualTaggedTypeName((TypeRef.TaggedTypeRef)s);
        String library = this.result.getLibrary((Element)s);
        if (library == null) {
            return null;
        }
        Identifier libClass = this.result.getLibraryClassFullName(library);
        TypeRef.SimpleTypeRef tr = new TypeRef.SimpleTypeRef("int");
        if (this.result.config.features.contains((Object)JNAeratorConfig.GenFeatures.EnumTypeLocationComments)) {
            tr.setCommentBefore("@see " + (SyntaxUtils.equal((Object)libClass, (Object)libraryClassName) ? name : libClass + "#" + name));
        }
        return tr;
    }

    public static Expression javaStaticFieldRef(Identifier javaClass, Identifier fieldName) {
        return ElementsHelper.memberRef((Expression)ElementsHelper.expr((TypeRef)ElementsHelper.typeRef((Identifier)javaClass)), (Expression.MemberRefStyle)Expression.MemberRefStyle.Dot, (Identifier)fieldName);
    }

    public Expression findDefine(Identifier name) {
        Define s = this.result.defines.get(name);
        String library = s == null ? null : this.result.getLibrary((Element)s);
        return library == null ? null : TypeConversion.javaStaticFieldRef(this.result.getLibraryClassFullName(library), name);
    }

    public Identifier inferCallBackName(TypeRef.FunctionSignature functionSignature, boolean prependNamespaces, boolean qualify, Identifier libraryClassName) {
        String library;
        ArrayList<String> nameElements = new ArrayList<String>();
        Identifier name = functionSignature.getFunction().getName();
        if (name != null) {
            name = name.clone();
        }
        Identifier parentIdent = null;
        Element parent = functionSignature.getParentElement();
        if (parent instanceof TypeRef.Pointer) {
            parent = parent.getParentElement();
        }
        boolean firstParent = true;
        while (parent != null) {
            TypeRef.SimpleTypeRef parentRef;
            if (parent instanceof Struct && (parentRef = this.findStructRef((Struct)parent, null)) != null) {
                parentIdent = parentRef.getName();
                break;
            }
            if (firstParent) {
                if (name == null && parent instanceof StoredDeclarations.TypeDef) {
                    Declarator simpleSto = null;
                    for (Declarator sto : ((StoredDeclarations.TypeDef)parent).getDeclarators()) {
                        String stoName = sto.resolveName();
                        if (stoName == null) continue;
                        if (!(sto instanceof Declarator.ArrayDeclarator)) {
                            boolean weirdName;
                            boolean bl = weirdName = stoName.startsWith("_") || stoName.endsWith("_");
                            if (simpleSto == null || (simpleSto.resolveName().startsWith("_") || simpleSto.resolveName().endsWith("_")) && !weirdName) {
                                simpleSto = sto;
                            }
                            if (!weirdName) break;
                        }
                        if (stoName == null) continue;
                        name = new Identifier.SimpleIdentifier(stoName, new Expression[0]);
                    }
                } else if (name == null && parent instanceof Arg) {
                    Arg arg = (Arg)parent;
                    Function f = (Function)SyntaxUtils.as((Object)arg.getParentElement(), Function.class);
                    if (f != null) {
                        name = new Identifier.SimpleIdentifier(f.getName() + "_" + arg.getName(), new Expression[0]);
                        break;
                    }
                } else if (firstParent) {
                    // empty if block
                }
            }
            parent = parent.getParentElement();
            firstParent = false;
        }
        if (qualify && parentIdent == null && (library = this.result.getLibrary((Element)functionSignature)) != null) {
            parentIdent = this.result.getLibraryClassFullName(library);
        }
        if (prependNamespaces) {
            if (name == null) {
                name = new Identifier.SimpleIdentifier("callback", new Expression[0]);
            }
            nameElements.add(name.toString());
            return ElementsHelper.ident((Identifier)(qualify ? parentIdent : null), (String)StringUtils.implode(nameElements, (Object)"_"));
        }
        return ElementsHelper.ident((Identifier)(qualify ? parentIdent : null), (Identifier[])new Identifier[]{name});
    }

    public TypeRef findCallbackRef(Identifier name, Identifier libraryClassName) {
        TypeRef.FunctionSignature s = this.result.resolveCallback(name);
        if (s == null) {
            return null;
        }
        return this.findCallbackRef(s, libraryClassName);
    }

    public TypeRef findCallbackRef(TypeRef.FunctionSignature s, Identifier callerLibraryClass) {
        String library;
        String string = library = s == null ? null : this.result.getLibrary((Element)s);
        if (library == null) {
            return null;
        }
        Identifier identifier = s.getResolvedJavaIdentifier();
        if (identifier == null) {
            throw new UnsupportedConversionException((Element)s, null);
        }
        return ElementsHelper.typeRef((Identifier)identifier);
    }

    static TypeRef primRef(Element element, JavaPrim p) {
        if (p == null) {
            return null;
        }
        if (p.type == null) {
            throw new UnsupportedConversionException(element, "Primitive without known type for this runtime: " + (Object)((Object)p));
        }
        return new JavaPrimitive(p);
    }

    boolean isResolved(TypeRef.SimpleTypeRef tr) {
        return tr != null && (tr.isMarkedAsResolved() || this.isResolved(tr.getName()));
    }

    boolean isResolved(Identifier i) {
        if (i == null || i.isPlain()) {
            return false;
        }
        return i instanceof Identifier.QualifiedIdentifier && Identifier.QualificationSeparator.Dot.equals((Object)((Identifier.QualifiedIdentifier)i).getSeparator());
    }

    protected boolean isString(String typeRefAsString, boolean wide) {
        if (wide) {
            return this.wstringPat.matcher(typeRefAsString).matches() || this.result.config.charPtrAsString && typeRefAsString.equals("wchar_t*");
        }
        return this.stringPat.matcher(typeRefAsString).matches() || this.result.config.charPtrAsString && typeRefAsString.equals("char*");
    }

    protected boolean isStringPtrPtr(String typeRefAsString, boolean wide) {
        if (wide) {
            return this.wstringPtrPtrPat.matcher(typeRefAsString).matches() || this.result.config.charPtrAsString && typeRefAsString.equals("wchar_t**");
        }
        return this.stringPtrPtrPat.matcher(typeRefAsString).matches() || this.result.config.charPtrAsString && typeRefAsString.equals("char**");
    }

    public Identifier findObjCClassIdent(Identifier name) {
        Class<?> class1;
        Identifier.SimpleIdentifier sname;
        String n;
        if (name instanceof Identifier.SimpleIdentifier && (n = (sname = (Identifier.SimpleIdentifier)name).getName()).equals("id") && sname.getTemplateArguments().size() == 1) {
            TypeRef.SimpleTypeRef str;
            Expression x = (Expression)sname.getTemplateArguments().get(0);
            Expression.TypeRefExpression trx = x instanceof Expression.TypeRefExpression ? (Expression.TypeRefExpression)x : null;
            TypeRef.SimpleTypeRef simpleTypeRef = str = trx.getType() instanceof TypeRef.SimpleTypeRef ? (TypeRef.SimpleTypeRef)trx.getType() : null;
            if (str != null) {
                name = str.getName();
            }
        }
        if ((class1 = predefObjCClasses.get(name.toString())) != null) {
            return ElementsHelper.ident(class1, (Expression[])new Expression[0]);
        }
        Struct s = this.result.resolveObjCClass(name);
        if (s != null) {
            return this.result.objectiveCGenerator.getFullClassName(s);
        }
        return null;
    }

    public TypeRef findObjCClass(Identifier name) {
        return ElementsHelper.typeRef((Identifier)this.findObjCClassIdent(name));
    }

    protected TypeRef arrayRef(TypeRef tr) {
        TypeRef.ArrayRef arrayRef;
        if (tr instanceof TypeRef.ArrayRef) {
            arrayRef = (TypeRef.ArrayRef)tr;
            arrayRef.addDimension((Expression)new Expression.EmptyArraySize());
        } else {
            arrayRef = new TypeRef.ArrayRef(tr, new Expression[0]);
        }
        return arrayRef;
    }

    public static <A, B> Pair<A, B> pair(A a, B b) {
        return new Pair(a, b);
    }

    public static Pair<Expression, TypeRef> typed(Expression a, TypeRef b) {
        return new Pair((Object)a, (Object)b);
    }

    public boolean isString(Expression val) {
        return val instanceof Expression.Constant && ((Expression.Constant)val).getType() == Expression.Constant.Type.String;
    }

    public Expression.Constant.Type getConstantType(Expression expr) {
        if (!(expr instanceof Expression.Constant)) {
            return null;
        }
        return ((Expression.Constant)expr).getType();
    }

    public abstract Expression getEnumItemValue(Enum.EnumItem var1, boolean var2);

    public TypeRef convertToJavaType(Expression.Constant.Type type) {
        switch (type) {
            case Bool: {
                return ElementsHelper.typeRef(Boolean.TYPE);
            }
            case IntegerString: 
            case UInt: 
            case Int: {
                return ElementsHelper.typeRef(Integer.TYPE);
            }
            case LongString: 
            case ULong: 
            case Long: {
                return ElementsHelper.typeRef(Long.TYPE);
            }
            case Short: {
                return ElementsHelper.typeRef(Short.TYPE);
            }
            case Byte: {
                return ElementsHelper.typeRef(Byte.TYPE);
            }
            case Float: {
                return ElementsHelper.typeRef(Float.TYPE);
            }
            case Double: {
                return ElementsHelper.typeRef(Double.TYPE);
            }
            case String: {
                return ElementsHelper.typeRef(String.class);
            }
        }
        return null;
    }

    protected Expression sizeof(JavaPrim prim) {
        return prim.size.sizeof(prim);
    }

    protected Expression findEnumItem(Enum.EnumItem enumItem) {
        String library = this.result.getLibrary((Element)enumItem);
        if (library == null) {
            return null;
        }
        Element parent = enumItem.getParentElement();
        if (parent == null || !(parent instanceof Enum)) {
            return null;
        }
        Enum e = (Enum)parent;
        Identifier enumItemName = ElementsHelper.ident((String[])new String[]{enumItem.getName()});
        enumItemName.resolveLastSimpleIdentifier().setJavaStaticImportable(true);
        Identifier ident = ElementsHelper.ident((Identifier)this.result.getLibraryClassFullName(library), (Identifier[])new Identifier[]{this.result.declarationsConverter.getActualTaggedTypeName((TypeRef.TaggedTypeRef)e), enumItemName});
        return ElementsHelper.expr((TypeRef)ElementsHelper.typeRef((Identifier)ident).setMarkedAsResolved(true));
    }

    public Identifier getValidJavaArgumentName(Identifier name) {
        return this.getValidJavaIdentifier(name);
    }

    public Identifier getValidJavaMethodName(Identifier name) {
        String nameStr = name.toString();
        String newName = null;
        if (nameStr.matches("operator[^\\w]+")) {
            String op = nameStr.substring("operator".length());
            String suffix = null;
            java.lang.Enum e = Expression.getAnyOperator((String)op);
            if (e == null) {
                if (op.equals("()")) {
                    suffix = "parenthesis";
                } else if (op.equals("[]")) {
                    suffix = "brackets";
                } else if (op.equals("->")) {
                    suffix = "arrow";
                }
            } else {
                suffix = e.name();
            }
            if (suffix != null) {
                newName = "operator" + StringUtils.capitalize((String)suffix);
            }
        } else if (objectMethodNames.contains(nameStr)) {
            newName = name + "$";
        }
        if (newName == null) {
            newName = this.getValidJavaIdentifierString(name);
        }
        return ElementsHelper.ident((String[])new String[]{newName});
    }

    String beautify(String name, boolean isType) {
        String newName = StringUtils.underscoredToCamel((String)name);
        if (!isType) {
            newName = StringUtils.uncapitalize((String)newName);
        }
        if (name.endsWith("_")) {
            newName = newName + "$";
        }
        return newName;
    }

    public boolean isJavaKeyword(String name) {
        return JAVA_KEYWORDS.contains(name) || JAVA_OBJECT_METHODS.contains(name);
    }

    public Identifier getValidJavaIdentifier(Identifier name) {
        return ElementsHelper.ident((String[])new String[]{this.getValidJavaIdentifierString(name)});
    }

    public String getValidJavaIdentifierString(Identifier name) {
        if (name == null) {
            return null;
        }
        if (this.isJavaKeyword(name.toString())) {
            return name + "$";
        }
        String newName = name.toString().replace('-', '_').replaceAll("[^\\w]", "\\$");
        return newName;
    }

    public static String toPrimString(JavaPrim prim) {
        return prim.name;
    }

    public Expression getJavaClassLitteralExpression(TypeRef tr) {
        JavaPrim prim = this.result.typeConverter.getPrimitive(tr);
        return prim != null ? ElementsHelper.classLiteral(prim.type) : this.typeLiteral(tr.clone());
    }

    public Expression getJavaClassLitteralExpression() {
        throw new UnsupportedOperationException(this.getClass().getName() + "." + this.toString() + " not handled !");
    }

    public Pair<Expression, TypeRef> convertExpressionToJava(Expression x, Identifier libraryClassName, boolean promoteNativeLongToLong, boolean forceConstants, Map<String, Pair<Expression, TypeRef>> mappings) throws UnsupportedConversionException {
        Pair<Expression, TypeRef> res = null;
        if (x instanceof Expression.AssignmentOp) {
            Pair<Expression, TypeRef> convTarget = this.convertExpressionToJava(((Expression.AssignmentOp)x).getTarget(), libraryClassName, promoteNativeLongToLong, forceConstants, mappings);
            Pair<Expression, TypeRef> convValue = this.convertExpressionToJava(((Expression.AssignmentOp)x).getValue(), libraryClassName, promoteNativeLongToLong, forceConstants, mappings);
            res = TypeConversion.typed(ElementsHelper.expr((Expression)((Expression)convTarget.getFirst()), (Expression.AssignmentOperator)Expression.AssignmentOperator.Equal, (Expression)((Expression)convValue.getFirst())), (TypeRef)convTarget.getSecond());
        } else if (x instanceof Expression.BinaryOp) {
            Expression.BinaryOp bop = (Expression.BinaryOp)x;
            Pair<Expression, TypeRef> conv1 = this.convertExpressionToJava(bop.getFirstOperand(), libraryClassName, promoteNativeLongToLong, forceConstants, mappings);
            Pair<Expression, TypeRef> conv2 = this.convertExpressionToJava(bop.getSecondOperand(), libraryClassName, promoteNativeLongToLong, forceConstants, mappings);
            if (conv1 != null && conv2 != null) {
                TypeRef t1 = (TypeRef)conv1.getSecond();
                TypeRef t2 = (TypeRef)conv2.getSecond();
                Expression x1 = (Expression)conv1.getFirst();
                Expression x2 = (Expression)conv2.getFirst();
                String s1 = String.valueOf(t1);
                String s2 = String.valueOf(t2);
                TypeRef tr = null;
                if (bop.getOperator().givesBool) {
                    tr = ElementsHelper.typeRef(Boolean.TYPE);
                } else if (s1.equals(s2)) {
                    tr = t1;
                } else {
                    JavaPrim p2;
                    JavaPrim p1 = "long".equals(t1.toString()) ? JavaPrim.Long : this.getPrimitive(t1);
                    JavaPrim javaPrim = p2 = "long".equals(t2.toString()) ? JavaPrim.Long : this.getPrimitive(t2);
                    if (p1 != null && p2 != null) {
                        block0 : switch (bop.getOperator()) {
                            case LeftShift: 
                            case RightShift: 
                            case SignedRightShift: {
                                tr = t1;
                                break;
                            }
                            default: {
                                for (JavaPrim p : new JavaPrim[]{JavaPrim.Double, JavaPrim.Float, JavaPrim.Long, JavaPrim.NativeSize, JavaPrim.NativeLong, JavaPrim.Int, JavaPrim.Short, JavaPrim.Byte}) {
                                    if (p1 != p && p2 != p) continue;
                                    if (promoteNativeLongToLong && (p == JavaPrim.NativeLong || p == JavaPrim.NativeSize)) {
                                        p = JavaPrim.Long;
                                    }
                                    tr = TypeConversion.primRef((Element)x, p);
                                    break block0;
                                }
                            }
                        }
                    }
                }
                res = TypeConversion.typed(ElementsHelper.expr((Expression)x1, (Expression.BinaryOperator)((Expression.BinaryOp)x).getOperator(), (Expression)x2), tr);
            }
        } else if (x instanceof Expression.UnaryOp) {
            Expression.UnaryOperator op = ((Expression.UnaryOp)x).getOperator();
            if (op == Expression.UnaryOperator.Not) {
                throw new UnsupportedConversionException((Element)x, null);
            }
            Pair<Expression, TypeRef> conv = this.convertExpressionToJava(((Expression.UnaryOp)x).getOperand(), libraryClassName, promoteNativeLongToLong, forceConstants, mappings);
            res = TypeConversion.typed(ElementsHelper.expr((Expression.UnaryOperator)op, (Expression)((Expression)conv.getFirst())), (TypeRef)conv.getSecond());
        } else if (x instanceof Expression.Constant) {
            Class<Object> c = null;
            Expression.Constant jc = ((Expression.Constant)x).asJava();
            switch (jc.getType()) {
                case Byte: {
                    c = Byte.TYPE;
                    break;
                }
                case Char: {
                    c = Character.TYPE;
                    break;
                }
                case Double: {
                    c = Double.TYPE;
                    break;
                }
                case Float: {
                    c = Float.TYPE;
                    break;
                }
                case IntegerString: 
                case UInt: 
                case Int: {
                    c = Integer.TYPE;
                    break;
                }
                case LongString: 
                case ULong: 
                case Long: {
                    c = Long.TYPE;
                    break;
                }
                case Short: {
                    c = Short.TYPE;
                    break;
                }
                case String: {
                    c = String.class;
                }
            }
            if (c != null) {
                res = TypeConversion.typed((Expression)((Expression.Constant)x).asJava(), ElementsHelper.typeRef(c));
            }
        } else if (x instanceof Expression.TypeRefExpression) {
            TypeRef.SimpleTypeRef str;
            Identifier name;
            Expression.TypeRefExpression tre = (Expression.TypeRefExpression)x;
            TypeRef tr = tre.getType();
            if (tr instanceof TypeRef.SimpleTypeRef && (name = (str = (TypeRef.SimpleTypeRef)tr).getName()) != null && this.result.enumItemsFullName.contains(name)) {
                res = TypeConversion.typed((Expression)tre, ElementsHelper.typeRef(Integer.TYPE));
            }
            if (res == null && tr.isMarkedAsResolved()) {
                res = TypeConversion.typed((Expression)tre, tr);
            }
        } else if (x instanceof Expression.VariableRef) {
            Identifier name = ((Expression.VariableRef)x).getName();
            Pair<Expression, TypeRef> mapping = mappings == null ? null : mappings.get(name.toString());
            res = mapping != null ? mapping : this.convertVariableRefToJava(name, libraryClassName, promoteNativeLongToLong, forceConstants);
        }
        if (res == null) {
            throw new UnsupportedConversionException((Element)x, null);
        }
        if (res.getFirst() == null) {
            return null;
        }
        ((Expression)res.getFirst()).setParenthesis(x.getParenthesis());
        return res;
    }

    protected Map<String, EnumItemResult> getEnumValuesAndCommentsByName(Enum e, Identifier libraryClassName) {
        LinkedHashMap<String, EnumItemResult> ret = new LinkedHashMap<String, EnumItemResult>();
        Integer lastAdditiveValue = null;
        Expression lastRefValue = null;
        boolean failedOnceForThisEnum = false;
        LinkedHashMap<String, Pair<Expression, TypeRef>> mappings = new LinkedHashMap<String, Pair<Expression, TypeRef>>();
        for (Enum.EnumItem item : e.getItems()) {
            EnumItemResult res = new EnumItemResult();
            res.originalItem = item;
            try {
                if (item.getArguments().isEmpty()) {
                    Integer n;
                    Integer n2;
                    if (lastRefValue == null) {
                        if (lastAdditiveValue != null) {
                            n2 = lastAdditiveValue;
                            n = lastAdditiveValue = Integer.valueOf(lastAdditiveValue + 1);
                            res.unconvertedValue = ElementsHelper.expr((int)lastAdditiveValue);
                        } else if (item == e.getItems().get(0)) {
                            lastAdditiveValue = 0;
                            res.unconvertedValue = ElementsHelper.expr((int)lastAdditiveValue);
                        } else {
                            res.unconvertedValue = null;
                        }
                    } else {
                        if (lastAdditiveValue != null) {
                            n2 = lastAdditiveValue;
                            n = lastAdditiveValue = Integer.valueOf(lastAdditiveValue + 1);
                        } else {
                            lastAdditiveValue = 1;
                        }
                        res.unconvertedValue = ElementsHelper.expr((Expression)lastRefValue.clone(), (Expression.BinaryOperator)Expression.BinaryOperator.Plus, (Expression)ElementsHelper.expr((int)lastAdditiveValue));
                    }
                } else {
                    failedOnceForThisEnum = false;
                    lastAdditiveValue = null;
                    res.unconvertedValue = lastRefValue = (Expression)item.getArguments().get(0);
                    if (lastRefValue instanceof Expression.Constant) {
                        try {
                            lastAdditiveValue = ((Expression.Constant)lastRefValue).asInteger();
                            lastRefValue = null;
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                }
                res.convertedValue = (Expression)this.result.typeConverter.convertExpressionToJava(res.unconvertedValue, libraryClassName, true, false, mappings).getFirst();
                res.constantValue = (Expression)this.result.typeConverter.convertExpressionToJava(res.unconvertedValue, libraryClassName, true, true, mappings).getFirst();
                mappings.put(item.getName(), TypeConversion.typed(res.constantValue, ElementsHelper.typeRef(Integer.TYPE)));
            }
            catch (Exception ex) {
                failedOnceForThisEnum = true;
                res.exceptionMessage = ex.toString();
            }
            boolean bl = failedOnceForThisEnum = failedOnceForThisEnum || res.errorElement != null;
            if (failedOnceForThisEnum) {
                res.errorElement = this.result.declarationsConverter.skipDeclaration((Element)item, new String[0]);
            }
            ret.put(item.getName(), res);
        }
        return ret;
    }

    private Pair<Expression, TypeRef> convertVariableRefToJava(Identifier name, Identifier libraryClassName, boolean promoteNativeLongToLong, boolean forceConstants) {
        if (name != null) {
            Define define = this.result.defines.get(name);
            if (define != null && define.getValue() != null) {
                if (name.toString().equals(define.getValue().toString())) {
                    return null;
                }
                Expression defineValue = define.getValue();
                if (defineValue instanceof Expression.Constant) {
                    Expression.Constant constant = (Expression.Constant)defineValue;
                    return TypeConversion.typed(this.findDefine(name), this.convertToJavaType(constant.getType()));
                }
                return this.convertExpressionToJava(defineValue, libraryClassName, promoteNativeLongToLong, forceConstants, null);
            }
            String sname = name.toString();
            if (sname.equals("True") || sname.equals("true")) {
                return TypeConversion.typed(ElementsHelper.expr((Expression.Constant.Type)Expression.Constant.Type.Bool, (Object)true), TypeConversion.primRef((Element)define, JavaPrim.Boolean));
            }
            if (sname.equals("False") || sname.equals("false")) {
                return TypeConversion.typed(ElementsHelper.expr((Expression.Constant.Type)Expression.Constant.Type.Bool, (Object)false), TypeConversion.primRef((Element)define, JavaPrim.Boolean));
            }
            Enum.EnumItem enumItem = this.result.enumItems.get(name);
            if (enumItem != null) {
                return TypeConversion.typed(this.getEnumItemValue(enumItem, forceConstants), ElementsHelper.typeRef(Integer.TYPE));
            }
            VariablesDeclaration constant = this.result.globalVariablesByName.get(name);
            if (constant != null) {
                return TypeConversion.typed(ElementsHelper.varRef((Identifier)this.findRef(name, (Element)constant, libraryClassName, true)), null);
            }
            return TypeConversion.typed((Expression)new Expression.VariableRef(name), null);
        }
        return null;
    }

    public Identifier getTaggedTypeIdentifierInJava(TypeRef.TaggedTypeRef s) {
        return this.result.resolveFullTaggedTypeRef(s).getResolvedJavaIdentifier();
    }

    public Identifier computeTaggedTypeIdentifierInJava(TypeRef.TaggedTypeRef s) {
        Identifier name = this.result.declarationsConverter.getActualTaggedTypeName(s);
        if (name == null) {
            return null;
        }
        String library = this.result.getLibrary((Element)s);
        if (library == null) {
            return null;
        }
        name = name.clone();
        Struct parentStruct = (Struct)s.findParentOfType(Struct.class);
        if (parentStruct != null && parentStruct != s) {
            return ElementsHelper.ident((Identifier)this.getTaggedTypeIdentifierInJava((TypeRef.TaggedTypeRef)parentStruct), (Identifier[])new Identifier[]{name});
        }
        if (s instanceof Struct && this.result.config.putTopStructsInSeparateFiles) {
            return this.packageMember(this.result.getLibraryPackage(library), name);
        }
        return this.libMember(this.result.getLibraryClassFullName(library), null, name);
    }

    public Identifier computeCallbackIdentifierInJava(TypeRef.FunctionSignature fs) {
        Identifier name = this.inferCallBackName(fs, false, false, null);
        if (name == null) {
            return null;
        }
        String library = this.result.getLibrary((Element)fs);
        if (library == null) {
            return null;
        }
        name = name.clone();
        Struct parentStruct = (Struct)fs.findParentOfType(Struct.class);
        if (parentStruct != null) {
            return ElementsHelper.ident((Identifier)this.getTaggedTypeIdentifierInJava((TypeRef.TaggedTypeRef)parentStruct), (Identifier[])new Identifier[]{name});
        }
        return this.libMember(this.result.getLibraryClassFullName(library), null, name);
    }

    static {
        for (Method method : Object.class.getDeclaredMethods()) {
            objectMethodNames.add(method.getName());
        }
        Object[] data = new Object[]{"char", Byte.TYPE, byte[].class, ByteBuffer.class, "Char", "long", Long.TYPE, long[].class, LongBuffer.class, "Long", "int", Integer.TYPE, int[].class, IntBuffer.class, "Int", "short", Short.TYPE, short[].class, ShortBuffer.class, "Short", "wchar_t", Character.TYPE, char[].class, CharBuffer.class, "WChar", "double", Double.TYPE, double[].class, DoubleBuffer.class, "Double", "float", Float.TYPE, float[].class, FloatBuffer.class, "Float", "bool", Boolean.TYPE, boolean[].class, null, "Bool"};
        for (int arity : new int[]{1, 2, 4, 8, 16}) {
            String suffix = arity == 1 ? "" : arity + "";
            for (int i = 0; i < data.length; i += 5) {
                String rawType = (String)data[i];
                Class scalClass = (Class)data[i + 1];
                Class arrClass = (Class)data[i + 2];
                Class buffClass = (Class)data[i + 3];
                String radix = (String)data[i + 4];
                Pair buffPair = new Pair((Object)arity, (Object)(arity == 1 ? scalClass : buffClass));
                Pair arrPair = new Pair((Object)arity, (Object)(arity == 1 ? scalClass : arrClass));
                for (String type : new String[]{rawType + suffix, "u" + rawType + suffix}) {
                    buffersAndArityByType.put(type, buffPair);
                    arraysAndArityByType.put(type, arrPair);
                }
            }
        }
        predefObjCClasses = new LinkedHashMap();
        predefObjCClasses.put("id", ObjCObject.class);
        predefObjCClasses.put("SEL", Selector.class);
        predefObjCClasses.put("IMP", Pointer.class);
        predefObjCClasses.put("Class", ObjCClass.class);
        predefObjCClasses.put("Protocol", ObjCClass.class);
        predefObjCClasses.put("NSObject", NSObject.class);
        JAVA_OBJECT_METHODS = new HashSet<String>(Arrays.asList("notify", "notifyAll", "equals", "finalize", "getClass", "hashCode", "clone", "toString", "wait"));
        JAVA_KEYWORDS = new HashSet<String>(Arrays.asList("null", "true", "false", "abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"));
    }

    static class EnumItemResult {
        public Enum.EnumItem originalItem;
        public Expression convertedValue;
        public Expression unconvertedValue;
        public Expression constantValue;
        public String comments;
        public String exceptionMessage;
        public Declaration errorElement;

        EnumItemResult() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConvType {
        Enum,
        Pointer,
        FunctionSignature,
        Primitive,
        Struct,
        NativeLong,
        NativeSize,
        NativeTime,
        ComplexDouble,
        Void,
        Callback,
        Default;

    }

    public static class JavaPrimitive
    extends TypeRef.Primitive {
        JavaPrim javaPrim;

        public JavaPrimitive() {
        }

        public JavaPrimitive(JavaPrim javaPrim) {
            this.setName(ElementsHelper.ident(javaPrim == JavaPrim.Void ? Void.TYPE : javaPrim.type, (Expression[])new Expression[0]));
            this.javaPrim = javaPrim;
        }

        public JavaPrim getJavaPrim() {
            return this.javaPrim;
        }

        public void setJavaPrim(JavaPrim javaPrim) {
            this.javaPrim = javaPrim;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JavaPrim {
        Void(java.lang.Void.TYPE, null, ESize.Zero),
        Char(Character.TYPE, Character.class, ESize.CharSize),
        Long(java.lang.Long.TYPE, Long.class, ESize.Eight),
        Int(Integer.TYPE, Integer.class, ESize.Four),
        Short(java.lang.Short.TYPE, Short.class, ESize.Two),
        Byte(java.lang.Byte.TYPE, Byte.class, ESize.One),
        Boolean(java.lang.Boolean.TYPE, Boolean.class, ESize.One),
        Float(java.lang.Float.TYPE, Float.class, ESize.Four),
        Double(java.lang.Double.TYPE, Double.class, ESize.Eight),
        ComplexDouble(null, null, ESize.Sixteen),
        NativeLong(NativeLong.class, NativeLong.class, ESize.StaticSizeField),
        NativeSize(NativeSize.class, NativeSize.class, ESize.StaticSizeField),
        NativeTime(null, null, ESize.StaticSizeField),
        NSInteger(NSInteger.class, NSInteger.class, ESize.StaticSizeField),
        NSUInteger(NSUInteger.class, NSUInteger.class, ESize.StaticSizeField),
        CGFloat(CGFloat.class, CGFloat.class, ESize.StaticSizeField);

        public final Class<?> type;
        public final Class<?> wrapperType;
        public final String simpleName;
        public final String name;
        public final boolean isPrimitive;
        public final ESize size;
        private static Map<String, JavaPrim> nameToPrim;

        public static JavaPrim getJavaPrim(String name) {
            if (nameToPrim == null) {
                nameToPrim = new LinkedHashMap<String, JavaPrim>();
                for (JavaPrim p : JavaPrim.values()) {
                    nameToPrim.put(p.simpleName, p);
                }
            }
            return nameToPrim.get(name);
        }

        private JavaPrim(Class<?> type, Class<?> wrapperType, ESize size) {
            this.type = type;
            this.wrapperType = wrapperType;
            this.size = size;
            this.name = type == null ? null : type.getName();
            this.isPrimitive = type == null || type.isPrimitive();
            this.simpleName = type == null ? null : type.getSimpleName();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ESize {
            One(ElementsHelper.expr((int)1)),
            Two(ElementsHelper.expr((int)2)),
            Four(ElementsHelper.expr((int)4)),
            Eight(ElementsHelper.expr((int)8)),
            Sixteen(ElementsHelper.expr((int)16)),
            StaticSizeField(null){

                public Expression sizeof(JavaPrim p) {
                    return ElementsHelper.staticField(p.type, (String)"SIZE");
                }
            }
            ,
            CharSize(null){

                public Expression sizeof(JavaPrim p) {
                    return ElementsHelper.staticField(Native.class, (String)"WCHAR_SIZE");
                }
            }
            ,
            Zero(ElementsHelper.expr((int)0));

            private final Expression sizeOfExpression;

            private ESize(Expression sizeOfExpression) {
                this.sizeOfExpression = sizeOfExpression;
            }

            public Expression sizeof(JavaPrim p) {
                return this.sizeOfExpression.clone();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TypeConversionMode {
        PrimitiveOrBufferParameter,
        NativeParameter,
        NativeParameterWithStructsPtrPtrs,
        FieldType,
        ReturnType,
        ExpressionType,
        StaticallySizedArrayField,
        PrimitiveReturnType,
        PointedValue;

    }
}

