/*
 * Decompiled with CFR 0.152.
 */
package com.natpryce.hamkrest;

import com.natpryce.hamkrest.CoreMatchers;
import com.natpryce.hamkrest.Describe;
import com.natpryce.hamkrest.InternalKt;
import com.natpryce.hamkrest.MatchResult;
import com.natpryce.hamkrest.Matcher;
import kotlin.Range;
import kotlin.jvm.ClassMapping;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FunctionReference;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"=\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005A\u0001!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001c\u0004\u0006\u0001\u0015\t\u0001bB\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003!!Q!\u0001E\u0006\u000b\u0005!i!B\u0001\r\u0003\u0015\tAQA\u0007&\t\u0005A1!\u0004\u0003\n\u0005%\tAu\u0001M\u0003#\u001d!\u0001\u0001c\u0002\u0016\t%\u0011\u0011\"\u0001S\u00041\u0011I2\u0001#\u0003\u000e\u0003a)\u0011d\u0001E\u0006\u001b\u0005!;!G\u0005\t\r59\u0011BA\u0005\u00021\u001dI!!C\u0001\u0019\u0010a5\u0011kA\u0001\t\u0011Q\u001b\u0019!d\u0006\t\u00125)\u0011bA\u0005\u0003\u0019\u0003!\u0013\u0002'\u0002\u0012\u0005\u0011\u0001\u0001\"\u0003+\u0004\u000451Ba\u0011\t\t\u00145!\u0011BA\u0005\u00021\u0005A*!E\u0003\u0005\u0001!IA\u0012A\u000b\u00021\u0005Ib\u0001\u0003\u0006\u000e\t%\u0011\u0011\"\u0001\u0013\n1\u000b!61A\u0007\u0012\u0011+iA!\u0003\u0002\n\u0003\u0011J\u0001TA\t\u0003\t\u0001A\u0011\"G\u0002\t\u00175\tA%C)\u0004\u0003!]Aka\u0001\u000e-!aQ\u0002B\u0005\u0003\u0013\u0005!;\u0001'\u0002\u0012\u000f\u0011\u0001\u0001rA\u000b\u0005\u0013\tI\u0011\u0001j\u0002\u0019\te\u0019\u00012B\u0007\u0002I\u000f\t6!\u0001E\r)\u000e\rQB\u0006\u0005\u000e\u001b\u0011I!!C\u0001%\ba\u0015\u0011c\u0002\u0003\u0001\u0011\u000f)B!\u0003\u0002\n\u0003\u0011\u001e\u0001\u0004B\r\u0004\u0011\u0017i\u0011\u0001j\u0002R\u0007\u0005AI\u0002VB\u0002\u001b[AY\"\u0004\u0003\n\u0005%\tA%\u0003M\u0003#\u001d!\u0001\u0001C\u0005\u0016\t%\u0011\u0011\"\u0001\u0013\n1\u0011Ib\u0001\u0003\b\u000e\t%\u0011\u0011\"\u0001\u0013\n1;!61A\u0007\u0017\u0011=iA!\u0003\u0002\n\u0003\u0011\u001e\u0001TA\t\b\t\u0001A9!\u0006\u0003\n\u0005%\tAu\u0001\r\u00053\rAY!D\u0001%\bE\u001b\u0011\u0001#\u0007U\u0007\u0007ia\u0003c\b\u000e\t%\u0011\u0011\"\u0001S\u00041\u000b\tr\u0001\u0002\u0001\t\bU!\u0011BA\u0005\u0002I\u000fAB!G\u0002\t\f5\tAuA)\u0004\u0003!eAka\u0001\u000e&!\u0001R\"B\u0005\u0004\u0013\ta\t\u0001J\u0005\u0019\u0006E\u0011A\u0001\u0001\u0005\n3\u0019A\t#\u0004\u0003\n\u0005%\tA%\u0003M\u0003)\u000e\rQ\"\u0005\u0005\u0012\u001b\u0011I!!C\u0001%\u0013a\u0015\u0011C\u0001\u0003\u0001\u0011%I2\u0001C\u0006\u000e\u0003\u0011J\u0011kA\u0001\t\u0018Q\u001b\u0019!%\u0007\u0005\b\"A\u0001!\u0004\u0003\n\u0005%\t\u0001$\u0001M\u00019\r\t6!A\u0003\u0001)\u000e\r\u0011\u0013\u0004CD\u0011!\u0011Q\u0002B\u0005\u0003\u0013\u0005A\u0012\u0001'\u0002\u001d\u0007E\u001b\u0011!\u0002\u0001U\u0007\u0007\u0001"}, strings={"anything", "Lcom/natpryce/hamkrest/Matcher$Primitive;", "", "CoreMatchers", "nothing", "Lcom/natpryce/hamkrest/Matcher;", "_comparesAs", "N", "", "description", "", "n", "expectedSignum", "Lkotlin/Function1;", "", "", "(Ljava/lang/String;Ljava/lang/Comparable;Lkotlin/jvm/functions/Function1;)Lcom/natpryce/hamkrest/Matcher;", "absent", "T", "cast", "downcastMatcher", "equalTo", "expected", "(Ljava/lang/Object;)Lcom/natpryce/hamkrest/Matcher;", "greaterThan", "(Ljava/lang/Comparable;)Lcom/natpryce/hamkrest/Matcher;", "greaterThanOrEqualTo", "isWithin", "range", "Lkotlin/Range;", "lessThan", "lessThanOrEqualTo", "present", "valueMatcher", "sameInstance"}, moduleName="hamkrest-compileKotlin")
@JvmName(name="CoreMatchers")
public final class CoreMatchers {
    @JvmField
    @NotNull
    public static final Matcher.Primitive<? super Object> anything = new Matcher.Primitive<Object>(){

        @NotNull
        public MatchResult invoke(@NotNull Object actual) {
            Intrinsics.checkParameterIsNotNull((Object)actual, (String)"actual");
            return MatchResult.Match.INSTANCE;
        }

        @NotNull
        public String description() {
            return "anything";
        }

        @NotNull
        protected String negatedDescription() {
            return "nothing";
        }
    };
    @JvmField
    @NotNull
    public static final Matcher<? super Object> nothing = anything.not();

    @NotNull
    public static final <T> Matcher<T> equalTo(T expected) {
        return new Matcher.Primitive<T>(expected){
            final /* synthetic */ Object $expected;

            @NotNull
            public MatchResult invoke(T actual) {
                return InternalKt.match(Intrinsics.areEqual(actual, (Object)this.$expected), (Function0<? extends String>)((Function0)new Function0<String>(actual){
                    final /* synthetic */ Object $actual;

                    @NotNull
                    public final String invoke() {
                        return "was " + Describe.describe(this.$actual);
                    }
                    {
                        this.$actual = object;
                        super(0);
                    }
                }));
            }

            @NotNull
            public String description() {
                return "is equal to " + Describe.describe(this.$expected);
            }

            @NotNull
            protected String negatedDescription() {
                return "is not equal to " + Describe.describe(this.$expected);
            }
            {
                this.$expected = $captured_local_variable$0;
            }
        };
    }

    @NotNull
    public static final <T> Matcher<T> sameInstance(T expected) {
        return new Matcher.Primitive<T>(expected){
            final /* synthetic */ Object $expected;

            @NotNull
            public MatchResult invoke(T actual) {
                return InternalKt.match(actual == this.$expected, (Function0<? extends String>)((Function0)new Function0<String>(actual){
                    final /* synthetic */ Object $actual;

                    @NotNull
                    public final String invoke() {
                        return "was " + Describe.describe(this.$actual);
                    }
                    {
                        this.$actual = object;
                        super(0);
                    }
                }));
            }

            @NotNull
            public String description() {
                return "is same instance as " + Describe.describe(this.$expected);
            }

            @NotNull
            protected String negatedDescription() {
                return "is not same instance as " + Describe.describe(this.$expected);
            }
            {
                this.$expected = $captured_local_variable$0;
            }
        };
    }

    @NotNull
    public static final <T> Matcher<T> absent() {
        return new Matcher.Primitive<T>(){

            @NotNull
            public MatchResult invoke(@Nullable T actual) {
                return InternalKt.match(actual == null, (Function0<? extends String>)((Function0)new Function0<String>(actual){
                    final /* synthetic */ Object $actual;

                    @NotNull
                    public final String invoke() {
                        return "was " + Describe.describe(this.$actual);
                    }
                    {
                        this.$actual = object;
                        super(0);
                    }
                }));
            }

            @NotNull
            public String description() {
                return "null";
            }
        };
    }

    @NotNull
    public static final <T> Matcher<T> present(@NotNull Matcher<? super T> valueMatcher) {
        Intrinsics.checkParameterIsNotNull(valueMatcher, (String)"valueMatcher");
        return new Matcher.Primitive<T>(valueMatcher){
            final /* synthetic */ Matcher $valueMatcher;

            @NotNull
            public MatchResult invoke(@Nullable T actual) {
                T t = actual;
                return Intrinsics.areEqual(t, null) ? (MatchResult)new MatchResult.Mismatch("was null") : this.$valueMatcher.invoke(actual);
            }

            @NotNull
            public String description() {
                return "is not null & " + this.$valueMatcher.description();
            }
            {
                this.$valueMatcher = $captured_local_variable$0;
            }
        };
    }

    @NotNull
    public static final <T> Matcher<Object> cast(@NotNull Matcher<? super T> downcastMatcher) {
        Intrinsics.checkParameterIsNotNull(downcastMatcher, (String)"downcastMatcher");
        Intrinsics.needClassReification();
        return new Matcher.Primitive<Object>(downcastMatcher){
            final /* synthetic */ Matcher $downcastMatcher;

            @NotNull
            public MatchResult invoke(@NotNull Object actual) {
                Intrinsics.checkParameterIsNotNull((Object)actual, (String)"actual");
                Object object = actual;
                Intrinsics.reifyInstanceof((String)"T");
                return object instanceof Object ? this.$downcastMatcher.invoke(actual) : (MatchResult)new MatchResult.Mismatch("had type " + ClassMapping.getKotlin(actual.getClass()).getQualifiedName());
            }

            @NotNull
            public String description() {
                StringBuilder stringBuilder = new StringBuilder().append("has type ");
                Intrinsics.reifyJavaClass((String)"T");
                return stringBuilder.append(Reflection.getOrCreateKotlinClass(Object.class).getQualifiedName()).append(" & ").append(this.$downcastMatcher.description()).toString();
            }
            {
                this.$downcastMatcher = $captured_local_variable$0;
            }
        };
    }

    @NotNull
    public static final <N extends Comparable<? super N>> Matcher<N> greaterThan(@NotNull N n) {
        Intrinsics.checkParameterIsNotNull(n, (String)"n");
        return CoreMatchers._comparesAs("greater than", n, (Function1<? super Integer, ? extends Boolean>)((Function1)greaterThan.1.INSTANCE));
    }

    @NotNull
    public static final <N extends Comparable<? super N>> Matcher<N> greaterThanOrEqualTo(@NotNull N n) {
        Intrinsics.checkParameterIsNotNull(n, (String)"n");
        return CoreMatchers._comparesAs("greater than or equal to", n, (Function1<? super Integer, ? extends Boolean>)((Function1)greaterThanOrEqualTo.1.INSTANCE));
    }

    @NotNull
    public static final <N extends Comparable<? super N>> Matcher<N> lessThan(@NotNull N n) {
        Intrinsics.checkParameterIsNotNull(n, (String)"n");
        return CoreMatchers._comparesAs("less than", n, (Function1<? super Integer, ? extends Boolean>)((Function1)lessThan.1.INSTANCE));
    }

    @NotNull
    public static final <N extends Comparable<? super N>> Matcher<N> lessThanOrEqualTo(@NotNull N n) {
        Intrinsics.checkParameterIsNotNull(n, (String)"n");
        return CoreMatchers._comparesAs("less than or equal to", n, (Function1<? super Integer, ? extends Boolean>)((Function1)lessThanOrEqualTo.1.INSTANCE));
    }

    private static final <N extends Comparable<? super N>> Matcher<N> _comparesAs(String description, N n, Function1<? super Integer, ? extends Boolean> expectedSignum) {
        return new Matcher.Primitive<N>(expectedSignum, n, description){
            final /* synthetic */ Function1 $expectedSignum;
            final /* synthetic */ Comparable $n;
            final /* synthetic */ String $description;

            @NotNull
            public MatchResult invoke(@NotNull N actual) {
                Intrinsics.checkParameterIsNotNull(actual, (String)"actual");
                return InternalKt.match((Boolean)this.$expectedSignum.invoke((Object)actual.compareTo((Comparable)this.$n)), (Function0<? extends String>)((Function0)new Function0<String>(actual){
                    final /* synthetic */ Comparable $actual;

                    @NotNull
                    public final String invoke() {
                        return "was " + Describe.describe(this.$actual);
                    }
                    {
                        this.$actual = comparable;
                        super(0);
                    }
                }));
            }

            @NotNull
            public String description() {
                return "is " + this.$description + " " + Describe.describe(this.$n);
            }
            {
                this.$expectedSignum = $captured_local_variable$0;
                this.$n = $captured_local_variable$1;
                this.$description = $captured_local_variable$2;
            }
        };
    }

    @NotNull
    public static final <T extends Comparable<? super T>> Matcher<T> isWithin(@NotNull Range<T> range) {
        Intrinsics.checkParameterIsNotNull(range, (String)"range");
        isWithin.1 _isWithin$ = isWithin.1.INSTANCE;
        return Matcher.Companion.invoke(Reflection.function((FunctionReference)isWithin.2.INSTANCE), range);
    }
}

