/*
 * Decompiled with CFR 0.152.
 */
package com.natpryce.makeiteasy;

import com.natpryce.makeiteasy.Donor;
import com.natpryce.makeiteasy.Instantiator;
import com.natpryce.makeiteasy.Property;
import com.natpryce.makeiteasy.PropertyLookup;
import com.natpryce.makeiteasy.PropertyValue;
import com.natpryce.makeiteasy.SameValueDonor;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Maker<T>
implements PropertyLookup<T>,
Donor<T> {
    private final Map<Property<? super T, ?>, PropertyValue<? super T, ?>> values = Maker.newHashMap();
    private final Instantiator<T> instantiator;

    public Maker(Instantiator<T> instantiator, PropertyValue<? super T, ?> ... propertyValues) {
        this.instantiator = instantiator;
        this.setPropertyValues(propertyValues);
    }

    private static <K, V> Map<K, V> newHashMap() {
        return new HashMap();
    }

    private Maker(Maker<T> that, PropertyValue<? super T, ?> ... propertyValues) {
        this.instantiator = that.instantiator;
        this.values.putAll(that.values);
        this.setPropertyValues(propertyValues);
    }

    private void setPropertyValues(PropertyValue<? super T, ?>[] propertyValues) {
        for (PropertyValue<T, ?> propertyValue : propertyValues) {
            this.values.put(propertyValue.property(), propertyValue);
        }
    }

    public T make() {
        return this.instantiator.instantiate(this);
    }

    @Override
    public T value() {
        return this.make();
    }

    public Maker<T> but(PropertyValue<? super T, ?> ... propertyValues) {
        return new Maker<T>(this, propertyValues);
    }

    @Override
    public <V> V valueOf(Property<? super T, V> property, V defaultValue) {
        return this.valueOf(property, (Donor<? extends V>)new SameValueDonor<V>(defaultValue));
    }

    @Override
    public <V> V valueOf(Property<? super T, V> property, Donor<? extends V> defaultValue) {
        if (this.values.containsKey(property)) {
            return (V)this.values.get(property).value();
        }
        return defaultValue.value();
    }
}

