/*
 * Decompiled with CFR 0.152.
 */
package example.donors;

import com.natpryce.makeiteasy.Donor;
import com.natpryce.makeiteasy.Instantiator;
import com.natpryce.makeiteasy.MakeItEasy;
import com.natpryce.makeiteasy.Maker;
import com.natpryce.makeiteasy.Property;
import com.natpryce.makeiteasy.PropertyLookup;
import com.natpryce.makeiteasy.sequence.ChainedSequence;
import com.natpryce.makeiteasy.sequence.IndexedSequence;
import java.util.TreeSet;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class DonorExample {
    public static final Property<NamedThing, String> name = Property.newProperty();
    public static final Instantiator<NamedThing> NamedThing = new Instantiator<NamedThing>(){

        @Override
        public NamedThing instantiate(PropertyLookup<NamedThing> lookup) {
            return new NamedThing(lookup.valueOf(name, "anonymous"));
        }
    };

    @Test
    public void allocatingUniqueNames() {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class UUIDValue
        implements Donor<String> {
            UUIDValue() {
            }

            @Override
            public String value() {
                return UUID.randomUUID().toString();
            }
        }
        Maker<NamedThing> aNamedThing = MakeItEasy.a(NamedThing, MakeItEasy.with(name, new UUIDValue()));
        NamedThing thing0 = MakeItEasy.make(aNamedThing);
        NamedThing thing1 = MakeItEasy.make(aNamedThing);
        MatcherAssert.assertThat((Object)thing0.name, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)thing1.name)));
    }

    @Test
    public void allocatingNamesByIndex() {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class NameSequence
        extends IndexedSequence<String> {
            NameSequence() {
            }

            @Override
            protected String valueAt(int index) {
                return Integer.toString(index);
            }
        }
        Maker<NamedThing> aNamedThing = MakeItEasy.a(NamedThing, MakeItEasy.with(name, new NameSequence()));
        NamedThing thing0 = MakeItEasy.make(aNamedThing);
        NamedThing thing1 = MakeItEasy.make(aNamedThing);
        MatcherAssert.assertThat((Object)thing0.name, (Matcher)Matchers.equalTo((Object)"0"));
        MatcherAssert.assertThat((Object)thing1.name, (Matcher)Matchers.equalTo((Object)"1"));
    }

    @Test
    public void allocatingNamesByChain() {
        Maker<NamedThing> aNamedThing = MakeItEasy.a(NamedThing, MakeItEasy.with(name, new ChainedSequence<String>(){

            @Override
            protected String firstValue() {
                return "X";
            }

            @Override
            protected String valueAfter(String prevValue) {
                return prevValue + "'";
            }
        }));
        NamedThing thing0 = MakeItEasy.make(aNamedThing);
        NamedThing thing1 = MakeItEasy.make(aNamedThing);
        NamedThing thing2 = MakeItEasy.make(aNamedThing);
        MatcherAssert.assertThat((Object)thing0.name, (Matcher)Matchers.equalTo((Object)"X"));
        MatcherAssert.assertThat((Object)thing1.name, (Matcher)Matchers.equalTo((Object)"X'"));
        MatcherAssert.assertThat((Object)thing2.name, (Matcher)Matchers.equalTo((Object)"X''"));
    }

    @Test
    public void allocatingNamesFromACollection() {
        TreeSet<String> names = new TreeSet<String>();
        names.add("Bob");
        names.add("Alice");
        names.add("Carol");
        names.add("Dave");
        Maker<NamedThing> aNamedThing = MakeItEasy.a(NamedThing, MakeItEasy.with(name, MakeItEasy.from(names)));
        NamedThing thing0 = MakeItEasy.make(aNamedThing);
        NamedThing thing1 = MakeItEasy.make(aNamedThing);
        NamedThing thing2 = MakeItEasy.make(aNamedThing);
        NamedThing thing3 = MakeItEasy.make(aNamedThing);
        MatcherAssert.assertThat((Object)thing0.name, (Matcher)Matchers.equalTo((Object)"Alice"));
        MatcherAssert.assertThat((Object)thing1.name, (Matcher)Matchers.equalTo((Object)"Bob"));
        MatcherAssert.assertThat((Object)thing2.name, (Matcher)Matchers.equalTo((Object)"Carol"));
        MatcherAssert.assertThat((Object)thing3.name, (Matcher)Matchers.equalTo((Object)"Dave"));
    }

    public static class NamedThing {
        public final String name;

        public NamedThing(String name) {
            this.name = name;
        }
    }
}

