/*
 * Decompiled with CFR 0.152.
 */
package com.natpryce.makeiteasy;

import com.natpryce.makeiteasy.Donor;
import com.natpryce.makeiteasy.Instantiator;
import com.natpryce.makeiteasy.Maker;
import com.natpryce.makeiteasy.NewCollectionDonor;
import com.natpryce.makeiteasy.Property;
import com.natpryce.makeiteasy.PropertyValue;
import com.natpryce.makeiteasy.SameValueDonor;
import com.natpryce.makeiteasy.sequence.ElementsSequence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class MakeItEasy {
    @SafeVarargs
    public static <T> Maker<T> a(Instantiator<T> instantiator, PropertyValue<? super T, ?> ... propertyProviders) {
        return new Maker<T>(instantiator, propertyProviders);
    }

    @SafeVarargs
    public static <T> Maker<T> an(Instantiator<T> instantiator, PropertyValue<? super T, ?> ... propertyProviders) {
        return new Maker<T>(instantiator, propertyProviders);
    }

    public static <T, V, W extends V> PropertyValue<T, V> with(Property<T, V> property, W value) {
        return new PropertyValue<T, V>(property, new SameValueDonor<W>(value));
    }

    public static <T, V, W extends V> PropertyValue<T, V> with(W value, Property<T, V> property) {
        return new PropertyValue<T, V>(property, new SameValueDonor<W>(value));
    }

    public static <T, V, W extends V> PropertyValue<T, V> with(Property<T, V> property, Donor<W> valueDonor) {
        return new PropertyValue<T, V>(property, valueDonor);
    }

    public static <T, V, W extends V> PropertyValue<T, V> with(Donor<W> valueDonor, Property<T, V> property) {
        return new PropertyValue<T, V>(property, valueDonor);
    }

    public static <T, V> PropertyValue<T, V> withNull(Property<T, V> property) {
        return new PropertyValue<T, Object>(property, new SameValueDonor<Object>(null));
    }

    @SafeVarargs
    public static <T> Donor<T> theSame(Instantiator<T> instantiator, PropertyValue<? super T, ?> ... propertyProviders) {
        return MakeItEasy.theSame(MakeItEasy.an(instantiator, propertyProviders));
    }

    public static <T> Donor<T> theSame(Donor<T> originalDonor) {
        return new SameValueDonor<T>(originalDonor.value());
    }

    public static <T> T make(Maker<T> maker) {
        return maker.value();
    }

    @SafeVarargs
    public static <T> Donor<List<T>> listOf(Donor<? extends T> ... donors) {
        return new NewCollectionDonor<List<T>, T>(donors){

            @Override
            protected List<T> newCollection() {
                return new ArrayList();
            }
        };
    }

    @SafeVarargs
    public static <T> Donor<Set<T>> setOf(Donor<? extends T> ... donors) {
        return new NewCollectionDonor<Set<T>, T>(donors){

            @Override
            protected Set<T> newCollection() {
                return new HashSet();
            }
        };
    }

    @SafeVarargs
    public static <T extends Comparable<T>> Donor<SortedSet<T>> sortedSetOf(Donor<? extends T> ... donors) {
        return new NewCollectionDonor<SortedSet<T>, T>(donors){

            @Override
            protected SortedSet<T> newCollection() {
                return new TreeSet();
            }
        };
    }

    public static <T> Donor<T> from(Iterable<T> values) {
        return new ElementsSequence<T>(values, Collections.emptyList());
    }

    @SafeVarargs
    public static <T> Donor<T> from(T ... values) {
        return MakeItEasy.from(Arrays.asList(values));
    }

    public static <T> Donor<T> fromRepeating(Iterable<T> values) {
        return new ElementsSequence<T>(values, values);
    }

    @SafeVarargs
    public static <T> Donor<T> fromRepeating(T ... values) {
        return MakeItEasy.fromRepeating(Arrays.asList(values));
    }
}

