/*
 * Decompiled with CFR 0.152.
 */
package com.natpryce.makeiteasy;

import com.natpryce.makeiteasy.Donor;
import com.natpryce.makeiteasy.Instantiator;
import com.natpryce.makeiteasy.Property;
import com.natpryce.makeiteasy.PropertyLookup;
import com.natpryce.makeiteasy.PropertyValue;
import com.natpryce.makeiteasy.SameValueDonor;
import org.pcollections.HashPMap;
import org.pcollections.HashTreePMap;
import org.pcollections.PMap;

public class Maker<T>
implements PropertyLookup<T>,
Donor<T> {
    private final PMap<Property<? super T, ?>, PropertyValue<? super T, ?>> values;
    private final Instantiator<T> instantiator;

    @SafeVarargs
    public Maker(Instantiator<T> instantiator, PropertyValue<? super T, ?> ... propertyValues) {
        this.instantiator = instantiator;
        this.values = Maker.byProperty(propertyValues);
    }

    @SafeVarargs
    private Maker(Maker<T> that, PropertyValue<? super T, ?> ... propertyValues) {
        this.instantiator = that.instantiator;
        this.values = that.values.plusAll(Maker.byProperty(propertyValues));
    }

    private static <T> PMap<Property<? super T, ?>, PropertyValue<? super T, ?>> byProperty(PropertyValue<? super T, ?>[] propertyValues) {
        HashPMap propertyMap = HashTreePMap.empty();
        for (PropertyValue<T, ?> propertyValue : propertyValues) {
            propertyMap = propertyMap.plus(propertyValue.property(), propertyValue);
        }
        return propertyMap;
    }

    public T make() {
        return this.instantiator.instantiate(this);
    }

    @Override
    public T value() {
        return this.make();
    }

    @SafeVarargs
    public final Maker<T> but(PropertyValue<? super T, ?> ... propertyValues) {
        return new Maker<T>(this, propertyValues);
    }

    @Override
    public <V> V valueOf(Property<? super T, V> property, V defaultValue) {
        return this.valueOf(property, (Donor<? extends V>)new SameValueDonor<V>(defaultValue));
    }

    @Override
    public <V> V valueOf(Property<? super T, V> property, Donor<? extends V> defaultValue) {
        if (this.values.containsKey(property)) {
            return ((PropertyValue)this.values.get(property)).value();
        }
        return defaultValue.value();
    }
}

