/*
 * Decompiled with CFR 0.152.
 */
package com.natpryce.snodge;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.natpryce.snodge.DocumentMutation;
import com.natpryce.snodge.JsonPath;
import com.natpryce.snodge.Mutagen;
import com.natpryce.snodge.Mutagens;
import com.natpryce.snodge.Mutator;
import com.natpryce.snodge.internal.EncodedStringMutator;
import com.natpryce.snodge.internal.JsonWalk;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;

public class JsonMutator
implements Mutator<JsonElement> {
    private final Random rng;
    private final Mutagen mutagens;

    public JsonMutator() {
        this(Mutagens.allMutagens());
    }

    public JsonMutator(Mutagen mutagen) {
        this(new Random(), mutagen);
    }

    public JsonMutator(Random rng, Mutagen mutagen) {
        this.rng = rng;
        this.mutagens = mutagen;
    }

    @Override
    public Stream<JsonElement> mutate(JsonElement document, int mutationCount) {
        return this.mutations(document, mutationCount).stream().map(mutation -> (JsonElement)mutation.apply(document));
    }

    private List<DocumentMutation> mutations(JsonElement document, int mutationCount) {
        ArrayList<DocumentMutation> selectedMutations = new ArrayList<DocumentMutation>(mutationCount);
        AtomicInteger counter = new AtomicInteger(0);
        ((Stream)JsonWalk.walk(document).flatMap(path -> this.mutagens.potentialMutations(document, (JsonPath)path, path.apply(document))).sequential()).forEach(potentialMutation -> {
            int count = counter.incrementAndGet();
            if (count <= mutationCount) {
                selectedMutations.add((DocumentMutation)potentialMutation);
            } else {
                int index = this.rng.nextInt(count);
                if (index < selectedMutations.size()) {
                    selectedMutations.set(index, (DocumentMutation)potentialMutation);
                }
            }
        });
        return selectedMutations;
    }

    public Mutator<String> forStrings() {
        Gson gson = new Gson();
        return (originalJsonString, mutationCount) -> {
            JsonElement originalJsonDocument = (JsonElement)gson.fromJson(originalJsonString, JsonElement.class);
            return this.mutate(originalJsonDocument, mutationCount).map(Object::toString);
        };
    }

    public Mutator<byte[]> forEncodedStrings(Charset encoding) {
        return new EncodedStringMutator(encoding, this.forStrings());
    }

    public Mutator<byte[]> forEncodedStrings(String encodingName) {
        return this.forEncodedStrings(Charset.forName(encodingName));
    }
}

