/*
 * Decompiled with CFR 0.152.
 */
package com.natpryce.snodge;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.natpryce.snodge.DocumentMutation;
import com.natpryce.snodge.internal.JsonFunctions;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JsonPath
implements Function<JsonElement, JsonElement> {
    public static final JsonPath root = new JsonPath(new Object[0]);
    private final Object[] steps;

    private JsonPath(Object[] steps) {
        this.steps = steps;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonPath that = (JsonPath)o;
        return Arrays.equals(this.steps, that.steps);
    }

    public int hashCode() {
        return Arrays.hashCode(this.steps);
    }

    public String toString() {
        return JsonPath.pathBitsToString(this.steps, this.steps.length);
    }

    public static JsonPath of(Object ... path) {
        return new JsonPath(path);
    }

    public int size() {
        return this.steps.length;
    }

    public boolean isRoot() {
        return this.size() == 0;
    }

    public Object at(int n) {
        return this.steps[(this.steps.length + n) % this.steps.length];
    }

    public JsonPath extend(Object ... morePath) {
        Object[] newPath = new Object[this.steps.length + morePath.length];
        System.arraycopy(this.steps, 0, newPath, 0, this.steps.length);
        System.arraycopy(morePath, 0, newPath, this.steps.length, morePath.length);
        return new JsonPath(newPath);
    }

    @Override
    public JsonElement apply(JsonElement json) {
        JsonElement result = json;
        for (int i = 0; i < this.steps.length; ++i) {
            result = this.applyPathElement(json, i, result);
        }
        return result;
    }

    private JsonElement applyPathElement(JsonElement root, int i, JsonElement parent) {
        Object pathBit = this.steps[i];
        if (pathBit instanceof String) {
            String memberName = (String)pathBit;
            JsonObject object = this.jsonObjectWithProperty(root, i, parent, memberName);
            return object.get(memberName);
        }
        if (pathBit instanceof Integer) {
            int index = (Integer)pathBit;
            JsonArray array = this.jsonArrayWithIndex(root, i, parent, index);
            return array.get(index);
        }
        throw new IllegalArgumentException("unexpected path element: " + JsonPath.pathBitsToString(this.steps, i));
    }

    public boolean endsWith(Object ... suffix) {
        return this.steps.length >= suffix.length && Arrays.asList(suffix).equals(Arrays.asList(this.steps).subList(this.size() - suffix.length, this.size()));
    }

    public boolean startsWith(JsonPath prefix) {
        return this.size() >= prefix.size() && Arrays.asList(this.steps).subList(0, prefix.size()).equals(Arrays.asList(prefix.steps));
    }

    public JsonElement map(JsonElement json, Function<? super JsonElement, ? extends JsonElement> f) {
        return this.map(json, this.steps.length, f);
    }

    public DocumentMutation map(Function<? super JsonElement, ? extends JsonElement> f) {
        return json -> this.map((JsonElement)json, f);
    }

    public JsonElement replace(JsonElement root, JsonElement replacement) {
        return this.map(root, e -> replacement);
    }

    private JsonElement replaceElement(JsonElement root, JsonElement parent, int i, JsonElement replacement) {
        Object pathBit = this.steps[i];
        if (pathBit instanceof String) {
            String memberName = (String)pathBit;
            JsonObject original = this.jsonObjectWithProperty(root, i, parent, memberName);
            return this.replaceObjectPropertyValue(original, memberName, replacement);
        }
        if (pathBit instanceof Integer) {
            int index = (Integer)pathBit;
            JsonArray original = this.jsonArrayWithIndex(root, i, parent, index);
            return this.replaceArrayElement(original, index, replacement);
        }
        throw new IllegalArgumentException("unexpected path element: " + JsonPath.pathBitsToString(this.steps, i));
    }

    private JsonElement replaceObjectPropertyValue(JsonObject original, String memberName, JsonElement replacement) {
        JsonObject replaced = new JsonObject();
        for (Map.Entry entry : original.entrySet()) {
            if (((String)entry.getKey()).equals(memberName)) {
                replaced.add(memberName, replacement);
                continue;
            }
            replaced.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        return replaced;
    }

    private JsonElement replaceArrayElement(JsonArray original, int index, JsonElement replacement) {
        int j;
        JsonArray replaced = new JsonArray();
        for (j = 0; j < index; ++j) {
            replaced.add(original.get(j));
        }
        replaced.add(replacement);
        for (j = index + 1; j < original.size(); ++j) {
            replaced.add(original.get(j));
        }
        return replaced;
    }

    public DocumentMutation remove() {
        return this::remove;
    }

    public JsonElement remove(JsonElement root) {
        int lastIndex = this.steps.length - 1;
        return this.map(root, lastIndex, input -> this.removeElement(root, lastIndex, (JsonElement)input, this.steps[lastIndex]));
    }

    private JsonElement removeElement(JsonElement root, int i, JsonElement parent, Object pathBit) {
        if (pathBit instanceof String) {
            String memberName = (String)pathBit;
            JsonObject original = this.jsonObjectWithProperty(root, i, parent, memberName);
            return JsonFunctions.removeObjectProperty(original, memberName);
        }
        if (pathBit instanceof Integer) {
            int index = (Integer)pathBit;
            JsonArray original = this.jsonArrayWithIndex(root, i, parent, index);
            return JsonFunctions.removeArrayElement(original, index);
        }
        throw new IllegalArgumentException("unexpected path element: " + JsonPath.pathBitsToString(this.steps, i));
    }

    private JsonElement map(JsonElement json, int pathLength, Function<? super JsonElement, ? extends JsonElement> f) {
        JsonElement[] parents = new JsonElement[pathLength + 1];
        parents[0] = json;
        for (int i = 0; i < pathLength; ++i) {
            parents[i + 1] = this.applyPathElement(json, i, parents[i]);
        }
        JsonElement replaced = f.apply((JsonElement)parents[pathLength]);
        for (int i = pathLength - 1; i >= 0; --i) {
            replaced = this.replaceElement(json, parents[i], i, replaced);
        }
        return replaced;
    }

    private JsonObject jsonObjectWithProperty(JsonElement root, int i, JsonElement parent, String memberName) {
        JsonPath.check(parent.isJsonObject(), "expected object", this.steps, i, root);
        JsonObject original = parent.getAsJsonObject();
        JsonPath.check(original.has(memberName), "no such member", this.steps, i, root);
        return original;
    }

    private JsonArray jsonArrayWithIndex(JsonElement root, int i, JsonElement parent, int index) {
        JsonPath.check(parent.isJsonArray(), "expected array", this.steps, i, root);
        JsonArray array = parent.getAsJsonArray();
        JsonPath.check(array.size() > index, "index out of bounds", this.steps, i, root);
        return array;
    }

    private static void check(boolean isOk, String what, Object[] pathBits, int badOne, JsonElement json) {
        if (!isOk) {
            throw new IllegalArgumentException(what + " at " + JsonPath.pathBitsToString(pathBits, badOne + 1) + " in " + json);
        }
    }

    private static String pathBitsToString(Object[] pathBits, int count) {
        return Stream.of(pathBits).limit(count).map(Object::toString).collect(Collectors.joining("/", "/", ""));
    }

    public static class functions {
        public static Predicate<JsonPath> endsWith(final Object ... suffix) {
            return new Predicate<JsonPath>(){

                @Override
                public boolean test(JsonPath path) {
                    return path.endsWith(suffix);
                }

                public String toString() {
                    return "endsWith(..." + JsonPath.of(suffix) + ")";
                }
            };
        }

        public static Predicate<JsonPath> startsWith(Object ... prefix) {
            return functions.startsWith(JsonPath.of(prefix));
        }

        public static Predicate<JsonPath> startsWith(final JsonPath prefix) {
            return new Predicate<JsonPath>(){

                @Override
                public boolean test(JsonPath path) {
                    return path.startsWith(prefix);
                }

                public String toString() {
                    return "startsWith(" + prefix + ")";
                }
            };
        }
    }
}

