/*
 * Decompiled with CFR 0.152.
 */
package com.natpryce.snodge;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.natpryce.snodge.JsonPath;
import com.natpryce.snodge.Mutagen;
import com.natpryce.snodge.mutagens.AddArrayElement;
import com.natpryce.snodge.mutagens.AddObjectProperty;
import com.natpryce.snodge.mutagens.RemoveJsonElement;
import com.natpryce.snodge.mutagens.ReorderObjectProperties;
import com.natpryce.snodge.mutagens.ReplaceJsonElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Mutagens {
    private static final List<JsonElement> exampleElements = Arrays.asList(JsonNull.INSTANCE, new JsonPrimitive(Boolean.valueOf(true)), new JsonPrimitive(Boolean.valueOf(false)), new JsonPrimitive((Number)99), new JsonPrimitive((Number)-99), new JsonPrimitive("a string"), new JsonArray(), new JsonObject());

    public static Mutagen combine(Mutagen ... mutagens) {
        return Mutagens.combine(Arrays.asList(mutagens));
    }

    public static Mutagen combine(Collection<Mutagen> mutagens) {
        return (document, pathToElement, elementToMutate) -> mutagens.stream().flatMap(mutagen -> mutagen.potentialMutations(document, pathToElement, elementToMutate));
    }

    public static Mutagen atPath(JsonPath path, Mutagen atPathMutagen) {
        return Mutagens.atPath((? super JsonPath p) -> p.equals(path), atPathMutagen);
    }

    public static Mutagen atPath(Predicate<? super JsonPath> pathSelector, Mutagen atPathMutagen) {
        return (document, pathToElement, elementToMutate) -> pathSelector.test(pathToElement) ? atPathMutagen.potentialMutations(document, pathToElement, elementToMutate) : Stream.empty();
    }

    public static Mutagen allMutagens() {
        return Mutagens.combine(Mutagens.forAll(exampleElements, ReplaceJsonElement::new), Mutagens.forAll(exampleElements, AddArrayElement::new), Mutagens.forAll(exampleElements, AddObjectProperty::new), new RemoveJsonElement(), new ReorderObjectProperties());
    }

    private static Mutagen forAll(List<JsonElement> elements, Function<JsonElement, Mutagen> fn) {
        return Mutagens.combine(elements.stream().map(fn).collect(Collectors.toList()));
    }
}

