/*
 * Decompiled with CFR 0.152.
 */
package com.natpryce.snodge.internal;

import com.google.gson.JsonElement;
import com.natpryce.snodge.JsonPath;
import com.natpryce.snodge.internal.JsonFunctions;
import java.util.Map;
import java.util.stream.Stream;

public class JsonWalk {
    public static Stream<JsonPath> walk(JsonElement start) {
        return JsonWalk.walk(start, JsonPath.root);
    }

    private static Stream<JsonPath> walk(JsonElement element, JsonPath elementPath) {
        return Stream.concat(Stream.of(elementPath), JsonWalk.walkChildren(element, elementPath));
    }

    private static Stream<JsonPath> walkChildren(JsonElement element, JsonPath elementPath) {
        if (element.isJsonObject()) {
            return JsonWalk.walkChildren(elementPath, element.getAsJsonObject().entrySet().stream());
        }
        if (element.isJsonArray()) {
            return JsonWalk.walkChildren(elementPath, JsonFunctions.arrayEntries(element.getAsJsonArray()));
        }
        return Stream.empty();
    }

    private static <T> Stream<JsonPath> walkChildren(JsonPath parentPath, Stream<Map.Entry<T, JsonElement>> children) {
        return children.flatMap(child -> JsonWalk.walk((JsonElement)child.getValue(), parentPath.extend(child.getKey())));
    }
}

